/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.utils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.ConcurrencyUtils;

public class IOUtils {
    private static final String FF = "%.4f";

    private IOUtils() {
    }

    public static void fillMatrix_1D(int N2, double[] m2) {
        Random r = new Random(2L);
        int i2 = 0;
        while (i2 < N2) {
            m2[i2] = r.nextDouble();
            ++i2;
        }
    }

    public static void fillMatrix_1D(int N2, float[] m2) {
        Random r = new Random(2L);
        int i2 = 0;
        while (i2 < N2) {
            m2[i2] = r.nextFloat();
            ++i2;
        }
    }

    public static void fillMatrix_2D(int n1, int n2, double[] m2) {
        Random r = new Random(2L);
        int i2 = 0;
        while (i2 < n1) {
            int j = 0;
            while (j < n2) {
                m2[i2 * n2 + j] = r.nextDouble();
                ++j;
            }
            ++i2;
        }
    }

    public static void fillMatrix_2D(int n1, int n2, float[] m2) {
        Random r = new Random(2L);
        int i2 = 0;
        while (i2 < n1) {
            int j = 0;
            while (j < n2) {
                m2[i2 * n2 + j] = r.nextFloat();
                ++j;
            }
            ++i2;
        }
    }

    public static void fillMatrix_2D(int n1, int n2, double[][] m2) {
        Random r = new Random(2L);
        int i2 = 0;
        while (i2 < n1) {
            int j = 0;
            while (j < n2) {
                m2[i2][j] = r.nextDouble();
                ++j;
            }
            ++i2;
        }
    }

    public static void fillMatrix_2D(int n1, int n2, float[][] m2) {
        Random r = new Random(2L);
        int i2 = 0;
        while (i2 < n1) {
            int j = 0;
            while (j < n2) {
                m2[i2][j] = r.nextFloat();
                ++j;
            }
            ++i2;
        }
    }

    public static void fillMatrix_3D(int n1, int n2, int n3, double[] m2) {
        Random r = new Random(2L);
        int sliceStride = n2 * n3;
        int rowStride = n3;
        int i2 = 0;
        while (i2 < n1) {
            int j = 0;
            while (j < n2) {
                int k = 0;
                while (k < n3) {
                    m2[i2 * sliceStride + j * rowStride + k] = r.nextDouble();
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void fillMatrix_3D(int n1, int n2, int n3, float[] m2) {
        Random r = new Random(2L);
        int sliceStride = n2 * n3;
        int rowStride = n3;
        int i2 = 0;
        while (i2 < n1) {
            int j = 0;
            while (j < n2) {
                int k = 0;
                while (k < n3) {
                    m2[i2 * sliceStride + j * rowStride + k] = r.nextFloat();
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void fillMatrix_3D(int n1, int n2, int n3, double[][][] m2) {
        Random r = new Random(2L);
        int i2 = 0;
        while (i2 < n1) {
            int j = 0;
            while (j < n2) {
                int k = 0;
                while (k < n3) {
                    m2[i2][j][k] = r.nextDouble();
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void fillMatrix_3D(int n1, int n2, int n3, float[][][] m2) {
        Random r = new Random(2L);
        int i2 = 0;
        while (i2 < n1) {
            int j = 0;
            while (j < n2) {
                int k = 0;
                while (k < n3) {
                    m2[i2][j][k] = r.nextFloat();
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void showComplex_1D(double[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int i2 = 0;
        while (i2 < x.length) {
            if (x[i2 + 1] == 0.0) {
                System.out.println(String.format(FF, x[i2]));
            } else if (x[i2] == 0.0) {
                System.out.println(String.valueOf(String.format(FF, x[i2 + 1])) + "i");
            } else if (x[i2 + 1] < 0.0) {
                System.out.println(String.valueOf(String.format(FF, x[i2])) + " - " + String.format(FF, -x[i2 + 1]) + "i");
            } else {
                System.out.println(String.valueOf(String.format(FF, x[i2])) + " + " + String.format(FF, x[i2 + 1]) + "i");
            }
            i2 += 2;
        }
        System.out.println();
    }

    public static void showComplex_2D(int rows, int columns, double[] x, String title) {
        StringBuffer s2 = new StringBuffer(String.format(String.valueOf(title) + ": complex array 2D: %d rows, %d columns\n\n", rows, columns));
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < 2 * columns) {
                if (x[r * 2 * columns + c + 1] == 0.0) {
                    s2.append(String.format("%.4f\t", x[r * 2 * columns + c]));
                } else if (x[r * 2 * columns + c] == 0.0) {
                    s2.append(String.format("%.4fi\t", x[r * 2 * columns + c + 1]));
                } else if (x[r * 2 * columns + c + 1] < 0.0) {
                    s2.append(String.format("%.4f - %.4fi\t", x[r * 2 * columns + c], -x[r * 2 * columns + c + 1]));
                } else {
                    s2.append(String.format("%.4f + %.4fi\t", x[r * 2 * columns + c], x[r * 2 * columns + c + 1]));
                }
                c += 2;
            }
            s2.append("\n");
            ++r;
        }
        System.out.println(s2.toString());
    }

    public static void showComplex_3D(int n1, int n2, int n3, double[] x, String title) {
        int sliceStride = n2 * 2 * n3;
        int rowStride = 2 * n3;
        System.out.println(title);
        System.out.println("-------------------");
        int k = 0;
        while (k < 2 * n3) {
            System.out.println("(:,:," + k / 2 + ")=\n");
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < n2) {
                    if (x[i2 * sliceStride + j * rowStride + k + 1] == 0.0) {
                        System.out.print(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k])) + "\t");
                    } else if (x[i2 * sliceStride + j * rowStride + k] == 0.0) {
                        System.out.print(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k + 1])) + "i\t");
                    } else if (x[i2 * sliceStride + j * rowStride + k + 1] < 0.0) {
                        System.out.print(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k])) + " - " + String.format(FF, -x[i2 * sliceStride + j * rowStride + k + 1]) + "i\t");
                    } else {
                        System.out.print(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k])) + " + " + String.format(FF, x[i2 * sliceStride + j * rowStride + k + 1]) + "i\t");
                    }
                    ++j;
                }
                System.out.println("");
                ++i2;
            }
            k += 2;
        }
        System.out.println("");
    }

    public static void showComplex_3D(int n1, int n2, int n3, double[][][] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int k = 0;
        while (k < 2 * n3) {
            System.out.println("(:,:," + k / 2 + ")=\n");
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < n2) {
                    if (x[i2][j][k + 1] == 0.0) {
                        System.out.print(String.valueOf(String.format(FF, x[i2][j][k])) + "\t");
                    } else if (x[i2][j][k] == 0.0) {
                        System.out.print(String.valueOf(String.format(FF, x[i2][j][k + 1])) + "i\t");
                    } else if (x[i2][j][k + 1] < 0.0) {
                        System.out.print(String.valueOf(String.format(FF, x[i2][j][k])) + " - " + String.format(FF, -x[i2][j][k + 1]) + "i\t");
                    } else {
                        System.out.print(String.valueOf(String.format(FF, x[i2][j][k])) + " + " + String.format(FF, x[i2][j][k + 1]) + "i\t");
                    }
                    ++j;
                }
                System.out.println("");
                ++i2;
            }
            k += 2;
        }
        System.out.println("");
    }

    public static void showComplex_3D(int n1, int n2, int n3, float[] x, String title) {
        int sliceStride = n2 * 2 * n3;
        int rowStride = 2 * n3;
        System.out.println(title);
        System.out.println("-------------------");
        int k = 0;
        while (k < 2 * n3) {
            System.out.println("(:,:," + k / 2 + ")=\n");
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < n2) {
                    if (x[i2 * sliceStride + j * rowStride + k + 1] == 0.0f) {
                        System.out.print(String.valueOf(String.format(FF, Float.valueOf(x[i2 * sliceStride + j * rowStride + k]))) + "\t");
                    } else if (x[i2 * sliceStride + j * rowStride + k] == 0.0f) {
                        System.out.print(String.valueOf(String.format(FF, Float.valueOf(x[i2 * sliceStride + j * rowStride + k + 1]))) + "i\t");
                    } else if (x[i2 * sliceStride + j * rowStride + k + 1] < 0.0f) {
                        System.out.print(String.valueOf(String.format(FF, Float.valueOf(x[i2 * sliceStride + j * rowStride + k]))) + " - " + String.format(FF, Float.valueOf(-x[i2 * sliceStride + j * rowStride + k + 1])) + "i\t");
                    } else {
                        System.out.print(String.valueOf(String.format(FF, Float.valueOf(x[i2 * sliceStride + j * rowStride + k]))) + " + " + String.format(FF, Float.valueOf(x[i2 * sliceStride + j * rowStride + k + 1])) + "i\t");
                    }
                    ++j;
                }
                System.out.println("");
                ++i2;
            }
            k += 2;
        }
        System.out.println("");
    }

    public static void showReal_1D(double[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int j = 0;
        while (j < x.length) {
            System.out.println(String.format(FF, x[j]));
            ++j;
        }
        System.out.println();
    }

    public static void showReal_2D(int n1, int n2, double[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int i2 = 0;
        while (i2 < n1) {
            int j = 0;
            while (j < n2) {
                if (Math.abs(x[i2 * n2 + j]) < 5.0E-5) {
                    System.out.print("0\t");
                } else {
                    System.out.print(String.valueOf(String.format(FF, x[i2 * n2 + j])) + "\t");
                }
                ++j;
            }
            System.out.println();
            ++i2;
        }
        System.out.println();
    }

    public static void showReal_3D(int n1, int n2, int n3, double[] x, String title) {
        int sliceStride = n2 * n3;
        int rowStride = n3;
        System.out.println(title);
        System.out.println("-------------------");
        int k = 0;
        while (k < n3) {
            System.out.println();
            System.out.println("(:,:," + k + ")=\n");
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < n2) {
                    if (Math.abs(x[i2 * sliceStride + j * rowStride + k]) <= 5.0E-5) {
                        System.out.print("0\t");
                    } else {
                        System.out.print(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k])) + "\t");
                    }
                    ++j;
                }
                System.out.println();
                ++i2;
            }
            ++k;
        }
        System.out.println();
    }

    public static void showReal_3D(int n1, int n2, int n3, double[][][] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int k = 0;
        while (k < n3) {
            System.out.println();
            System.out.println("(:,:," + k + ")=\n");
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < n2) {
                    if (Math.abs(x[i2][j][k]) <= 5.0E-5) {
                        System.out.print("0\t");
                    } else {
                        System.out.print(String.valueOf(String.format(FF, x[i2][j][k])) + "\t");
                    }
                    ++j;
                }
                System.out.println();
                ++i2;
            }
            ++k;
        }
        System.out.println();
    }

    public static void writeToFileComplex_1D(double[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i2 = 0;
            while (i2 < x.length) {
                if (x[i2 + 1] == 0.0) {
                    out.write(String.format(FF, x[i2]));
                    out.newLine();
                } else if (x[i2] == 0.0) {
                    out.write(String.valueOf(String.format(FF, x[i2 + 1])) + "i");
                    out.newLine();
                } else if (x[i2 + 1] < 0.0) {
                    out.write(String.valueOf(String.format(FF, x[i2])) + " - " + String.format(FF, -x[i2 + 1]) + "i");
                    out.newLine();
                } else {
                    out.write(String.valueOf(String.format(FF, x[i2])) + " + " + String.format(FF, x[i2 + 1]) + "i");
                    out.newLine();
                }
                i2 += 2;
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_1D(float[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i2 = 0;
            while (i2 < x.length) {
                if (x[i2 + 1] == 0.0f) {
                    out.write(String.format(FF, Float.valueOf(x[i2])));
                    out.newLine();
                } else if (x[i2] == 0.0f) {
                    out.write(String.valueOf(String.format(FF, Float.valueOf(x[i2 + 1]))) + "i");
                    out.newLine();
                } else if (x[i2 + 1] < 0.0f) {
                    out.write(String.valueOf(String.format(FF, Float.valueOf(x[i2]))) + " - " + String.format(FF, Float.valueOf(-x[i2 + 1])) + "i");
                    out.newLine();
                } else {
                    out.write(String.valueOf(String.format(FF, Float.valueOf(x[i2]))) + " + " + String.format(FF, Float.valueOf(x[i2 + 1])) + "i");
                    out.newLine();
                }
                i2 += 2;
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n1, int n2, double[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < 2 * n2) {
                    if (Math.abs(x[i2 * 2 * n2 + j]) < 5.0E-5 && Math.abs(x[i2 * 2 * n2 + j + 1]) < 5.0E-5) {
                        if (x[i2 * 2 * n2 + j + 1] >= 0.0) {
                            out.write("0 + 0i\t");
                        } else {
                            out.write("0 - 0i\t");
                        }
                    } else if (Math.abs(x[i2 * 2 * n2 + j + 1]) < 5.0E-5) {
                        if (x[i2 * 2 * n2 + j + 1] >= 0.0) {
                            out.write(String.valueOf(String.format(FF, x[i2 * 2 * n2 + j])) + " + 0i\t");
                        } else {
                            out.write(String.valueOf(String.format(FF, x[i2 * 2 * n2 + j])) + " - 0i\t");
                        }
                    } else if (Math.abs(x[i2 * 2 * n2 + j]) < 5.0E-5) {
                        if (x[i2 * 2 * n2 + j + 1] >= 0.0) {
                            out.write("0 + " + String.format(FF, x[i2 * 2 * n2 + j + 1]) + "i\t");
                        } else {
                            out.write("0 - " + String.format(FF, -x[i2 * 2 * n2 + j + 1]) + "i\t");
                        }
                    } else if (x[i2 * 2 * n2 + j + 1] < 0.0) {
                        out.write(String.valueOf(String.format(FF, x[i2 * 2 * n2 + j])) + " - " + String.format(FF, -x[i2 * 2 * n2 + j + 1]) + "i\t");
                    } else {
                        out.write(String.valueOf(String.format(FF, x[i2 * 2 * n2 + j])) + " + " + String.format(FF, x[i2 * 2 * n2 + j + 1]) + "i\t");
                    }
                    j += 2;
                }
                out.newLine();
                ++i2;
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n1, int n2, float[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < 2 * n2) {
                    if ((double)Math.abs(x[i2 * 2 * n2 + j]) < 5.0E-5 && (double)Math.abs(x[i2 * 2 * n2 + j + 1]) < 5.0E-5) {
                        if ((double)x[i2 * 2 * n2 + j + 1] >= 0.0) {
                            out.write("0 + 0i\t");
                        } else {
                            out.write("0 - 0i\t");
                        }
                    } else if ((double)Math.abs(x[i2 * 2 * n2 + j + 1]) < 5.0E-5) {
                        if ((double)x[i2 * 2 * n2 + j + 1] >= 0.0) {
                            out.write(String.valueOf(String.format(FF, Float.valueOf(x[i2 * 2 * n2 + j]))) + " + 0i\t");
                        } else {
                            out.write(String.valueOf(String.format(FF, Float.valueOf(x[i2 * 2 * n2 + j]))) + " - 0i\t");
                        }
                    } else if ((double)Math.abs(x[i2 * 2 * n2 + j]) < 5.0E-5) {
                        if ((double)x[i2 * 2 * n2 + j + 1] >= 0.0) {
                            out.write("0 + " + String.format(FF, Float.valueOf(x[i2 * 2 * n2 + j + 1])) + "i\t");
                        } else {
                            out.write("0 - " + String.format(FF, Float.valueOf(-x[i2 * 2 * n2 + j + 1])) + "i\t");
                        }
                    } else if (x[i2 * 2 * n2 + j + 1] < 0.0f) {
                        out.write(String.valueOf(String.format(FF, Float.valueOf(x[i2 * 2 * n2 + j]))) + " - " + String.format(FF, Float.valueOf(-x[i2 * 2 * n2 + j + 1])) + "i\t");
                    } else {
                        out.write(String.valueOf(String.format(FF, Float.valueOf(x[i2 * 2 * n2 + j]))) + " + " + String.format(FF, Float.valueOf(x[i2 * 2 * n2 + j + 1])) + "i\t");
                    }
                    j += 2;
                }
                out.newLine();
                ++i2;
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n1, int n2, double[][] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < 2 * n2) {
                    if (Math.abs(x[i2][j]) < 5.0E-5 && Math.abs(x[i2][j + 1]) < 5.0E-5) {
                        if (x[i2][j + 1] >= 0.0) {
                            out.write("0 + 0i\t");
                        } else {
                            out.write("0 - 0i\t");
                        }
                    } else if (Math.abs(x[i2][j + 1]) < 5.0E-5) {
                        if (x[i2][j + 1] >= 0.0) {
                            out.write(String.valueOf(String.format(FF, x[i2][j])) + " + 0i\t");
                        } else {
                            out.write(String.valueOf(String.format(FF, x[i2][j])) + " - 0i\t");
                        }
                    } else if (Math.abs(x[i2][j]) < 5.0E-5) {
                        if (x[i2][j + 1] >= 0.0) {
                            out.write("0 + " + String.format(FF, x[i2][j + 1]) + "i\t");
                        } else {
                            out.write("0 - " + String.format(FF, -x[i2][j + 1]) + "i\t");
                        }
                    } else if (x[i2][j + 1] < 0.0) {
                        out.write(String.valueOf(String.format(FF, x[i2][j])) + " - " + String.format(FF, -x[i2][j + 1]) + "i\t");
                    } else {
                        out.write(String.valueOf(String.format(FF, x[i2][j])) + " + " + String.format(FF, x[i2][j + 1]) + "i\t");
                    }
                    j += 2;
                }
                out.newLine();
                ++i2;
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(int n1, int n2, int n3, double[] x, String filename) {
        int sliceStride = n2 * n3 * 2;
        int rowStride = n3 * 2;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int k = 0;
            while (k < 2 * n3) {
                out.newLine();
                out.write("(:,:," + k / 2 + ")=");
                out.newLine();
                out.newLine();
                int i2 = 0;
                while (i2 < n1) {
                    int j = 0;
                    while (j < n2) {
                        if (x[i2 * sliceStride + j * rowStride + k + 1] == 0.0) {
                            out.write(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k])) + "\t");
                        } else if (x[i2 * sliceStride + j * rowStride + k] == 0.0) {
                            out.write(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k + 1])) + "i\t");
                        } else if (x[i2 * sliceStride + j * rowStride + k + 1] < 0.0) {
                            out.write(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k])) + " - " + String.format(FF, -x[i2 * sliceStride + j * rowStride + k + 1]) + "i\t");
                        } else {
                            out.write(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k])) + " + " + String.format(FF, x[i2 * sliceStride + j * rowStride + k + 1]) + "i\t");
                        }
                        ++j;
                    }
                    out.newLine();
                    ++i2;
                }
                k += 2;
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(int n1, int n2, int n3, double[][][] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int k = 0;
            while (k < 2 * n3) {
                out.newLine();
                out.write("(:,:," + k / 2 + ")=");
                out.newLine();
                out.newLine();
                int i2 = 0;
                while (i2 < n1) {
                    int j = 0;
                    while (j < n2) {
                        if (x[i2][j][k + 1] == 0.0) {
                            out.write(String.valueOf(String.format(FF, x[i2][j][k])) + "\t");
                        } else if (x[i2][j][k] == 0.0) {
                            out.write(String.valueOf(String.format(FF, x[i2][j][k + 1])) + "i\t");
                        } else if (x[i2][j][k + 1] < 0.0) {
                            out.write(String.valueOf(String.format(FF, x[i2][j][k])) + " - " + String.format(FF, -x[i2][j][k + 1]) + "i\t");
                        } else {
                            out.write(String.valueOf(String.format(FF, x[i2][j][k])) + " + " + String.format(FF, x[i2][j][k + 1]) + "i\t");
                        }
                        ++j;
                    }
                    out.newLine();
                    ++i2;
                }
                k += 2;
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(double[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int j = 0;
            while (j < x.length) {
                out.write(String.format(FF, x[j]));
                out.newLine();
                ++j;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(float[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int j = 0;
            while (j < x.length) {
                out.write(String.format(FF, Float.valueOf(x[j])));
                out.newLine();
                ++j;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(int n1, int n2, double[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < n2) {
                    if (Math.abs(x[i2 * n2 + j]) < 5.0E-5) {
                        out.write("0\t");
                    } else {
                        out.write(String.valueOf(String.format(FF, x[i2 * n2 + j])) + "\t");
                    }
                    ++j;
                }
                out.newLine();
                ++i2;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(int n1, int n2, float[] x, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i2 = 0;
            while (i2 < n1) {
                int j = 0;
                while (j < n2) {
                    if ((double)Math.abs(x[i2 * n2 + j]) < 5.0E-5) {
                        out.write("0\t");
                    } else {
                        out.write(String.valueOf(String.format(FF, Float.valueOf(x[i2 * n2 + j]))) + "\t");
                    }
                    ++j;
                }
                out.newLine();
                ++i2;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFileReal_3D(int n1, int n2, int n3, double[] x, String filename) {
        int sliceStride = n2 * n3;
        int rowStride = n3;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int k = 0;
            while (k < n3) {
                out.newLine();
                out.write("(:,:," + k + ")=");
                out.newLine();
                out.newLine();
                int i2 = 0;
                while (i2 < n1) {
                    int j = 0;
                    while (j < n2) {
                        out.write(String.valueOf(String.format(FF, x[i2 * sliceStride + j * rowStride + k])) + "\t");
                        ++j;
                    }
                    out.newLine();
                    ++i2;
                }
                out.newLine();
                ++k;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeFFTBenchmarkResultsToFile(String filename, int nthread, int niter, boolean doWarmup, boolean doScaling, int[] sizes, double[] times) {
        String[] properties = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version"};
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename, false));
            out.write(new Date().toString());
            out.newLine();
            out.write("System properties:");
            out.newLine();
            out.write("\tos.name = " + System.getProperty(properties[0]));
            out.newLine();
            out.write("\tos.version = " + System.getProperty(properties[1]));
            out.newLine();
            out.write("\tos.arch = " + System.getProperty(properties[2]));
            out.newLine();
            out.write("\tjava.vendor = " + System.getProperty(properties[3]));
            out.newLine();
            out.write("\tjava.version = " + System.getProperty(properties[4]));
            out.newLine();
            out.write("\tavailable processors = " + Runtime.getRuntime().availableProcessors());
            out.newLine();
            out.write("Settings:");
            out.newLine();
            out.write("\tused processors = " + nthread);
            out.newLine();
            out.write("\tTHREADS_BEGIN_N_2D = " + ConcurrencyUtils.getThreadsBeginN_2D());
            out.newLine();
            out.write("\tTHREADS_BEGIN_N_3D = " + ConcurrencyUtils.getThreadsBeginN_3D());
            out.newLine();
            out.write("\tnumber of iterations = " + niter);
            out.newLine();
            out.write("\twarm-up performed = " + doWarmup);
            out.newLine();
            out.write("\tscaling performed = " + doScaling);
            out.newLine();
            out.write("--------------------------------------------------------------------------------------------------");
            out.newLine();
            out.write("sizes=[");
            int i2 = 0;
            while (i2 < sizes.length) {
                out.write(Integer.toString(sizes[i2]));
                if (i2 < sizes.length - 1) {
                    out.write(", ");
                } else {
                    out.write("]");
                }
                ++i2;
            }
            out.newLine();
            out.write("times(in msec)=[");
            i2 = 0;
            while (i2 < times.length) {
                out.write(String.format("%.2f", times[i2]));
                if (i2 < times.length - 1) {
                    out.write(", ");
                } else {
                    out.write("]");
                }
                ++i2;
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

