/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.core.regression;

import ml.combust.mleap.core.Model;
import ml.combust.mleap.core.annotation.SparkCode;
import ml.combust.mleap.core.regression.AFTSurvivalRegressionModel$;
import ml.combust.mleap.core.types.DataType;
import ml.combust.mleap.core.types.ScalarType$;
import ml.combust.mleap.core.types.StructField;
import ml.combust.mleap.core.types.StructField$;
import ml.combust.mleap.core.types.StructType;
import ml.combust.mleap.core.types.StructType$;
import ml.combust.mleap.core.types.TensorType$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.linalg.mleap.BLAS$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@SparkCode(uri="https://github.com/apache/spark/blob/v2.0.0/mllib/src/main/scala/org/apache/spark/ml/regression/AFTSurvivalRegression.scala")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u00016\u0011!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2T!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005!1m\u001c:f\u0015\t9\u0001\"A\u0003nY\u0016\f\u0007O\u0003\u0002\n\u0015\u000591m\\7ckN$(\"A\u0006\u0002\u00055d7\u0001A\n\u0006\u00019!\u0002d\u0007\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0003\n\u0005]!!!B'pI\u0016d\u0007CA\b\u001a\u0013\tQ\u0002CA\u0004Qe>$Wo\u0019;\u0011\u0005=a\u0012BA\u000f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!y\u0002A!f\u0001\n\u0003\u0001\u0013\u0001D2pK\u001a4\u0017nY5f]R\u001cX#A\u0011\u0011\u0005\tbS\"A\u0012\u000b\u0005\u0011*\u0013A\u00027j]\u0006dwM\u0003\u0002\fM)\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.G\t1a+Z2u_JD\u0001b\f\u0001\u0003\u0012\u0003\u0006I!I\u0001\u000eG>,gMZ5dS\u0016tGo\u001d\u0011\t\u0011E\u0002!Q3A\u0005\u0002I\n\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0016\u0003M\u0002\"a\u0004\u001b\n\u0005U\u0002\"A\u0002#pk\ndW\r\u0003\u00058\u0001\tE\t\u0015!\u00034\u0003)Ig\u000e^3sG\u0016\u0004H\u000f\t\u0005\ts\u0001\u0011)\u001a!C\u0001u\u0005)\u0012/^1oi&dW\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cX#A\u001e\u0011\u0007=a4'\u0003\u0002>!\t)\u0011I\u001d:bs\"Aq\b\u0001B\tB\u0003%1(\u0001\frk\u0006tG/\u001b7f!J|'-\u00192jY&$\u0018.Z:!\u0011!\t\u0005A!f\u0001\n\u0003\u0011\u0014!B:dC2,\u0007\u0002C\"\u0001\u0005#\u0005\u000b\u0011B\u001a\u0002\rM\u001c\u0017\r\\3!\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}Q)q)\u0013&L\u0019B\u0011\u0001\nA\u0007\u0002\u0005!)q\u0004\u0012a\u0001C!)\u0011\u0007\u0012a\u0001g!)\u0011\b\u0012a\u0001w!)\u0011\t\u0012a\u0001g!)a\n\u0001C\u0001\u001f\u0006)\u0011\r\u001d9msR\u00111\u0007\u0015\u0005\u0006#6\u0003\r!I\u0001\tM\u0016\fG/\u001e:fg\")1\u000b\u0001C\u0001)\u0006!\u0002O]3eS\u000e$x+\u001b;i#V\fg\u000e^5mKN$\"!\u0016-\u0011\t=16'I\u0005\u0003/B\u0011a\u0001V;qY\u0016\u0014\u0004\"B)S\u0001\u0004\t\u0003\"\u0002.\u0001\t\u0003Y\u0016\u0001\u00059sK\u0012L7\r^)vC:$\u0018\u000e\\3t)\t\tC\fC\u0003R3\u0002\u0007\u0011\u0005C\u0003_\u0001\u0011\u0005q,A\u0004qe\u0016$\u0017n\u0019;\u0015\u0005M\u0002\u0007\"B)^\u0001\u0004\t\u0003\"\u00022\u0001\t\u0003\u001a\u0017aC5oaV$8k\u00195f[\u0006,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O\u0012\tQ\u0001^=qKNL!!\u001b4\u0003\u0015M#(/^2u)f\u0004X\rC\u0003l\u0001\u0011\u00053-\u0001\u0007pkR\u0004X\u000f^*dQ\u0016l\u0017\rC\u0004n\u0001\u0005\u0005I\u0011\u00018\u0002\t\r|\u0007/\u001f\u000b\u0006\u000f>\u0004\u0018O\u001d\u0005\b?1\u0004\n\u00111\u0001\"\u0011\u001d\tD\u000e%AA\u0002MBq!\u000f7\u0011\u0002\u0003\u00071\bC\u0004BYB\u0005\t\u0019A\u001a\t\u000fQ\u0004\u0011\u0013!C\u0001k\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001<+\u0005\u0005:8&\u0001=\u0011\u0005etX\"\u0001>\u000b\u0005md\u0018!C;oG\",7m[3e\u0015\ti\b#\u0001\u0006b]:|G/\u0019;j_:L!a >\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0004\u0001\t\n\u0011\"\u0001\u0002\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0004U\t\u0019t\u000fC\u0005\u0002\f\u0001\t\n\u0011\"\u0001\u0002\u000e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\bU\tYt\u000fC\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001\u0002\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0004\"CA\f\u0001\u0005\u0005I\u0011IA\r\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0004\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002 \t11\u000b\u001e:j]\u001eD\u0011\"!\f\u0001\u0003\u0003%\t!a\f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0002cA\b\u00024%\u0019\u0011Q\u0007\t\u0003\u0007%sG\u000fC\u0005\u0002:\u0001\t\t\u0011\"\u0001\u0002<\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001f\u0003\u0007\u00022aDA \u0013\r\t\t\u0005\u0005\u0002\u0004\u0003:L\bBCA#\u0003o\t\t\u00111\u0001\u00022\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005%\u0003!!A\u0005B\u0005-\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0003CBA(\u0003+\ni$\u0004\u0002\u0002R)\u0019\u00111\u000b\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002X\u0005E#\u0001C%uKJ\fGo\u001c:\t\u0013\u0005m\u0003!!A\u0005\u0002\u0005u\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0013Q\r\t\u0004\u001f\u0005\u0005\u0014bAA2!\t9!i\\8mK\u0006t\u0007BCA#\u00033\n\t\u00111\u0001\u0002>!I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00131N\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\u0007\u0005\n\u0003_\u0002\u0011\u0011!C!\u0003c\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037A\u0011\"!\u001e\u0001\u0003\u0003%\t%a\u001e\u0002\r\u0015\fX/\u00197t)\u0011\ty&!\u001f\t\u0015\u0005\u0015\u00131OA\u0001\u0002\u0004\ti\u0004K\u0004\u0001\u0003{\n9)!#\u0011\t\u0005}\u00141Q\u0007\u0003\u0003\u0003S!! \u0003\n\t\u0005\u0015\u0015\u0011\u0011\u0002\n'B\f'o[\"pI\u0016\f1!\u001e:jC\t\tY)A>iiR\u00048OO\u00180O&$\b.\u001e2/G>lw&\u00199bG\",wf\u001d9be.|#\r\\8c_Y\u0014d\u0006\r\u00181_5dG.\u001b20gJ\u001cw&\\1j]>\u001a8-\u00197b_=\u0014xmL1qC\u000eDWmL:qCJ\\w&\u001c70e\u0016<'/Z:tS>tw&\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|gNL:dC2\fw!CAH\u0005\u0005\u0005\t\u0012AAI\u0003i\te\tV*veZLg/\u00197SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\rA\u00151\u0013\u0004\t\u0003\t\t\t\u0011#\u0001\u0002\u0016N)\u00111SAL7AI\u0011\u0011TAPCMZ4gR\u0007\u0003\u00037S1!!(\u0011\u0003\u001d\u0011XO\u001c;j[\u0016LA!!)\u0002\u001c\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\t\u000f\u0015\u000b\u0019\n\"\u0001\u0002&R\u0011\u0011\u0011\u0013\u0005\u000b\u0003_\n\u0019*!A\u0005F\u0005E\u0004\"\u0003(\u0002\u0014\u0006\u0005I\u0011QAV)%9\u0015QVAX\u0003c\u000b\u0019\f\u0003\u0004 \u0003S\u0003\r!\t\u0005\u0007c\u0005%\u0006\u0019A\u001a\t\re\nI\u000b1\u0001<\u0011\u0019\t\u0015\u0011\u0016a\u0001g!Q\u0011qWAJ\u0003\u0003%\t)!/\u0002\u000fUt\u0017\r\u001d9msR!\u00111XAd!\u0015y\u0011QXAa\u0013\r\ty\f\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f=\t\u0019-I\u001a<g%\u0019\u0011Q\u0019\t\u0003\rQ+\b\u000f\\35\u0011%\tI-!.\u0002\u0002\u0003\u0007q)A\u0002yIAB!\"!4\u0002\u0014\u0006\u0005I\u0011BAh\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0007\u0003BA\u000f\u0003'LA!!6\u0002 \t1qJ\u00196fGR\u0004")
public class AFTSurvivalRegressionModel
implements Model,
Product,
Serializable {
    private final Vector coefficients;
    private final double intercept;
    private final double[] quantileProbabilities;
    private final double scale;

    public static Option<Tuple4<Vector, Object, double[], Object>> unapply(AFTSurvivalRegressionModel aFTSurvivalRegressionModel) {
        return AFTSurvivalRegressionModel$.MODULE$.unapply(aFTSurvivalRegressionModel);
    }

    public static Function1<Tuple4<Vector, Object, double[], Object>, AFTSurvivalRegressionModel> tupled() {
        return AFTSurvivalRegressionModel$.MODULE$.tupled();
    }

    public static Function1<Vector, Function1<Object, Function1<double[], Function1<Object, AFTSurvivalRegressionModel>>>> curried() {
        return AFTSurvivalRegressionModel$.MODULE$.curried();
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double[] quantileProbabilities() {
        return this.quantileProbabilities;
    }

    public double scale() {
        return this.scale;
    }

    public double apply(Vector features) {
        return this.predict(features);
    }

    public Tuple2<Object, Vector> predictWithQuantiles(Vector features) {
        Vector quantiles = this.predictQuantiles(features);
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)this.predict(features)), (Object)quantiles);
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
        double k = 1.0 / this.scale();
        double[] quantiles = (double[])Predef$.MODULE$.doubleArrayOps(this.quantileProbabilities()).map((Function1)new Serializable(this, lambda, k){
            public static final long serialVersionUID = 0L;
            private final double lambda$1;
            private final double k$1;

            public final double apply(double q) {
                return this.apply$mcDD$sp(q);
            }

            public double apply$mcDD$sp(double q) {
                return this.lambda$1 * package$.MODULE$.exp(package$.MODULE$.log(-package$.MODULE$.log(1.0 - q)) / this.k$1);
            }
            {
                this.lambda$1 = lambda$1;
                this.k$1 = k$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return Vectors$.MODULE$.dense(quantiles);
    }

    public double predict(Vector features) {
        return package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public StructType inputSchema() {
        return (StructType)StructType$.MODULE$.apply(StructField$.MODULE$.apply((Tuple2<String, DataType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)TensorType$.MODULE$.Double((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{this.coefficients().size()})))), (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])new StructField[0])).get();
    }

    @Override
    public StructType outputSchema() {
        return (StructType)StructType$.MODULE$.apply(StructField$.MODULE$.apply((Tuple2<String, DataType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prediction"), (Object)ScalarType$.MODULE$.Double().nonNullable())), (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{StructField$.MODULE$.apply((Tuple2<String, DataType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quantiles"), (Object)TensorType$.MODULE$.Double((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{this.quantileProbabilities().length}))))})).get();
    }

    public AFTSurvivalRegressionModel copy(Vector coefficients, double intercept, double[] quantileProbabilities, double scale) {
        return new AFTSurvivalRegressionModel(coefficients, intercept, quantileProbabilities, scale);
    }

    public Vector copy$default$1() {
        return this.coefficients();
    }

    public double copy$default$2() {
        return this.intercept();
    }

    public double[] copy$default$3() {
        return this.quantileProbabilities();
    }

    public double copy$default$4() {
        return this.scale();
    }

    public String productPrefix() {
        return "AFTSurvivalRegressionModel";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n2 = x$1;
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToDouble((double)this.scale());
                break;
            }
            case 2: {
                object = this.quantileProbabilities();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this.intercept());
                break;
            }
            case 0: {
                object = this.coefficients();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AFTSurvivalRegressionModel;
    }

    public int hashCode() {
        int n2 = -889275714;
        n2 = Statics.mix((int)n2, (int)Statics.anyHash((Object)this.coefficients()));
        n2 = Statics.mix((int)n2, (int)Statics.doubleHash((double)this.intercept()));
        n2 = Statics.mix((int)n2, (int)Statics.anyHash((Object)this.quantileProbabilities()));
        n2 = Statics.mix((int)n2, (int)Statics.doubleHash((double)this.scale()));
        return Statics.finalizeHash((int)n2, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AFTSurvivalRegressionModel)) return false;
        boolean bl = true;
        if (!bl) return false;
        AFTSurvivalRegressionModel aFTSurvivalRegressionModel = (AFTSurvivalRegressionModel)x$1;
        Vector vector = this.coefficients();
        Vector vector2 = aFTSurvivalRegressionModel.coefficients();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        if (this.intercept() != aFTSurvivalRegressionModel.intercept()) return false;
        if (this.quantileProbabilities() != aFTSurvivalRegressionModel.quantileProbabilities()) return false;
        if (this.scale() != aFTSurvivalRegressionModel.scale()) return false;
        if (!aFTSurvivalRegressionModel.canEqual(this)) return false;
        return true;
    }

    public AFTSurvivalRegressionModel(Vector coefficients, double intercept, double[] quantileProbabilities, double scale) {
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.quantileProbabilities = quantileProbabilities;
        this.scale = scale;
        Product.class.$init$((Product)this);
    }
}

