/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.com.typesafe.config.impl;

import ml.combust.mleap.shaded.com.typesafe.config.ConfigException;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigObject;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ConfigImpl;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Container;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Path;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveContext;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveResult;
import ml.combust.mleap.shaded.com.typesafe.config.impl.SimpleConfigObject;
import ml.combust.mleap.shaded.com.typesafe.config.impl.SubstitutionExpression;

final class ResolveSource {
    final AbstractConfigObject root;
    final Node<Container> pathFromRoot;

    ResolveSource(AbstractConfigObject root2, Node<Container> pathFromRoot) {
        this.root = root2;
        this.pathFromRoot = pathFromRoot;
    }

    ResolveSource(AbstractConfigObject root2) {
        this.root = root2;
        this.pathFromRoot = null;
    }

    private AbstractConfigObject rootMustBeObj(Container value2) {
        if (value2 instanceof AbstractConfigObject) {
            return (AbstractConfigObject)value2;
        }
        return SimpleConfigObject.empty();
    }

    private static ResultWithPath findInObject(AbstractConfigObject obj, ResolveContext context, Path path2) throws AbstractConfigValue.NotPossibleToResolve {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("*** finding '" + path2 + "' in " + obj);
        }
        Path restriction = context.restrictToChild();
        ResolveResult<? extends AbstractConfigValue> partiallyResolved = context.restrict(path2).resolve(obj, new ResolveSource(obj));
        ResolveContext newContext = partiallyResolved.context.restrict(restriction);
        if (partiallyResolved.value instanceof AbstractConfigObject) {
            ValueWithPath pair = ResolveSource.findInObject((AbstractConfigObject)partiallyResolved.value, path2);
            return new ResultWithPath(ResolveResult.make(newContext, pair.value), pair.pathFromRoot);
        }
        throw new ConfigException.BugOrBroken("resolved object to non-object " + obj + " to " + partiallyResolved);
    }

    private static ValueWithPath findInObject(AbstractConfigObject obj, Path path2) {
        try {
            return ResolveSource.findInObject(obj, path2, null);
        }
        catch (ConfigException.NotResolved e) {
            throw ConfigImpl.improveNotResolved(path2, e);
        }
    }

    private static ValueWithPath findInObject(AbstractConfigObject obj, Path path2, Node<Container> parents) {
        Node<Container> newParents;
        String key2 = path2.first();
        Path next = path2.remainder();
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("*** looking up '" + key2 + "' in " + obj);
        }
        AbstractConfigValue v2 = obj.attemptPeekWithPartialResolve(key2);
        Node<Container> node = newParents = parents == null ? new Node<Container>(obj) : parents.prepend(obj);
        if (next == null) {
            return new ValueWithPath(v2, newParents);
        }
        if (v2 instanceof AbstractConfigObject) {
            return ResolveSource.findInObject((AbstractConfigObject)v2, next, newParents);
        }
        return new ValueWithPath(null, newParents);
    }

    ResultWithPath lookupSubst(ResolveContext context, SubstitutionExpression subst, int prefixLength) throws AbstractConfigValue.NotPossibleToResolve {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(context.depth(), "searching for " + subst);
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(context.depth(), subst + " - looking up relative to file it occurred in");
        }
        ResultWithPath result2 = ResolveSource.findInObject(this.root, context, subst.path());
        if (result2.result.value == null) {
            Path unprefixed = subst.path().subPath(prefixLength);
            if (prefixLength > 0) {
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(result2.result.context.depth(), unprefixed + " - looking up relative to parent file");
                }
                result2 = ResolveSource.findInObject(this.root, result2.result.context, unprefixed);
            }
            if (result2.result.value == null && result2.result.context.options().getUseSystemEnvironment()) {
                if (ConfigImpl.traceSubstitutionsEnabled()) {
                    ConfigImpl.trace(result2.result.context.depth(), unprefixed + " - looking up in system environment");
                }
                result2 = ResolveSource.findInObject(ConfigImpl.envVariablesAsConfigObject(), context, unprefixed);
            }
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace(result2.result.context.depth(), "resolved to " + result2);
        }
        return result2;
    }

    ResolveSource pushParent(Container parent) {
        if (parent == null) {
            throw new ConfigException.BugOrBroken("can't push null parent");
        }
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("pushing parent " + parent + " ==root " + (parent == this.root) + " onto " + this);
        }
        if (this.pathFromRoot == null) {
            if (parent == this.root) {
                return new ResolveSource(this.root, new Node<Container>(parent));
            }
            if (ConfigImpl.traceSubstitutionsEnabled() && this.root.hasDescendant((AbstractConfigValue)((Object)parent))) {
                ConfigImpl.trace("***** BUG ***** tried to push parent " + parent + " without having a path to it in " + this);
            }
            return this;
        }
        Container parentParent = this.pathFromRoot.head();
        if (ConfigImpl.traceSubstitutionsEnabled() && parentParent != null && !parentParent.hasDescendant((AbstractConfigValue)((Object)parent))) {
            ConfigImpl.trace("***** BUG ***** trying to push non-child of " + parentParent + ", non-child was " + parent);
        }
        return new ResolveSource(this.root, this.pathFromRoot.prepend(parent));
    }

    ResolveSource resetParents() {
        if (this.pathFromRoot == null) {
            return this;
        }
        return new ResolveSource(this.root);
    }

    private static Node<Container> replace(Node<Container> list2, Container old, AbstractConfigValue replacement) {
        Container parent;
        Container child = list2.head();
        if (child != old) {
            throw new ConfigException.BugOrBroken("Can only replace() the top node we're resolving; had " + child + " on top and tried to replace " + old + " overall list was " + list2);
        }
        Container container = parent = list2.tail() == null ? null : list2.tail().head();
        if (replacement == null || !(replacement instanceof Container)) {
            if (parent == null) {
                return null;
            }
            AbstractConfigValue newParent = parent.replaceChild((AbstractConfigValue)((Object)old), null);
            return ResolveSource.replace(list2.tail(), parent, newParent);
        }
        if (parent == null) {
            return new Node<Container>((Container)((Object)replacement));
        }
        AbstractConfigValue newParent = parent.replaceChild((AbstractConfigValue)((Object)old), replacement);
        Node<Container> newTail = ResolveSource.replace(list2.tail(), parent, newParent);
        if (newTail != null) {
            return newTail.prepend((Container)((Object)replacement));
        }
        return new Node<Container>((Container)((Object)replacement));
    }

    ResolveSource replaceCurrentParent(Container old, Container replacement) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("replaceCurrentParent old " + old + "@" + System.identityHashCode(old) + " replacement " + replacement + "@" + System.identityHashCode(old) + " in " + this);
        }
        if (old == replacement) {
            return this;
        }
        if (this.pathFromRoot != null) {
            Node<Container> newPath = ResolveSource.replace(this.pathFromRoot, old, (AbstractConfigValue)((Object)replacement));
            if (ConfigImpl.traceSubstitutionsEnabled()) {
                ConfigImpl.trace("replaced " + old + " with " + replacement + " in " + this);
                ConfigImpl.trace("path was: " + this.pathFromRoot + " is now " + newPath);
            }
            if (newPath != null) {
                return new ResolveSource((AbstractConfigObject)newPath.last(), newPath);
            }
            return new ResolveSource(SimpleConfigObject.empty());
        }
        if (old == this.root) {
            return new ResolveSource(this.rootMustBeObj(replacement));
        }
        throw new ConfigException.BugOrBroken("attempt to replace root " + this.root + " with " + replacement);
    }

    ResolveSource replaceWithinCurrentParent(AbstractConfigValue old, AbstractConfigValue replacement) {
        if (ConfigImpl.traceSubstitutionsEnabled()) {
            ConfigImpl.trace("replaceWithinCurrentParent old " + old + "@" + System.identityHashCode(old) + " replacement " + replacement + "@" + System.identityHashCode(old) + " in " + this);
        }
        if (old == replacement) {
            return this;
        }
        if (this.pathFromRoot != null) {
            Container parent;
            AbstractConfigValue newParent = (parent = this.pathFromRoot.head()).replaceChild(old, replacement);
            return this.replaceCurrentParent(parent, newParent instanceof Container ? (Container)((Object)newParent) : null);
        }
        if (old == this.root && replacement instanceof Container) {
            return new ResolveSource(this.rootMustBeObj((Container)((Object)replacement)));
        }
        throw new ConfigException.BugOrBroken("replace in parent not possible " + old + " with " + replacement + " in " + this);
    }

    public String toString() {
        return "ResolveSource(root=" + this.root + ", pathFromRoot=" + this.pathFromRoot + ")";
    }

    static final class ResultWithPath {
        final ResolveResult<? extends AbstractConfigValue> result;
        final Node<Container> pathFromRoot;

        ResultWithPath(ResolveResult<? extends AbstractConfigValue> result2, Node<Container> pathFromRoot) {
            this.result = result2;
            this.pathFromRoot = pathFromRoot;
        }

        public String toString() {
            return "ResultWithPath(result=" + this.result + ", pathFromRoot=" + this.pathFromRoot + ")";
        }
    }

    static final class ValueWithPath {
        final AbstractConfigValue value;
        final Node<Container> pathFromRoot;

        ValueWithPath(AbstractConfigValue value2, Node<Container> pathFromRoot) {
            this.value = value2;
            this.pathFromRoot = pathFromRoot;
        }

        public String toString() {
            return "ValueWithPath(value=" + this.value + ", pathFromRoot=" + this.pathFromRoot + ")";
        }
    }

    static final class Node<T> {
        final T value;
        final Node<T> next;

        Node(T value2, Node<T> next) {
            this.value = value2;
            this.next = next;
        }

        Node(T value2) {
            this(value2, null);
        }

        Node<T> prepend(T value2) {
            return new Node<T>(value2, this);
        }

        T head() {
            return this.value;
        }

        Node<T> tail() {
            return this.next;
        }

        T last() {
            Node<T> i2 = this;
            while (i2.next != null) {
                i2 = i2.next;
            }
            return i2.value;
        }

        Node<T> reverse() {
            if (this.next == null) {
                return this;
            }
            Node<T> reversed = new Node<T>(this.value);
            Node<T> i2 = this.next;
            while (i2 != null) {
                reversed = reversed.prepend(i2.value);
                i2 = i2.next;
            }
            return reversed;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            Node<T> toAppendValue = this.reverse();
            while (toAppendValue != null) {
                sb.append(toAppendValue.value.toString());
                if (toAppendValue.next != null) {
                    sb.append(" <= ");
                }
                toAppendValue = toAppendValue.next;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

