/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dct;

import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckDoubleDCT {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static double eps = Math.pow(2.0, -52.0);

    private AccuracyCheckDoubleDCT() {
    }

    public static void checkAccuracyDCT_1D() {
        System.out.println("Checking accuracy of 1D DCT...");
        int i2 = 0;
        while (i2 < sizes1D.length) {
            DoubleDCT_1D dct = new DoubleDCT_1D(sizes1D[i2]);
            double err = 0.0;
            double[] a = new double[sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], a);
            double[] b2 = new double[sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], b2);
            dct.forward(a, true);
            dct.inverse(a, true);
            err = AccuracyCheckDoubleDCT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            dct = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyDCT_2D() {
        Object b2;
        Object a;
        double err;
        DoubleDCT_2D dct2;
        System.out.println("Checking accuracy of 2D DCT (double[] input)...");
        int i2 = 0;
        while (i2 < sizes2D.length) {
            dct2 = new DoubleDCT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new double[sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], a);
            b2 = new double[sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], b2);
            dct2.forward((double[])a, true);
            dct2.inverse((double[])a, true);
            err = AccuracyCheckDoubleDCT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            dct2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D DCT (double[][] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            dct2 = new DoubleDCT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new double[sizes2D[i2]][sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], (double[][])a);
            b2 = new double[sizes2D[i2]][sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], (double[][])b2);
            dct2.forward((double[][])a, true);
            dct2.inverse((double[][])a, true);
            err = AccuracyCheckDoubleDCT.computeRMSE((double[][])a, (double[][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            dct2 = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyDCT_3D() {
        Object b2;
        Object a;
        double err;
        DoubleDCT_3D dct3;
        System.out.println("Checking accuracy of 3D DCT (double[] input)...");
        int i2 = 0;
        while (i2 < sizes3D.length) {
            dct3 = new DoubleDCT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new double[sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], a);
            b2 = new double[sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], b2);
            dct3.forward((double[])a, true);
            dct3.inverse((double[])a, true);
            err = AccuracyCheckDoubleDCT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            dct3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D DCT (double[][][] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            dct3 = new DoubleDCT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new double[sizes3D[i2]][sizes3D[i2]][sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], (double[][][])a);
            b2 = new double[sizes3D[i2]][sizes3D[i2]][sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], (double[][][])b2);
            dct3.forward((double[][][])a, true);
            dct3.inverse((double[][][])a, true);
            err = AccuracyCheckDoubleDCT.computeRMSE((double[][][])a, (double[][][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            dct3 = null;
            System.gc();
            ++i2;
        }
    }

    private static double computeRMSE(double[] a, double[] b2) {
        if (a.length != b2.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        int i2 = 0;
        while (i2 < a.length) {
            double tmp = a[i2] - b2[i2];
            rms += tmp * tmp;
            ++i2;
        }
        return Math.sqrt(rms / (double)a.length);
    }

    private static double computeRMSE(double[][] a, double[][] b2) {
        if (a.length != b2.length || a[0].length != b2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        int r = 0;
        while (r < a.length) {
            int c = 0;
            while (c < a[0].length) {
                double tmp = a[r][c] - b2[r][c];
                rms += tmp * tmp;
                ++c;
            }
            ++r;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length));
    }

    private static double computeRMSE(double[][][] a, double[][][] b2) {
        if (a.length != b2.length || a[0].length != b2[0].length || a[0][0].length != b2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        int s2 = 0;
        while (s2 < a.length) {
            int r = 0;
            while (r < a[0].length) {
                int c = 0;
                while (c < a[0][0].length) {
                    double tmp = a[s2][r][c] - b2[s2][r][c];
                    rms += tmp * tmp;
                    ++c;
                }
                ++r;
            }
            ++s2;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length * a[0][0].length));
    }

    public static void main(String[] args) {
        AccuracyCheckDoubleDCT.checkAccuracyDCT_1D();
        AccuracyCheckDoubleDCT.checkAccuracyDCT_2D();
        AccuracyCheckDoubleDCT.checkAccuracyDCT_3D();
        System.exit(0);
    }
}

