/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.core.ann;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import ml.combust.mleap.core.annotation.SparkCode;
import ml.combust.mleap.shaded.com.github.fommil.netlib.BLAS;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;

@SparkCode(uri="https://github.com/apache/spark/blob/v2.0.0/mllib/src/main/scala/org/apache/spark/ml/ann/BreezeUtil.scala")
public final class BreezeUtil$ {
    public static final BreezeUtil$ MODULE$;

    static {
        new BreezeUtil$();
    }

    private String transposeString(DenseMatrix<Object> A) {
        return A.isTranspose() ? "T" : "N";
    }

    public void dgemm(double alpha, DenseMatrix<Object> A, DenseMatrix<Object> B, double beta, DenseMatrix<Object> C) {
        Predef$.MODULE$.require(A.cols() == B.rows(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A & B Dimension mismatch!";
            }
        });
        Predef$.MODULE$.require(A.rows() == C.rows(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A & C Dimension mismatch!";
            }
        });
        Predef$.MODULE$.require(B.cols() == C.cols(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A & C Dimension mismatch!";
            }
        });
        BLAS.getInstance().dgemm(this.transposeString(A), this.transposeString(B), C.rows(), C.cols(), A.cols(), alpha, A.data$mcD$sp(), A.offset(), A.majorStride(), B.data$mcD$sp(), B.offset(), B.majorStride(), beta, C.data$mcD$sp(), C.offset(), C.rows());
    }

    public void dgemv(double alpha, DenseMatrix<Object> A, DenseVector<Object> x, double beta, DenseVector<Object> y) {
        Predef$.MODULE$.require(A.cols() == x.length(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A & x Dimension mismatch!";
            }
        });
        Predef$.MODULE$.require(A.rows() == y.length(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A & y Dimension mismatch!";
            }
        });
        BLAS.getInstance().dgemv(this.transposeString(A), A.rows(), A.cols(), alpha, A.data$mcD$sp(), A.offset(), A.majorStride(), x.data$mcD$sp(), x.offset(), x.stride(), beta, y.data$mcD$sp(), y.offset(), y.stride());
    }

    private BreezeUtil$() {
        MODULE$ = this;
    }
}

