/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.com.google.protobuf;

import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import ml.combust.mleap.shaded.com.google.protobuf.AbstractProtobufList;
import ml.combust.mleap.shaded.com.google.protobuf.Internal;
import ml.combust.mleap.shaded.com.google.protobuf.PrimitiveNonBoxingCollection;

final class BooleanArrayList
extends AbstractProtobufList<Boolean>
implements Internal.BooleanList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final BooleanArrayList EMPTY_LIST = new BooleanArrayList();
    private boolean[] array;
    private int size;

    public static BooleanArrayList emptyList() {
        return EMPTY_LIST;
    }

    BooleanArrayList() {
        this(new boolean[10], 0);
    }

    private BooleanArrayList(boolean[] other, int size2) {
        this.array = other;
        this.size = size2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BooleanArrayList)) {
            return super.equals(o);
        }
        BooleanArrayList other = (BooleanArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        boolean[] arr = other.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.array[i2] == arr[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            result2 = 31 * result2 + Internal.hashBoolean(this.array[i2]);
        }
        return result2;
    }

    @Override
    public Internal.BooleanList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new BooleanArrayList(Arrays.copyOf(this.array, capacity), this.size);
    }

    @Override
    public Boolean get(int index2) {
        return this.getBoolean(index2);
    }

    @Override
    public boolean getBoolean(int index2) {
        this.ensureIndexInRange(index2);
        return this.array[index2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Boolean set(int index2, Boolean element) {
        return this.setBoolean(index2, element);
    }

    @Override
    public boolean setBoolean(int index2, boolean element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        boolean previousValue = this.array[index2];
        this.array[index2] = element;
        return previousValue;
    }

    @Override
    public void add(int index2, Boolean element) {
        this.addBoolean(index2, element);
    }

    @Override
    public void addBoolean(boolean element) {
        this.addBoolean(this.size, element);
    }

    private void addBoolean(int index2, boolean element) {
        this.ensureIsMutable();
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index2, this.array, index2 + 1, this.size - index2);
        } else {
            int length = this.size * 3 / 2 + 1;
            boolean[] newArray = new boolean[length];
            System.arraycopy(this.array, 0, newArray, 0, index2);
            System.arraycopy(this.array, index2, newArray, index2 + 1, this.size - index2);
            this.array = newArray;
        }
        this.array[index2] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof BooleanArrayList)) {
            return super.addAll(collection);
        }
        BooleanArrayList list2 = (BooleanArrayList)collection;
        if (list2.size == 0) {
            return false;
        }
        int overflow = Integer.MAX_VALUE - this.size;
        if (overflow < list2.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list2.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list2.array, 0, this.array, this.size, list2.size);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.ensureIsMutable();
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!o.equals(this.array[i2])) continue;
            System.arraycopy(this.array, i2 + 1, this.array, i2, this.size - i2);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Boolean remove(int index2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        boolean value2 = this.array[index2];
        System.arraycopy(this.array, index2 + 1, this.array, index2, this.size - index2);
        --this.size;
        ++this.modCount;
        return value2;
    }

    private void ensureIndexInRange(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index2) {
        return "Index:" + index2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

