/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.com.google.protobuf;

import java.io.IOException;
import java.util.Arrays;
import ml.combust.mleap.shaded.com.google.protobuf.ByteString;
import ml.combust.mleap.shaded.com.google.protobuf.CodedInputStream;
import ml.combust.mleap.shaded.com.google.protobuf.CodedOutputStream;
import ml.combust.mleap.shaded.com.google.protobuf.InvalidProtocolBufferException;
import ml.combust.mleap.shaded.com.google.protobuf.MessageLiteToString;
import ml.combust.mleap.shaded.com.google.protobuf.WireFormat;

public final class UnknownFieldSetLite {
    private static final int MIN_CAPACITY = 8;
    private static final UnknownFieldSetLite DEFAULT_INSTANCE = new UnknownFieldSetLite(0, new int[0], new Object[0], false);
    private int count;
    private int[] tags;
    private Object[] objects;
    private int memoizedSerializedSize = -1;
    private boolean isMutable;

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    static UnknownFieldSetLite newInstance() {
        return new UnknownFieldSetLite();
    }

    static UnknownFieldSetLite mutableCopyOf(UnknownFieldSetLite first, UnknownFieldSetLite second) {
        int count = first.count + second.count;
        int[] tags = Arrays.copyOf(first.tags, count);
        System.arraycopy(second.tags, 0, tags, first.count, second.count);
        Object[] objects = Arrays.copyOf(first.objects, count);
        System.arraycopy(second.objects, 0, objects, first.count, second.count);
        return new UnknownFieldSetLite(count, tags, objects, true);
    }

    private UnknownFieldSetLite() {
        this(0, new int[8], new Object[8], true);
    }

    private UnknownFieldSetLite(int count, int[] tags, Object[] objects, boolean isMutable) {
        this.count = count;
        this.tags = tags;
        this.objects = objects;
        this.isMutable = isMutable;
    }

    public void makeImmutable() {
        this.isMutable = false;
    }

    void checkMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        block7: for (int i2 = 0; i2 < this.count; ++i2) {
            int tag = this.tags[i2];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    output.writeUInt64(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 5: {
                    output.writeFixed32(fieldNumber, (Integer)this.objects[i2]);
                    continue block7;
                }
                case 1: {
                    output.writeFixed64(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 2: {
                    output.writeBytes(fieldNumber, (ByteString)this.objects[i2]);
                    continue block7;
                }
                case 3: {
                    output.writeTag(fieldNumber, 3);
                    ((UnknownFieldSetLite)this.objects[i2]).writeTo(output);
                    output.writeTag(fieldNumber, 4);
                    continue block7;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
    }

    public void writeAsMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i2]);
            output.writeRawMessageSetExtension(fieldNumber, (ByteString)this.objects[i2]);
        }
    }

    public int getSerializedSizeAsMessageSet() {
        int size2 = this.memoizedSerializedSize;
        if (size2 != -1) {
            return size2;
        }
        size2 = 0;
        for (int i2 = 0; i2 < this.count; ++i2) {
            int tag = this.tags[i2];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            size2 += CodedOutputStream.computeRawMessageSetExtensionSize(fieldNumber, (ByteString)this.objects[i2]);
        }
        this.memoizedSerializedSize = size2;
        return size2;
    }

    public int getSerializedSize() {
        int size2 = this.memoizedSerializedSize;
        if (size2 != -1) {
            return size2;
        }
        size2 = 0;
        block7: for (int i2 = 0; i2 < this.count; ++i2) {
            int tag = this.tags[i2];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    size2 += CodedOutputStream.computeUInt64Size(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 5: {
                    size2 += CodedOutputStream.computeFixed32Size(fieldNumber, (Integer)this.objects[i2]);
                    continue block7;
                }
                case 1: {
                    size2 += CodedOutputStream.computeFixed64Size(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 2: {
                    size2 += CodedOutputStream.computeBytesSize(fieldNumber, (ByteString)this.objects[i2]);
                    continue block7;
                }
                case 3: {
                    size2 += CodedOutputStream.computeTagSize(fieldNumber) * 2 + ((UnknownFieldSetLite)this.objects[i2]).getSerializedSize();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(InvalidProtocolBufferException.invalidWireType());
                }
            }
        }
        this.memoizedSerializedSize = size2;
        return size2;
    }

    private static boolean equals(int[] tags1, int[] tags2, int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            if (tags1[i2] == tags2[i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(Object[] objects1, Object[] objects2, int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            if (objects1[i2].equals(objects2[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnknownFieldSetLite)) {
            return false;
        }
        UnknownFieldSetLite other = (UnknownFieldSetLite)obj;
        return this.count == other.count && UnknownFieldSetLite.equals(this.tags, other.tags, this.count) && UnknownFieldSetLite.equals(this.objects, other.objects, this.count);
    }

    public int hashCode() {
        int hashCode2 = 17;
        hashCode2 = 31 * hashCode2 + this.count;
        hashCode2 = 31 * hashCode2 + Arrays.hashCode(this.tags);
        hashCode2 = 31 * hashCode2 + Arrays.deepHashCode(this.objects);
        return hashCode2;
    }

    final void printWithIndent(StringBuilder buffer, int indent) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i2]);
            MessageLiteToString.printField(buffer, indent, String.valueOf(fieldNumber), this.objects[i2]);
        }
    }

    void storeField(int tag, Object value2) {
        this.checkMutable();
        this.ensureCapacity();
        this.tags[this.count] = tag;
        this.objects[this.count] = value2;
        ++this.count;
    }

    private void ensureCapacity() {
        if (this.count == this.tags.length) {
            int increment = this.count < 4 ? 8 : this.count >> 1;
            int newLength = this.count + increment;
            this.tags = Arrays.copyOf(this.tags, newLength);
            this.objects = Arrays.copyOf(this.objects, newLength);
        }
    }

    boolean mergeFieldFrom(int tag, CodedInputStream input) throws IOException {
        this.checkMutable();
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                this.storeField(tag, input.readInt64());
                return true;
            }
            case 5: {
                this.storeField(tag, input.readFixed32());
                return true;
            }
            case 1: {
                this.storeField(tag, input.readFixed64());
                return true;
            }
            case 2: {
                this.storeField(tag, input.readBytes());
                return true;
            }
            case 3: {
                UnknownFieldSetLite subFieldSet = new UnknownFieldSetLite();
                subFieldSet.mergeFrom(input);
                input.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
                this.storeField(tag, subFieldSet);
                return true;
            }
            case 4: {
                return false;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    UnknownFieldSetLite mergeVarintField(int fieldNumber, int value2) {
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(fieldNumber, 0), value2);
        return this;
    }

    UnknownFieldSetLite mergeLengthDelimitedField(int fieldNumber, ByteString value2) {
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(fieldNumber, 2), value2);
        return this;
    }

    private UnknownFieldSetLite mergeFrom(CodedInputStream input) throws IOException {
        int tag;
        while ((tag = input.readTag()) != 0 && this.mergeFieldFrom(tag, input)) {
        }
        return this;
    }
}

