/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.com.typesafe.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigException;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigOrigin;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigSyntax;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigNode;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigNodeValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ConfigNodeArray;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ConfigNodeComplexValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ConfigNodeObject;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Path;
import ml.combust.mleap.shaded.com.typesafe.config.impl.PathParser;

final class ConfigNodeRoot
extends ConfigNodeComplexValue {
    private final ConfigOrigin origin;

    ConfigNodeRoot(Collection<AbstractConfigNode> children, ConfigOrigin origin) {
        super(children);
        this.origin = origin;
    }

    @Override
    protected ConfigNodeRoot newNode(Collection<AbstractConfigNode> nodes) {
        throw new ConfigException.BugOrBroken("Tried to indent the root object");
    }

    protected ConfigNodeComplexValue value() {
        for (AbstractConfigNode node : this.children) {
            if (!(node instanceof ConfigNodeComplexValue)) continue;
            return (ConfigNodeComplexValue)node;
        }
        throw new ConfigException.BugOrBroken("ConfigNodeRoot did not contain a value");
    }

    protected ConfigNodeRoot setValue(String desiredPath, AbstractConfigNodeValue value2, ConfigSyntax flavor) {
        ArrayList<AbstractConfigNode> childrenCopy = new ArrayList<AbstractConfigNode>(this.children);
        for (int i2 = 0; i2 < childrenCopy.size(); ++i2) {
            AbstractConfigNode node = (AbstractConfigNode)childrenCopy.get(i2);
            if (!(node instanceof ConfigNodeComplexValue)) continue;
            if (node instanceof ConfigNodeArray) {
                throw new ConfigException.WrongType(this.origin, "The ConfigDocument had an array at the root level, and values cannot be modified inside an array.");
            }
            if (!(node instanceof ConfigNodeObject)) continue;
            if (value2 == null) {
                childrenCopy.set(i2, ((ConfigNodeObject)node).removeValueOnPath(desiredPath, flavor));
            } else {
                childrenCopy.set(i2, ((ConfigNodeObject)node).setValueOnPath(desiredPath, value2, flavor));
            }
            return new ConfigNodeRoot(childrenCopy, this.origin);
        }
        throw new ConfigException.BugOrBroken("ConfigNodeRoot did not contain a value");
    }

    protected boolean hasValue(String desiredPath) {
        Path path2 = PathParser.parsePath(desiredPath);
        ArrayList childrenCopy = new ArrayList(this.children);
        for (int i2 = 0; i2 < childrenCopy.size(); ++i2) {
            AbstractConfigNode node = (AbstractConfigNode)childrenCopy.get(i2);
            if (!(node instanceof ConfigNodeComplexValue)) continue;
            if (node instanceof ConfigNodeArray) {
                throw new ConfigException.WrongType(this.origin, "The ConfigDocument had an array at the root level, and values cannot be modified inside an array.");
            }
            if (!(node instanceof ConfigNodeObject)) continue;
            return ((ConfigNodeObject)node).hasValue(path2);
        }
        throw new ConfigException.BugOrBroken("ConfigNodeRoot did not contain a value");
    }
}

