/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dst;

import java.util.Arrays;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dst.FloatDST_1D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dst.FloatDST_2D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dst.FloatDST_3D;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.ConcurrencyUtils;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.IOUtils;

public class BenchmarkFloatDST {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static int[] sizes1D = new int[]{65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 10368, 27000, 75600, 165375, 362880, 1562500, 0x310000, 6250000};
    private static int[] sizes2D = new int[]{128, 256, 512, 1024, 2048, 4096, 8192, 16384, 260, 520, 1050, 1458, 1960, 2916, 4116, 5832};
    private static int[] sizes3D = new int[]{8, 16, 32, 64, 128, 256, 512, 1024, 5, 17, 30, 95, 180, 270, 324, 420};
    private static boolean doScaling = false;

    private BenchmarkFloatDST() {
    }

    public static void parseArguments(String[] args) {
        if (args.length > 0) {
            nthread = Integer.parseInt(args[0]);
            threadsBegin2D = Integer.parseInt(args[1]);
            threadsBegin3D = Integer.parseInt(args[2]);
            niter = Integer.parseInt(args[3]);
            doWarmup = Boolean.parseBoolean(args[4]);
            doScaling = Boolean.parseBoolean(args[5]);
            nsize = Integer.parseInt(args[6]);
            sizes1D = new int[nsize];
            sizes2D = new int[nsize];
            sizes3D = new int[nsize];
            int i2 = 0;
            while (i2 < nsize) {
                BenchmarkFloatDST.sizes1D[i2] = Integer.parseInt(args[7 + i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < nsize) {
                BenchmarkFloatDST.sizes2D[i2] = Integer.parseInt(args[7 + nsize + i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < nsize) {
                BenchmarkFloatDST.sizes3D[i2] = Integer.parseInt(args[7 + nsize + nsize + i2]);
                ++i2;
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads(nthread);
        ConcurrencyUtils.setThreadsBeginN_2D(threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkForward_1D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Forward DST 1D of size " + sizes1D[i2]);
            FloatDST_1D dst = new FloatDST_1D(sizes1D[i2]);
            float[] x = new float[sizes1D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(sizes1D[i2], x);
                dst.forward(x, doScaling);
                IOUtils.fillMatrix_1D(sizes1D[i2], x);
                dst.forward(x, doScaling);
            }
            float av_time = 0.0f;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_1D(sizes1D[i2], x);
                elapsedTime = System.nanoTime();
                dst.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (float)elapsedTime;
                ++j;
            }
            times[i2] = (double)av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dst = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, times);
    }

    public static void benchmarkForward_2D_input_1D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Forward DST 2D (input 1D) of size " + sizes2D[i2] + " x " + sizes2D[i2]);
            FloatDST_2D dst2 = new FloatDST_2D(sizes2D[i2], sizes2D[i2]);
            float[] x = new float[sizes2D[i2] * sizes2D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                dst2.forward(x, doScaling);
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                dst2.forward(x, doScaling);
            }
            float av_time = 0.0f;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                elapsedTime = System.nanoTime();
                dst2.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (float)elapsedTime;
                ++j;
            }
            times[i2] = (double)av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dst2 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times);
    }

    public static void benchmarkForward_2D_input_2D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Forward DST 2D (input 2D) of size " + sizes2D[i2] + " x " + sizes2D[i2]);
            FloatDST_2D dst2 = new FloatDST_2D(sizes2D[i2], sizes2D[i2]);
            float[][] x = new float[sizes2D[i2]][sizes2D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                dst2.forward(x, doScaling);
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                dst2.forward(x, doScaling);
            }
            float av_time = 0.0f;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                elapsedTime = System.nanoTime();
                dst2.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (float)elapsedTime;
                ++j;
            }
            times[i2] = (double)av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dst2 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times);
    }

    public static void benchmarkForward_3D_input_1D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Forward DST 3D (input 1D) of size " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2]);
            FloatDST_3D dst3 = new FloatDST_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            float[] x = new float[sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                dst3.forward(x, doScaling);
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                dst3.forward(x, doScaling);
            }
            float av_time = 0.0f;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                elapsedTime = System.nanoTime();
                dst3.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (float)elapsedTime;
                ++j;
            }
            times[i2] = (double)av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dst3 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times);
    }

    public static void benchmarkForward_3D_input_3D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Forward DST 3D (input 3D) of size " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2]);
            FloatDST_3D dst3 = new FloatDST_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            float[][][] x = new float[sizes3D[i2]][sizes3D[i2]][sizes3D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                dst3.forward(x, doScaling);
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                dst3.forward(x, doScaling);
            }
            float av_time = 0.0f;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                elapsedTime = System.nanoTime();
                dst3.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (float)elapsedTime;
                ++j;
            }
            times[i2] = (double)av_time / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            dst3 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times);
    }

    public static void main(String[] args) {
        BenchmarkFloatDST.parseArguments(args);
        BenchmarkFloatDST.benchmarkForward_1D();
        BenchmarkFloatDST.benchmarkForward_2D_input_1D();
        BenchmarkFloatDST.benchmarkForward_2D_input_2D();
        BenchmarkFloatDST.benchmarkForward_3D_input_1D();
        BenchmarkFloatDST.benchmarkForward_3D_input_3D();
        System.exit(0);
    }
}

