/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dst;

import java.util.concurrent.Future;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.ConcurrencyUtils;

public class DoubleDST_1D {
    private int n;
    private DoubleDCT_1D dct;

    public DoubleDST_1D(int n2) {
        this.n = n2;
        this.dct = new DoubleDCT_1D(n2);
    }

    public void forward(double[] a, boolean scale) {
        this.forward(a, 0, scale);
    }

    public void forward(final double[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        int nd2 = this.n / 2;
        int startIdx = 1 + offa;
        int stopIdx = offa + this.n;
        int i2 = startIdx;
        while (i2 < stopIdx) {
            a[i2] = -a[i2];
            i2 += 2;
        }
        this.dct.forward(a, offa, scale);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && nd2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = nd2 / nthreads;
            Future[] futures = new Future[nthreads];
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? nd2 : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx0 = offa + DoubleDST_1D.this.n - 1;
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int idx2 = offa + i2;
                            double tmp = a[idx2];
                            int idx1 = idx0 - i2;
                            a[idx2] = a[idx1];
                            a[idx1] = tmp;
                            ++i2;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx0 = offa + this.n - 1;
            int i3 = 0;
            while (i3 < nd2) {
                int idx2 = offa + i3;
                double tmp = a[idx2];
                int idx1 = idx0 - i3;
                a[idx2] = a[idx1];
                a[idx1] = tmp;
                ++i3;
            }
        }
    }

    public void inverse(double[] a, boolean scale) {
        this.inverse(a, 0, scale);
    }

    public void inverse(final double[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        int nd2 = this.n / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && nd2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = nd2 / nthreads;
            Future[] futures = new Future[nthreads];
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? nd2 : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx0 = offa + DoubleDST_1D.this.n - 1;
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int idx2 = offa + i2;
                            double tmp = a[idx2];
                            int idx1 = idx0 - i2;
                            a[idx2] = a[idx1];
                            a[idx1] = tmp;
                            ++i2;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx0 = offa + this.n - 1;
            int i2 = 0;
            while (i2 < nd2) {
                double tmp = a[offa + i2];
                a[offa + i2] = a[idx0 - i2];
                a[idx0 - i2] = tmp;
                ++i2;
            }
        }
        this.dct.inverse(a, offa, scale);
        int startidx = 1 + offa;
        int stopidx = offa + this.n;
        int i3 = startidx;
        while (i3 < stopidx) {
            a[i3] = -a[i3];
            i3 += 2;
        }
    }
}

