/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.learner;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.jafama.FastMath;

public class ObjFunction
implements Serializable {
    private static final Map<String, ObjFunction> FUNCTIONS = new HashMap<String, ObjFunction>();

    public static ObjFunction fromName(String name2) {
        ObjFunction result2 = FUNCTIONS.get(name2);
        if (result2 == null) {
            throw new IllegalArgumentException(name2 + " is not supported objective function.");
        }
        return result2;
    }

    public static void register(String name2, ObjFunction objFunction) {
        FUNCTIONS.put(name2, objFunction);
    }

    public static void useFastMathExp(boolean useJafama) {
        if (useJafama) {
            ObjFunction.register("binary:logistic", new RegLossObjLogistic_Jafama());
            ObjFunction.register("reg:logistic", new RegLossObjLogistic_Jafama());
            ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb_Jafama());
        } else {
            ObjFunction.register("binary:logistic", new RegLossObjLogistic());
            ObjFunction.register("reg:logistic", new RegLossObjLogistic());
            ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb());
        }
    }

    public double[] predTransform(double[] preds) {
        return preds;
    }

    public double predTransform(double pred) {
        return pred;
    }

    static {
        ObjFunction.register("rank:pairwise", new ObjFunction());
        ObjFunction.register("binary:logistic", new RegLossObjLogistic());
        ObjFunction.register("binary:logitraw", new ObjFunction());
        ObjFunction.register("multi:softmax", new SoftmaxMultiClassObjClassify());
        ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb());
        ObjFunction.register("reg:linear", new ObjFunction());
        ObjFunction.register("reg:logistic", new RegLossObjLogistic());
    }

    static class SoftmaxMultiClassObjProb_Jafama
    extends SoftmaxMultiClassObjProb {
        SoftmaxMultiClassObjProb_Jafama() {
        }

        @Override
        double exp(double x) {
            return FastMath.exp(x);
        }
    }

    static class SoftmaxMultiClassObjProb
    extends ObjFunction {
        SoftmaxMultiClassObjProb() {
        }

        @Override
        public double[] predTransform(double[] preds) {
            int i2;
            double max = preds[0];
            for (int i3 = 1; i3 < preds.length; ++i3) {
                max = Math.max(preds[i3], max);
            }
            double sum = 0.0;
            for (i2 = 0; i2 < preds.length; ++i2) {
                preds[i2] = this.exp(preds[i2] - max);
                sum += preds[i2];
            }
            i2 = 0;
            while (i2 < preds.length) {
                int n2 = i2++;
                preds[n2] = preds[n2] / (double)((float)sum);
            }
            return preds;
        }

        @Override
        public double predTransform(double pred) {
            throw new UnsupportedOperationException();
        }

        double exp(double x) {
            return Math.exp(x);
        }
    }

    static class SoftmaxMultiClassObjClassify
    extends ObjFunction {
        SoftmaxMultiClassObjClassify() {
        }

        @Override
        public double[] predTransform(double[] preds) {
            int maxIndex = 0;
            double max = preds[0];
            for (int i2 = 1; i2 < preds.length; ++i2) {
                if (!(max < preds[i2])) continue;
                maxIndex = i2;
                max = preds[i2];
            }
            return new double[]{maxIndex};
        }

        @Override
        public double predTransform(double pred) {
            throw new UnsupportedOperationException();
        }
    }

    static class RegLossObjLogistic_Jafama
    extends RegLossObjLogistic {
        RegLossObjLogistic_Jafama() {
        }

        @Override
        double sigmoid(double x) {
            return 1.0 / (1.0 + FastMath.exp(-x));
        }
    }

    static class RegLossObjLogistic
    extends ObjFunction {
        RegLossObjLogistic() {
        }

        @Override
        public double[] predTransform(double[] preds) {
            for (int i2 = 0; i2 < preds.length; ++i2) {
                preds[i2] = this.sigmoid(preds[i2]);
            }
            return preds;
        }

        @Override
        public double predTransform(double pred) {
            return this.sigmoid(pred);
        }

        double sigmoid(double x) {
            return 1.0 / (1.0 + Math.exp(-x));
        }
    }
}

