/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.core.linalg;

import ml.combust.mleap.core.annotation.SparkCode;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.linalg.mleap.BLAS$;
import org.apache.spark.ml.linalg.mleap.VectorWithNorm;
import scala.Predef$;
import scala.math.package$;

@SparkCode(uri="https://github.com/apache/spark/blob/v2.0.0/mllib/src/main/scala/org/apache/spark/mllib/util/MLUtils.scala")
public final class LinalgUtils$ {
    public static final LinalgUtils$ MODULE$;
    private double EPSILON;
    private volatile boolean bitmap$0;

    static {
        new LinalgUtils$();
    }

    /*
     * WARNING - void declaration
     */
    private double EPSILON$lzycompute() {
        LinalgUtils$ linalgUtils$ = this;
        synchronized (linalgUtils$) {
            if (!this.bitmap$0) {
                void var2_2;
                double eps = 1.0;
                while (1.0 + eps / 2.0 != 1.0) {
                    eps /= 2.0;
                }
                this.EPSILON = var2_2;
                this.bitmap$0 = true;
            }
            return this.EPSILON;
        }
    }

    public double EPSILON() {
        return this.bitmap$0 ? this.EPSILON : this.EPSILON$lzycompute();
    }

    public double fastSquaredDistance(VectorWithNorm v1, VectorWithNorm v2) {
        return this.fastSquaredDistance(v1.vector(), v1.norm(), v2.vector(), v2.norm(), this.fastSquaredDistance$default$5());
    }

    public double fastSquaredDistance(Vector v1, double norm1, Vector v2, double norm2, double precision) {
        int n2 = v1.size();
        Predef$.MODULE$.require(v2.size() == n2);
        Predef$.MODULE$.require(norm1 >= 0.0 && norm2 >= 0.0);
        double sumSquaredNorm = norm1 * norm1 + norm2 * norm2;
        double normDiff = norm1 - norm2;
        double sqDist = 0.0;
        double precisionBound1 = 2.0 * this.EPSILON() * sumSquaredNorm / (normDiff * normDiff + this.EPSILON());
        if (precisionBound1 < precision) {
            sqDist = sumSquaredNorm - 2.0 * BLAS$.MODULE$.dot(v1, v2);
        } else if (v1 instanceof SparseVector || v2 instanceof SparseVector) {
            double dotValue = BLAS$.MODULE$.dot(v1, v2);
            sqDist = package$.MODULE$.max(sumSquaredNorm - 2.0 * dotValue, 0.0);
            double precisionBound2 = this.EPSILON() * (sumSquaredNorm + 2.0 * package$.MODULE$.abs(dotValue)) / (sqDist + this.EPSILON());
            if (precisionBound2 > precision) {
                sqDist = Vectors$.MODULE$.sqdist(v1, v2);
            }
        } else {
            sqDist = Vectors$.MODULE$.sqdist(v1, v2);
        }
        return sqDist;
    }

    public double fastSquaredDistance$default$5() {
        return 1.0E-6;
    }

    public double log1pExp(double x) {
        return x > 0.0 ? x + package$.MODULE$.log1p(package$.MODULE$.exp(-x)) : package$.MODULE$.log1p(package$.MODULE$.exp(x));
    }

    private LinalgUtils$() {
        MODULE$ = this;
    }
}

