/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.core.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;

public final class Platform {
    private static final Unsafe _UNSAFE;
    public static final int BYTE_ARRAY_OFFSET;
    public static final int SHORT_ARRAY_OFFSET;
    public static final int INT_ARRAY_OFFSET;
    public static final int LONG_ARRAY_OFFSET;
    public static final int FLOAT_ARRAY_OFFSET;
    public static final int DOUBLE_ARRAY_OFFSET;
    private static final boolean unaligned;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    public static boolean unaligned() {
        return unaligned;
    }

    public static int getInt(Object object, long l2) {
        return _UNSAFE.getInt(object, l2);
    }

    public static void putInt(Object object, long l2, int n2) {
        _UNSAFE.putInt(object, l2, n2);
    }

    public static boolean getBoolean(Object object, long l2) {
        return _UNSAFE.getBoolean(object, l2);
    }

    public static void putBoolean(Object object, long l2, boolean bl) {
        _UNSAFE.putBoolean(object, l2, bl);
    }

    public static byte getByte(Object object, long l2) {
        return _UNSAFE.getByte(object, l2);
    }

    public static void putByte(Object object, long l2, byte by) {
        _UNSAFE.putByte(object, l2, by);
    }

    public static short getShort(Object object, long l2) {
        return _UNSAFE.getShort(object, l2);
    }

    public static void putShort(Object object, long l2, short s2) {
        _UNSAFE.putShort(object, l2, s2);
    }

    public static long getLong(Object object, long l2) {
        return _UNSAFE.getLong(object, l2);
    }

    public static void putLong(Object object, long l2, long l3) {
        _UNSAFE.putLong(object, l2, l3);
    }

    public static float getFloat(Object object, long l2) {
        return _UNSAFE.getFloat(object, l2);
    }

    public static void putFloat(Object object, long l2, float f2) {
        _UNSAFE.putFloat(object, l2, f2);
    }

    public static double getDouble(Object object, long l2) {
        return _UNSAFE.getDouble(object, l2);
    }

    public static void putDouble(Object object, long l2, double d2) {
        _UNSAFE.putDouble(object, l2, d2);
    }

    public static Object getObjectVolatile(Object object, long l2) {
        return _UNSAFE.getObjectVolatile(object, l2);
    }

    public static void putObjectVolatile(Object object, long l2, Object object2) {
        _UNSAFE.putObjectVolatile(object, l2, object2);
    }

    public static long allocateMemory(long l2) {
        return _UNSAFE.allocateMemory(l2);
    }

    public static void freeMemory(long l2) {
        _UNSAFE.freeMemory(l2);
    }

    public static long reallocateMemory(long l2, long l3, long l4) {
        long l5 = _UNSAFE.allocateMemory(l4);
        Platform.copyMemory(null, l2, null, l5, l3);
        Platform.freeMemory(l2);
        return l5;
    }

    public static ByteBuffer allocateDirectBuffer(int n2) {
        try {
            Class<?> clazz = Class.forName("java.nio.DirectByteBuffer");
            Constructor<?> constructor = clazz.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            constructor.setAccessible(true);
            Field field2 = clazz.getDeclaredField("cleaner");
            field2.setAccessible(true);
            final long l2 = Platform.allocateMemory(n2);
            ByteBuffer byteBuffer = (ByteBuffer)constructor.newInstance(l2, n2);
            Cleaner cleaner = Cleaner.create((Object)byteBuffer, (Runnable)new Runnable(){

                @Override
                public void run() {
                    Platform.freeMemory(l2);
                }
            });
            field2.set(byteBuffer, cleaner);
            return byteBuffer;
        }
        catch (Exception exception) {
            Platform.throwException(exception);
            throw new IllegalStateException("unreachable");
        }
    }

    public static void setMemory(long l2, byte by, long l3) {
        _UNSAFE.setMemory(l2, l3, by);
    }

    public static void copyMemory(Object object, long l2, Object object2, long l3, long l4) {
        if (l3 < l2) {
            while (l4 > 0L) {
                long l5 = Math.min(l4, 0x100000L);
                _UNSAFE.copyMemory(object, l2, object2, l3, l5);
                l4 -= l5;
                l2 += l5;
                l3 += l5;
            }
        } else {
            l2 += l4;
            l3 += l4;
            while (l4 > 0L) {
                long l6 = Math.min(l4, 0x100000L);
                _UNSAFE.copyMemory(object, l2 -= l6, object2, l3 -= l6, l6);
                l4 -= l6;
            }
        }
    }

    public static void throwException(Throwable throwable) {
        _UNSAFE.throwException(throwable);
    }

    static {
        Unsafe unsafe;
        boolean bl;
        AnnotatedElement annotatedElement;
        try {
            annotatedElement = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
            Method method2 = ((Class)annotatedElement).getDeclaredMethod("unaligned", new Class[0]);
            method2.setAccessible(true);
            bl = Boolean.TRUE.equals(method2.invoke(null, new Object[0]));
        }
        catch (Throwable throwable) {
            String string = System.getProperty("os.arch", "");
            bl = string.matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
        }
        unaligned = bl;
        try {
            annotatedElement = Unsafe.class.getDeclaredField("theUnsafe");
            ((Field)annotatedElement).setAccessible(true);
            unsafe = (Unsafe)((Field)annotatedElement).get(null);
        }
        catch (Throwable throwable) {
            unsafe = null;
        }
        _UNSAFE = unsafe;
        if (_UNSAFE != null) {
            BYTE_ARRAY_OFFSET = _UNSAFE.arrayBaseOffset(byte[].class);
            SHORT_ARRAY_OFFSET = _UNSAFE.arrayBaseOffset(short[].class);
            INT_ARRAY_OFFSET = _UNSAFE.arrayBaseOffset(int[].class);
            LONG_ARRAY_OFFSET = _UNSAFE.arrayBaseOffset(long[].class);
            FLOAT_ARRAY_OFFSET = _UNSAFE.arrayBaseOffset(float[].class);
            DOUBLE_ARRAY_OFFSET = _UNSAFE.arrayBaseOffset(double[].class);
        } else {
            BYTE_ARRAY_OFFSET = 0;
            SHORT_ARRAY_OFFSET = 0;
            INT_ARRAY_OFFSET = 0;
            LONG_ARRAY_OFFSET = 0;
            FLOAT_ARRAY_OFFSET = 0;
            DOUBLE_ARRAY_OFFSET = 0;
        }
    }
}

