/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.com.google.protobuf;

import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import ml.combust.mleap.shaded.com.google.protobuf.AbstractProtobufList;
import ml.combust.mleap.shaded.com.google.protobuf.Internal;
import ml.combust.mleap.shaded.com.google.protobuf.PrimitiveNonBoxingCollection;

final class FloatArrayList
extends AbstractProtobufList<Float>
implements Internal.FloatList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final FloatArrayList EMPTY_LIST = new FloatArrayList();
    private float[] array;
    private int size;

    public static FloatArrayList emptyList() {
        return EMPTY_LIST;
    }

    FloatArrayList() {
        this(new float[10], 0);
    }

    private FloatArrayList(float[] other, int size2) {
        this.array = other;
        this.size = size2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatArrayList)) {
            return super.equals(o);
        }
        FloatArrayList other = (FloatArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        float[] arr = other.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.array[i2] == arr[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            result2 = 31 * result2 + Float.floatToIntBits(this.array[i2]);
        }
        return result2;
    }

    @Override
    public Internal.FloatList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new FloatArrayList(Arrays.copyOf(this.array, capacity), this.size);
    }

    @Override
    public Float get(int index2) {
        return Float.valueOf(this.getFloat(index2));
    }

    @Override
    public float getFloat(int index2) {
        this.ensureIndexInRange(index2);
        return this.array[index2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Float set(int index2, Float element) {
        return Float.valueOf(this.setFloat(index2, element.floatValue()));
    }

    @Override
    public float setFloat(int index2, float element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        float previousValue = this.array[index2];
        this.array[index2] = element;
        return previousValue;
    }

    @Override
    public void add(int index2, Float element) {
        this.addFloat(index2, element.floatValue());
    }

    @Override
    public void addFloat(float element) {
        this.addFloat(this.size, element);
    }

    private void addFloat(int index2, float element) {
        this.ensureIsMutable();
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index2, this.array, index2 + 1, this.size - index2);
        } else {
            int length = this.size * 3 / 2 + 1;
            float[] newArray = new float[length];
            System.arraycopy(this.array, 0, newArray, 0, index2);
            System.arraycopy(this.array, index2, newArray, index2 + 1, this.size - index2);
            this.array = newArray;
        }
        this.array[index2] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Float> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof FloatArrayList)) {
            return super.addAll(collection);
        }
        FloatArrayList list2 = (FloatArrayList)collection;
        if (list2.size == 0) {
            return false;
        }
        int overflow = Integer.MAX_VALUE - this.size;
        if (overflow < list2.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list2.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list2.array, 0, this.array, this.size, list2.size);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.ensureIsMutable();
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!o.equals(Float.valueOf(this.array[i2]))) continue;
            System.arraycopy(this.array, i2 + 1, this.array, i2, this.size - i2);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Float remove(int index2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        float value2 = this.array[index2];
        System.arraycopy(this.array, index2 + 1, this.array, index2, this.size - index2);
        --this.size;
        ++this.modCount;
        return Float.valueOf(value2);
    }

    private void ensureIndexInRange(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index2) {
        return "Index:" + index2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

