/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.com.typesafe.config.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigException;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigList;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigOrigin;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigRenderOptions;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigValue;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigValueType;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Container;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Path;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveContext;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveResult;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveSource;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveStatus;
import ml.combust.mleap.shaded.com.typesafe.config.impl.SerializedConfigValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.SimpleConfigOrigin;

final class SimpleConfigList
extends AbstractConfigValue
implements ConfigList,
Container,
Serializable {
    private static final long serialVersionUID = 2L;
    private final List<AbstractConfigValue> value;
    private final boolean resolved;

    SimpleConfigList(ConfigOrigin origin, List<AbstractConfigValue> value2) {
        this(origin, value2, ResolveStatus.fromValues(value2));
    }

    SimpleConfigList(ConfigOrigin origin, List<AbstractConfigValue> value2, ResolveStatus status) {
        super(origin);
        this.value = value2;
        boolean bl = this.resolved = status == ResolveStatus.RESOLVED;
        if (status != ResolveStatus.fromValues(value2)) {
            throw new ConfigException.BugOrBroken("SimpleConfigList created with wrong resolve status: " + this);
        }
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.LIST;
    }

    @Override
    public List<Object> unwrapped() {
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (AbstractConfigValue v2 : this.value) {
            list2.add(v2.unwrapped());
        }
        return list2;
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.fromBoolean(this.resolved);
    }

    @Override
    public SimpleConfigList replaceChild(AbstractConfigValue child, AbstractConfigValue replacement) {
        List<AbstractConfigValue> newList = SimpleConfigList.replaceChildInList(this.value, child, replacement);
        if (newList == null) {
            return null;
        }
        return new SimpleConfigList(this.origin(), newList);
    }

    @Override
    public boolean hasDescendant(AbstractConfigValue descendant) {
        return SimpleConfigList.hasDescendantInList(this.value, descendant);
    }

    private SimpleConfigList modify(AbstractConfigValue.NoExceptionsModifier modifier, ResolveStatus newResolveStatus) {
        try {
            return this.modifyMayThrow(modifier, newResolveStatus);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException.BugOrBroken("unexpected checked exception", e);
        }
    }

    private SimpleConfigList modifyMayThrow(AbstractConfigValue.Modifier modifier, ResolveStatus newResolveStatus) throws Exception {
        ArrayList<AbstractConfigValue> changed = null;
        int i2 = 0;
        for (AbstractConfigValue v2 : this.value) {
            AbstractConfigValue modified = modifier.modifyChildMayThrow(null, v2);
            if (changed == null && modified != v2) {
                changed = new ArrayList<AbstractConfigValue>();
                for (int j = 0; j < i2; ++j) {
                    changed.add(this.value.get(j));
                }
            }
            if (changed != null && modified != null) {
                changed.add(modified);
            }
            ++i2;
        }
        if (changed != null) {
            if (newResolveStatus != null) {
                return new SimpleConfigList(this.origin(), changed, newResolveStatus);
            }
            return new SimpleConfigList(this.origin(), changed);
        }
        return this;
    }

    ResolveResult<? extends SimpleConfigList> resolveSubstitutions(ResolveContext context, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        if (this.resolved) {
            return ResolveResult.make(context, this);
        }
        if (context.isRestrictedToChild()) {
            return ResolveResult.make(context, this);
        }
        try {
            ResolveModifier modifier = new ResolveModifier(context, source.pushParent(this));
            SimpleConfigList value2 = this.modifyMayThrow(modifier, context.options().getAllowUnresolved() ? null : ResolveStatus.RESOLVED);
            return ResolveResult.make(modifier.context, value2);
        }
        catch (AbstractConfigValue.NotPossibleToResolve e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException.BugOrBroken("unexpected checked exception", e);
        }
    }

    @Override
    SimpleConfigList relativized(final Path prefix) {
        return this.modify(new AbstractConfigValue.NoExceptionsModifier(){

            @Override
            public AbstractConfigValue modifyChild(String key2, AbstractConfigValue v2) {
                return v2.relativized(prefix);
            }
        }, this.resolveStatus());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SimpleConfigList;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SimpleConfigList) {
            return this.canEqual(other) && (this.value == ((SimpleConfigList)other).value || this.value.equals(((SimpleConfigList)other).value));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options2) {
        if (this.value.isEmpty()) {
            sb.append("[]");
        } else {
            sb.append("[");
            if (options2.getFormatted()) {
                sb.append('\n');
            }
            for (AbstractConfigValue v2 : this.value) {
                if (options2.getOriginComments()) {
                    String[] lines;
                    for (String l2 : lines = v2.origin().description().split("\n")) {
                        SimpleConfigList.indent(sb, indent + 1, options2);
                        sb.append('#');
                        if (!l2.isEmpty()) {
                            sb.append(' ');
                        }
                        sb.append(l2);
                        sb.append("\n");
                    }
                }
                if (options2.getComments()) {
                    for (String comment : v2.origin().comments()) {
                        SimpleConfigList.indent(sb, indent + 1, options2);
                        sb.append("# ");
                        sb.append(comment);
                        sb.append("\n");
                    }
                }
                SimpleConfigList.indent(sb, indent + 1, options2);
                v2.render(sb, indent + 1, atRoot, options2);
                sb.append(",");
                if (!options2.getFormatted()) continue;
                sb.append('\n');
            }
            sb.setLength(sb.length() - 1);
            if (options2.getFormatted()) {
                sb.setLength(sb.length() - 1);
                sb.append('\n');
                SimpleConfigList.indent(sb, indent, options2);
            }
            sb.append("]");
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.value.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.value.containsAll(c);
    }

    @Override
    public AbstractConfigValue get(int index2) {
        return this.value.get(index2);
    }

    @Override
    public int indexOf(Object o) {
        return this.value.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public Iterator<ConfigValue> iterator() {
        final Iterator<AbstractConfigValue> i2 = this.value.iterator();
        return new Iterator<ConfigValue>(){

            @Override
            public boolean hasNext() {
                return i2.hasNext();
            }

            @Override
            public ConfigValue next() {
                return (ConfigValue)i2.next();
            }

            @Override
            public void remove() {
                throw SimpleConfigList.weAreImmutable("iterator().remove");
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.value.lastIndexOf(o);
    }

    private static ListIterator<ConfigValue> wrapListIterator(final ListIterator<AbstractConfigValue> i2) {
        return new ListIterator<ConfigValue>(){

            @Override
            public boolean hasNext() {
                return i2.hasNext();
            }

            @Override
            public ConfigValue next() {
                return (ConfigValue)i2.next();
            }

            @Override
            public void remove() {
                throw SimpleConfigList.weAreImmutable("listIterator().remove");
            }

            @Override
            public void add(ConfigValue arg0) {
                throw SimpleConfigList.weAreImmutable("listIterator().add");
            }

            @Override
            public boolean hasPrevious() {
                return i2.hasPrevious();
            }

            @Override
            public int nextIndex() {
                return i2.nextIndex();
            }

            @Override
            public ConfigValue previous() {
                return (ConfigValue)i2.previous();
            }

            @Override
            public int previousIndex() {
                return i2.previousIndex();
            }

            @Override
            public void set(ConfigValue arg0) {
                throw SimpleConfigList.weAreImmutable("listIterator().set");
            }
        };
    }

    @Override
    public ListIterator<ConfigValue> listIterator() {
        return SimpleConfigList.wrapListIterator(this.value.listIterator());
    }

    @Override
    public ListIterator<ConfigValue> listIterator(int index2) {
        return SimpleConfigList.wrapListIterator(this.value.listIterator(index2));
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public List<ConfigValue> subList(int fromIndex, int toIndex) {
        ArrayList<ConfigValue> list2 = new ArrayList<ConfigValue>();
        for (AbstractConfigValue v2 : this.value.subList(fromIndex, toIndex)) {
            list2.add(v2);
        }
        return list2;
    }

    @Override
    public Object[] toArray() {
        return this.value.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.value.toArray(a);
    }

    private static UnsupportedOperationException weAreImmutable(String method2) {
        return new UnsupportedOperationException("ConfigList is immutable, you can't call List.'" + method2 + "'");
    }

    @Override
    public boolean add(ConfigValue e) {
        throw SimpleConfigList.weAreImmutable("add");
    }

    @Override
    public void add(int index2, ConfigValue element) {
        throw SimpleConfigList.weAreImmutable("add");
    }

    @Override
    public boolean addAll(Collection<? extends ConfigValue> c) {
        throw SimpleConfigList.weAreImmutable("addAll");
    }

    @Override
    public boolean addAll(int index2, Collection<? extends ConfigValue> c) {
        throw SimpleConfigList.weAreImmutable("addAll");
    }

    @Override
    public void clear() {
        throw SimpleConfigList.weAreImmutable("clear");
    }

    @Override
    public boolean remove(Object o) {
        throw SimpleConfigList.weAreImmutable("remove");
    }

    @Override
    public ConfigValue remove(int index2) {
        throw SimpleConfigList.weAreImmutable("remove");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw SimpleConfigList.weAreImmutable("removeAll");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw SimpleConfigList.weAreImmutable("retainAll");
    }

    @Override
    public ConfigValue set(int index2, ConfigValue element) {
        throw SimpleConfigList.weAreImmutable("set");
    }

    @Override
    protected SimpleConfigList newCopy(ConfigOrigin newOrigin) {
        return new SimpleConfigList(newOrigin, this.value);
    }

    final SimpleConfigList concatenate(SimpleConfigList other) {
        ConfigOrigin combinedOrigin = SimpleConfigOrigin.mergeOrigins(this.origin(), other.origin());
        ArrayList<AbstractConfigValue> combined = new ArrayList<AbstractConfigValue>(this.value.size() + other.value.size());
        combined.addAll(this.value);
        combined.addAll(other.value);
        return new SimpleConfigList(combinedOrigin, combined);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }

    @Override
    public SimpleConfigList withOrigin(ConfigOrigin origin) {
        return (SimpleConfigList)super.withOrigin(origin);
    }

    private static class ResolveModifier
    implements AbstractConfigValue.Modifier {
        ResolveContext context;
        final ResolveSource source;

        ResolveModifier(ResolveContext context, ResolveSource source) {
            this.context = context;
            this.source = source;
        }

        @Override
        public AbstractConfigValue modifyChildMayThrow(String key2, AbstractConfigValue v2) throws AbstractConfigValue.NotPossibleToResolve {
            ResolveResult<? extends AbstractConfigValue> result2 = this.context.resolve(v2, this.source);
            this.context = result2.context;
            return result2.value;
        }
    }
}

