/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft;

import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckDoubleFFT {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65530, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static int[] sizes2D2 = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static int[] sizes3D2 = new int[]{2, 4, 8, 16, 32, 64, 128};
    private static double eps = Math.pow(2.0, -52.0);

    private AccuracyCheckDoubleFFT() {
    }

    public static void checkAccuracyComplexFFT_1D() {
        System.out.println("Checking accuracy of 1D complex FFT...");
        int i2 = 0;
        while (i2 < sizes1D.length) {
            DoubleFFT_1D fft = new DoubleFFT_1D(sizes1D[i2]);
            double err = 0.0;
            double[] a = new double[2 * sizes1D[i2]];
            IOUtils.fillMatrix_1D(2 * sizes1D[i2], a);
            double[] b2 = new double[2 * sizes1D[i2]];
            IOUtils.fillMatrix_1D(2 * sizes1D[i2], b2);
            fft.complexForward(a);
            fft.complexInverse(a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyComplexFFT_2D() {
        Object b2;
        Object a;
        double err;
        DoubleFFT_2D fft2;
        System.out.println("Checking accuracy of 2D complex FFT (double[] input)...");
        int i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new double[2 * sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], a);
            b2 = new double[2 * sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], b2);
            fft2.complexForward((double[])a);
            fft2.complexInverse((double[])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D complex FFT (double[][] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new double[sizes2D[i2]][2 * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], (double[][])a);
            b2 = new double[sizes2D[i2]][2 * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], (double[][])b2);
            fft2.complexForward((double[][])a);
            fft2.complexInverse((double[][])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE((double[][])a, (double[][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyComplexFFT_3D() {
        Object b2;
        Object a;
        double err;
        DoubleFFT_3D fft3;
        System.out.println("Checking accuracy of 3D complex FFT (double[] input)...");
        int i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new double[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], a);
            b2 = new double[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], b2);
            fft3.complexForward((double[])a);
            fft3.complexInverse((double[])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D complex FFT (double[][][] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new double[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], (double[][][])a);
            b2 = new double[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], (double[][][])b2);
            fft3.complexForward((double[][][])a);
            fft3.complexInverse((double[][][])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE((double[][][])a, (double[][][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyRealFFT_1D() {
        int j;
        double[] b2;
        double[] a;
        double err;
        DoubleFFT_1D fft;
        System.out.println("Checking accuracy of 1D real FFT...");
        int i2 = 0;
        while (i2 < sizes1D.length) {
            fft = new DoubleFFT_1D(sizes1D[i2]);
            err = 0.0;
            a = new double[sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], a);
            b2 = new double[sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], b2);
            fft.realForward(a);
            fft.realInverse(a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of on 1D real forward full FFT...");
        i2 = 0;
        while (i2 < sizes1D.length) {
            fft = new DoubleFFT_1D(sizes1D[i2]);
            err = 0.0;
            a = new double[2 * sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], a);
            b2 = new double[2 * sizes1D[i2]];
            j = 0;
            while (j < sizes1D[i2]) {
                b2[2 * j] = a[j];
                ++j;
            }
            fft.realForwardFull(a);
            fft.complexInverse(a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 1D real inverse full FFT...");
        i2 = 0;
        while (i2 < sizes1D.length) {
            fft = new DoubleFFT_1D(sizes1D[i2]);
            err = 0.0;
            a = new double[2 * sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], a);
            b2 = new double[2 * sizes1D[i2]];
            j = 0;
            while (j < sizes1D[i2]) {
                b2[2 * j] = a[j];
                ++j;
            }
            fft.realInverseFull(a, true);
            fft.complexForward(a);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyRealFFT_2D() {
        int c;
        int r;
        Object b2;
        Object a;
        double err;
        DoubleFFT_2D fft2;
        System.out.println("Checking accuracy of 2D real FFT (double[] input)...");
        int i2 = 0;
        while (i2 < sizes2D2.length) {
            fft2 = new DoubleFFT_2D(sizes2D2[i2], sizes2D2[i2]);
            err = 0.0;
            a = new double[sizes2D2[i2] * sizes2D2[i2]];
            IOUtils.fillMatrix_2D(sizes2D2[i2], sizes2D2[i2], a);
            b2 = new double[sizes2D2[i2] * sizes2D2[i2]];
            IOUtils.fillMatrix_2D(sizes2D2[i2], sizes2D2[i2], b2);
            fft2.realForward((double[])a);
            fft2.realInverse((double[])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D2[i2] + " x " + sizes2D2[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D2[i2] + " x " + sizes2D2[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real FFT (double[][] input)...");
        i2 = 0;
        while (i2 < sizes2D2.length) {
            fft2 = new DoubleFFT_2D(sizes2D2[i2], sizes2D2[i2]);
            err = 0.0;
            a = new double[sizes2D2[i2]][sizes2D2[i2]];
            IOUtils.fillMatrix_2D(sizes2D2[i2], sizes2D2[i2], (double[][])a);
            b2 = new double[sizes2D2[i2]][sizes2D2[i2]];
            IOUtils.fillMatrix_2D(sizes2D2[i2], sizes2D2[i2], (double[][])b2);
            fft2.realForward((double[][])a);
            fft2.realInverse((double[][])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE((double[][])a, (double[][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D2[i2] + " x " + sizes2D2[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D2[i2] + " x " + sizes2D2[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (double[] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new double[2 * sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], a);
            b2 = new double[2 * sizes2D[i2] * sizes2D[i2]];
            r = 0;
            while (r < sizes2D[i2]) {
                c = 0;
                while (c < sizes2D[i2]) {
                    b2[r * 2 * AccuracyCheckDoubleFFT.sizes2D[i2] + 2 * c] = a[r * sizes2D[i2] + c];
                    ++c;
                }
                ++r;
            }
            fft2.realForwardFull((double[])a);
            fft2.complexInverse((double[])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (double[][] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new double[sizes2D[i2]][2 * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], (double[][])a);
            b2 = new double[sizes2D[i2]][2 * sizes2D[i2]];
            r = 0;
            while (r < sizes2D[i2]) {
                c = 0;
                while (c < sizes2D[i2]) {
                    b2[r][2 * c] = a[r][c];
                    ++c;
                }
                ++r;
            }
            fft2.realForwardFull((double[][])a);
            fft2.complexInverse((double[][])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE((double[][])a, (double[][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (double[] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new double[2 * sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], a);
            b2 = new double[2 * sizes2D[i2] * sizes2D[i2]];
            r = 0;
            while (r < sizes2D[i2]) {
                c = 0;
                while (c < sizes2D[i2]) {
                    b2[r * 2 * AccuracyCheckDoubleFFT.sizes2D[i2] + 2 * c] = a[r * sizes2D[i2] + c];
                    ++c;
                }
                ++r;
            }
            fft2.realInverseFull((double[])a, true);
            fft2.complexForward((double[])a);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (double[][] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new double[sizes2D[i2]][2 * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], (double[][])a);
            b2 = new double[sizes2D[i2]][2 * sizes2D[i2]];
            r = 0;
            while (r < sizes2D[i2]) {
                c = 0;
                while (c < sizes2D[i2]) {
                    b2[r][2 * c] = a[r][c];
                    ++c;
                }
                ++r;
            }
            fft2.realInverseFull((double[][])a, true);
            fft2.complexForward((double[][])a);
            err = AccuracyCheckDoubleFFT.computeRMSE((double[][])a, (double[][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyRealFFT_3D() {
        int c;
        int r;
        int s2;
        Object b2;
        Object a;
        double err;
        DoubleFFT_3D fft3;
        System.out.println("Checking accuracy of 3D real FFT (double[] input)...");
        int i2 = 0;
        while (i2 < sizes3D2.length) {
            fft3 = new DoubleFFT_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2]);
            err = 0.0;
            a = new double[sizes3D2[i2] * sizes3D2[i2] * sizes3D2[i2]];
            IOUtils.fillMatrix_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2], a);
            b2 = new double[sizes3D2[i2] * sizes3D2[i2] * sizes3D2[i2]];
            IOUtils.fillMatrix_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2], b2);
            fft3.realForward((double[])b2);
            fft3.realInverse((double[])b2, true);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D2[i2] + " x " + sizes3D2[i2] + " x " + sizes3D2[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D2[i2] + " x " + sizes3D2[i2] + " x " + sizes3D2[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real FFT (double[][][] input)...");
        i2 = 0;
        while (i2 < sizes3D2.length) {
            fft3 = new DoubleFFT_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2]);
            err = 0.0;
            a = new double[sizes3D2[i2]][sizes3D2[i2]][sizes3D2[i2]];
            IOUtils.fillMatrix_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2], (double[][][])a);
            b2 = new double[sizes3D2[i2]][sizes3D2[i2]][sizes3D2[i2]];
            IOUtils.fillMatrix_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2], (double[][][])b2);
            fft3.realForward((double[][][])b2);
            fft3.realInverse((double[][][])b2, true);
            err = AccuracyCheckDoubleFFT.computeRMSE((double[][][])a, (double[][][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D2[i2] + " x " + sizes3D2[i2] + " x " + sizes3D2[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D2[i2] + " x " + sizes3D2[i2] + " x " + sizes3D2[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (double[] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new double[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], a);
            b2 = new double[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            s2 = 0;
            while (s2 < sizes3D[i2]) {
                r = 0;
                while (r < sizes3D[i2]) {
                    c = 0;
                    while (c < sizes3D[i2]) {
                        b2[s2 * 2 * AccuracyCheckDoubleFFT.sizes3D[i2] * AccuracyCheckDoubleFFT.sizes3D[i2] + r * 2 * AccuracyCheckDoubleFFT.sizes3D[i2] + 2 * c] = a[s2 * sizes3D[i2] * sizes3D[i2] + r * sizes3D[i2] + c];
                        ++c;
                    }
                    ++r;
                }
                ++s2;
            }
            fft3.realForwardFull((double[])a);
            fft3.complexInverse((double[])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (double[][][] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new double[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], (double[][][])a);
            b2 = new double[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            s2 = 0;
            while (s2 < sizes3D[i2]) {
                r = 0;
                while (r < sizes3D[i2]) {
                    c = 0;
                    while (c < sizes3D[i2]) {
                        b2[s2][r][2 * c] = a[s2][r][c];
                        ++c;
                    }
                    ++r;
                }
                ++s2;
            }
            fft3.realForwardFull((double[][][])a);
            fft3.complexInverse((double[][][])a, true);
            err = AccuracyCheckDoubleFFT.computeRMSE((double[][][])a, (double[][][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (double[] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new double[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], a);
            b2 = new double[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            s2 = 0;
            while (s2 < sizes3D[i2]) {
                r = 0;
                while (r < sizes3D[i2]) {
                    c = 0;
                    while (c < sizes3D[i2]) {
                        b2[s2 * 2 * AccuracyCheckDoubleFFT.sizes3D[i2] * AccuracyCheckDoubleFFT.sizes3D[i2] + r * 2 * AccuracyCheckDoubleFFT.sizes3D[i2] + 2 * c] = a[s2 * sizes3D[i2] * sizes3D[i2] + r * sizes3D[i2] + c];
                        ++c;
                    }
                    ++r;
                }
                ++s2;
            }
            fft3.realInverseFull((double[])a, true);
            fft3.complexForward((double[])a);
            err = AccuracyCheckDoubleFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (double[][][] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new double[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], (double[][][])a);
            b2 = new double[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            s2 = 0;
            while (s2 < sizes3D[i2]) {
                r = 0;
                while (r < sizes3D[i2]) {
                    c = 0;
                    while (c < sizes3D[i2]) {
                        b2[s2][r][2 * c] = a[s2][r][c];
                        ++c;
                    }
                    ++r;
                }
                ++s2;
            }
            fft3.realInverseFull((double[][][])a, true);
            fft3.complexForward((double[][][])a);
            err = AccuracyCheckDoubleFFT.computeRMSE((double[][][])a, (double[][][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
    }

    private static double computeRMSE(double[] a, double[] b2) {
        if (a.length != b2.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int i2 = 0;
        while (i2 < a.length) {
            double tmp = a[i2] - b2[i2];
            rms += tmp * tmp;
            ++i2;
        }
        return Math.sqrt(rms / (double)a.length);
    }

    private static double computeRMSE(double[][] a, double[][] b2) {
        if (a.length != b2.length || a[0].length != b2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int r = 0;
        while (r < a.length) {
            int c = 0;
            while (c < a[0].length) {
                double tmp = a[r][c] - b2[r][c];
                rms += tmp * tmp;
                ++c;
            }
            ++r;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length));
    }

    private static double computeRMSE(double[][][] a, double[][][] b2) {
        if (a.length != b2.length || a[0].length != b2[0].length || a[0][0].length != b2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int s2 = 0;
        while (s2 < a.length) {
            int r = 0;
            while (r < a[0].length) {
                int c = 0;
                while (c < a[0][0].length) {
                    double tmp = a[s2][r][c] - b2[s2][r][c];
                    rms += tmp * tmp;
                    ++c;
                }
                ++r;
            }
            ++s2;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length * a[0][0].length));
    }

    public static void main(String[] args) {
        AccuracyCheckDoubleFFT.checkAccuracyComplexFFT_1D();
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_1D();
        AccuracyCheckDoubleFFT.checkAccuracyComplexFFT_2D();
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_2D();
        AccuracyCheckDoubleFFT.checkAccuracyComplexFFT_3D();
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_3D();
        System.exit(0);
    }
}

