/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft;

import java.util.Arrays;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.ConcurrencyUtils;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.IOUtils;

public class BenchmarkDoubleFFT {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static int[] sizes1D = new int[]{65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 10368, 27000, 75600, 165375, 362880, 1562500, 0x310000, 6250000};
    private static int[] sizes2D = new int[]{128, 256, 512, 1024, 2048, 4096, 8192, 16384, 260, 520, 1050, 1458, 1960, 2916, 4116, 5832};
    private static int[] sizes3D = new int[]{8, 16, 32, 64, 128, 256, 512, 1024, 5, 17, 30, 95, 180, 270, 324, 420};
    private static boolean doScaling = false;

    private BenchmarkDoubleFFT() {
    }

    public static void parseArguments(String[] args) {
        if (args.length > 0) {
            nthread = Integer.parseInt(args[0]);
            threadsBegin2D = Integer.parseInt(args[1]);
            threadsBegin3D = Integer.parseInt(args[2]);
            niter = Integer.parseInt(args[3]);
            doWarmup = Boolean.parseBoolean(args[4]);
            doScaling = Boolean.parseBoolean(args[5]);
            nsize = Integer.parseInt(args[6]);
            sizes1D = new int[nsize];
            sizes2D = new int[nsize];
            sizes3D = new int[nsize];
            int i2 = 0;
            while (i2 < nsize) {
                BenchmarkDoubleFFT.sizes1D[i2] = Integer.parseInt(args[7 + i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < nsize) {
                BenchmarkDoubleFFT.sizes2D[i2] = Integer.parseInt(args[7 + nsize + i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < nsize) {
                BenchmarkDoubleFFT.sizes3D[i2] = Integer.parseInt(args[7 + nsize + nsize + i2]);
                ++i2;
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads(nthread);
        ConcurrencyUtils.setThreadsBeginN_2D(threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkComplexForward_1D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Complex forward FFT 1D of size " + sizes1D[i2]);
            DoubleFFT_1D fft = new DoubleFFT_1D(sizes1D[i2]);
            double[] x = new double[2 * sizes1D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(2 * sizes1D[i2], x);
                fft.complexForward(x);
                IOUtils.fillMatrix_1D(2 * sizes1D[i2], x);
                fft.complexForward(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_1D(2 * sizes1D[i2], x);
                elapsedTime = System.nanoTime();
                fft.complexForward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
                ++j;
            }
            times[i2] = av_time / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            fft = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, times);
    }

    public static void benchmarkRealForward_1D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Real forward FFT 1D of size " + sizes1D[i2]);
            DoubleFFT_1D fft = new DoubleFFT_1D(sizes1D[i2]);
            double[] x = new double[2 * sizes1D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(sizes1D[i2], x);
                fft.realForwardFull(x);
                IOUtils.fillMatrix_1D(sizes1D[i2], x);
                fft.realForwardFull(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_1D(sizes1D[i2], x);
                elapsedTime = System.nanoTime();
                fft.realForwardFull(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
                ++j;
            }
            times[i2] = av_time / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            fft = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, times);
    }

    public static void benchmarkComplexForward_2D_input_1D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Complex forward FFT 2D (input 1D) of size " + sizes2D[i2] + " x " + sizes2D[i2]);
            DoubleFFT_2D fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            double[] x = new double[sizes2D[i2] * 2 * sizes2D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], x);
                fft2.complexForward(x);
                IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], x);
                fft2.complexForward(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], x);
                elapsedTime = System.nanoTime();
                fft2.complexForward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
                ++j;
            }
            times[i2] = av_time / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            fft2 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times);
    }

    public static void benchmarkComplexForward_2D_input_2D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Complex forward FFT 2D (input 2D) of size " + sizes2D[i2] + " x " + sizes2D[i2]);
            DoubleFFT_2D fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            double[][] x = new double[sizes2D[i2]][2 * sizes2D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], x);
                fft2.complexForward(x);
                IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], x);
                fft2.complexForward(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], x);
                elapsedTime = System.nanoTime();
                fft2.complexForward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
                ++j;
            }
            times[i2] = av_time / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            fft2 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times);
    }

    public static void benchmarkRealForward_2D_input_1D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Real forward FFT 2D (input 1D) of size " + sizes2D[i2] + " x " + sizes2D[i2]);
            DoubleFFT_2D fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            double[] x = new double[sizes2D[i2] * 2 * sizes2D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                fft2.realForwardFull(x);
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                fft2.realForwardFull(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                elapsedTime = System.nanoTime();
                fft2.realForwardFull(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
                ++j;
            }
            times[i2] = av_time / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            fft2 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times);
    }

    public static void benchmarkRealForward_2D_input_2D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Real forward FFT 2D (input 2D) of size " + sizes2D[i2] + " x " + sizes2D[i2]);
            DoubleFFT_2D fft2 = new DoubleFFT_2D(sizes2D[i2], sizes2D[i2]);
            double[][] x = new double[sizes2D[i2]][2 * sizes2D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                fft2.realForwardFull(x);
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                fft2.realForwardFull(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], x);
                elapsedTime = System.nanoTime();
                fft2.realForwardFull(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
                ++j;
            }
            times[i2] = av_time / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            fft2 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times);
    }

    public static void benchmarkComplexForward_3D_input_1D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            if (sizes3D[i2] < 1024) {
                System.out.println("Complex forward FFT 3D (input 1D) of size " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2]);
                DoubleFFT_3D fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
                double[] x = new double[sizes3D[i2] * sizes3D[i2] * 2 * sizes3D[i2]];
                if (doWarmup) {
                    IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], x);
                    fft3.complexForward(x);
                    IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], x);
                    fft3.complexForward(x);
                }
                double av_time = 0.0;
                long elapsedTime = 0L;
                int j = 0;
                while (j < niter) {
                    IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], x);
                    elapsedTime = System.nanoTime();
                    fft3.complexForward(x);
                    elapsedTime = System.nanoTime() - elapsedTime;
                    av_time += (double)elapsedTime;
                    ++j;
                }
                times[i2] = av_time / 1000000.0 / (double)niter;
                System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
                x = null;
                fft3 = null;
                System.gc();
                ConcurrencyUtils.sleep(5000L);
            }
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times);
    }

    public static void benchmarkComplexForward_3D_input_3D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Complex forward FFT 3D (input 3D) of size " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2]);
            DoubleFFT_3D fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            double[][][] x = new double[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], x);
                fft3.complexForward(x);
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], x);
                fft3.complexForward(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], x);
                elapsedTime = System.nanoTime();
                fft3.complexForward(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
                ++j;
            }
            times[i2] = av_time / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            fft3 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleComplexForwardFFT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times);
    }

    public static void benchmarkRealForward_3D_input_1D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            if (sizes3D[i2] < 1024) {
                System.out.println("Real forward FFT 3D (input 1D) of size " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2]);
                DoubleFFT_3D fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
                double[] x = new double[sizes3D[i2] * sizes3D[i2] * 2 * sizes3D[i2]];
                if (doWarmup) {
                    IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                    fft3.realForwardFull(x);
                    IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                    fft3.realForwardFull(x);
                }
                double av_time = 0.0;
                long elapsedTime = 0L;
                int j = 0;
                while (j < niter) {
                    IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                    elapsedTime = System.nanoTime();
                    fft3.realForwardFull(x);
                    elapsedTime = System.nanoTime() - elapsedTime;
                    av_time += (double)elapsedTime;
                    ++j;
                }
                times[i2] = av_time / 1000000.0 / (double)niter;
                System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
                x = null;
                fft3 = null;
                System.gc();
                ConcurrencyUtils.sleep(5000L);
            }
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times);
    }

    public static void benchmarkRealForward_3D_input_3D() {
        double[] times = new double[nsize];
        int i2 = 0;
        while (i2 < nsize) {
            System.out.println("Real forward FFT 3D (input 3D) of size " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2]);
            DoubleFFT_3D fft3 = new DoubleFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            double[][][] x = new double[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                fft3.realForwardFull(x);
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                fft3.realForwardFull(x);
            }
            double av_time = 0.0;
            long elapsedTime = 0L;
            int j = 0;
            while (j < niter) {
                IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], x);
                elapsedTime = System.nanoTime();
                fft3.realForwardFull(x);
                elapsedTime = System.nanoTime() - elapsedTime;
                av_time += (double)elapsedTime;
                ++j;
            }
            times[i2] = av_time / 1000000.0 / (double)niter;
            System.out.println("\tAverage execution time: " + String.format("%.2f", av_time / 1000000.0 / (double)niter) + " msec");
            x = null;
            fft3 = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
            ++i2;
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkDoubleRealForwardFFT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times);
    }

    public static void main(String[] args) {
        BenchmarkDoubleFFT.parseArguments(args);
        BenchmarkDoubleFFT.benchmarkComplexForward_1D();
        BenchmarkDoubleFFT.benchmarkRealForward_1D();
        BenchmarkDoubleFFT.benchmarkComplexForward_2D_input_1D();
        BenchmarkDoubleFFT.benchmarkComplexForward_2D_input_2D();
        BenchmarkDoubleFFT.benchmarkRealForward_2D_input_1D();
        BenchmarkDoubleFFT.benchmarkRealForward_2D_input_2D();
        BenchmarkDoubleFFT.benchmarkComplexForward_3D_input_1D();
        BenchmarkDoubleFFT.benchmarkComplexForward_3D_input_3D();
        BenchmarkDoubleFFT.benchmarkRealForward_3D_input_1D();
        BenchmarkDoubleFFT.benchmarkRealForward_3D_input_3D();
        System.exit(0);
    }
}

