/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft;

import java.util.concurrent.Future;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.ConcurrencyUtils;

public strictfp class FloatFFT_2D {
    private int rows;
    private int columns;
    private float[] t;
    private FloatFFT_1D fftColumns;
    private FloatFFT_1D fftRows;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatFFT_2D(int rows, int columns) {
        if (rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = rows;
        this.columns = columns;
        if (rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = 8 * this.oldNthreads * rows;
            if (2 * columns == 4 * this.oldNthreads) {
                this.nt >>= 1;
            } else if (2 * columns < 4 * this.oldNthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
        }
        this.fftRows = new FloatFFT_1D(rows);
        this.fftColumns = rows == columns ? this.fftRows : new FloatFFT_1D(columns);
    }

    public void complexForward(final float[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns *= 2;
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, a, true);
                this.cdft2d_subth(-1, a, true);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.complexForward(a, r * this.columns);
                    ++r;
                }
                this.cdft2d_sub(-1, a, true);
            }
            this.columns = oldn2;
        } else {
            final int rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                int l2 = 0;
                while (l2 < nthreads) {
                    final int firstRow = l2 * p;
                    final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int r = firstRow;
                            while (r < lastRow) {
                                FloatFFT_2D.this.fftColumns.complexForward(a, r * rowStride);
                                ++r;
                            }
                        }
                    });
                    ++l2;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                l2 = 0;
                while (l2 < nthreads) {
                    final int firstColumn = l2 * p;
                    final int lastColumn = l2 == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] temp = new float[2 * FloatFFT_2D.this.rows];
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int idx2;
                                int idx1;
                                int idx0 = 2 * c;
                                int r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx1 = 2 * r;
                                    idx2 = r * rowStride + idx0;
                                    temp[idx1] = a[idx2];
                                    temp[idx1 + 1] = a[idx2 + 1];
                                    ++r;
                                }
                                FloatFFT_2D.this.fftRows.complexForward(temp);
                                r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx1 = 2 * r;
                                    idx2 = r * rowStride + idx0;
                                    a[idx2] = temp[idx1];
                                    a[idx2 + 1] = temp[idx1 + 1];
                                    ++r;
                                }
                                ++c;
                            }
                        }
                    });
                    ++l2;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.complexForward(a, r * rowStride);
                    ++r;
                }
                float[] temp = new float[2 * this.rows];
                int c = 0;
                while (c < this.columns) {
                    int idx2;
                    int idx1;
                    int idx0 = 2 * c;
                    int r2 = 0;
                    while (r2 < this.rows) {
                        idx1 = 2 * r2;
                        idx2 = r2 * rowStride + idx0;
                        temp[idx1] = a[idx2];
                        temp[idx1 + 1] = a[idx2 + 1];
                        ++r2;
                    }
                    this.fftRows.complexForward(temp);
                    r2 = 0;
                    while (r2 < this.rows) {
                        idx1 = 2 * r2;
                        idx2 = r2 * rowStride + idx0;
                        a[idx2] = temp[idx1];
                        a[idx2 + 1] = temp[idx1 + 1];
                        ++r2;
                    }
                    ++c;
                }
            }
        }
    }

    public void complexForward(final float[][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns *= 2;
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, a, true);
                this.cdft2d_subth(-1, a, true);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.complexForward(a[r]);
                    ++r;
                }
                this.cdft2d_sub(-1, a, true);
            }
            this.columns = oldn2;
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                final int firstRow = l2 * p;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            FloatFFT_2D.this.fftColumns.complexForward(a[r]);
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_2D.this.rows];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idx2;
                            int idx1 = 2 * c;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = 2 * r;
                                temp[idx2] = a[r][idx1];
                                temp[idx2 + 1] = a[r][idx1 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp);
                            r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = 2 * r;
                                a[r][idx1] = temp[idx2];
                                a[r][idx1 + 1] = temp[idx2 + 1];
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.complexForward(a[r]);
                ++r;
            }
            float[] temp = new float[2 * this.rows];
            int c = 0;
            while (c < this.columns) {
                int idx2;
                int idx1 = 2 * c;
                int r2 = 0;
                while (r2 < this.rows) {
                    idx2 = 2 * r2;
                    temp[idx2] = a[r2][idx1];
                    temp[idx2 + 1] = a[r2][idx1 + 1];
                    ++r2;
                }
                this.fftRows.complexForward(temp);
                r2 = 0;
                while (r2 < this.rows) {
                    idx2 = 2 * r2;
                    a[r2][idx1] = temp[idx2];
                    a[r2][idx1 + 1] = temp[idx2 + 1];
                    ++r2;
                }
                ++c;
            }
        }
    }

    public void complexInverse(final float[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns *= 2;
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, a, scale);
                this.cdft2d_subth(1, a, scale);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.complexInverse(a, r * this.columns, scale);
                    ++r;
                }
                this.cdft2d_sub(1, a, scale);
            }
            this.columns = oldn2;
        } else {
            final int rowspan = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                int l2 = 0;
                while (l2 < nthreads) {
                    final int firstRow = l2 * p;
                    final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int r = firstRow;
                            while (r < lastRow) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a, r * rowspan, scale);
                                ++r;
                            }
                        }
                    });
                    ++l2;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                l2 = 0;
                while (l2 < nthreads) {
                    final int firstColumn = l2 * p;
                    final int lastColumn = l2 == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] temp = new float[2 * FloatFFT_2D.this.rows];
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int idx3;
                                int idx2;
                                int idx1 = 2 * c;
                                int r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx2 = 2 * r;
                                    idx3 = r * rowspan + idx1;
                                    temp[idx2] = a[idx3];
                                    temp[idx2 + 1] = a[idx3 + 1];
                                    ++r;
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(temp, scale);
                                r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx2 = 2 * r;
                                    idx3 = r * rowspan + idx1;
                                    a[idx3] = temp[idx2];
                                    a[idx3 + 1] = temp[idx2 + 1];
                                    ++r;
                                }
                                ++c;
                            }
                        }
                    });
                    ++l2;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.complexInverse(a, r * rowspan, scale);
                    ++r;
                }
                float[] temp = new float[2 * this.rows];
                int c = 0;
                while (c < this.columns) {
                    int idx3;
                    int idx2;
                    int idx1 = 2 * c;
                    int r2 = 0;
                    while (r2 < this.rows) {
                        idx2 = 2 * r2;
                        idx3 = r2 * rowspan + idx1;
                        temp[idx2] = a[idx3];
                        temp[idx2 + 1] = a[idx3 + 1];
                        ++r2;
                    }
                    this.fftRows.complexInverse(temp, scale);
                    r2 = 0;
                    while (r2 < this.rows) {
                        idx2 = 2 * r2;
                        idx3 = r2 * rowspan + idx1;
                        a[idx3] = temp[idx2];
                        a[idx3 + 1] = temp[idx2 + 1];
                        ++r2;
                    }
                    ++c;
                }
            }
        }
    }

    public void complexInverse(final float[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns *= 2;
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, a, scale);
                this.cdft2d_subth(1, a, scale);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.complexInverse(a[r], scale);
                    ++r;
                }
                this.cdft2d_sub(1, a, scale);
            }
            this.columns = oldn2;
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                final int firstRow = l2 * p;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            FloatFFT_2D.this.fftColumns.complexInverse(a[r], scale);
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_2D.this.rows];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idx2;
                            int idx1 = 2 * c;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = 2 * r;
                                temp[idx2] = a[r][idx1];
                                temp[idx2 + 1] = a[r][idx1 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp, scale);
                            r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = 2 * r;
                                a[r][idx1] = temp[idx2];
                                a[r][idx1 + 1] = temp[idx2 + 1];
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.complexInverse(a[r], scale);
                ++r;
            }
            float[] temp = new float[2 * this.rows];
            int c = 0;
            while (c < this.columns) {
                int idx2;
                int idx1 = 2 * c;
                int r2 = 0;
                while (r2 < this.rows) {
                    idx2 = 2 * r2;
                    temp[idx2] = a[r2][idx1];
                    temp[idx2 + 1] = a[r2][idx1 + 1];
                    ++r2;
                }
                this.fftRows.complexInverse(temp, scale);
                r2 = 0;
                while (r2 < this.rows) {
                    idx2 = 2 * r2;
                    a[r2][idx1] = temp[idx2];
                    a[r2][idx1 + 1] = temp[idx2 + 1];
                    ++r2;
                }
                ++c;
            }
        }
    }

    public void realForward(float[] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = 8 * nthreads * this.rows;
            if (this.columns == 4 * nthreads) {
                this.nt >>= 1;
            } else if (this.columns < 4 * nthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, a, true);
            this.cdft2d_subth(-1, a, true);
            this.rdft2d_sub(1, a);
        } else {
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.realForward(a, r * this.columns);
                ++r;
            }
            this.cdft2d_sub(-1, a, true);
            this.rdft2d_sub(1, a);
        }
    }

    public void realForward(float[][] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = 8 * nthreads * this.rows;
            if (this.columns == 4 * nthreads) {
                this.nt >>= 1;
            } else if (this.columns < 4 * nthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, a, true);
            this.cdft2d_subth(-1, a, true);
            this.rdft2d_sub(1, a);
        } else {
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.realForward(a[r]);
                ++r;
            }
            this.cdft2d_sub(-1, a, true);
            this.rdft2d_sub(1, a);
        }
    }

    public void realForwardFull(float[] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, a, true);
                this.cdft2d_subth(-1, a, true);
                this.rdft2d_sub(1, a);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.realForward(a, r * this.columns);
                    ++r;
                }
                this.cdft2d_sub(-1, a, true);
                this.rdft2d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realForwardFull(float[][] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, a, true);
                this.cdft2d_subth(-1, a, true);
                this.rdft2d_sub(1, a);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.realForward(a[r]);
                    ++r;
                }
                this.cdft2d_sub(-1, a, true);
                this.rdft2d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realInverse(float[] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = 8 * nthreads * this.rows;
            if (this.columns == 4 * nthreads) {
                this.nt >>= 1;
            } else if (this.columns < 4 * nthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.rdft2d_sub(-1, a);
            this.cdft2d_subth(1, a, scale);
            this.xdft2d0_subth1(1, -1, a, scale);
        } else {
            this.rdft2d_sub(-1, a);
            this.cdft2d_sub(1, a, scale);
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.realInverse(a, r * this.columns, scale);
                ++r;
            }
        }
    }

    public void realInverse(float[][] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = 8 * nthreads * this.rows;
            if (this.columns == 4 * nthreads) {
                this.nt >>= 1;
            } else if (this.columns < 4 * nthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.rdft2d_sub(-1, a);
            this.cdft2d_subth(1, a, scale);
            this.xdft2d0_subth1(1, -1, a, scale);
        } else {
            this.rdft2d_sub(-1, a);
            this.cdft2d_sub(1, a, scale);
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.realInverse(a[r], scale);
                ++r;
            }
        }
    }

    public void realInverseFull(float[] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, a, scale);
                this.cdft2d_subth(1, a, scale);
                this.rdft2d_sub(1, a);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.realInverse2(a, r * this.columns, scale);
                    ++r;
                }
                this.cdft2d_sub(1, a, scale);
                this.rdft2d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    public void realInverseFull(float[][] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, a, scale);
                this.cdft2d_subth(1, a, scale);
                this.rdft2d_sub(1, a);
            } else {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.realInverse2(a[r], 0, scale);
                    ++r;
                }
                this.cdft2d_sub(1, a, scale);
                this.rdft2d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    private void mixedRadixRealForwardFull(final float[][] a) {
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int lastRow;
            int firstRow;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                firstRow = l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstRow;
                        while (i2 < lastRow) {
                            FloatFFT_2D.this.fftColumns.realForward(a[i2]);
                            ++i2;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            int r = 0;
            while (r < this.rows) {
                temp[0][r] = a[r][0];
                ++r;
            }
            this.fftRows.realForwardFull(temp[0]);
            p = (n2d2 - 2) / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = 1 + l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? n2d2 - 1 : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idx2 = 2 * c;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                int idx1 = 2 * r;
                                temp[c][idx1] = a[r][idx2];
                                temp[c][idx1 + 1] = a[r][idx2 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp[c]);
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            if (this.columns % 2 == 0) {
                r = 0;
                while (r < this.rows) {
                    temp[n2d2 - 1][r] = a[r][1];
                    ++r;
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                r = 0;
                while (r < this.rows) {
                    int idx1 = 2 * r;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a[r][2 * idx2];
                    temp[idx2][idx1 + 1] = a[r][1];
                    ++r;
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            p = this.rows / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                firstRow = l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx1 = 2 * r;
                            int c = 0;
                            while (c < n2d2) {
                                int idx2 = 2 * c;
                                a[r][idx2] = temp[c][idx1];
                                a[r][idx2 + 1] = temp[c][idx1 + 1];
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l2 = 0;
            while (l2 < nthreads) {
                firstRow = 1 + l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx3 = FloatFFT_2D.this.rows - r;
                            int c = n2d2;
                            while (c < FloatFFT_2D.this.columns) {
                                int idx1 = 2 * c;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c);
                                a[0][idx1] = a[0][idx2];
                                a[0][idx1 + 1] = -a[0][idx2 + 1];
                                a[r][idx1] = a[idx3][idx2];
                                a[r][idx1 + 1] = -a[idx3][idx2 + 1];
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int idx1;
            int idx12;
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.realForward(a[r]);
                ++r;
            }
            r = 0;
            while (r < this.rows) {
                temp[0][r] = a[r][0];
                ++r;
            }
            this.fftRows.realForwardFull(temp[0]);
            int c2 = 1;
            while (c2 < n2d2 - 1) {
                int idx2 = 2 * c2;
                int r2 = 0;
                while (r2 < this.rows) {
                    idx12 = 2 * r2;
                    temp[c2][idx12] = a[r2][idx2];
                    temp[c2][idx12 + 1] = a[r2][idx2 + 1];
                    ++r2;
                }
                this.fftRows.complexForward(temp[c2]);
                ++c2;
            }
            if (this.columns % 2 == 0) {
                r = 0;
                while (r < this.rows) {
                    temp[n2d2 - 1][r] = a[r][1];
                    ++r;
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                r = 0;
                while (r < this.rows) {
                    idx1 = 2 * r;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a[r][2 * idx2];
                    temp[idx2][idx1 + 1] = a[r][1];
                    ++r;
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            r = 0;
            while (r < this.rows) {
                idx1 = 2 * r;
                c = 0;
                while (c < n2d2) {
                    int idx2 = 2 * c;
                    a[r][idx2] = temp[c][idx1];
                    a[r][idx2 + 1] = temp[c][idx1 + 1];
                    ++c;
                }
                ++r;
            }
            r = 1;
            while (r < this.rows) {
                int idx3 = this.rows - r;
                c = n2d2;
                while (c < this.columns) {
                    idx12 = 2 * c;
                    int idx2 = 2 * (this.columns - c);
                    a[0][idx12] = a[0][idx2];
                    a[0][idx12 + 1] = -a[0][idx2 + 1];
                    a[r][idx12] = a[idx3][idx2];
                    a[r][idx12 + 1] = -a[idx3][idx2 + 1];
                    ++c;
                }
                ++r;
            }
        }
    }

    private void mixedRadixRealForwardFull(final float[] a) {
        final int rowStride = 2 * this.columns;
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int lastRow;
            int firstRow;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                firstRow = l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstRow;
                        while (i2 < lastRow) {
                            FloatFFT_2D.this.fftColumns.realForward(a, i2 * FloatFFT_2D.this.columns);
                            ++i2;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            int r = 0;
            while (r < this.rows) {
                temp[0][r] = a[r * this.columns];
                ++r;
            }
            this.fftRows.realForwardFull(temp[0]);
            p = (n2d2 - 2) / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = 1 + l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? n2d2 - 1 : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idx0 = 2 * c;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                int idx1 = 2 * r;
                                int idx2 = r * FloatFFT_2D.this.columns + idx0;
                                temp[c][idx1] = a[idx2];
                                temp[c][idx1 + 1] = a[idx2 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp[c]);
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            if (this.columns % 2 == 0) {
                r = 0;
                while (r < this.rows) {
                    temp[n2d2 - 1][r] = a[r * this.columns + 1];
                    ++r;
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                r = 0;
                while (r < this.rows) {
                    int idx1 = 2 * r;
                    int idx2 = r * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a[idx2 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a[idx2 + 1];
                    ++r;
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            p = this.rows / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                firstRow = l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx1 = 2 * r;
                            int c = 0;
                            while (c < n2d2) {
                                int idx0 = 2 * c;
                                int idx2 = r * rowStride + idx0;
                                a[idx2] = temp[c][idx1];
                                a[idx2 + 1] = temp[c][idx1 + 1];
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l2 = 0;
            while (l2 < nthreads) {
                firstRow = 1 + l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx5 = r * rowStride;
                            int idx6 = (FloatFFT_2D.this.rows - r + 1) * rowStride;
                            int c = n2d2;
                            while (c < FloatFFT_2D.this.columns) {
                                int idx1 = 2 * c;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c);
                                a[idx1] = a[idx2];
                                a[idx1 + 1] = -a[idx2 + 1];
                                int idx3 = idx5 + idx1;
                                int idx4 = idx6 - idx1;
                                a[idx3] = a[idx4];
                                a[idx3 + 1] = -a[idx4 + 1];
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx1;
            int idx2;
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.realForward(a, r * this.columns);
                ++r;
            }
            r = 0;
            while (r < this.rows) {
                temp[0][r] = a[r * this.columns];
                ++r;
            }
            this.fftRows.realForwardFull(temp[0]);
            int c = 1;
            while (c < n2d2 - 1) {
                int idx0 = 2 * c;
                int r2 = 0;
                while (r2 < this.rows) {
                    int idx12 = 2 * r2;
                    idx2 = r2 * this.columns + idx0;
                    temp[c][idx12] = a[idx2];
                    temp[c][idx12 + 1] = a[idx2 + 1];
                    ++r2;
                }
                this.fftRows.complexForward(temp[c]);
                ++c;
            }
            if (this.columns % 2 == 0) {
                r = 0;
                while (r < this.rows) {
                    temp[n2d2 - 1][r] = a[r * this.columns + 1];
                    ++r;
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                r = 0;
                while (r < this.rows) {
                    idx1 = 2 * r;
                    int idx22 = r * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a[idx22 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a[idx22 + 1];
                    ++r;
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            r = 0;
            while (r < this.rows) {
                idx1 = 2 * r;
                int c2 = 0;
                while (c2 < n2d2) {
                    int idx0 = 2 * c2;
                    idx2 = r * rowStride + idx0;
                    a[idx2] = temp[c2][idx1];
                    a[idx2 + 1] = temp[c2][idx1 + 1];
                    ++c2;
                }
                ++r;
            }
            r = 1;
            while (r < this.rows) {
                int idx5 = r * rowStride;
                int idx6 = (this.rows - r + 1) * rowStride;
                int c3 = n2d2;
                while (c3 < this.columns) {
                    int idx13 = 2 * c3;
                    int idx23 = 2 * (this.columns - c3);
                    a[idx13] = a[idx23];
                    a[idx13 + 1] = -a[idx23 + 1];
                    int idx3 = idx5 + idx13;
                    int idx4 = idx6 - idx13;
                    a[idx3] = a[idx4];
                    a[idx3 + 1] = -a[idx4 + 1];
                    ++c3;
                }
                ++r;
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[][] a, final boolean scale) {
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int lastRow;
            int firstRow;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                firstRow = l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstRow;
                        while (i2 < lastRow) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a[i2], 0, scale);
                            ++i2;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            int r = 0;
            while (r < this.rows) {
                temp[0][r] = a[r][0];
                ++r;
            }
            this.fftRows.realInverseFull(temp[0], scale);
            p = (n2d2 - 2) / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = 1 + l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? n2d2 - 1 : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idx2 = 2 * c;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                int idx1 = 2 * r;
                                temp[c][idx1] = a[r][idx2];
                                temp[c][idx1 + 1] = a[r][idx2 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp[c], scale);
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            if (this.columns % 2 == 0) {
                r = 0;
                while (r < this.rows) {
                    temp[n2d2 - 1][r] = a[r][1];
                    ++r;
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                r = 0;
                while (r < this.rows) {
                    int idx1 = 2 * r;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a[r][2 * idx2];
                    temp[idx2][idx1 + 1] = a[r][1];
                    ++r;
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            p = this.rows / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                firstRow = l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx1 = 2 * r;
                            int c = 0;
                            while (c < n2d2) {
                                int idx2 = 2 * c;
                                a[r][idx2] = temp[c][idx1];
                                a[r][idx2 + 1] = temp[c][idx1 + 1];
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l2 = 0;
            while (l2 < nthreads) {
                firstRow = 1 + l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx3 = FloatFFT_2D.this.rows - r;
                            int c = n2d2;
                            while (c < FloatFFT_2D.this.columns) {
                                int idx1 = 2 * c;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c);
                                a[0][idx1] = a[0][idx2];
                                a[0][idx1 + 1] = -a[0][idx2 + 1];
                                a[r][idx1] = a[idx3][idx2];
                                a[r][idx1 + 1] = -a[idx3][idx2 + 1];
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int idx1;
            int idx12;
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.realInverse2(a[r], 0, scale);
                ++r;
            }
            r = 0;
            while (r < this.rows) {
                temp[0][r] = a[r][0];
                ++r;
            }
            this.fftRows.realInverseFull(temp[0], scale);
            int c2 = 1;
            while (c2 < n2d2 - 1) {
                int idx2 = 2 * c2;
                int r2 = 0;
                while (r2 < this.rows) {
                    idx12 = 2 * r2;
                    temp[c2][idx12] = a[r2][idx2];
                    temp[c2][idx12 + 1] = a[r2][idx2 + 1];
                    ++r2;
                }
                this.fftRows.complexInverse(temp[c2], scale);
                ++c2;
            }
            if (this.columns % 2 == 0) {
                r = 0;
                while (r < this.rows) {
                    temp[n2d2 - 1][r] = a[r][1];
                    ++r;
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                r = 0;
                while (r < this.rows) {
                    idx1 = 2 * r;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a[r][2 * idx2];
                    temp[idx2][idx1 + 1] = a[r][1];
                    ++r;
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            r = 0;
            while (r < this.rows) {
                idx1 = 2 * r;
                c = 0;
                while (c < n2d2) {
                    int idx2 = 2 * c;
                    a[r][idx2] = temp[c][idx1];
                    a[r][idx2 + 1] = temp[c][idx1 + 1];
                    ++c;
                }
                ++r;
            }
            r = 1;
            while (r < this.rows) {
                int idx3 = this.rows - r;
                c = n2d2;
                while (c < this.columns) {
                    idx12 = 2 * c;
                    int idx2 = 2 * (this.columns - c);
                    a[0][idx12] = a[0][idx2];
                    a[0][idx12 + 1] = -a[0][idx2 + 1];
                    a[r][idx12] = a[idx3][idx2];
                    a[r][idx12 + 1] = -a[idx3][idx2 + 1];
                    ++c;
                }
                ++r;
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[] a, final boolean scale) {
        final int rowStride = 2 * this.columns;
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int lastRow;
            int firstRow;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                firstRow = l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstRow;
                        while (i2 < lastRow) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a, i2 * FloatFFT_2D.this.columns, scale);
                            ++i2;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            int r = 0;
            while (r < this.rows) {
                temp[0][r] = a[r * this.columns];
                ++r;
            }
            this.fftRows.realInverseFull(temp[0], scale);
            p = (n2d2 - 2) / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = 1 + l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? n2d2 - 1 : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idx0 = 2 * c;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                int idx1 = 2 * r;
                                int idx2 = r * FloatFFT_2D.this.columns + idx0;
                                temp[c][idx1] = a[idx2];
                                temp[c][idx1 + 1] = a[idx2 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp[c], scale);
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            if (this.columns % 2 == 0) {
                r = 0;
                while (r < this.rows) {
                    temp[n2d2 - 1][r] = a[r * this.columns + 1];
                    ++r;
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                r = 0;
                while (r < this.rows) {
                    int idx1 = 2 * r;
                    int idx2 = r * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a[idx2 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a[idx2 + 1];
                    ++r;
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            p = this.rows / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                firstRow = l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx1 = 2 * r;
                            int c = 0;
                            while (c < n2d2) {
                                int idx0 = 2 * c;
                                int idx2 = r * rowStride + idx0;
                                a[idx2] = temp[c][idx1];
                                a[idx2 + 1] = temp[c][idx1 + 1];
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l2 = 0;
            while (l2 < nthreads) {
                firstRow = 1 + l2 * p;
                lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx5 = r * rowStride;
                            int idx6 = (FloatFFT_2D.this.rows - r + 1) * rowStride;
                            int c = n2d2;
                            while (c < FloatFFT_2D.this.columns) {
                                int idx1 = 2 * c;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c);
                                a[idx1] = a[idx2];
                                a[idx1 + 1] = -a[idx2 + 1];
                                int idx3 = idx5 + idx1;
                                int idx4 = idx6 - idx1;
                                a[idx3] = a[idx4];
                                a[idx3 + 1] = -a[idx4 + 1];
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx1;
            int idx2;
            int r = 0;
            while (r < this.rows) {
                this.fftColumns.realInverse2(a, r * this.columns, scale);
                ++r;
            }
            r = 0;
            while (r < this.rows) {
                temp[0][r] = a[r * this.columns];
                ++r;
            }
            this.fftRows.realInverseFull(temp[0], scale);
            int c = 1;
            while (c < n2d2 - 1) {
                int idx0 = 2 * c;
                int r2 = 0;
                while (r2 < this.rows) {
                    int idx12 = 2 * r2;
                    idx2 = r2 * this.columns + idx0;
                    temp[c][idx12] = a[idx2];
                    temp[c][idx12 + 1] = a[idx2 + 1];
                    ++r2;
                }
                this.fftRows.complexInverse(temp[c], scale);
                ++c;
            }
            if (this.columns % 2 == 0) {
                r = 0;
                while (r < this.rows) {
                    temp[n2d2 - 1][r] = a[r * this.columns + 1];
                    ++r;
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                r = 0;
                while (r < this.rows) {
                    idx1 = 2 * r;
                    int idx22 = r * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a[idx22 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a[idx22 + 1];
                    ++r;
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            r = 0;
            while (r < this.rows) {
                idx1 = 2 * r;
                int c2 = 0;
                while (c2 < n2d2) {
                    int idx0 = 2 * c2;
                    idx2 = r * rowStride + idx0;
                    a[idx2] = temp[c2][idx1];
                    a[idx2 + 1] = temp[c2][idx1 + 1];
                    ++c2;
                }
                ++r;
            }
            r = 1;
            while (r < this.rows) {
                int idx5 = r * rowStride;
                int idx6 = (this.rows - r + 1) * rowStride;
                int c3 = n2d2;
                while (c3 < this.columns) {
                    int idx13 = 2 * c3;
                    int idx23 = 2 * (this.columns - c3);
                    a[idx13] = a[idx23];
                    a[idx13 + 1] = -a[idx23 + 1];
                    int idx3 = idx5 + idx13;
                    int idx4 = idx6 - idx13;
                    a[idx3] = a[idx4];
                    a[idx3 + 1] = -a[idx4 + 1];
                    ++c3;
                }
                ++r;
            }
        }
    }

    private void rdft2d_sub(int isgn, float[] a) {
        int n1h = this.rows >> 1;
        if (isgn < 0) {
            int i2 = 1;
            while (i2 < n1h) {
                int j = this.rows - i2;
                int idx1 = i2 * this.columns;
                int idx2 = j * this.columns;
                float xi = a[idx1] - a[idx2];
                int n2 = idx1;
                a[n2] = a[n2] + a[idx2];
                a[idx2] = xi;
                xi = a[idx2 + 1] - a[idx1 + 1];
                int n3 = idx1 + 1;
                a[n3] = a[n3] + a[idx2 + 1];
                a[idx2 + 1] = xi;
                ++i2;
            }
        } else {
            int i3 = 1;
            while (i3 < n1h) {
                int j = this.rows - i3;
                int idx1 = i3 * this.columns;
                int idx2 = j * this.columns;
                a[idx2] = 0.5f * (a[idx1] - a[idx2]);
                int n4 = idx1;
                a[n4] = a[n4] - a[idx2];
                a[idx2 + 1] = 0.5f * (a[idx1 + 1] + a[idx2 + 1]);
                int n5 = idx1 + 1;
                a[n5] = a[n5] - a[idx2 + 1];
                ++i3;
            }
        }
    }

    private void rdft2d_sub(int isgn, float[][] a) {
        int n1h = this.rows >> 1;
        if (isgn < 0) {
            int i2 = 1;
            while (i2 < n1h) {
                int j = this.rows - i2;
                float xi = a[i2][0] - a[j][0];
                float[] fArray = a[i2];
                fArray[0] = fArray[0] + a[j][0];
                a[j][0] = xi;
                xi = a[j][1] - a[i2][1];
                float[] fArray2 = a[i2];
                fArray2[1] = fArray2[1] + a[j][1];
                a[j][1] = xi;
                ++i2;
            }
        } else {
            int i3 = 1;
            while (i3 < n1h) {
                int j = this.rows - i3;
                a[j][0] = 0.5f * (a[i3][0] - a[j][0]);
                float[] fArray = a[i3];
                fArray[0] = fArray[0] - a[j][0];
                a[j][1] = 0.5f * (a[i3][1] + a[j][1]);
                float[] fArray3 = a[i3];
                fArray3[1] = fArray3[1] - a[j][1];
                ++i3;
            }
        }
    }

    private void cdft2d_sub(int isgn, float[] a, boolean scale) {
        block21: {
            block19: {
                int idx2;
                int idx1;
                block22: {
                    int idx3;
                    int idx22;
                    int idx12;
                    block20: {
                        if (isgn != -1) break block19;
                        if (this.columns <= 4) break block20;
                        int c = 0;
                        while (c < this.columns) {
                            int idx5;
                            int idx4;
                            int idx32;
                            int idx23;
                            int idx13;
                            int r = 0;
                            while (r < this.rows) {
                                idx13 = r * this.columns + c;
                                idx23 = 2 * r;
                                idx32 = 2 * this.rows + 2 * r;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                this.t[idx23] = a[idx13];
                                this.t[idx23 + 1] = a[idx13 + 1];
                                this.t[idx32] = a[idx13 + 2];
                                this.t[idx32 + 1] = a[idx13 + 3];
                                this.t[idx4] = a[idx13 + 4];
                                this.t[idx4 + 1] = a[idx13 + 5];
                                this.t[idx5] = a[idx13 + 6];
                                this.t[idx5 + 1] = a[idx13 + 7];
                                ++r;
                            }
                            this.fftRows.complexForward(this.t, 0);
                            this.fftRows.complexForward(this.t, 2 * this.rows);
                            this.fftRows.complexForward(this.t, 4 * this.rows);
                            this.fftRows.complexForward(this.t, 6 * this.rows);
                            r = 0;
                            while (r < this.rows) {
                                idx13 = r * this.columns + c;
                                idx23 = 2 * r;
                                idx32 = 2 * this.rows + 2 * r;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                a[idx13] = this.t[idx23];
                                a[idx13 + 1] = this.t[idx23 + 1];
                                a[idx13 + 2] = this.t[idx32];
                                a[idx13 + 3] = this.t[idx32 + 1];
                                a[idx13 + 4] = this.t[idx4];
                                a[idx13 + 5] = this.t[idx4 + 1];
                                a[idx13 + 6] = this.t[idx5];
                                a[idx13 + 7] = this.t[idx5 + 1];
                                ++r;
                            }
                            c += 8;
                        }
                        break block21;
                    }
                    if (this.columns != 4) break block22;
                    int r = 0;
                    while (r < this.rows) {
                        idx12 = r * this.columns;
                        idx22 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx22] = a[idx12];
                        this.t[idx22 + 1] = a[idx12 + 1];
                        this.t[idx3] = a[idx12 + 2];
                        this.t[idx3 + 1] = a[idx12 + 3];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    r = 0;
                    while (r < this.rows) {
                        idx12 = r * this.columns;
                        idx22 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx12] = this.t[idx22];
                        a[idx12 + 1] = this.t[idx22 + 1];
                        a[idx12 + 2] = this.t[idx3];
                        a[idx12 + 3] = this.t[idx3 + 1];
                        ++r;
                    }
                    break block21;
                }
                if (this.columns != 2) break block21;
                int r = 0;
                while (r < this.rows) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                    ++r;
                }
                this.fftRows.complexForward(this.t, 0);
                r = 0;
                while (r < this.rows) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                    ++r;
                }
                break block21;
            }
            if (this.columns > 4) {
                int c = 0;
                while (c < this.columns) {
                    int idx5;
                    int idx4;
                    int idx3;
                    int idx2;
                    int idx1;
                    int r = 0;
                    while (r < this.rows) {
                        idx1 = r * this.columns + c;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                        this.t[idx4] = a[idx1 + 4];
                        this.t[idx4 + 1] = a[idx1 + 5];
                        this.t[idx5] = a[idx1 + 6];
                        this.t[idx5 + 1] = a[idx1 + 7];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = r * this.columns + c;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                        a[idx1 + 4] = this.t[idx4];
                        a[idx1 + 5] = this.t[idx4 + 1];
                        a[idx1 + 6] = this.t[idx5];
                        a[idx1 + 7] = this.t[idx5 + 1];
                        ++r;
                    }
                    c += 8;
                }
            } else if (this.columns == 4) {
                int idx3;
                int idx2;
                int idx1;
                int r = 0;
                while (r < this.rows) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                    this.t[idx3] = a[idx1 + 2];
                    this.t[idx3 + 1] = a[idx1 + 3];
                    ++r;
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                r = 0;
                while (r < this.rows) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                    a[idx1 + 2] = this.t[idx3];
                    a[idx1 + 3] = this.t[idx3 + 1];
                    ++r;
                }
            } else if (this.columns == 2) {
                int idx2;
                int idx1;
                int r = 0;
                while (r < this.rows) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                    ++r;
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                r = 0;
                while (r < this.rows) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                    ++r;
                }
            }
        }
    }

    private void cdft2d_sub(int isgn, float[][] a, boolean scale) {
        block21: {
            block19: {
                int idx2;
                block22: {
                    int idx3;
                    int idx22;
                    block20: {
                        if (isgn != -1) break block19;
                        if (this.columns <= 4) break block20;
                        int c = 0;
                        while (c < this.columns) {
                            int idx5;
                            int idx4;
                            int idx32;
                            int idx23;
                            int r = 0;
                            while (r < this.rows) {
                                idx23 = 2 * r;
                                idx32 = 2 * this.rows + 2 * r;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                this.t[idx23] = a[r][c];
                                this.t[idx23 + 1] = a[r][c + 1];
                                this.t[idx32] = a[r][c + 2];
                                this.t[idx32 + 1] = a[r][c + 3];
                                this.t[idx4] = a[r][c + 4];
                                this.t[idx4 + 1] = a[r][c + 5];
                                this.t[idx5] = a[r][c + 6];
                                this.t[idx5 + 1] = a[r][c + 7];
                                ++r;
                            }
                            this.fftRows.complexForward(this.t, 0);
                            this.fftRows.complexForward(this.t, 2 * this.rows);
                            this.fftRows.complexForward(this.t, 4 * this.rows);
                            this.fftRows.complexForward(this.t, 6 * this.rows);
                            r = 0;
                            while (r < this.rows) {
                                idx23 = 2 * r;
                                idx32 = 2 * this.rows + 2 * r;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                a[r][c] = this.t[idx23];
                                a[r][c + 1] = this.t[idx23 + 1];
                                a[r][c + 2] = this.t[idx32];
                                a[r][c + 3] = this.t[idx32 + 1];
                                a[r][c + 4] = this.t[idx4];
                                a[r][c + 5] = this.t[idx4 + 1];
                                a[r][c + 6] = this.t[idx5];
                                a[r][c + 7] = this.t[idx5 + 1];
                                ++r;
                            }
                            c += 8;
                        }
                        break block21;
                    }
                    if (this.columns != 4) break block22;
                    int r = 0;
                    while (r < this.rows) {
                        idx22 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx22] = a[r][0];
                        this.t[idx22 + 1] = a[r][1];
                        this.t[idx3] = a[r][2];
                        this.t[idx3 + 1] = a[r][3];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    r = 0;
                    while (r < this.rows) {
                        idx22 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[r][0] = this.t[idx22];
                        a[r][1] = this.t[idx22 + 1];
                        a[r][2] = this.t[idx3];
                        a[r][3] = this.t[idx3 + 1];
                        ++r;
                    }
                    break block21;
                }
                if (this.columns != 2) break block21;
                int r = 0;
                while (r < this.rows) {
                    idx2 = 2 * r;
                    this.t[idx2] = a[r][0];
                    this.t[idx2 + 1] = a[r][1];
                    ++r;
                }
                this.fftRows.complexForward(this.t, 0);
                r = 0;
                while (r < this.rows) {
                    idx2 = 2 * r;
                    a[r][0] = this.t[idx2];
                    a[r][1] = this.t[idx2 + 1];
                    ++r;
                }
                break block21;
            }
            if (this.columns > 4) {
                int c = 0;
                while (c < this.columns) {
                    int idx5;
                    int idx4;
                    int idx3;
                    int idx2;
                    int r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        this.t[idx2] = a[r][c];
                        this.t[idx2 + 1] = a[r][c + 1];
                        this.t[idx3] = a[r][c + 2];
                        this.t[idx3 + 1] = a[r][c + 3];
                        this.t[idx4] = a[r][c + 4];
                        this.t[idx4 + 1] = a[r][c + 5];
                        this.t[idx5] = a[r][c + 6];
                        this.t[idx5 + 1] = a[r][c + 7];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        a[r][c] = this.t[idx2];
                        a[r][c + 1] = this.t[idx2 + 1];
                        a[r][c + 2] = this.t[idx3];
                        a[r][c + 3] = this.t[idx3 + 1];
                        a[r][c + 4] = this.t[idx4];
                        a[r][c + 5] = this.t[idx4 + 1];
                        a[r][c + 6] = this.t[idx5];
                        a[r][c + 7] = this.t[idx5 + 1];
                        ++r;
                    }
                    c += 8;
                }
            } else if (this.columns == 4) {
                int idx3;
                int idx2;
                int r = 0;
                while (r < this.rows) {
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    this.t[idx2] = a[r][0];
                    this.t[idx2 + 1] = a[r][1];
                    this.t[idx3] = a[r][2];
                    this.t[idx3 + 1] = a[r][3];
                    ++r;
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                r = 0;
                while (r < this.rows) {
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    a[r][0] = this.t[idx2];
                    a[r][1] = this.t[idx2 + 1];
                    a[r][2] = this.t[idx3];
                    a[r][3] = this.t[idx3 + 1];
                    ++r;
                }
            } else if (this.columns == 2) {
                int idx2;
                int r = 0;
                while (r < this.rows) {
                    idx2 = 2 * r;
                    this.t[idx2] = a[r][0];
                    this.t[idx2 + 1] = a[r][1];
                    ++r;
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                r = 0;
                while (r < this.rows) {
                    idx2 = 2 * r;
                    a[r][0] = this.t[idx2];
                    a[r][1] = this.t[idx2 + 1];
                    ++r;
                }
            }
        }
    }

    private void xdft2d0_subth1(final int icr, final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        int i2 = 0;
        while (i2 < nthreads) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            int r = n0;
                            while (r < FloatFFT_2D.this.rows) {
                                FloatFFT_2D.this.fftColumns.complexForward(a, r * FloatFFT_2D.this.columns);
                                r += nthreads;
                            }
                        } else {
                            int r = n0;
                            while (r < FloatFFT_2D.this.rows) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a, r * FloatFFT_2D.this.columns, scale);
                                r += nthreads;
                            }
                        }
                    } else if (isgn == 1) {
                        int r = n0;
                        while (r < FloatFFT_2D.this.rows) {
                            FloatFFT_2D.this.fftColumns.realForward(a, r * FloatFFT_2D.this.columns);
                            r += nthreads;
                        }
                    } else {
                        int r = n0;
                        while (r < FloatFFT_2D.this.rows) {
                            FloatFFT_2D.this.fftColumns.realInverse(a, r * FloatFFT_2D.this.columns, scale);
                            r += nthreads;
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft2d0_subth2(final int icr, final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        int i2 = 0;
        while (i2 < nthreads) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            int r = n0;
                            while (r < FloatFFT_2D.this.rows) {
                                FloatFFT_2D.this.fftColumns.complexForward(a, r * FloatFFT_2D.this.columns);
                                r += nthreads;
                            }
                        } else {
                            int r = n0;
                            while (r < FloatFFT_2D.this.rows) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a, r * FloatFFT_2D.this.columns, scale);
                                r += nthreads;
                            }
                        }
                    } else if (isgn == 1) {
                        int r = n0;
                        while (r < FloatFFT_2D.this.rows) {
                            FloatFFT_2D.this.fftColumns.realForward(a, r * FloatFFT_2D.this.columns);
                            r += nthreads;
                        }
                    } else {
                        int r = n0;
                        while (r < FloatFFT_2D.this.rows) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a, r * FloatFFT_2D.this.columns, scale);
                            r += nthreads;
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft2d0_subth1(final int icr, final int isgn, final float[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        int i2 = 0;
        while (i2 < nthreads) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            int r = n0;
                            while (r < FloatFFT_2D.this.rows) {
                                FloatFFT_2D.this.fftColumns.complexForward(a[r]);
                                r += nthreads;
                            }
                        } else {
                            int r = n0;
                            while (r < FloatFFT_2D.this.rows) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a[r], scale);
                                r += nthreads;
                            }
                        }
                    } else if (isgn == 1) {
                        int r = n0;
                        while (r < FloatFFT_2D.this.rows) {
                            FloatFFT_2D.this.fftColumns.realForward(a[r]);
                            r += nthreads;
                        }
                    } else {
                        int r = n0;
                        while (r < FloatFFT_2D.this.rows) {
                            FloatFFT_2D.this.fftColumns.realInverse(a[r], scale);
                            r += nthreads;
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft2d0_subth2(final int icr, final int isgn, final float[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        int i2 = 0;
        while (i2 < nthreads) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            int r = n0;
                            while (r < FloatFFT_2D.this.rows) {
                                FloatFFT_2D.this.fftColumns.complexForward(a[r]);
                                r += nthreads;
                            }
                        } else {
                            int r = n0;
                            while (r < FloatFFT_2D.this.rows) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a[r], scale);
                                r += nthreads;
                            }
                        }
                    } else if (isgn == 1) {
                        int r = n0;
                        while (r < FloatFFT_2D.this.rows) {
                            FloatFFT_2D.this.fftColumns.realForward(a[r]);
                            r += nthreads;
                        }
                    } else {
                        int r = n0;
                        while (r < FloatFFT_2D.this.rows) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a[r], 0, scale);
                            r += nthreads;
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void cdft2d_subth(final int isgn, final float[] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 8 * this.rows;
        if (this.columns == 4 * nthread) {
            nt >>= 1;
        } else if (this.columns < 4 * nthread) {
            nthread = this.columns >> 1;
            nt >>= 2;
        }
        Future[] futures = new Future[nthread];
        final int nthreads = nthread;
        int i2 = 0;
        while (i2 < nthread) {
            final int n0 = i2;
            final int startt = nt * i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block21: {
                        block19: {
                            int idx2;
                            int idx1;
                            block22: {
                                int idx3;
                                int idx22;
                                int idx12;
                                block20: {
                                    if (isgn != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * nthreads) break block20;
                                    int c = 8 * n0;
                                    while (c < FloatFFT_2D.this.columns) {
                                        int idx5;
                                        int idx4;
                                        int idx32;
                                        int idx23;
                                        int idx13;
                                        int r = 0;
                                        while (r < FloatFFT_2D.this.rows) {
                                            idx13 = r * FloatFFT_2D.this.columns + c;
                                            idx23 = startt + 2 * r;
                                            idx32 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx23] = a[idx13];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx23 + 1] = a[idx13 + 1];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx32] = a[idx13 + 2];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx32 + 1] = a[idx13 + 3];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx4] = a[idx13 + 4];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx4 + 1] = a[idx13 + 5];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx5] = a[idx13 + 6];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx5 + 1] = a[idx13 + 7];
                                            ++r;
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 6 * FloatFFT_2D.this.rows);
                                        r = 0;
                                        while (r < FloatFFT_2D.this.rows) {
                                            idx13 = r * FloatFFT_2D.this.columns + c;
                                            idx23 = startt + 2 * r;
                                            idx32 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            a[idx13] = FloatFFT_2D.this.t[idx23];
                                            a[idx13 + 1] = FloatFFT_2D.this.t[idx23 + 1];
                                            a[idx13 + 2] = FloatFFT_2D.this.t[idx32];
                                            a[idx13 + 3] = FloatFFT_2D.this.t[idx32 + 1];
                                            a[idx13 + 4] = FloatFFT_2D.this.t[idx4];
                                            a[idx13 + 5] = FloatFFT_2D.this.t[idx4 + 1];
                                            a[idx13 + 6] = FloatFFT_2D.this.t[idx5];
                                            a[idx13 + 7] = FloatFFT_2D.this.t[idx5 + 1];
                                            ++r;
                                        }
                                        c += 8 * nthreads;
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * nthreads) break block22;
                                int r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx12 = r * FloatFFT_2D.this.columns + 4 * n0;
                                    idx22 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx22] = a[idx12];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx22 + 1] = a[idx12 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[idx12 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[idx12 + 3];
                                    ++r;
                                }
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows);
                                r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx12 = r * FloatFFT_2D.this.columns + 4 * n0;
                                    idx22 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    a[idx12] = FloatFFT_2D.this.t[idx22];
                                    a[idx12 + 1] = FloatFFT_2D.this.t[idx22 + 1];
                                    a[idx12 + 2] = FloatFFT_2D.this.t[idx3];
                                    a[idx12 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                    ++r;
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * nthreads) break block21;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx1 = r * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = startt + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[idx1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[idx1 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                            r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx1 = r * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = startt + 2 * r;
                                a[idx1] = FloatFFT_2D.this.t[idx2];
                                a[idx1 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                ++r;
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * nthreads) {
                            int c = 8 * n0;
                            while (c < FloatFFT_2D.this.columns) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int idx1;
                                int r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx1 = r * FloatFFT_2D.this.columns + c;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[idx1 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[idx1 + 3];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx4] = a[idx1 + 4];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx4 + 1] = a[idx1 + 5];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx5] = a[idx1 + 6];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx5 + 1] = a[idx1 + 7];
                                    ++r;
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 4 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 6 * FloatFFT_2D.this.rows, scale);
                                r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx1 = r * FloatFFT_2D.this.columns + c;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    a[idx1] = FloatFFT_2D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                    a[idx1 + 2] = FloatFFT_2D.this.t[idx3];
                                    a[idx1 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                    a[idx1 + 4] = FloatFFT_2D.this.t[idx4];
                                    a[idx1 + 5] = FloatFFT_2D.this.t[idx4 + 1];
                                    a[idx1 + 6] = FloatFFT_2D.this.t[idx5];
                                    a[idx1 + 7] = FloatFFT_2D.this.t[idx5 + 1];
                                    ++r;
                                }
                                c += 8 * nthreads;
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx1 = r * FloatFFT_2D.this.columns + 4 * n0;
                                idx2 = startt + 2 * r;
                                idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[idx1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[idx1 + 1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[idx1 + 2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[idx1 + 3];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows, scale);
                            r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx1 = r * FloatFFT_2D.this.columns + 4 * n0;
                                idx2 = startt + 2 * r;
                                idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                a[idx1] = FloatFFT_2D.this.t[idx2];
                                a[idx1 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                a[idx1 + 2] = FloatFFT_2D.this.t[idx3];
                                a[idx1 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                ++r;
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * nthreads) {
                            int idx2;
                            int idx1;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx1 = r * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = startt + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[idx1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[idx1 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                            r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx1 = r * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = startt + 2 * r;
                                a[idx1] = FloatFFT_2D.this.t[idx2];
                                a[idx1 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                ++r;
                            }
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void cdft2d_subth(final int isgn, final float[][] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 8 * this.rows;
        if (this.columns == 4 * nthread) {
            nt >>= 1;
        } else if (this.columns < 4 * nthread) {
            nthread = this.columns >> 1;
            nt >>= 2;
        }
        Future[] futures = new Future[nthread];
        final int nthreads = nthread;
        int i2 = 0;
        while (i2 < nthreads) {
            final int n0 = i2;
            final int startt = nt * i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block21: {
                        block19: {
                            int idx2;
                            block22: {
                                int idx3;
                                int idx22;
                                block20: {
                                    if (isgn != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * nthreads) break block20;
                                    int c = 8 * n0;
                                    while (c < FloatFFT_2D.this.columns) {
                                        int idx5;
                                        int idx4;
                                        int idx32;
                                        int idx23;
                                        int r = 0;
                                        while (r < FloatFFT_2D.this.rows) {
                                            idx23 = startt + 2 * r;
                                            idx32 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx23] = a[r][c];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx23 + 1] = a[r][c + 1];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx32] = a[r][c + 2];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx32 + 1] = a[r][c + 3];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx4] = a[r][c + 4];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx4 + 1] = a[r][c + 5];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx5] = a[r][c + 6];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx5 + 1] = a[r][c + 7];
                                            ++r;
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 6 * FloatFFT_2D.this.rows);
                                        r = 0;
                                        while (r < FloatFFT_2D.this.rows) {
                                            idx23 = startt + 2 * r;
                                            idx32 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            a[r][c] = FloatFFT_2D.this.t[idx23];
                                            a[r][c + 1] = FloatFFT_2D.this.t[idx23 + 1];
                                            a[r][c + 2] = FloatFFT_2D.this.t[idx32];
                                            a[r][c + 3] = FloatFFT_2D.this.t[idx32 + 1];
                                            a[r][c + 4] = FloatFFT_2D.this.t[idx4];
                                            a[r][c + 5] = FloatFFT_2D.this.t[idx4 + 1];
                                            a[r][c + 6] = FloatFFT_2D.this.t[idx5];
                                            a[r][c + 7] = FloatFFT_2D.this.t[idx5 + 1];
                                            ++r;
                                        }
                                        c += 8 * nthreads;
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * nthreads) break block22;
                                int r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx22 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx22] = a[r][4 * n0];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx22 + 1] = a[r][4 * n0 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[r][4 * n0 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[r][4 * n0 + 3];
                                    ++r;
                                }
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows);
                                r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx22 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    a[r][4 * n0] = FloatFFT_2D.this.t[idx22];
                                    a[r][4 * n0 + 1] = FloatFFT_2D.this.t[idx22 + 1];
                                    a[r][4 * n0 + 2] = FloatFFT_2D.this.t[idx3];
                                    a[r][4 * n0 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                    ++r;
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * nthreads) break block21;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = startt + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[r][2 * n0];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[r][2 * n0 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                            r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = startt + 2 * r;
                                a[r][2 * n0] = FloatFFT_2D.this.t[idx2];
                                a[r][2 * n0 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                ++r;
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * nthreads) {
                            int c = 8 * n0;
                            while (c < FloatFFT_2D.this.columns) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[r][c];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[r][c + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[r][c + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[r][c + 3];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx4] = a[r][c + 4];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx4 + 1] = a[r][c + 5];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx5] = a[r][c + 6];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx5 + 1] = a[r][c + 7];
                                    ++r;
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 4 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 6 * FloatFFT_2D.this.rows, scale);
                                r = 0;
                                while (r < FloatFFT_2D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    a[r][c] = FloatFFT_2D.this.t[idx2];
                                    a[r][c + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                    a[r][c + 2] = FloatFFT_2D.this.t[idx3];
                                    a[r][c + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                    a[r][c + 4] = FloatFFT_2D.this.t[idx4];
                                    a[r][c + 5] = FloatFFT_2D.this.t[idx4 + 1];
                                    a[r][c + 6] = FloatFFT_2D.this.t[idx5];
                                    a[r][c + 7] = FloatFFT_2D.this.t[idx5 + 1];
                                    ++r;
                                }
                                c += 8 * nthreads;
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * nthreads) {
                            int idx3;
                            int idx2;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = startt + 2 * r;
                                idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[r][4 * n0];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[r][4 * n0 + 1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[r][4 * n0 + 2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[r][4 * n0 + 3];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows, scale);
                            r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = startt + 2 * r;
                                idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                a[r][4 * n0] = FloatFFT_2D.this.t[idx2];
                                a[r][4 * n0 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                a[r][4 * n0 + 2] = FloatFFT_2D.this.t[idx3];
                                a[r][4 * n0 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                ++r;
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * nthreads) {
                            int idx2;
                            int r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = startt + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[r][2 * n0];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[r][2 * n0 + 1];
                                ++r;
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                            r = 0;
                            while (r < FloatFFT_2D.this.rows) {
                                idx2 = startt + 2 * r;
                                a[r][2 * n0] = FloatFFT_2D.this.t[idx2];
                                a[r][2 * n0 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                ++r;
                            }
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void fillSymmetric(final float[] a) {
        int idx2;
        int idx1;
        int twon2 = 2 * this.columns;
        int n1d2 = this.rows / 2;
        int r = this.rows - 1;
        while (r >= 1) {
            idx1 = r * this.columns;
            idx2 = 2 * idx1;
            int c = 0;
            while (c < this.columns) {
                a[idx2 + c] = a[idx1 + c];
                a[idx1 + c] = 0.0f;
                a[idx2 + c + 1] = a[idx1 + c + 1];
                a[idx1 + c + 1] = 0.0f;
                c += 2;
            }
            --r;
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads) {
            Future[] futures = new Future[nthreads];
            int l1k = n1d2 / nthreads;
            final int newn2 = 2 * this.columns;
            int i2 = 0;
            while (i2 < nthreads) {
                final int l1offa = i2 == 0 ? i2 * l1k + 1 : i2 * l1k;
                final int l1stopa = i2 * l1k + l1k;
                final int l2offa = i2 * l1k;
                final int l2stopa = i2 == nthreads - 1 ? i2 * l1k + l1k + 1 : i2 * l1k + l1k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx4;
                        int c;
                        int idx3;
                        int idx2;
                        int idx1;
                        int r = l1offa;
                        while (r < l1stopa) {
                            idx1 = r * newn2;
                            idx2 = (FloatFFT_2D.this.rows - r) * newn2;
                            idx3 = idx1 + FloatFFT_2D.this.columns;
                            a[idx3] = a[idx2 + 1];
                            a[idx3 + 1] = -a[idx2];
                            ++r;
                        }
                        r = l1offa;
                        while (r < l1stopa) {
                            idx1 = r * newn2;
                            idx3 = (FloatFFT_2D.this.rows - r + 1) * newn2;
                            c = FloatFFT_2D.this.columns + 2;
                            while (c < newn2) {
                                idx2 = idx3 - c;
                                idx4 = idx1 + c;
                                a[idx4] = a[idx2];
                                a[idx4 + 1] = -a[idx2 + 1];
                                c += 2;
                            }
                            ++r;
                        }
                        r = l2offa;
                        while (r < l2stopa) {
                            idx3 = (FloatFFT_2D.this.rows - r) % FloatFFT_2D.this.rows * newn2;
                            idx4 = r * newn2;
                            c = 0;
                            while (c < newn2) {
                                idx1 = idx3 + (newn2 - c) % newn2;
                                idx2 = idx4 + c;
                                a[idx1] = a[idx2];
                                a[idx1 + 1] = -a[idx2 + 1];
                                c += 2;
                            }
                            ++r;
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int idx3;
            int r2 = 1;
            while (r2 < n1d2) {
                idx2 = r2 * twon2;
                idx3 = (this.rows - r2) * twon2;
                a[idx2 + this.columns] = a[idx3 + 1];
                a[idx2 + this.columns + 1] = -a[idx3];
                ++r2;
            }
            r2 = 1;
            while (r2 < n1d2) {
                idx2 = r2 * twon2;
                idx3 = (this.rows - r2 + 1) * twon2;
                c = this.columns + 2;
                while (c < twon2) {
                    a[idx2 + c] = a[idx3 - c];
                    a[idx2 + c + 1] = -a[idx3 - c + 1];
                    c += 2;
                }
                ++r2;
            }
            r2 = 0;
            while (r2 <= this.rows / 2) {
                idx1 = r2 * twon2;
                int idx4 = (this.rows - r2) % this.rows * twon2;
                c = 0;
                while (c < twon2) {
                    idx2 = idx1 + c;
                    idx3 = idx4 + (twon2 - c) % twon2;
                    a[idx3] = a[idx2];
                    a[idx3 + 1] = -a[idx2 + 1];
                    c += 2;
                }
                ++r2;
            }
        }
        a[this.columns] = -a[1];
        a[1] = 0.0f;
        idx1 = n1d2 * twon2;
        a[idx1 + this.columns] = -a[idx1 + 1];
        a[idx1 + 1] = 0.0f;
        a[idx1 + this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final float[][] a) {
        final int newn2 = 2 * this.columns;
        int n1d2 = this.rows / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads) {
            Future[] futures = new Future[nthreads];
            int l1k = n1d2 / nthreads;
            int i2 = 0;
            while (i2 < nthreads) {
                final int l1offa = i2 == 0 ? i2 * l1k + 1 : i2 * l1k;
                final int l1stopa = i2 * l1k + l1k;
                final int l2offa = i2 * l1k;
                final int l2stopa = i2 == nthreads - 1 ? i2 * l1k + l1k + 1 : i2 * l1k + l1k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx2;
                        int c;
                        int idx1;
                        int r = l1offa;
                        while (r < l1stopa) {
                            idx1 = FloatFFT_2D.this.rows - r;
                            a[r][((FloatFFT_2D)FloatFFT_2D.this).columns] = a[idx1][1];
                            a[r][((FloatFFT_2D)FloatFFT_2D.this).columns + 1] = -a[idx1][0];
                            ++r;
                        }
                        r = l1offa;
                        while (r < l1stopa) {
                            idx1 = FloatFFT_2D.this.rows - r;
                            c = FloatFFT_2D.this.columns + 2;
                            while (c < newn2) {
                                idx2 = newn2 - c;
                                a[r][c] = a[idx1][idx2];
                                a[r][c + 1] = -a[idx1][idx2 + 1];
                                c += 2;
                            }
                            ++r;
                        }
                        r = l2offa;
                        while (r < l2stopa) {
                            idx1 = (FloatFFT_2D.this.rows - r) % FloatFFT_2D.this.rows;
                            c = 0;
                            while (c < newn2) {
                                idx2 = (newn2 - c) % newn2;
                                a[idx1][idx2] = a[r][c];
                                a[idx1][idx2 + 1] = -a[r][c + 1];
                                c += 2;
                            }
                            ++r;
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx2;
            int c;
            int idx1;
            int r = 1;
            while (r < n1d2) {
                idx1 = this.rows - r;
                a[r][this.columns] = a[idx1][1];
                a[r][this.columns + 1] = -a[idx1][0];
                ++r;
            }
            r = 1;
            while (r < n1d2) {
                idx1 = this.rows - r;
                c = this.columns + 2;
                while (c < newn2) {
                    idx2 = newn2 - c;
                    a[r][c] = a[idx1][idx2];
                    a[r][c + 1] = -a[idx1][idx2 + 1];
                    c += 2;
                }
                ++r;
            }
            r = 0;
            while (r <= this.rows / 2) {
                idx1 = (this.rows - r) % this.rows;
                c = 0;
                while (c < newn2) {
                    idx2 = (newn2 - c) % newn2;
                    a[idx1][idx2] = a[r][c];
                    a[idx1][idx2 + 1] = -a[r][c + 1];
                    c += 2;
                }
                ++r;
            }
        }
        a[0][this.columns] = -a[0][1];
        a[0][1] = 0.0f;
        a[n1d2][this.columns] = -a[n1d2][1];
        a[n1d2][1] = 0.0f;
        a[n1d2][this.columns + 1] = 0.0f;
    }
}

