/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft;

public class RealFFTUtils_3D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private final int columns;
    private final int rows;
    private final int rowStride;
    private final int slices;
    private final int sliceStride;

    public RealFFTUtils_3D(int slices, int rows, int columns) {
        this.slices = slices;
        this.rows = rows;
        this.columns = columns;
        this.rowStride = columns;
        this.sliceStride = rows * this.rowStride;
    }

    public int getIndex(int s2, int r, int c) {
        int rr;
        int cmod2 = c & 1;
        int rmul2 = r << 1;
        int smul2 = s2 << 1;
        int ss = s2 == 0 ? 0 : this.slices - s2;
        int n2 = rr = r == 0 ? 0 : this.rows - r;
        if (c <= 1) {
            if (r == 0) {
                if (s2 == 0) {
                    return c == 0 ? 0 : Integer.MIN_VALUE;
                }
                if (smul2 < this.slices) {
                    return s2 * this.sliceStride + c;
                }
                if (smul2 > this.slices) {
                    int index2 = ss * this.sliceStride;
                    return cmod2 == 0 ? index2 : -(index2 + 1);
                }
                return cmod2 == 0 ? s2 * this.sliceStride : Integer.MIN_VALUE;
            }
            if (rmul2 < this.rows) {
                return s2 * this.sliceStride + r * this.rowStride + c;
            }
            if (rmul2 > this.rows) {
                int index3 = ss * this.sliceStride + rr * this.rowStride;
                return cmod2 == 0 ? index3 : -(index3 + 1);
            }
            if (s2 == 0) {
                return cmod2 == 0 ? r * this.rowStride : Integer.MIN_VALUE;
            }
            if (smul2 < this.slices) {
                return s2 * this.sliceStride + r * this.rowStride + c;
            }
            if (smul2 > this.slices) {
                int index4 = ss * this.sliceStride + r * this.rowStride;
                return cmod2 == 0 ? index4 : -(index4 + 1);
            }
            int index5 = s2 * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index5 : Integer.MIN_VALUE;
        }
        if (c < this.columns) {
            return s2 * this.sliceStride + r * this.rowStride + c;
        }
        if (c > this.columns + 1) {
            int cc = (this.columns << 1) - c;
            int index6 = ss * this.sliceStride + rr * this.rowStride + cc;
            return cmod2 == 0 ? index6 : -(index6 + 2);
        }
        if (r == 0) {
            if (s2 == 0) {
                return cmod2 == 0 ? 1 : Integer.MIN_VALUE;
            }
            if (smul2 < this.slices) {
                int index7 = ss * this.sliceStride;
                return cmod2 == 0 ? index7 + 1 : -index7;
            }
            if (smul2 > this.slices) {
                int index8 = s2 * this.sliceStride;
                return cmod2 == 0 ? index8 + 1 : index8;
            }
            int index9 = s2 * this.sliceStride;
            return cmod2 == 0 ? index9 + 1 : Integer.MIN_VALUE;
        }
        if (rmul2 < this.rows) {
            int index10 = ss * this.sliceStride + rr * this.rowStride;
            return cmod2 == 0 ? index10 + 1 : -index10;
        }
        if (rmul2 > this.rows) {
            int index11 = s2 * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index11 + 1 : index11;
        }
        if (s2 == 0) {
            int index12 = r * this.rowStride + 1;
            return cmod2 == 0 ? index12 : Integer.MIN_VALUE;
        }
        if (smul2 < this.slices) {
            int index13 = ss * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index13 + 1 : -index13;
        }
        if (smul2 > this.slices) {
            int index14 = s2 * this.sliceStride + r * this.rowStride;
            return cmod2 == 0 ? index14 + 1 : index14;
        }
        int index15 = s2 * this.sliceStride + r * this.rowStride;
        return cmod2 == 0 ? index15 + 1 : Integer.MIN_VALUE;
    }

    public void pack(double val, int s2, int r, int c, double[] packed2, int pos) {
        int i2 = this.getIndex(s2, r, c);
        if (i2 >= 0) {
            packed2[pos + i2] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed2[pos - i2] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s2, r, c));
        }
    }

    public void pack(double val, int s2, int r, int c, double[][][] packed2) {
        int i2 = this.getIndex(s2, r, c);
        int ii = Math.abs(i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            packed2[ss][rr][cc] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed2[ss][rr][cc] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(float val, int s2, int r, int c, float[] packed2, int pos) {
        int i2 = this.getIndex(s2, r, c);
        if (i2 >= 0) {
            packed2[pos + i2] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed2[pos - i2] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s2, r, c));
        }
    }

    public void pack(float val, int s2, int r, int c, float[][][] packed2) {
        int i2 = this.getIndex(s2, r, c);
        int ii = Math.abs(i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            packed2[ss][rr][cc] = val;
        } else if (i2 > Integer.MIN_VALUE) {
            packed2[ss][rr][cc] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", s2, r, c));
        }
    }

    public double unpack(int s2, int r, int c, double[] packed2, int pos) {
        int i2 = this.getIndex(s2, r, c);
        if (i2 >= 0) {
            return packed2[pos + i2];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed2[pos - i2];
        }
        return 0.0;
    }

    public double unpack(int s2, int r, int c, double[][][] packed2) {
        int i2 = this.getIndex(s2, r, c);
        int ii = Math.abs(i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            return packed2[ss][rr][cc];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed2[ss][rr][cc];
        }
        return 0.0;
    }

    public float unpack(int s2, int r, int c, float[] packed2, int pos) {
        int i2 = this.getIndex(s2, r, c);
        if (i2 >= 0) {
            return packed2[pos + i2];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed2[pos - i2];
        }
        return 0.0f;
    }

    public float unpack(int s2, int r, int c, float[][][] packed2) {
        int i2 = this.getIndex(s2, r, c);
        int ii = Math.abs(i2);
        int ss = ii / this.sliceStride;
        int remainder = ii % this.sliceStride;
        int rr = remainder / this.rowStride;
        int cc = remainder % this.rowStride;
        if (i2 >= 0) {
            return packed2[ss][rr][cc];
        }
        if (i2 > Integer.MIN_VALUE) {
            return -packed2[ss][rr][cc];
        }
        return 0.0f;
    }
}

