/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import ml.combust.mleap.shaded.org.apache.commons.io.IOCase;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.AbstractFileFilter;

public class SuffixFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -3389157631240246157L;
    private final String[] suffixes;
    private final IOCase caseSensitivity;

    public SuffixFileFilter(String suffix2) {
        this(suffix2, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String suffix2, IOCase caseSensitivity) {
        if (suffix2 == null) {
            throw new IllegalArgumentException("The suffix must not be null");
        }
        this.suffixes = new String[]{suffix2};
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public SuffixFileFilter(String[] suffixes) {
        this(suffixes, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String[] suffixes, IOCase caseSensitivity) {
        if (suffixes == null) {
            throw new IllegalArgumentException("The array of suffixes must not be null");
        }
        this.suffixes = new String[suffixes.length];
        System.arraycopy(suffixes, 0, this.suffixes, 0, suffixes.length);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public SuffixFileFilter(List<String> suffixes) {
        this(suffixes, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(List<String> suffixes, IOCase caseSensitivity) {
        if (suffixes == null) {
            throw new IllegalArgumentException("The list of suffixes must not be null");
        }
        this.suffixes = suffixes.toArray(new String[suffixes.size()]);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public boolean accept(File file2) {
        String name2 = file2.getName();
        for (String suffix2 : this.suffixes) {
            if (!this.caseSensitivity.checkEndsWith(name2, suffix2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file2, String name2) {
        for (String suffix2 : this.suffixes) {
            if (!this.caseSensitivity.checkEndsWith(name2, suffix2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.suffixes != null) {
            for (int i2 = 0; i2 < this.suffixes.length; ++i2) {
                if (i2 > 0) {
                    buffer.append(",");
                }
                buffer.append(this.suffixes[i2]);
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

