/*
 * Decompiled with CFR 0.152.
 */
package net.jafama;

public final class NumbersUtils {
    public static final double DOUBLE_MIN_NORMAL = Double.longBitsToDouble(0x10000000000000L);
    public static final float FLOAT_MIN_NORMAL = Float.intBitsToFloat(0x800000);
    private static final int MIN_DOUBLE_EXPONENT = -1074;
    private static final int MAX_DOUBLE_EXPONENT = 1023;
    private static final char[] CHAR_BY_DIGIT;
    private static final int[] DIV_SHIFT_BY_RADIX;
    private static final int[] MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX;
    private static final int[] MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX;
    static final double NO_CSN_MIN_BOUND_INCL = 0.001;
    static final double NO_CSN_MAX_BOUND_EXCL = 1.0E7;
    private static final double PIO2_HI;
    private static final double PIO2_LO;
    private static final double PI_HI;
    private static final double PI_LO;
    private static final double TWOPI_HI;
    private static final double TWOPI_LO;

    static {
        int minDecimal = 48;
        int maxDecimal = 57;
        int n1 = 10;
        int minLetter = 65;
        int maxLetter = 90;
        int n2 = 26;
        CHAR_BY_DIGIT = new char[36];
        int i2 = 0;
        int c = 48;
        while (c <= 57) {
            NumbersUtils.CHAR_BY_DIGIT[i2++] = c;
            c = (char)(c + 1);
        }
        c = 65;
        while (c <= 90) {
            NumbersUtils.CHAR_BY_DIGIT[i2++] = c;
            c = (char)(c + 1);
        }
        DIV_SHIFT_BY_RADIX = new int[33];
        int shift = 1;
        int radix = 2;
        while (radix <= 32) {
            NumbersUtils.DIV_SHIFT_BY_RADIX[radix] = shift++;
            radix *= 2;
        }
        MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX = new int[37];
        MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX = new int[37];
        int radix2 = 2;
        while (radix2 <= 36) {
            NumbersUtils.MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX[radix2] = Integer.toString(Integer.MIN_VALUE, radix2).length() - 1;
            NumbersUtils.MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX[radix2] = Long.toString(Long.MIN_VALUE, radix2).length() - 1;
            ++radix2;
        }
        PIO2_HI = Double.longBitsToDouble(4609753056924401664L);
        PIO2_LO = Double.longBitsToDouble(4454258360616903473L);
        PI_HI = 2.0 * PIO2_HI;
        PI_LO = 2.0 * PIO2_LO;
        TWOPI_HI = 4.0 * PIO2_HI;
        TWOPI_LO = 4.0 * PIO2_LO;
    }

    public static boolean equal(float a, float b2) {
        return a == b2 ? true : a != a && b2 != b2;
    }

    public static boolean equal(double a, double b2) {
        return a == b2 ? true : a != a && b2 != b2;
    }

    public static boolean isMathematicalInteger(float value2) {
        return (value2 = Math.abs(value2)) >= 8388608.0f && value2 != Float.POSITIVE_INFINITY || value2 == (float)((int)value2);
    }

    public static boolean isMathematicalInteger(double value2) {
        return (value2 = Math.abs(value2)) >= 4.503599627370496E15 && value2 != Double.POSITIVE_INFINITY || value2 == (double)((long)value2);
    }

    public static boolean isEquidistant(float value2) {
        float valueAbs = Math.abs(value2);
        if (!(valueAbs < 8388608.0f)) {
            return false;
        }
        float twice = valueAbs + valueAbs;
        return twice == (float)((int)twice) && value2 != (float)((int)value2);
    }

    public static boolean isEquidistant(double value2) {
        double valueAbs = Math.abs(value2);
        if (!(valueAbs < 4.503599627370496E15)) {
            return false;
        }
        double twice = valueAbs + valueAbs;
        return twice == (double)((long)twice) && value2 != (double)((long)value2);
    }

    public static boolean isNaNOrInfinite(float a) {
        return a - a != 0.0f;
    }

    public static boolean isNaNOrInfinite(double a) {
        return a - a != 0.0;
    }

    public static boolean isInRange(int min, int max, int a) {
        return min <= a && a <= max;
    }

    public static boolean isInRange(long min, long max, long a) {
        return min <= a && a <= max;
    }

    public static boolean isInRange(float min, float max, float a) {
        return min <= a && a <= max;
    }

    public static boolean isInRange(double min, double max, double a) {
        return min <= a && a <= max;
    }

    public static boolean checkIsInRange(int min, int max, int a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(String.valueOf(a) + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean checkIsInRange(long min, long max, long a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(String.valueOf(a) + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean checkIsInRange(float min, float max, float a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(String.valueOf(a) + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean checkIsInRange(double min, double max, double a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(String.valueOf(a) + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static int toRange(int min, int max, int a) {
        if (a <= min) {
            return min;
        }
        if (a >= max) {
            return max;
        }
        return a;
    }

    public static long toRange(long min, long max, long a) {
        if (a <= min) {
            return min;
        }
        if (a >= max) {
            return max;
        }
        return a;
    }

    public static float toRange(float min, float max, float a) {
        if (a <= min) {
            return min;
        }
        if (a >= max) {
            return max;
        }
        return a;
    }

    public static double toRange(double min, double max, double a) {
        if (a <= min) {
            return min;
        }
        if (a >= max) {
            return max;
        }
        return a;
    }

    public static boolean isInRangeSigned(int a, int bitSize) {
        NumbersUtils.checkBitSizeForSignedInt(bitSize);
        return NumbersUtils.minSignedIntForBitSize_noCheck(bitSize) <= a && a <= NumbersUtils.maxSignedIntForBitSize_noCheck(bitSize);
    }

    public static boolean isInRangeSigned(long a, int bitSize) {
        NumbersUtils.checkBitSizeForSignedLong(bitSize);
        return NumbersUtils.minSignedLongForBitSize_noCheck(bitSize) <= a && a <= NumbersUtils.maxSignedLongForBitSize_noCheck(bitSize);
    }

    public static boolean isInRangeUnsigned(int a, int bitSize) {
        return NumbersUtils.isInRange(0, NumbersUtils.maxUnsignedIntForBitSize(bitSize), a);
    }

    public static boolean isInRangeUnsigned(long a, int bitSize) {
        return NumbersUtils.isInRange(0L, NumbersUtils.maxUnsignedLongForBitSize(bitSize), a);
    }

    public static boolean checkIsInRangeSigned(int a, int bitSize) {
        if (!NumbersUtils.isInRangeSigned(a, bitSize)) {
            throw new IllegalArgumentException(String.valueOf(a) + " does not fit as a signed value over " + bitSize + " bits");
        }
        return true;
    }

    public static boolean checkIsInRangeSigned(long a, int bitSize) {
        if (!NumbersUtils.isInRangeSigned(a, bitSize)) {
            throw new IllegalArgumentException(String.valueOf(a) + " does not fit as a signed value over " + bitSize + " bits");
        }
        return true;
    }

    public static boolean checkIsInRangeUnsigned(int a, int bitSize) {
        if (!NumbersUtils.isInRangeUnsigned(a, bitSize)) {
            throw new IllegalArgumentException(String.valueOf(a) + " does not fit as an unsigned value over " + bitSize + " bits");
        }
        return true;
    }

    public static boolean checkIsInRangeUnsigned(long a, int bitSize) {
        if (!NumbersUtils.isInRangeUnsigned(a, bitSize)) {
            throw new IllegalArgumentException(String.valueOf(a) + " does not fit as an unsigned value over " + bitSize + " bits");
        }
        return true;
    }

    public static int intMaskMSBits0(int bitSize) {
        NumbersUtils.checkIsInRange(0, 32, bitSize);
        int halfish = bitSize >> 1;
        return -1 >>> halfish >>> bitSize - halfish;
    }

    public static int intMaskMSBits1(int bitSize) {
        return ~NumbersUtils.intMaskMSBits0(bitSize);
    }

    public static int intMaskLSBits0(int bitSize) {
        return ~NumbersUtils.intMaskMSBits0(32 - bitSize);
    }

    public static int intMaskLSBits1(int bitSize) {
        return NumbersUtils.intMaskMSBits0(32 - bitSize);
    }

    public static long longMaskMSBits0(int bitSize) {
        NumbersUtils.checkIsInRange(0, 64, bitSize);
        int halfish = bitSize >> 1;
        return -1L >>> halfish >>> bitSize - halfish;
    }

    public static long longMaskMSBits1(int bitSize) {
        return NumbersUtils.longMaskMSBits0(bitSize) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long longMaskLSBits0(int bitSize) {
        return NumbersUtils.longMaskMSBits0(64 - bitSize) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long longMaskLSBits1(int bitSize) {
        return NumbersUtils.longMaskMSBits0(64 - bitSize);
    }

    public static short byteAsUnsigned(byte value2) {
        return (short)((short)value2 & 0xFF);
    }

    public static int shortAsUnsigned(short value2) {
        return value2 & 0xFFFF;
    }

    public static long intAsUnsigned(int value2) {
        return (long)value2 & 0xFFFFFFFFFFFFFFFFL;
    }

    public static boolean isValidBitSizeForSignedInt(int bitSize) {
        return bitSize > 0 && bitSize <= 32;
    }

    public static boolean isValidBitSizeForSignedLong(int bitSize) {
        return bitSize > 0 && bitSize <= 64;
    }

    public static boolean isValidBitSizeForUnsignedInt(int bitSize) {
        return bitSize > 0 && bitSize < 32;
    }

    public static boolean isValidBitSizeForUnsignedLong(int bitSize) {
        return bitSize > 0 && bitSize < 64;
    }

    public static boolean checkBitSizeForSignedInt(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForSignedInt(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,32] for signed int values");
        }
        return true;
    }

    public static boolean checkBitSizeForSignedLong(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForSignedLong(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,64] for signed long values");
        }
        return true;
    }

    public static boolean checkBitSizeForUnsignedInt(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForUnsignedInt(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,31] for unsigned int values");
        }
        return true;
    }

    public static boolean checkBitSizeForUnsignedLong(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForUnsignedLong(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,63] for unsigned long values");
        }
        return true;
    }

    public static int minSignedIntForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForSignedInt(bitSize);
        return NumbersUtils.minSignedIntForBitSize_noCheck(bitSize);
    }

    public static long minSignedLongForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForSignedLong(bitSize);
        return NumbersUtils.minSignedLongForBitSize_noCheck(bitSize);
    }

    public static int maxSignedIntForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForSignedInt(bitSize);
        return NumbersUtils.maxSignedIntForBitSize_noCheck(bitSize);
    }

    public static long maxSignedLongForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForSignedLong(bitSize);
        return NumbersUtils.maxSignedLongForBitSize_noCheck(bitSize);
    }

    public static int maxUnsignedIntForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForUnsignedInt(bitSize);
        return Integer.MAX_VALUE >> 31 - bitSize;
    }

    public static long maxUnsignedLongForBitSize(int bitSize) {
        NumbersUtils.checkBitSizeForUnsignedLong(bitSize);
        return Long.MAX_VALUE >> 63 - bitSize;
    }

    public static int bitSizeForSignedValue(int value2) {
        if (value2 > 0) {
            return 33 - Integer.numberOfLeadingZeros(value2);
        }
        if (value2 == 0) {
            return 1;
        }
        return 33 - Integer.numberOfLeadingZeros(-value2 - 1);
    }

    public static int bitSizeForSignedValue(long value2) {
        if (value2 > 0L) {
            return 65 - Long.numberOfLeadingZeros(value2);
        }
        if (value2 == 0L) {
            return 1;
        }
        return 65 - Long.numberOfLeadingZeros(-value2 - 1L);
    }

    public static int bitSizeForUnsignedValue(int value2) {
        if (value2 > 0) {
            return 32 - Integer.numberOfLeadingZeros(value2);
        }
        if (value2 == 0) {
            return 1;
        }
        throw new IllegalArgumentException("unsigned value [" + value2 + "] must be >= 0");
    }

    public static int bitSizeForUnsignedValue(long value2) {
        if (value2 > 0L) {
            return 64 - Long.numberOfLeadingZeros(value2);
        }
        if (value2 == 0L) {
            return 1;
        }
        throw new IllegalArgumentException("unsigned value [" + value2 + "] must be >= 0");
    }

    public static int signum(int a) {
        return a < 0 ? -1 : (a == 0 ? 0 : 1);
    }

    public static int signum(long a) {
        return a < 0L ? -1 : (a == 0L ? 0 : 1);
    }

    public static boolean isEven(int a) {
        return (a & 1) == 0;
    }

    public static boolean isEven(long a) {
        return NumbersUtils.isEven((int)a);
    }

    public static boolean isOdd(int a) {
        return (a & 1) != 0;
    }

    public static boolean isOdd(long a) {
        return NumbersUtils.isOdd((int)a);
    }

    public static boolean haveSameEvenness(int a, int b2) {
        return ((a ^ b2) & 1) == 0;
    }

    public static boolean haveSameEvenness(long a, long b2) {
        return NumbersUtils.haveSameEvenness((int)a, (int)b2);
    }

    public static boolean haveSameSign(int a, int b2) {
        return (a ^ b2) >= 0;
    }

    public static boolean haveSameSign(long a, long b2) {
        return (a ^ b2) >= 0L;
    }

    public static boolean isPowerOfTwo(int a) {
        if (a <= 0) {
            return false;
        }
        return (a & a - 1) == 0;
    }

    public static boolean isPowerOfTwo(long a) {
        if (a <= 0L) {
            return false;
        }
        return (a & a - 1L) == 0L;
    }

    public static boolean isSignedPowerOfTwo(int a) {
        if (a > 0) {
            return (a & a - 1) == 0;
        }
        if (a == -a) {
            return a != 0;
        }
        return (-a & -a - 1) == 0;
    }

    public static boolean isSignedPowerOfTwo(long a) {
        if (a > 0L) {
            return (a & a - 1L) == 0L;
        }
        if (a == -a) {
            return a != 0L;
        }
        return (-a & -a - 1L) == 0L;
    }

    public static int floorPowerOfTwo(int a) {
        if (a <= 0) {
            throw new IllegalArgumentException("a [" + a + "] must be > 0");
        }
        return Integer.highestOneBit(a);
    }

    public static long floorPowerOfTwo(long a) {
        if (a <= 0L) {
            throw new IllegalArgumentException("a [" + a + "] must be > 0");
        }
        return 1L << 63 - Long.numberOfLeadingZeros(a);
    }

    public static int ceilingPowerOfTwo(int a) {
        NumbersUtils.checkIsInRange(0, 0x40000000, a);
        return a >= 2 ? Integer.highestOneBit(a - 1 << 1) : 1;
    }

    public static long ceilingPowerOfTwo(long a) {
        NumbersUtils.checkIsInRange(0L, 0x4000000000000000L, a);
        return 1L << 64 - Long.numberOfLeadingZeros(a - 1L);
    }

    public static int meanLow(int a, int b2) {
        return (a & b2) + ((a ^ b2) >> 1);
    }

    public static long meanLow(long a, long b2) {
        return (a & b2) + ((a ^ b2) >> 1);
    }

    public static int meanSml(int a, int b2) {
        int result2 = NumbersUtils.meanLow(a, b2);
        if (!NumbersUtils.haveSameEvenness(a, b2) && ((a & b2) < 0 || (a | b2) < 0 && a + b2 < 0)) {
            ++result2;
        }
        return result2;
    }

    public static long meanSml(long a, long b2) {
        long result2 = NumbersUtils.meanLow(a, b2);
        if (!NumbersUtils.haveSameEvenness(a, b2) && ((a & b2) < 0L || (a | b2) < 0L && a + b2 < 0L)) {
            ++result2;
        }
        return result2;
    }

    public static int negHalfWidth(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("min [" + min + "] must be <= max [" + max + "]");
        }
        int mean = NumbersUtils.meanLow(min, max);
        return min - mean - ((min ^ max) & 1);
    }

    public static long negHalfWidth(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("min [" + min + "] must be <= max [" + max + "]");
        }
        long mean = NumbersUtils.meanLow(min, max);
        return min - mean - ((min ^ max) & 1L);
    }

    public static int moduloSignedPowerOfTwo(int value2, int spot) {
        if (spot == Integer.MIN_VALUE) {
            return value2 != Integer.MIN_VALUE ? value2 : 0;
        }
        int s2 = value2 >> 31;
        return ((value2 + s2 ^ s2) & NumbersUtils.abs(spot) - 1) + s2 ^ s2;
    }

    public static long moduloSignedPowerOfTwo(long value2, long spot) {
        if (spot == Long.MIN_VALUE) {
            return value2 != Long.MIN_VALUE ? value2 : 0L;
        }
        long s2 = value2 >> 63;
        return ((value2 + s2 ^ s2) & NumbersUtils.abs(spot) - 1L) + s2 ^ s2;
    }

    public static int log2(int value2) {
        if (value2 <= 0) {
            throw new IllegalArgumentException("value [" + value2 + "] must be > 0");
        }
        return 31 - Integer.numberOfLeadingZeros(value2);
    }

    public static int log2(long value2) {
        if (value2 <= 0L) {
            throw new IllegalArgumentException("value [" + value2 + "] must be > 0");
        }
        return 63 - Long.numberOfLeadingZeros(value2);
    }

    public static int abs(int a) {
        return (a ^ a >> 31) - (a >> 31);
    }

    public static long abs(long a) {
        return (a ^ a >> 63) - (a >> 63);
    }

    public static int absNeg(int a) {
        return (a >> 31) - (a ^ a >> 31);
    }

    public static long absNeg(long a) {
        return (a >> 63) - (a ^ a >> 63);
    }

    public static double twoPow(int power) {
        if (power <= -1023) {
            if (power >= -1074) {
                return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
            }
            return 0.0;
        }
        if (power > 1023) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.longBitsToDouble((long)(power + 1023) << 52);
    }

    public static int intHash(long a) {
        int hash = (int)(a >> 32) + (int)a;
        if (a < 0L) {
            ++hash;
        }
        return hash;
    }

    public static byte asByte(int a) {
        if (a != (byte)a) {
            throw new ArithmeticException("overflow: " + a);
        }
        return (byte)a;
    }

    public static int asInt(long a) {
        if (a != (long)((int)a)) {
            throw new ArithmeticException("overflow: " + a);
        }
        return (int)a;
    }

    public static int toInt(long a) {
        if (a != (long)((int)a)) {
            return a < 0L ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        return (int)a;
    }

    public static int plusExact(int a, int b2) {
        int sum = a + b2;
        if (((a ^ sum) & (b2 ^ sum)) < 0) {
            throw new ArithmeticException("overflow: " + a + "+" + b2);
        }
        return sum;
    }

    public static long plusExact(long a, long b2) {
        long sum = a + b2;
        if (((a ^ sum) & (b2 ^ sum)) < 0L) {
            throw new ArithmeticException("overflow: " + a + "+" + b2);
        }
        return sum;
    }

    public static int plusBounded(int a, int b2) {
        return NumbersUtils.toInt((long)a + (long)b2);
    }

    public static long plusBounded(long a, long b2) {
        long sum = a + b2;
        if (((a ^ sum) & (b2 ^ sum)) < 0L) {
            return sum >= 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return sum;
    }

    public static int minusExact(int a, int b2) {
        int diff = a - b2;
        if (((a ^ b2) & (a ^ diff)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return diff;
    }

    public static long minusExact(long a, long b2) {
        long diff = a - b2;
        if (((a ^ b2) & (a ^ diff)) < 0L) {
            throw new ArithmeticException("integer overflow");
        }
        return diff;
    }

    public static int minusBounded(int a, int b2) {
        return NumbersUtils.toInt((long)a - (long)b2);
    }

    public static long minusBounded(long a, long b2) {
        long diff = a - b2;
        if (((a ^ b2) & (a ^ diff)) < 0L) {
            return diff >= 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return diff;
    }

    public static int timesExact(int a, int b2) {
        long prod = (long)a * (long)b2;
        if (prod != (long)((int)prod)) {
            throw new ArithmeticException("overflow: " + a + "*" + b2);
        }
        return (int)prod;
    }

    public static long timesExact(long a, long b2) {
        long absB;
        long prod = a * b2;
        long absA = NumbersUtils.abs(a);
        if ((absA | (absB = NumbersUtils.abs(b2))) >>> 31 != 0L && (b2 != 0L && prod / b2 != a || a == Long.MIN_VALUE && b2 == -1L)) {
            throw new ArithmeticException("overflow: " + a + "*" + b2);
        }
        return prod;
    }

    public static int timesBounded(int a, int b2) {
        return (int)((double)a * (double)b2);
    }

    public static long timesBounded(long a, long b2) {
        long absB;
        long prod = a * b2;
        long absA = NumbersUtils.abs(a);
        if ((absA | (absB = NumbersUtils.abs(b2))) >>> 31 != 0L && (b2 != 0L && prod / b2 != a || a == Long.MIN_VALUE && b2 == -1L)) {
            return (a ^ b2) >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return prod;
    }

    public static int pow2(int a) {
        return a * a;
    }

    public static long pow2(long a) {
        return a * a;
    }

    public static float pow2(float a) {
        return a * a;
    }

    public static strictfp float pow2_strict(float a) {
        return a * a;
    }

    public static double pow2(double a) {
        return a * a;
    }

    public static strictfp double pow2_strict(double a) {
        return a * a;
    }

    public static int pow3(int a) {
        return a * a * a;
    }

    public static long pow3(long a) {
        return a * a * a;
    }

    public static float pow3(float a) {
        return a * a * a;
    }

    public static strictfp float pow3_strict(float a) {
        return a * a * a;
    }

    public static double pow3(double a) {
        return a * a * a;
    }

    public static strictfp double pow3_strict(double a) {
        return a * a * a;
    }

    public static double plus2PI(double angRad) {
        if (angRad > -Math.PI) {
            return angRad + TWOPI_LO + TWOPI_HI;
        }
        return angRad + TWOPI_HI + TWOPI_LO;
    }

    public static strictfp double plus2PI_strict(double angRad) {
        if (angRad > -Math.PI) {
            return angRad + TWOPI_LO + TWOPI_HI;
        }
        return angRad + TWOPI_HI + TWOPI_LO;
    }

    public static double minus2PI(double angRad) {
        if (angRad < Math.PI) {
            return angRad - TWOPI_LO - TWOPI_HI;
        }
        return angRad - TWOPI_HI - TWOPI_LO;
    }

    public static strictfp double minus2PI_strict(double angRad) {
        if (angRad < Math.PI) {
            return angRad - TWOPI_LO - TWOPI_HI;
        }
        return angRad - TWOPI_HI - TWOPI_LO;
    }

    public static double plusPI(double angRad) {
        if (angRad > -1.5707963267948966) {
            return angRad + PI_LO + PI_HI;
        }
        return angRad + PI_HI + PI_LO;
    }

    public static strictfp double plusPI_strict(double angRad) {
        if (angRad > -1.5707963267948966) {
            return angRad + PI_LO + PI_HI;
        }
        return angRad + PI_HI + PI_LO;
    }

    public static double minusPI(double angRad) {
        if (angRad < 1.5707963267948966) {
            return angRad - PI_LO - PI_HI;
        }
        return angRad - PI_HI - PI_LO;
    }

    public static strictfp double minusPI_strict(double angRad) {
        if (angRad < 1.5707963267948966) {
            return angRad - PI_LO - PI_HI;
        }
        return angRad - PI_HI - PI_LO;
    }

    public static double plusPIO2(double angRad) {
        if (angRad > -0.7853981633974483) {
            return angRad + PIO2_LO + PIO2_HI;
        }
        return angRad + PIO2_HI + PIO2_LO;
    }

    public static strictfp double plusPIO2_strict(double angRad) {
        if (angRad > -0.7853981633974483) {
            return angRad + PIO2_LO + PIO2_HI;
        }
        return angRad + PIO2_HI + PIO2_LO;
    }

    public static double minusPIO2(double angRad) {
        if (angRad < 0.7853981633974483) {
            return angRad - PIO2_LO - PIO2_HI;
        }
        return angRad - PIO2_HI - PIO2_LO;
    }

    public static strictfp double minusPIO2_strict(double angRad) {
        if (angRad < 0.7853981633974483) {
            return angRad - PIO2_LO - PIO2_HI;
        }
        return angRad - PIO2_HI - PIO2_LO;
    }

    public static boolean checkRadix(int radix) {
        if (!NumbersUtils.isInRange(2, 36, radix)) {
            throw new IllegalArgumentException("radix [" + radix + "] must be in [" + 2 + "," + 36 + "]");
        }
        return true;
    }

    public static int computeNbrOfChars(int value2, int radix) {
        if (value2 < 0) {
            return 1 + NumbersUtils.computeNbrOfDigits_negValue(value2, radix);
        }
        return NumbersUtils.computeNbrOfDigits_negValue(-value2, radix);
    }

    public static int computeNbrOfChars(long value2, int radix) {
        if (value2 < 0L) {
            return 1 + NumbersUtils.computeNbrOfDigits_negValue(value2, radix);
        }
        return NumbersUtils.computeNbrOfDigits_negValue(-value2, radix);
    }

    public static int computeNbrOfChars(int value2, int radix, int paddingUpTo) {
        if (value2 < 0) {
            return 1 + Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(value2, radix));
        }
        return Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(-value2, radix));
    }

    public static int computeNbrOfChars(long value2, int radix, int paddingUpTo) {
        if (value2 < 0L) {
            return 1 + Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(value2, radix));
        }
        return Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(-value2, radix));
    }

    public static int computeNbrOfDigits(int value2, int radix) {
        return NumbersUtils.computeNbrOfDigits_negValue(-NumbersUtils.abs(value2), radix);
    }

    public static int computeNbrOfDigits(long value2, int radix) {
        return NumbersUtils.computeNbrOfDigits_negValue(-NumbersUtils.abs(value2), radix);
    }

    public static int computeNbrOfDigits(int value2, int radix, int paddingUpTo) {
        return Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits(value2, radix));
    }

    public static int computeNbrOfDigits(long value2, int radix, int paddingUpTo) {
        return Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits(value2, radix));
    }

    public static String toString(int value2) {
        return Integer.toString(value2);
    }

    public static String toString(long value2) {
        return Long.toString(value2);
    }

    public static String toString(int value2, int radix) {
        return NumbersUtils.toString(value2, radix, 0);
    }

    public static String toString(long value2, int radix) {
        return NumbersUtils.toString(value2, radix, 0);
    }

    /*
     * Unable to fully structure code
     */
    public static String toString(int value, int radix, int paddingUpTo) {
        block7: {
            if (radix + paddingUpTo == 10 && paddingUpTo == 0) {
                return Integer.toString(value);
            }
            v0 = negative = value < 0;
            if (negative) {
                negValue = value;
                signSize = 1;
            } else {
                negValue = -value;
                signSize = 0;
            }
            nbrOfChars = signSize + Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(negValue, radix));
            chars = new char[nbrOfChars];
            charPos = nbrOfChars;
            v1 = radixIsPowerOfTwo = (radix & radix - 1) == 0;
            if (!radixIsPowerOfTwo || negValue == -2147483648) ** GOTO lbl24
            mask = radix - 1;
            divShift = NumbersUtils.DIV_SHIFT_BY_RADIX[radix];
            while (negValue <= -radix) {
                chars[--charPos] = NumbersUtils.CHAR_BY_DIGIT[-negValue & mask];
                negValue = -(-negValue >> divShift);
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                chars[--charPos] = NumbersUtils.CHAR_BY_DIGIT[-(negValue % radix)];
                negValue /= radix;
lbl24:
                // 2 sources

                ** while (negValue <= -radix)
            }
        }
        chars[--charPos] = NumbersUtils.CHAR_BY_DIGIT[-negValue];
        while (charPos > signSize) {
            chars[--charPos] = 48;
        }
        if (negative) {
            chars[0] = 45;
        }
        return new String(chars);
    }

    /*
     * Unable to fully structure code
     */
    public static String toString(long value, int radix, int paddingUpTo) {
        block7: {
            if (radix + paddingUpTo == 10 && paddingUpTo == 0) {
                return Long.toString(value);
            }
            v0 = negative = value < 0L;
            if (negative) {
                negValue = value;
                signSize = 1;
            } else {
                negValue = -value;
                signSize = 0;
            }
            nbrOfChars = signSize + Math.max(paddingUpTo, NumbersUtils.computeNbrOfDigits_negValue(negValue, radix));
            chars = new char[nbrOfChars];
            charPos = nbrOfChars;
            v1 = radixIsPowerOfTwo = (radix & radix - 1) == 0;
            if (!radixIsPowerOfTwo || negValue == -9223372036854775808L) ** GOTO lbl24
            mask = radix - 1;
            divShift = NumbersUtils.DIV_SHIFT_BY_RADIX[radix];
            while (negValue <= (long)(-radix)) {
                chars[--charPos] = NumbersUtils.CHAR_BY_DIGIT[(int)(-negValue & (long)mask)];
                negValue = -(-negValue >> divShift);
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                chars[--charPos] = NumbersUtils.CHAR_BY_DIGIT[(int)(-(negValue % (long)radix))];
                negValue /= (long)radix;
lbl24:
                // 2 sources

                ** while (negValue <= (long)(-radix))
            }
        }
        chars[--charPos] = NumbersUtils.CHAR_BY_DIGIT[(int)(-negValue)];
        while (charPos > signSize) {
            chars[--charPos] = 48;
        }
        if (negative) {
            chars[0] = 45;
        }
        return new String(chars);
    }

    public static boolean checkBitPositionsByte(int firstBitPos, int lastBitPosExcl) {
        return NumbersUtils.checkBitPositions(firstBitPos, lastBitPosExcl, 8);
    }

    public static boolean checkBitPositionsShort(int firstBitPos, int lastBitPosExcl) {
        return NumbersUtils.checkBitPositions(firstBitPos, lastBitPosExcl, 16);
    }

    public static boolean checkBitPositionsInt(int firstBitPos, int lastBitPosExcl) {
        return NumbersUtils.checkBitPositions(firstBitPos, lastBitPosExcl, 32);
    }

    public static boolean checkBitPositionsLong(int firstBitPos, int lastBitPosExcl) {
        return NumbersUtils.checkBitPositions(firstBitPos, lastBitPosExcl, 64);
    }

    public static String toStringBits(byte bits) {
        char[] chars = new char[8];
        int bitIndex = 8;
        while (--bitIndex >= 0) {
            chars[7 - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
        }
        return new String(chars);
    }

    public static String toStringBits(short bits) {
        char[] chars = new char[16];
        int bitIndex = 16;
        while (--bitIndex >= 0) {
            chars[15 - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
        }
        return new String(chars);
    }

    public static String toStringBits(int bits) {
        char[] chars = new char[32];
        int bitIndex = 32;
        while (--bitIndex >= 0) {
            chars[31 - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
        }
        return new String(chars);
    }

    public static String toStringBits(long bits) {
        char[] chars = new char[64];
        int bitIndex = 64;
        while (--bitIndex >= 0) {
            chars[63 - bitIndex] = (char)(48L + (bits >> bitIndex & 1L));
        }
        return new String(chars);
    }

    public static String toStringBits(byte bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        NumbersUtils.checkBitPositionsByte(firstBitPos, lastBitPosExcl);
        return NumbersUtils.toStringBits_0_32_bitPosAlreadyChecked(8, bits, firstBitPos, lastBitPosExcl, bigEndian, padding);
    }

    public static String toStringBits(short bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        NumbersUtils.checkBitPositionsShort(firstBitPos, lastBitPosExcl);
        return NumbersUtils.toStringBits_0_32_bitPosAlreadyChecked(16, bits, firstBitPos, lastBitPosExcl, bigEndian, padding);
    }

    public static String toStringBits(int bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        NumbersUtils.checkBitPositionsInt(firstBitPos, lastBitPosExcl);
        return NumbersUtils.toStringBits_0_32_bitPosAlreadyChecked(32, bits, firstBitPos, lastBitPosExcl, bigEndian, padding);
    }

    /*
     * Unable to fully structure code
     */
    public static String toStringBits(long bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        block10: {
            block11: {
                NumbersUtils.checkBitPositionsLong(firstBitPos, lastBitPosExcl);
                bitSize = 64;
                bitSizeM1 = 63;
                lastBitPos = lastBitPosExcl - 1;
                if (!padding) break block10;
                nbrOfChars = 64;
                chars = new char[64];
                bitIndex = 63;
                if (!bigEndian) ** GOTO lbl28
                firstBitIndex = 63 - lastBitPos;
                lastBitIndex = 63 - firstBitPos;
                while (bitIndex > lastBitIndex) {
                    chars[63 - bitIndex] = 95;
                    --bitIndex;
                }
                while (bitIndex >= firstBitIndex) {
                    chars[63 - bitIndex] = (char)(48L + (bits >> bitIndex & 1L));
                    --bitIndex;
                }
                while (bitIndex >= 0) {
                    chars[63 - bitIndex] = 95;
                    --bitIndex;
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    chars[bitIndex] = 95;
                    --bitIndex;
lbl28:
                    // 2 sources

                    ** while (bitIndex > lastBitPos)
                }
lbl29:
                // 2 sources

                while (bitIndex >= firstBitPos) {
                    chars[bitIndex] = (char)(48L + (bits >> bitIndex & 1L));
                    --bitIndex;
                }
                while (bitIndex >= 0) {
                    chars[bitIndex] = 95;
                    --bitIndex;
                }
            }
            return new String(chars);
        }
        nbrOfChars = lastBitPosExcl - firstBitPos;
        chars = new char[nbrOfChars];
        if (bigEndian) {
            firstBitIndex = 63 - lastBitPos;
            bitIndex = lastBitIndex = 63 - firstBitPos;
            while (bitIndex >= firstBitIndex) {
                chars[lastBitIndex - bitIndex] = (char)(48L + (bits >> bitIndex & 1L));
                --bitIndex;
            }
        } else {
            bitIndex = lastBitPos;
            while (bitIndex >= firstBitPos) {
                chars[bitIndex - firstBitPos] = (char)(48L + (bits >> bitIndex & 1L));
                --bitIndex;
            }
        }
        return new String(chars);
    }

    public static String toStringCSN(double value2) {
        if (value2 == 0.0) {
            if (Double.doubleToRawLongBits(value2) < 0L) {
                return "-0.0E0";
            }
            return "0.0E0";
        }
        double abs = Math.abs(value2);
        if (abs >= 0.001 && abs < 1.0E7) {
            boolean neg = value2 < 0.0;
            String rawAbs = Double.toString(abs);
            if (abs >= 1.0) {
                int dotIndex = rawAbs.indexOf(46);
                int powerOfTen = dotIndex - 1;
                StringBuilder sb = new StringBuilder();
                if (neg) {
                    sb.append('-');
                }
                sb.append(rawAbs.charAt(0));
                sb.append('.');
                sb.append(rawAbs, 1, dotIndex);
                if (value2 != (double)((int)value2) || abs < 10.0) {
                    sb.append(rawAbs, dotIndex + 1, rawAbs.length());
                }
                sb.append('E');
                sb.append(CHAR_BY_DIGIT[powerOfTen]);
                return sb.toString();
            }
            int nonZeroIndex = 1;
            while (rawAbs.charAt(++nonZeroIndex) == '0') {
            }
            int powerOfTen = 1 - nonZeroIndex;
            int nbrOfSignificantDigitsPastDot = rawAbs.length() - (nonZeroIndex + 1);
            StringBuilder sb = new StringBuilder();
            if (neg) {
                sb.append('-');
            }
            sb.append(rawAbs.charAt(nonZeroIndex));
            sb.append('.');
            if (nbrOfSignificantDigitsPastDot > 0) {
                sb.append(rawAbs, nonZeroIndex + 1, rawAbs.length());
            } else {
                sb.append('0');
            }
            sb.append("E-");
            sb.append(CHAR_BY_DIGIT[-powerOfTen]);
            return sb.toString();
        }
        return Double.toString(value2);
    }

    public static String toStringNoCSN(double value2) {
        int intValue = (int)value2;
        if (value2 == (double)intValue) {
            if (value2 == 0.0) {
                if (Double.doubleToRawLongBits(value2) < 0L) {
                    return "-0.0";
                }
                return "0.0";
            }
            return String.valueOf(Integer.toString(intValue)) + ".0";
        }
        String raw = Double.toString(value2);
        double abs = Math.abs(value2);
        if (abs >= 1.0E7) {
            if (abs == Double.POSITIVE_INFINITY) {
                return raw;
            }
            int dotIndex = raw.indexOf(46);
            int eIndex = raw.lastIndexOf(69);
            int powerOfTen = Integer.parseInt(raw.substring(eIndex + 1));
            int nbrOfSignificantLoDigits = eIndex - dotIndex - 1;
            int nbrOfZerosToAddBeforeDot = powerOfTen - nbrOfSignificantLoDigits;
            StringBuilder sb = new StringBuilder();
            sb.append(raw, 0, dotIndex);
            if (nbrOfZerosToAddBeforeDot >= 0) {
                sb.append(raw, dotIndex + 1, eIndex);
                int i2 = 0;
                while (i2 < nbrOfZerosToAddBeforeDot) {
                    sb.append('0');
                    ++i2;
                }
                sb.append(".0");
            } else {
                int start2 = dotIndex + 1;
                int end2 = start2 + powerOfTen;
                sb.append(raw, start2, end2);
                sb.append('.');
                start2 = end2;
                end2 = eIndex;
                sb.append(raw, start2, end2);
            }
            return sb.toString();
        }
        if (abs < 0.001) {
            int dotIndex = raw.indexOf(46);
            int eIndex = raw.lastIndexOf(69);
            int powerOfTen = Integer.parseInt(raw.substring(eIndex + 1));
            int nbrOfZerosToAddAfterDot = -powerOfTen - 1;
            StringBuilder sb = new StringBuilder();
            if (value2 < 0.0) {
                sb.append("-0.");
            } else {
                sb.append("0.");
            }
            int i3 = 0;
            while (i3 < nbrOfZerosToAddAfterDot) {
                sb.append('0');
                ++i3;
            }
            sb.append(raw, dotIndex - 1, dotIndex);
            if (eIndex != dotIndex + 2 || raw.charAt(dotIndex + 1) != '0') {
                sb.append(raw, dotIndex + 1, eIndex);
            }
            return sb.toString();
        }
        if (abs < 1.0 && raw.charAt(raw.length() - 1) == '0') {
            return raw.substring(0, raw.length() - 1);
        }
        return raw;
    }

    private NumbersUtils() {
    }

    private static boolean dontUseMe_isInNonEmptyRange_(int min, int max, int a) {
        return Integer.MIN_VALUE + (a - min) <= Integer.MIN_VALUE + (max - min);
    }

    private static int minSignedIntForBitSize_noCheck(int bitSize) {
        return Integer.MIN_VALUE >> 32 - bitSize;
    }

    private static long minSignedLongForBitSize_noCheck(int bitSize) {
        return Long.MIN_VALUE >> 64 - bitSize;
    }

    private static int maxSignedIntForBitSize_noCheck(int bitSize) {
        return Integer.MAX_VALUE >> 32 - bitSize;
    }

    private static long maxSignedLongForBitSize_noCheck(int bitSize) {
        return Long.MAX_VALUE >> 64 - bitSize;
    }

    private static int computeNbrOfDigits_negValue(int negValue, int radix) {
        NumbersUtils.checkRadix(radix);
        int maxNbrOfDigits = MAX_NBR_OF_NEG_INT_DIGITS_BY_RADIX[radix];
        int p = radix;
        int i2 = 1;
        while (i2 < maxNbrOfDigits) {
            if (negValue > -p) {
                return i2;
            }
            p *= radix;
            ++i2;
        }
        return maxNbrOfDigits;
    }

    private static int computeNbrOfDigits_negValue(long negValue, int radix) {
        NumbersUtils.checkRadix(radix);
        int maxNbrOfDigits = MAX_NBR_OF_NEG_LONG_DIGITS_BY_RADIX[radix];
        long p = radix;
        int i2 = 1;
        while (i2 < maxNbrOfDigits) {
            if (negValue > -p) {
                return i2;
            }
            p *= (long)radix;
            ++i2;
        }
        return maxNbrOfDigits;
    }

    private static boolean checkBitPositions(int firstBitPos, int lastBitPosExcl, int bitSize) {
        if (firstBitPos < 0 || firstBitPos > lastBitPosExcl || lastBitPosExcl > bitSize) {
            throw new IllegalArgumentException("bit positions (first=" + firstBitPos + ",lastExcl=" + lastBitPosExcl + ") must verify 0 <= first <= lastExcl <= " + bitSize);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static String toStringBits_0_32_bitPosAlreadyChecked(int bitSize, int bits, int firstBitPos, int lastBitPosExcl, boolean bigEndian, boolean padding) {
        block10: {
            block11: {
                bitSizeM1 = bitSize - 1;
                lastBitPos = lastBitPosExcl - 1;
                if (!padding) break block10;
                nbrOfChars = bitSize;
                chars = new char[nbrOfChars];
                bitIndex = bitSizeM1;
                if (!bigEndian) ** GOTO lbl25
                firstBitIndex = bitSizeM1 - lastBitPos;
                lastBitIndex = bitSizeM1 - firstBitPos;
                while (bitIndex > lastBitIndex) {
                    chars[bitSizeM1 - bitIndex] = 95;
                    --bitIndex;
                }
                while (bitIndex >= firstBitIndex) {
                    chars[bitSizeM1 - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
                    --bitIndex;
                }
                while (bitIndex >= 0) {
                    chars[bitSizeM1 - bitIndex] = 95;
                    --bitIndex;
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    chars[bitIndex] = 95;
                    --bitIndex;
lbl25:
                    // 2 sources

                    ** while (bitIndex > lastBitPos)
                }
lbl26:
                // 2 sources

                while (bitIndex >= firstBitPos) {
                    chars[bitIndex] = (char)(48 + (bits >> bitIndex & 1));
                    --bitIndex;
                }
                while (bitIndex >= 0) {
                    chars[bitIndex] = 95;
                    --bitIndex;
                }
            }
            return new String(chars);
        }
        nbrOfChars = lastBitPosExcl - firstBitPos;
        chars = new char[nbrOfChars];
        if (bigEndian) {
            firstBitIndex = bitSizeM1 - lastBitPos;
            bitIndex = lastBitIndex = bitSizeM1 - firstBitPos;
            while (bitIndex >= firstBitIndex) {
                chars[lastBitIndex - bitIndex] = (char)(48 + (bits >> bitIndex & 1));
                --bitIndex;
            }
        } else {
            bitIndex = lastBitPos;
            while (bitIndex >= firstBitPos) {
                chars[bitIndex - firstBitPos] = (char)(48 + (bits >> bitIndex & 1));
                --bitIndex;
            }
        }
        return new String(chars);
    }
}

