/*
 * Decompiled with CFR 0.152.
 */
package net.jafama;

import net.jafama.AbstractFastMath;
import net.jafama.DoubleWrapper;
import net.jafama.IntWrapper;
import net.jafama.NumbersUtils;

public strictfp final class StrictFastMath
extends AbstractFastMath {
    private static final boolean USE_JDK_MATH = SFM_USE_JDK_MATH;
    private static final boolean USE_REDEFINED_LOG = SFM_USE_REDEFINED_LOG;
    private static final boolean USE_REDEFINED_SQRT = SFM_USE_REDEFINED_SQRT;
    private static final boolean USE_POWTABS_FOR_ASIN = false;
    public static final double E = Math.E;
    public static final double PI = Math.PI;

    public static double sin(double angle) {
        if (USE_JDK_MATH) {
            return StrictMath.sin(angle);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (angle > SIN_COS_MAX_VALUE_FOR_INT_MODULO) {
            long remAndQuad = StrictFastMath.remainderPiO2(angle);
            angle = StrictFastMath.decodeRemainder(remAndQuad);
            int q = StrictFastMath.decodeQuadrant(remAndQuad);
            double sin = q == 0 ? StrictFastMath.sin(angle) : (q == 1 ? StrictFastMath.cos(angle) : (q == 2 ? -StrictFastMath.sin(angle) : -StrictFastMath.cos(angle)));
            return negateResult ? -sin : sin;
        }
        int index2 = (int)(angle * SIN_COS_INDEXER + 0.5);
        double delta = angle - (double)index2 * SIN_COS_DELTA_HI - (double)index2 * SIN_COS_DELTA_LO;
        double indexSin = sinTab[index2 &= SIN_COS_TABS_SIZE - 2];
        double indexCos = cosTab[index2];
        double result2 = indexSin + delta * (indexCos + delta * (-indexSin * 0.5 + delta * (-indexCos * 0.16666666666666666 + delta * indexSin * 0.041666666666666664)));
        return negateResult ? -result2 : result2;
    }

    public static double sinQuick(double angle) {
        if (USE_JDK_MATH) {
            return StrictMath.sin(angle);
        }
        return cosTab[(int)(Math.abs(angle - 1.5707963267948966) * SIN_COS_INDEXER + 0.5) & SIN_COS_TABS_SIZE - 2];
    }

    public static double cos(double angle) {
        if (USE_JDK_MATH) {
            return StrictMath.cos(angle);
        }
        if ((angle = Math.abs(angle)) > SIN_COS_MAX_VALUE_FOR_INT_MODULO) {
            long remAndQuad = StrictFastMath.remainderPiO2(angle);
            angle = StrictFastMath.decodeRemainder(remAndQuad);
            int q = StrictFastMath.decodeQuadrant(remAndQuad);
            double cos = q == 0 ? StrictFastMath.cos(angle) : (q == 1 ? -StrictFastMath.sin(angle) : (q == 2 ? -StrictFastMath.cos(angle) : StrictFastMath.sin(angle)));
            return cos;
        }
        int index2 = (int)(angle * SIN_COS_INDEXER + 0.5);
        double delta = angle - (double)index2 * SIN_COS_DELTA_HI - (double)index2 * SIN_COS_DELTA_LO;
        double indexCos = cosTab[index2 &= SIN_COS_TABS_SIZE - 2];
        double indexSin = sinTab[index2];
        return indexCos + delta * (-indexSin + delta * (-indexCos * 0.5 + delta * (indexSin * 0.16666666666666666 + delta * indexCos * 0.041666666666666664)));
    }

    public static double cosQuick(double angle) {
        if (USE_JDK_MATH) {
            return StrictMath.cos(angle);
        }
        return cosTab[(int)(Math.abs(angle) * SIN_COS_INDEXER + 0.5) & SIN_COS_TABS_SIZE - 2];
    }

    public static double sinAndCos(double angle, DoubleWrapper cosine) {
        if (USE_JDK_MATH) {
            cosine.value = StrictMath.cos(angle);
            return StrictMath.sin(angle);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (angle > SIN_COS_MAX_VALUE_FOR_INT_MODULO) {
            double sin;
            long remAndQuad = StrictFastMath.remainderPiO2(angle);
            angle = StrictFastMath.decodeRemainder(remAndQuad);
            int q = StrictFastMath.decodeQuadrant(remAndQuad);
            if (q == 0) {
                sin = StrictFastMath.sin(angle);
                cosine.value = StrictFastMath.cos(angle);
            } else if (q == 1) {
                sin = StrictFastMath.cos(angle);
                cosine.value = -StrictFastMath.sin(angle);
            } else if (q == 2) {
                sin = -StrictFastMath.sin(angle);
                cosine.value = -StrictFastMath.cos(angle);
            } else {
                sin = -StrictFastMath.cos(angle);
                cosine.value = StrictFastMath.sin(angle);
            }
            return negateResult ? -sin : sin;
        }
        int index2 = (int)(angle * SIN_COS_INDEXER + 0.5);
        double delta = angle - (double)index2 * SIN_COS_DELTA_HI - (double)index2 * SIN_COS_DELTA_LO;
        double indexSin = sinTab[index2 &= SIN_COS_TABS_SIZE - 2];
        double indexCos = cosTab[index2];
        cosine.value = indexCos + delta * (-indexSin + delta * (-indexCos * 0.5 + delta * (indexSin * 0.16666666666666666 + delta * indexCos * 0.041666666666666664)));
        double result2 = indexSin + delta * (indexCos + delta * (-indexSin * 0.5 + delta * (-indexCos * 0.16666666666666666 + delta * indexSin * 0.041666666666666664)));
        return negateResult ? -result2 : result2;
    }

    public static double tan(double angle) {
        double result2;
        if (USE_JDK_MATH) {
            return StrictMath.tan(angle);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (angle > TAN_MAX_VALUE_FOR_INT_MODULO && (angle = StrictFastMath.remainderPi(angle)) < 0.0) {
            angle = -angle;
            negateResult = !negateResult;
        }
        int index2 = (int)(angle * TAN_INDEXER + 0.5);
        double delta = angle - (double)index2 * TAN_DELTA_HI - (double)index2 * TAN_DELTA_LO;
        if ((index2 &= 2 * (TAN_VIRTUAL_TABS_SIZE - 1) - 1) > TAN_VIRTUAL_TABS_SIZE - 1) {
            index2 = 2 * (TAN_VIRTUAL_TABS_SIZE - 1) - index2;
            delta = -delta;
            boolean bl = negateResult = !negateResult;
        }
        if (index2 < TAN_TABS_SIZE) {
            result2 = tanTab[index2] + delta * (tanDer1DivF1Tab[index2] + delta * (tanDer2DivF2Tab[index2] + delta * (tanDer3DivF3Tab[index2] + delta * tanDer4DivF4Tab[index2])));
        } else {
            index2 = TAN_VIRTUAL_TABS_SIZE - 1 - index2;
            result2 = 1.0 / (tanTab[index2] - delta * (tanDer1DivF1Tab[index2] - delta * (tanDer2DivF2Tab[index2] - delta * (tanDer3DivF3Tab[index2] - delta * tanDer4DivF4Tab[index2]))));
        }
        return negateResult ? -result2 : result2;
    }

    public static double asin(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.asin(value2);
        }
        boolean negateResult = false;
        if (value2 < 0.0) {
            value2 = -value2;
            negateResult = true;
        }
        if (value2 <= ASIN_MAX_VALUE_FOR_TABS) {
            int index2 = (int)(value2 * ASIN_INDEXER + 0.5);
            double delta = value2 - (double)index2 * ASIN_DELTA;
            double result2 = asinTab[index2] + delta * (asinDer1DivF1Tab[index2] + delta * (asinDer2DivF2Tab[index2] + delta * (asinDer3DivF3Tab[index2] + delta * asinDer4DivF4Tab[index2])));
            return negateResult ? -result2 : result2;
        }
        if (value2 < 1.0) {
            double t2 = (1.0 - value2) * 0.5;
            double p = t2 * (ASIN_PS0 + t2 * (ASIN_PS1 + t2 * (ASIN_PS2 + t2 * (ASIN_PS3 + t2 * (ASIN_PS4 + t2 * ASIN_PS5)))));
            double q = 1.0 + t2 * (ASIN_QS1 + t2 * (ASIN_QS2 + t2 * (ASIN_QS3 + t2 * ASIN_QS4)));
            double s2 = StrictFastMath.sqrt(t2);
            double z = s2 + s2 * (p / q);
            double result3 = ASIN_PIO2_HI - (z + z - ASIN_PIO2_LO);
            return negateResult ? -result3 : result3;
        }
        if (value2 == 1.0) {
            return negateResult ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Double.NaN;
    }

    public static double asinInRange(double value2) {
        if (value2 <= -1.0) {
            return -1.5707963267948966;
        }
        if (value2 >= 1.0) {
            return 1.5707963267948966;
        }
        return StrictFastMath.asin(value2);
    }

    public static double acos(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.acos(value2);
        }
        return 1.5707963267948966 - StrictFastMath.asin(value2);
    }

    public static double acosInRange(double value2) {
        if (value2 <= -1.0) {
            return Math.PI;
        }
        if (value2 >= 1.0) {
            return 0.0;
        }
        return StrictFastMath.acos(value2);
    }

    public static double atan(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.atan(value2);
        }
        boolean negateResult = false;
        if (value2 < 0.0) {
            value2 = -value2;
            negateResult = true;
        }
        if (value2 == 1.0) {
            return negateResult ? -0.7853981633974483 : 0.7853981633974483;
        }
        if (value2 <= ATAN_MAX_VALUE_FOR_TABS) {
            int index2 = (int)(value2 * ATAN_INDEXER + 0.5);
            double delta = value2 - (double)index2 * ATAN_DELTA;
            double result2 = atanTab[index2] + delta * (atanDer1DivF1Tab[index2] + delta * (atanDer2DivF2Tab[index2] + delta * (atanDer3DivF3Tab[index2] + delta * atanDer4DivF4Tab[index2])));
            return negateResult ? -result2 : result2;
        }
        if (value2 < TWO_POW_66) {
            double x = -1.0 / value2;
            double x2 = x * x;
            double x4 = x2 * x2;
            double s1 = x2 * (ATAN_AT0 + x4 * (ATAN_AT2 + x4 * (ATAN_AT4 + x4 * (ATAN_AT6 + x4 * (ATAN_AT8 + x4 * ATAN_AT10)))));
            double s2 = x4 * (ATAN_AT1 + x4 * (ATAN_AT3 + x4 * (ATAN_AT5 + x4 * (ATAN_AT7 + x4 * ATAN_AT9))));
            double result3 = ATAN_HI3 - (x * (s1 + s2) - ATAN_LO3 - x);
            return negateResult ? -result3 : result3;
        }
        if (value2 != value2) {
            return Double.NaN;
        }
        return negateResult ? -1.5707963267948966 : 1.5707963267948966;
    }

    public static double atan2(double y, double x) {
        if (USE_JDK_MATH) {
            return StrictMath.atan2(y, x);
        }
        if (x > 0.0) {
            if (y == 0.0) {
                return y;
            }
            if (x == Double.POSITIVE_INFINITY) {
                return StrictFastMath.atan2_pinf_yyy(y);
            }
            return StrictFastMath.atan(y / x);
        }
        if (x < 0.0) {
            if (y == 0.0) {
                return (double)StrictFastMath.signFromBit(y) * Math.PI;
            }
            if (x == Double.NEGATIVE_INFINITY) {
                return StrictFastMath.atan2_ninf_yyy(y);
            }
            if (y > 0.0) {
                return 1.5707963267948966 - StrictFastMath.atan(x / y);
            }
            if (y < 0.0) {
                return -1.5707963267948966 - StrictFastMath.atan(x / y);
            }
            return Double.NaN;
        }
        return StrictFastMath.atan2_yyy_zeroOrNaN(y, x);
    }

    public static double toRadians(double angdeg) {
        if (USE_JDK_MATH) {
            return StrictMath.toRadians(angdeg);
        }
        return angdeg * (Math.PI / 180);
    }

    public static double toDegrees(double angrad) {
        if (USE_JDK_MATH) {
            return StrictMath.toDegrees(angrad);
        }
        return angrad * 57.29577951308232;
    }

    public static double toRadians(boolean sign, int degrees, int minutes, double seconds2) {
        return StrictFastMath.toRadians(StrictFastMath.toDegrees(sign, degrees, minutes, seconds2));
    }

    public static double toDegrees(boolean sign, int degrees, int minutes, double seconds2) {
        double signFactor = sign ? 1.0 : -1.0;
        return signFactor * ((double)degrees + 0.016666666666666666 * ((double)minutes + 0.016666666666666666 * seconds2));
    }

    public static boolean toDMS(double angrad, IntWrapper degrees, IntWrapper minutes, DoubleWrapper seconds2) {
        boolean isNeg;
        double tmp = StrictFastMath.toDegrees(StrictFastMath.normalizeMinusPiPi(angrad));
        boolean bl = isNeg = tmp < 0.0;
        if (isNeg) {
            tmp = -tmp;
        }
        degrees.value = (int)tmp;
        tmp = (tmp - (double)degrees.value) * 60.0;
        minutes.value = (int)tmp;
        seconds2.value = Math.min((tmp - (double)minutes.value) * 60.0, DOUBLE_BEFORE_60);
        return !isNeg;
    }

    public static boolean isInClockwiseDomain(double startAngRad, double angSpanRad, double angRad) {
        if (Math.abs(angRad) < 2.4492935982947064E-16) {
            if (angSpanRad <= Math.PI * 2) {
                double endAngRad;
                if (angSpanRad < 0.0) {
                    return false;
                }
                if ((startAngRad = StrictFastMath.normalizeMinusPiPi(startAngRad)) <= (endAngRad = StrictFastMath.normalizeMinusPiPi(startAngRad + angSpanRad))) {
                    return angRad >= startAngRad && angRad <= endAngRad;
                }
                return angRad >= startAngRad || angRad <= endAngRad;
            }
            return angSpanRad == angSpanRad;
        }
        return StrictFastMath.normalizeZeroTwoPi(angRad - startAngRad) <= angSpanRad;
    }

    public static double sinh(double value2) {
        double h;
        if (USE_JDK_MATH) {
            return StrictMath.sinh(value2);
        }
        if (value2 < 0.0) {
            value2 = -value2;
            h = -0.5;
        } else {
            h = 0.5;
        }
        if (value2 < 22.0) {
            if (value2 < TWO_POW_N28) {
                return h < 0.0 ? -value2 : value2;
            }
            double t2 = StrictFastMath.expm1(value2);
            return h * (t2 + t2 / (t2 + 1.0));
        }
        if (value2 < LOG_DOUBLE_MAX_VALUE) {
            return h * StrictFastMath.exp(value2);
        }
        double t3 = StrictFastMath.exp(value2 * 0.5);
        return h * t3 * t3;
    }

    public static double cosh(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.cosh(value2);
        }
        if (value2 < 0.0) {
            value2 = -value2;
        }
        if (value2 < LOG_TWO_POW_27) {
            if (value2 < TWO_POW_N27) {
                return 1.0;
            }
            double t2 = StrictFastMath.exp(value2);
            return 0.5 * (t2 + 1.0 / t2);
        }
        if (value2 < LOG_DOUBLE_MAX_VALUE) {
            return 0.5 * StrictFastMath.exp(value2);
        }
        double t3 = StrictFastMath.exp(value2 * 0.5);
        return 0.5 * t3 * t3;
    }

    public static double coshm1(double value2) {
        if (value2 < 0.0) {
            value2 = -value2;
        }
        if (value2 < LOG_TWO_POW_27) {
            if (value2 < TWO_POW_N27) {
                if (value2 == 0.0) {
                    return value2;
                }
                return 0.5 * value2 * value2;
            }
            return 0.5 * (StrictFastMath.expm1(value2) + StrictFastMath.expm1(-value2));
        }
        if (value2 < LOG_DOUBLE_MAX_VALUE) {
            return 0.5 * StrictFastMath.exp(value2) - 1.0;
        }
        double t2 = StrictFastMath.exp(value2 * 0.5);
        return 0.5 * t2 * t2;
    }

    public static double sinhAndCosh(double value2, DoubleWrapper hcosine) {
        double hsine;
        double h;
        if (USE_JDK_MATH) {
            hcosine.value = StrictMath.cosh(value2);
            return StrictMath.sinh(value2);
        }
        if (value2 < 0.0) {
            value2 = -value2;
            h = -0.5;
        } else {
            h = 0.5;
        }
        if (value2 < LOG_TWO_POW_27) {
            double t2;
            if (value2 < TWO_POW_N28) {
                hsine = h < 0.0 ? -value2 : value2;
            } else {
                t2 = StrictFastMath.expm1(value2);
                hsine = h * (t2 + t2 / (t2 + 1.0));
            }
            if (value2 < TWO_POW_N27) {
                hcosine.value = 1.0;
            } else {
                t2 = StrictFastMath.exp(value2);
                hcosine.value = 0.5 * (t2 + 1.0 / t2);
            }
        } else if (value2 < 22.0) {
            double t3 = StrictFastMath.expm1(value2);
            hsine = h * (t3 + t3 / (t3 + 1.0));
            hcosine.value = 0.5 * (t3 + 1.0);
        } else {
            if (value2 < LOG_DOUBLE_MAX_VALUE) {
                hsine = h * StrictFastMath.exp(value2);
            } else {
                double t4 = StrictFastMath.exp(value2 * 0.5);
                hsine = h * t4 * t4;
            }
            hcosine.value = Math.abs(hsine);
        }
        return hsine;
    }

    public static double tanh(double value2) {
        double z;
        if (USE_JDK_MATH) {
            return StrictMath.tanh(value2);
        }
        boolean negateResult = false;
        if (value2 < 0.0) {
            value2 = -value2;
            negateResult = true;
        }
        if (value2 < 19.061547465398498) {
            if (value2 < TWO_POW_N55) {
                return negateResult ? -value2 * (1.0 - value2) : value2 * (1.0 + value2);
            }
            if (value2 >= 1.0) {
                z = 1.0 - 2.0 / (StrictFastMath.expm1(value2 + value2) + 2.0);
            } else {
                double t2 = StrictFastMath.expm1(-(value2 + value2));
                z = -t2 / (t2 + 2.0);
            }
        } else {
            z = value2 != value2 ? Double.NaN : 1.0;
        }
        return negateResult ? -z : z;
    }

    public static double asinh(double value2) {
        double result2;
        boolean negateResult = false;
        if (value2 < 0.0) {
            value2 = -value2;
            negateResult = true;
        }
        if (value2 < 0.04) {
            double x = value2;
            double x2 = x * x;
            double argLog1p = x * (1.0 + 0.5 * x * (1.0 + -0.25 * x2 * (1.0 + -0.5 * x2 * (1.0 + -0.625 * x2 * (1.0 + -0.7 * x2)))));
            result2 = StrictFastMath.log1p(argLog1p);
        } else {
            result2 = value2 < 1.6777216E7 ? StrictFastMath.log(value2 + StrictFastMath.sqrt(value2 * value2 + 1.0)) : LOG_2 + StrictFastMath.log(value2);
        }
        return negateResult ? -result2 : result2;
    }

    public static double acosh(double value2) {
        if (!(value2 > 1.0)) {
            return value2 < 1.0 ? Double.NaN : value2 - 1.0;
        }
        double result2 = value2 < 1.6777216E7 ? StrictFastMath.log(value2 + StrictFastMath.sqrt(value2 * value2 - 1.0)) : LOG_2 + StrictFastMath.log(value2);
        return result2;
    }

    public static double acosh1p(double value2) {
        if (!(value2 > 0.0)) {
            return value2 < 0.0 ? Double.NaN : value2;
        }
        double result2 = value2 < 1.6777215E7 ? StrictFastMath.log1p(value2 + StrictFastMath.sqrt(value2 * (2.0 + value2))) : LOG_2 + StrictFastMath.log(1.0 + value2);
        return result2;
    }

    public static double atanh(double value2) {
        boolean negateResult = false;
        if (value2 < 0.0) {
            value2 = -value2;
            negateResult = true;
        }
        double result2 = !(value2 < 1.0) ? (value2 > 1.0 ? Double.NaN : Double.POSITIVE_INFINITY + value2) : 0.5 * StrictFastMath.log1p((value2 + value2) / (1.0 - value2));
        return negateResult ? -result2 : result2;
    }

    public static double exp(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.exp(value2);
        }
        if (value2 > EXP_OVERFLOW_LIMIT) {
            return Double.POSITIVE_INFINITY;
        }
        if (!(value2 >= EXP_UNDERFLOW_LIMIT)) {
            return value2 != value2 ? Double.NaN : 0.0;
        }
        int indexes = (int)(value2 * (double)EXP_LO_INDEXING);
        int valueInt = indexes >= 0 ? indexes >> EXP_LO_INDEXING_DIV_SHIFT : -(-indexes >> EXP_LO_INDEXING_DIV_SHIFT);
        double hiTerm = expHiTab[valueInt - (int)EXP_UNDERFLOW_LIMIT];
        int zIndex = indexes - (valueInt << EXP_LO_INDEXING_DIV_SHIFT);
        double y = value2 - (double)valueInt;
        double z = (double)zIndex * (1.0 / (double)EXP_LO_INDEXING);
        double eps = y - z;
        double expZ = expLoPosTab[zIndex + EXP_LO_TAB_MID_INDEX];
        double expEps = 1.0 + eps * (1.0 + eps * (0.5 + eps * (0.16666666666666666 + eps * 0.041666666666666664)));
        double loTerm = expZ * expEps;
        return hiTerm * loTerm;
    }

    public static double expQuick(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.exp(value2);
        }
        return Double.longBitsToDouble((long)((int)(1512775.3952 * value2 + 1.0726481222E9)) << 32);
    }

    public static double expm1(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.expm1(value2);
        }
        if (Math.abs(value2) < 1.0) {
            int i2 = (int)(value2 * (double)EXP_LO_INDEXING);
            double delta = value2 - (double)i2 * (1.0 / (double)EXP_LO_INDEXING);
            return expLoPosTab[i2 + EXP_LO_TAB_MID_INDEX] * (expLoNegTab[i2 + EXP_LO_TAB_MID_INDEX] + delta * (1.0 + delta * (0.5 + delta * (0.16666666666666666 + delta * (0.041666666666666664 + delta * 0.008333333333333333)))));
        }
        return StrictFastMath.exp(value2) - 1.0;
    }

    public static double log(double value2) {
        if (USE_JDK_MATH || !USE_REDEFINED_LOG) {
            return StrictMath.log(value2);
        }
        if (value2 > 0.0) {
            double h;
            if (value2 == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            if (value2 > 0.95) {
                if (value2 < 1.14) {
                    double z = (value2 - 1.0) / (value2 + 1.0);
                    double z2 = z * z;
                    return z * (2.0 + z2 * (0.6666666666666666 + z2 * (0.4 + z2 * (0.2857142857142857 + z2 * (0.2222222222222222 + z2 * 0.18181818181818182)))));
                }
                h = 0.0;
            } else if (value2 < DOUBLE_MIN_NORMAL) {
                value2 *= TWO_POW_52;
                h = -52.0 * LOG_2;
            } else {
                h = 0.0;
            }
            int valueBitsHi = (int)(Double.doubleToRawLongBits(value2) >> 32);
            int valueExp = (valueBitsHi >> 20) - 1023;
            int xIndex = valueBitsHi << 12 >>> 32 - LOG_BITS;
            double z = value2 * StrictFastMath.twoPowNormalOrSubnormal(-valueExp) * logXInvTab[xIndex] - 1.0;
            z *= 1.0 - z * (0.5 - z * 0.3333333333333333);
            return h + (double)valueExp * LOG_2 + (logXLogTab[xIndex] + z);
        }
        if (value2 == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.NaN;
    }

    public static double logQuick(double value2) {
        double h;
        if (USE_JDK_MATH) {
            return StrictMath.log(value2);
        }
        if (value2 > 0.87) {
            if (value2 < 1.16) {
                return 2.0 * (value2 - 1.0) / (value2 + 1.0);
            }
            h = 0.0;
        } else if (value2 < DOUBLE_MIN_NORMAL) {
            value2 *= TWO_POW_52;
            h = -52.0 * LOG_2;
        } else {
            h = 0.0;
        }
        int valueBitsHi = (int)(Double.doubleToRawLongBits(value2) >> 32);
        int valueExp = (valueBitsHi >> 20) - 1023;
        int xIndex = valueBitsHi << 12 >>> 32 - LOG_BITS;
        return h + (double)valueExp * LOG_2 + logXLogTab[xIndex];
    }

    public static double log10(double value2) {
        if (USE_JDK_MATH || !USE_REDEFINED_LOG) {
            return StrictMath.log10(value2);
        }
        return StrictFastMath.log(value2) * INV_LOG_10;
    }

    public static double log1p(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.log1p(value2);
        }
        if (value2 > -1.0) {
            if (value2 == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            double valuePlusOne = 1.0 + value2;
            if (valuePlusOne == 1.0) {
                return value2;
            }
            if (Math.abs(value2) < 0.15) {
                double z = value2 / (value2 + 2.0);
                double z2 = z * z;
                return z * (2.0 + z2 * (0.6666666666666666 + z2 * (0.4 + z2 * (0.2857142857142857 + z2 * (0.2222222222222222 + z2 * 0.18181818181818182)))));
            }
            int valuePlusOneBitsHi = (int)(Double.doubleToRawLongBits(valuePlusOne) >> 32) & Integer.MAX_VALUE;
            int valuePlusOneExp = (valuePlusOneBitsHi >> 20) - 1023;
            int xIndex = valuePlusOneBitsHi << 12 >>> 32 - LOG_BITS;
            double z = valuePlusOne * StrictFastMath.twoPowNormalOrSubnormal(-valuePlusOneExp) * logXInvTab[xIndex] - 1.0;
            z *= 1.0 - z * (0.5 - z * 0.3333333333333333);
            return (double)valuePlusOneExp * LOG_2 + logXLogTab[xIndex] + (z + (value2 - (valuePlusOne - 1.0)) / valuePlusOne);
        }
        if (value2 == -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.NaN;
    }

    public static int log2(int value2) {
        return NumbersUtils.log2(value2);
    }

    public static int log2(long value2) {
        return NumbersUtils.log2(value2);
    }

    public static double pow(double value2, double power) {
        if (USE_JDK_MATH) {
            return StrictMath.pow(value2, power);
        }
        if (power == 0.0) {
            return 1.0;
        }
        if (power == 1.0) {
            return value2;
        }
        if (value2 <= 0.0) {
            int powerInfo;
            if (Math.abs(power) >= TWO_POW_52 * 2.0) {
                powerInfo = 1;
            } else if (Math.abs(power) <= 2.147483647E9) {
                int powerAsInt = (int)power;
                powerInfo = power == (double)powerAsInt ? ((powerAsInt & 1) == 0 ? 1 : -1) : 0;
            } else {
                long powerAsLong = (long)power;
                if (power == (double)powerAsLong) {
                    powerInfo = (powerAsLong & 1L) == 0L ? 1 : -1;
                } else {
                    if (power != power) {
                        return Double.NaN;
                    }
                    powerInfo = 0;
                }
            }
            if (value2 == 0.0) {
                if (power < 0.0) {
                    return powerInfo < 0 ? 1.0 / value2 : Double.POSITIVE_INFINITY;
                }
                return powerInfo < 0 ? value2 : 0.0;
            }
            if (value2 == Double.NEGATIVE_INFINITY) {
                if (powerInfo < 0) {
                    return power < 0.0 ? -0.0 : Double.NEGATIVE_INFINITY;
                }
                return power < 0.0 ? 0.0 : Double.POSITIVE_INFINITY;
            }
            return powerInfo == 0 ? Double.NaN : (double)powerInfo * StrictFastMath.exp(power * StrictFastMath.log(-value2));
        }
        return StrictFastMath.exp(power * StrictFastMath.log(value2));
    }

    public static double powQuick(double value2, double power) {
        if (USE_JDK_MATH) {
            return StrictMath.pow(value2, power);
        }
        return StrictFastMath.exp(power * StrictFastMath.logQuick(value2));
    }

    public static double powFast(double value2, int power) {
        if (USE_JDK_MATH) {
            return StrictMath.pow(value2, power);
        }
        if (power > 5) {
            double oddRemains = 1.0;
            do {
                if ((power & 1) != 0) {
                    oddRemains *= value2;
                }
                value2 *= value2;
            } while ((power >>= 1) > 5);
            if (power == 3) {
                return oddRemains * value2 * value2 * value2;
            }
            double v2 = value2 * value2;
            if (power == 4) {
                return oddRemains * v2 * v2;
            }
            return oddRemains * v2 * v2 * value2;
        }
        if (power >= 0) {
            if (power < 3) {
                if (power == 2) {
                    return value2 * value2;
                }
                if (power != 0) {
                    return value2;
                }
                return 1.0;
            }
            if (power == 3) {
                return value2 * value2 * value2;
            }
            double v2 = value2 * value2;
            if (power == 4) {
                return v2 * v2;
            }
            return v2 * v2 * value2;
        }
        if (power == Integer.MIN_VALUE) {
            return 1.0 / (StrictFastMath.powFast(value2, Integer.MAX_VALUE) * value2);
        }
        return 1.0 / StrictFastMath.powFast(value2, -power);
    }

    public static double twoPow(int power) {
        return NumbersUtils.twoPow(power);
    }

    public static int pow2(int value2) {
        return value2 * value2;
    }

    public static long pow2(long value2) {
        return value2 * value2;
    }

    public static float pow2(float value2) {
        return value2 * value2;
    }

    public static double pow2(double value2) {
        return value2 * value2;
    }

    public static int pow3(int value2) {
        return value2 * value2 * value2;
    }

    public static long pow3(long value2) {
        return value2 * value2 * value2;
    }

    public static float pow3(float value2) {
        return value2 * value2 * value2;
    }

    public static double pow3(double value2) {
        return value2 * value2 * value2;
    }

    public static double sqrt(double value2) {
        double h;
        if (USE_JDK_MATH || !USE_REDEFINED_SQRT) {
            return StrictMath.sqrt(value2);
        }
        if (!(value2 > 0.0)) {
            return value2 < 0.0 ? Double.NaN : value2;
        }
        if (value2 == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (value2 < DOUBLE_MIN_NORMAL) {
            value2 *= TWO_POW_52;
            h = 2.0 * TWO_POW_N26;
        } else {
            h = 2.0;
        }
        int valueBitsHi = (int)(Double.doubleToRawLongBits(value2) >> 32);
        int valueExponentIndex = (valueBitsHi >> 20) + 51;
        int xIndex = valueBitsHi << 12 >>> 32 - SQRT_LO_BITS;
        double result2 = sqrtXSqrtHiTab[valueExponentIndex] * sqrtXSqrtLoTab[xIndex];
        double slope = sqrtSlopeHiTab[valueExponentIndex] * sqrtSlopeLoTab[xIndex];
        result2 += ((value2 *= 0.25) - result2 * result2) * slope;
        result2 += (value2 - result2 * result2) * slope;
        return h * (result2 + (value2 - result2 * result2) * slope);
    }

    public static double sqrtQuick(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.sqrt(value2);
        }
        long bits = Double.doubleToRawLongBits(value2);
        return Double.longBitsToDouble(bits + 4606859074900000000L >>> 1);
    }

    public static double invSqrtQuick(double value2) {
        if (USE_JDK_MATH) {
            return 1.0 / StrictMath.sqrt(value2);
        }
        return Double.longBitsToDouble(6910469410427058089L - (Double.doubleToRawLongBits(value2) >> 1));
    }

    public static double cbrt(double value2) {
        double h;
        if (USE_JDK_MATH) {
            return StrictMath.cbrt(value2);
        }
        if (value2 < 0.0) {
            if (value2 == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            if ((value2 = -value2) < DOUBLE_MIN_NORMAL) {
                value2 *= TWO_POW_52 * TWO_POW_26;
                h = -2.0 * TWO_POW_N26;
            } else {
                h = -2.0;
            }
        } else {
            if (!(value2 < Double.POSITIVE_INFINITY)) {
                return value2;
            }
            if (value2 < DOUBLE_MIN_NORMAL) {
                if (value2 == 0.0) {
                    return value2;
                }
                value2 *= TWO_POW_52 * TWO_POW_26;
                h = 2.0 * TWO_POW_N26;
            } else {
                h = 2.0;
            }
        }
        int valueBitsHi = (int)(Double.doubleToRawLongBits(value2) >> 32);
        int valueExponentIndex = (valueBitsHi >> 20) + 51;
        int xIndex = valueBitsHi << 12 >>> 32 - CBRT_LO_BITS;
        double result2 = cbrtXCbrtHiTab[valueExponentIndex] * cbrtXCbrtLoTab[xIndex];
        double slope = cbrtSlopeHiTab[valueExponentIndex] * cbrtSlopeLoTab[xIndex];
        result2 += ((value2 *= 0.125) - result2 * result2 * result2) * slope;
        result2 += (value2 - result2 * result2 * result2) * slope;
        return h * (result2 + (value2 - result2 * result2 * result2) * slope);
    }

    public static double hypot(double x, double y) {
        double factor;
        if (USE_JDK_MATH) {
            return StrictMath.hypot(x, y);
        }
        x = Math.abs(x);
        if ((y = Math.abs(y)) < x) {
            double a = x;
            x = y;
            y = a;
        } else if (!(y >= x)) {
            return StrictFastMath.hypot_NaN(x, y);
        }
        if (y - x == y) {
            return y;
        }
        if (y > HYPOT_MAX_MAG) {
            x *= 1.0 / HYPOT_FACTOR;
            y *= 1.0 / HYPOT_FACTOR;
            factor = HYPOT_FACTOR;
        } else if (x < 1.0 / HYPOT_MAX_MAG) {
            x *= HYPOT_FACTOR;
            y *= HYPOT_FACTOR;
            factor = 1.0 / HYPOT_FACTOR;
        } else {
            factor = 1.0;
        }
        return factor * StrictFastMath.sqrt(x * x + y * y);
    }

    public static double hypot(double x, double y, double z) {
        double factor;
        double a;
        x = Math.abs(x);
        y = Math.abs(y);
        if ((z = Math.abs(z)) > y) {
            a = z;
            z = y;
            y = a;
        } else if (!(z <= y)) {
            return StrictFastMath.hypot_NaN(x, y, z);
        }
        if (z > x) {
            double oldZ = z;
            z = x;
            double oldY = y;
            y = oldZ;
            x = oldY;
        } else if (y > x) {
            a = y;
            y = x;
            x = a;
        } else if (x != x) {
            return StrictFastMath.hypot_NaN(x, y, z);
        }
        if (x - y == x) {
            return x;
        }
        if (y - z == y) {
            if (x > HYPOT_MAX_MAG) {
                x *= 1.0 / HYPOT_FACTOR;
                y *= 1.0 / HYPOT_FACTOR;
                factor = HYPOT_FACTOR;
            } else if (y < 1.0 / HYPOT_MAX_MAG) {
                x *= HYPOT_FACTOR;
                y *= HYPOT_FACTOR;
                factor = 1.0 / HYPOT_FACTOR;
            } else {
                factor = 1.0;
            }
            return factor * StrictFastMath.sqrt(x * x + y * y);
        }
        if (x > HYPOT_MAX_MAG) {
            x *= 1.0 / HYPOT_FACTOR;
            y *= 1.0 / HYPOT_FACTOR;
            z *= 1.0 / HYPOT_FACTOR;
            factor = HYPOT_FACTOR;
        } else if (z < 1.0 / HYPOT_MAX_MAG) {
            x *= HYPOT_FACTOR;
            y *= HYPOT_FACTOR;
            z *= HYPOT_FACTOR;
            factor = 1.0 / HYPOT_FACTOR;
        } else {
            factor = 1.0;
        }
        return factor * StrictFastMath.sqrt(x * x + (y * y + z * z));
    }

    public static int abs(int value2) {
        if (USE_JDK_MATH) {
            return StrictMath.abs(value2);
        }
        return NumbersUtils.abs(value2);
    }

    public static long abs(long value2) {
        if (USE_JDK_MATH) {
            return StrictMath.abs(value2);
        }
        return NumbersUtils.abs(value2);
    }

    public static int toIntExact(long value2) {
        return NumbersUtils.asInt(value2);
    }

    public static int toInt(long value2) {
        return NumbersUtils.toInt(value2);
    }

    public static float floor(float value2) {
        int exponent = StrictFastMath.getExponent(value2);
        if (exponent < 0) {
            if (value2 < 0.0f) {
                return -1.0f;
            }
            return 0.0f * value2;
        }
        if (exponent < 23) {
            int bits = Float.floatToRawIntBits(value2);
            int anteCommaBits = bits & -8388608 >> exponent;
            if (value2 < 0.0f && anteCommaBits != bits) {
                return Float.intBitsToFloat(anteCommaBits) - 1.0f;
            }
            return Float.intBitsToFloat(anteCommaBits);
        }
        return value2;
    }

    public static double floor(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.floor(value2);
        }
        double valueAbs = Math.abs(value2);
        if (valueAbs <= 2.147483647E9) {
            if (value2 > 0.0) {
                return (int)value2;
            }
            if (value2 < 0.0) {
                double anteCommaDigits = (int)value2;
                if (value2 != anteCommaDigits) {
                    return anteCommaDigits - 1.0;
                }
                return anteCommaDigits;
            }
            return value2;
        }
        if (valueAbs < TWO_POW_52) {
            double highPart = (double)((int)(value2 * TWO_POW_N26)) * TWO_POW_26;
            if (value2 > 0.0) {
                return highPart + (double)((int)(value2 - highPart));
            }
            double anteCommaDigits = highPart + (double)((int)(value2 - highPart));
            if (value2 != anteCommaDigits) {
                return anteCommaDigits - 1.0;
            }
            return anteCommaDigits;
        }
        return value2;
    }

    public static float ceil(float value2) {
        return -StrictFastMath.floor(-value2);
    }

    public static double ceil(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.ceil(value2);
        }
        return -StrictFastMath.floor(-value2);
    }

    public static int round(float value2) {
        int bits = Float.floatToRawIntBits(value2);
        int biasedExp = bits >> 23 & 0xFF;
        int shift = 149 - biasedExp;
        if ((shift & 0xFFFFFFE0) == 0) {
            int extendedMantissa = 0x800000 | bits & 0x7FFFFF;
            if (bits < 0) {
                extendedMantissa = -extendedMantissa;
            }
            return (extendedMantissa >> shift) + 1 >> 1;
        }
        return (int)value2;
    }

    public static long round(double value2) {
        long bits = Double.doubleToRawLongBits(value2);
        int biasedExp = (int)(bits >> 52) & 0x7FF;
        int shift = 1074 - biasedExp;
        if ((shift & 0xFFFFFFC0) == 0) {
            long extendedMantissa = 0x10000000000000L | bits & 0xFFFFFFFFFFFFFL;
            if (bits < 0L) {
                extendedMantissa = -extendedMantissa;
            }
            return (extendedMantissa >> shift) + 1L >> 1;
        }
        if (Math.abs(value2) >= 9.223372036854776E18) {
            return value2 < 0.0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return (long)value2;
    }

    public static int roundEven(float value2) {
        int sign = StrictFastMath.signFromBit(value2);
        if ((value2 = Math.abs(value2)) < TWO_POW_23_F) {
            value2 = value2 + TWO_POW_23_F - TWO_POW_23_F;
            return sign * (int)value2;
        }
        if (value2 < 2.1474836E9f) {
            return sign * (int)value2;
        }
        return (int)((float)sign * value2);
    }

    public static long roundEven(double value2) {
        int sign = (int)StrictFastMath.signFromBit(value2);
        if ((value2 = Math.abs(value2)) < TWO_POW_52) {
            value2 = value2 + TWO_POW_52 - TWO_POW_52;
        }
        if (value2 <= 2.147483647E9) {
            return sign * (int)value2;
        }
        return (long)((double)sign * value2);
    }

    public static float rint(float value2) {
        int sign = StrictFastMath.signFromBit(value2);
        if ((value2 = Math.abs(value2)) < TWO_POW_23_F) {
            value2 = TWO_POW_23_F + value2 - TWO_POW_23_F;
        }
        return (float)sign * value2;
    }

    public static double rint(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.rint(value2);
        }
        int sign = (int)StrictFastMath.signFromBit(value2);
        if ((value2 = Math.abs(value2)) < TWO_POW_52) {
            value2 = TWO_POW_52 + value2 - TWO_POW_52;
        }
        return (double)sign * value2;
    }

    public static int toRange(int min, int max, int value2) {
        return NumbersUtils.toRange(min, max, value2);
    }

    public static long toRange(long min, long max, long value2) {
        return NumbersUtils.toRange(min, max, value2);
    }

    public static float toRange(float min, float max, float value2) {
        return NumbersUtils.toRange(min, max, value2);
    }

    public static double toRange(double min, double max, double value2) {
        return NumbersUtils.toRange(min, max, value2);
    }

    public static int addExact(int a, int b2) {
        return NumbersUtils.plusExact(a, b2);
    }

    public static long addExact(long a, long b2) {
        return NumbersUtils.plusExact(a, b2);
    }

    public static int addBounded(int a, int b2) {
        return NumbersUtils.plusBounded(a, b2);
    }

    public static long addBounded(long a, long b2) {
        return NumbersUtils.plusBounded(a, b2);
    }

    public static int subtractExact(int a, int b2) {
        return NumbersUtils.minusExact(a, b2);
    }

    public static long subtractExact(long a, long b2) {
        return NumbersUtils.minusExact(a, b2);
    }

    public static int subtractBounded(int a, int b2) {
        return NumbersUtils.minusBounded(a, b2);
    }

    public static long subtractBounded(long a, long b2) {
        return NumbersUtils.minusBounded(a, b2);
    }

    public static int multiplyExact(int a, int b2) {
        return NumbersUtils.timesExact(a, b2);
    }

    public static long multiplyExact(long a, long b2) {
        return NumbersUtils.timesExact(a, b2);
    }

    public static int multiplyBounded(int a, int b2) {
        return NumbersUtils.timesBounded(a, b2);
    }

    public static long multiplyBounded(long a, long b2) {
        return NumbersUtils.timesBounded(a, b2);
    }

    public static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    public static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }

    public static int floorMod(int x, int y) {
        return x - StrictFastMath.floorDiv(x, y) * y;
    }

    public static long floorMod(long x, long y) {
        return x - StrictFastMath.floorDiv(x, y) * y;
    }

    public static double remainder(double dividend, double divisor) {
        if (Double.isInfinite(divisor)) {
            if (Double.isInfinite(dividend)) {
                return Double.NaN;
            }
            return dividend;
        }
        double value2 = dividend % divisor;
        if (Math.abs(value2 + value2) > Math.abs(divisor)) {
            return value2 + (value2 > 0.0 ? -Math.abs(divisor) : Math.abs(divisor));
        }
        return value2;
    }

    public static double normalizeMinusPiPi(double angle) {
        if (angle >= -Math.PI && angle <= Math.PI) {
            return angle;
        }
        return StrictFastMath.remainderTwoPi(angle);
    }

    public static double normalizeMinusPiPiFast(double angle) {
        if (angle >= -Math.PI && angle <= Math.PI) {
            return angle;
        }
        return StrictFastMath.remainderTwoPiFast(angle);
    }

    public static double normalizeZeroTwoPi(double angle) {
        if (angle >= 0.0 && angle <= Math.PI * 2) {
            return angle;
        }
        if ((angle = StrictFastMath.remainderTwoPi(angle)) < 0.0) {
            return angle + TWOPI_LO + TWOPI_HI;
        }
        return angle;
    }

    public static double normalizeZeroTwoPiFast(double angle) {
        if (angle >= 0.0 && angle <= Math.PI * 2) {
            return angle;
        }
        if ((angle = StrictFastMath.remainderTwoPiFast(angle)) < 0.0) {
            return angle + TWOPI_LO + TWOPI_HI;
        }
        return angle;
    }

    public static double normalizeMinusHalfPiHalfPi(double angle) {
        if (angle >= -1.5707963267948966 && angle <= 1.5707963267948966) {
            return angle;
        }
        return StrictFastMath.remainderPi(angle);
    }

    public static double normalizeMinusHalfPiHalfPiFast(double angle) {
        if (angle >= -1.5707963267948966 && angle <= 1.5707963267948966) {
            return angle;
        }
        return StrictFastMath.remainderPiFast(angle);
    }

    public static boolean isNaNOrInfinite(float value2) {
        return NumbersUtils.isNaNOrInfinite(value2);
    }

    public static boolean isNaNOrInfinite(double value2) {
        return NumbersUtils.isNaNOrInfinite(value2);
    }

    public static int getExponent(float value2) {
        return (Float.floatToRawIntBits(value2) >> 23 & 0xFF) - 127;
    }

    public static int getExponent(double value2) {
        return ((int)(Double.doubleToRawLongBits(value2) >> 52) & 0x7FF) - 1023;
    }

    public static float signum(float value2) {
        if (USE_JDK_MATH) {
            return StrictMath.signum(value2);
        }
        if (value2 == 0.0f || value2 != value2) {
            return value2;
        }
        return StrictFastMath.signFromBit(value2);
    }

    public static double signum(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.signum(value2);
        }
        if (value2 == 0.0 || value2 != value2) {
            return value2;
        }
        return (int)StrictFastMath.signFromBit(value2);
    }

    public static int signFromBit(float value2) {
        return Float.floatToRawIntBits(value2) >> 30 | 1;
    }

    public static long signFromBit(double value2) {
        return Double.doubleToRawLongBits(value2) >> 62 | 1L;
    }

    public static float copySign(float magnitude, float sign) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(sign != sign ? 1.0f : sign) & Integer.MIN_VALUE | Float.floatToRawIntBits(magnitude) & Integer.MAX_VALUE);
    }

    public static double copySign(double magnitude, double sign) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(sign != sign ? 1.0 : sign) & Long.MIN_VALUE | Double.doubleToRawLongBits(magnitude) & Long.MAX_VALUE);
    }

    public static float ulp(float value2) {
        if (USE_JDK_MATH) {
            return StrictMath.ulp(value2);
        }
        int exponent = StrictFastMath.getExponent(value2);
        if (exponent >= -103) {
            if (exponent == 128) {
                return Math.abs(value2);
            }
            return Float.intBitsToFloat(exponent + 104 << 23);
        }
        if (exponent == -127) {
            return Float.MIN_VALUE;
        }
        return Float.intBitsToFloat(1 << exponent - -126);
    }

    public static double ulp(double value2) {
        if (USE_JDK_MATH) {
            return StrictMath.ulp(value2);
        }
        int exponent = StrictFastMath.getExponent(value2);
        if (exponent >= -970) {
            if (exponent == 1024) {
                return Math.abs(value2);
            }
            return Double.longBitsToDouble((long)exponent + 971L << 52);
        }
        if (exponent == -1023) {
            return Double.MIN_VALUE;
        }
        return Double.longBitsToDouble(1L << exponent - -1022);
    }

    public static float nextAfter(float start2, double direction) {
        if (direction > (double)start2) {
            int bits;
            return Float.intBitsToFloat(bits + ((bits = Float.floatToRawIntBits(start2 + 0.0f)) >= 0 ? 1 : -1));
        }
        if (direction < (double)start2) {
            int bits;
            if (start2 == 0.0f) {
                return -1.4E-45f;
            }
            return Float.intBitsToFloat(bits + ((bits = Float.floatToRawIntBits(start2)) > 0 ? -1 : 1));
        }
        if ((double)start2 == direction) {
            return (float)direction;
        }
        return start2 + (float)direction;
    }

    public static double nextAfter(double start2, double direction) {
        if (direction > start2) {
            long bits;
            return Double.longBitsToDouble(bits + (long)((bits = Double.doubleToRawLongBits(start2 + 0.0)) >= 0L ? 1 : -1));
        }
        if (direction < start2) {
            long bits;
            if (start2 == 0.0) {
                return -4.9E-324;
            }
            return Double.longBitsToDouble(bits + (long)((bits = Double.doubleToRawLongBits(start2)) > 0L ? -1 : 1));
        }
        if (start2 == direction) {
            return direction;
        }
        return start2 + direction;
    }

    public static float nextDown(float start2) {
        if (start2 > Float.NEGATIVE_INFINITY) {
            int bits;
            if (start2 == 0.0f) {
                return -1.4E-45f;
            }
            return Float.intBitsToFloat(bits + ((bits = Float.floatToRawIntBits(start2)) > 0 ? -1 : 1));
        }
        if (start2 == Float.NEGATIVE_INFINITY) {
            return Float.NEGATIVE_INFINITY;
        }
        return start2;
    }

    public static double nextDown(double start2) {
        if (start2 > Double.NEGATIVE_INFINITY) {
            long bits;
            if (start2 == 0.0) {
                return -4.9E-324;
            }
            return Double.longBitsToDouble(bits + (long)((bits = Double.doubleToRawLongBits(start2)) > 0L ? -1 : 1));
        }
        if (start2 == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return start2;
    }

    public static float nextUp(float start2) {
        if (start2 < Float.POSITIVE_INFINITY) {
            int bits;
            return Float.intBitsToFloat(bits + ((bits = Float.floatToRawIntBits(start2 + 0.0f)) >= 0 ? 1 : -1));
        }
        if (start2 == Float.POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        return start2;
    }

    public static double nextUp(double start2) {
        if (start2 < Double.POSITIVE_INFINITY) {
            long bits;
            return Double.longBitsToDouble(bits + (long)((bits = Double.doubleToRawLongBits(start2 + 0.0)) >= 0L ? 1 : -1));
        }
        if (start2 == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return start2;
    }

    public static float scalb(float value2, int scaleFactor) {
        int MAX_SCALE = 278;
        scaleFactor = Math.max(Math.min(scaleFactor, 278), -278);
        return (float)((double)value2 * StrictFastMath.twoPowNormal(scaleFactor));
    }

    public static double scalb(double value2, int scaleFactor) {
        double exponentDelta;
        int scaleIncrement;
        if (scaleFactor > -1023 && scaleFactor <= 1023) {
            return value2 * StrictFastMath.twoPowNormal(scaleFactor);
        }
        int MAX_SCALE = 2099;
        if (scaleFactor < 0) {
            scaleFactor = Math.max(scaleFactor, -2099);
            scaleIncrement = -512;
            exponentDelta = TWO_POW_N512;
        } else {
            scaleFactor = Math.min(scaleFactor, 2099);
            scaleIncrement = 512;
            exponentDelta = TWO_POW_512;
        }
        int t2 = scaleFactor >> 8 >>> 23;
        int exponentAdjust = (scaleFactor + t2 & 0x1FF) - t2;
        value2 *= StrictFastMath.twoPowNormal(exponentAdjust);
        scaleFactor -= exponentAdjust;
        while (scaleFactor != 0) {
            value2 *= exponentDelta;
            scaleFactor -= scaleIncrement;
        }
        return value2;
    }

    public static float abs(float a) {
        return StrictMath.abs(a);
    }

    public static double abs(double a) {
        return StrictMath.abs(a);
    }

    public static int min(int a, int b2) {
        return StrictMath.min(a, b2);
    }

    public static long min(long a, long b2) {
        return StrictMath.min(a, b2);
    }

    public static float min(float a, float b2) {
        return StrictMath.min(a, b2);
    }

    public static double min(double a, double b2) {
        return StrictMath.min(a, b2);
    }

    public static int max(int a, int b2) {
        return StrictMath.max(a, b2);
    }

    public static long max(long a, long b2) {
        return StrictMath.max(a, b2);
    }

    public static float max(float a, float b2) {
        return StrictMath.max(a, b2);
    }

    public static double max(double a, double b2) {
        return StrictMath.max(a, b2);
    }

    public static double IEEEremainder(double f1, double f2) {
        return StrictMath.IEEEremainder(f1, f2);
    }

    public static double random() {
        return StrictMath.random();
    }

    private StrictFastMath() {
    }

    private static double remainderTwoPi(double angle) {
        if (USE_JDK_MATH) {
            return StrictFastMath.jdkRemainderTwoPi(angle);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (angle <= 4.0 * NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE_PIO2) {
            double fn = (int)(angle * TWOPI_INV + 0.5);
            if ((angle = angle - fn * TWOPI_HI - fn * TWOPI_LO) < -Math.PI) {
                angle = angle + TWOPI_HI + TWOPI_LO;
            } else if (angle > Math.PI) {
                angle = angle - TWOPI_HI - TWOPI_LO;
            }
            return negateResult ? -angle : angle;
        }
        if (angle < Double.POSITIVE_INFINITY) {
            angle = StrictFastMath.heavyRemainderTwoPi(angle);
            return negateResult ? -angle : angle;
        }
        return Double.NaN;
    }

    private static double remainderPi(double angle) {
        if (USE_JDK_MATH) {
            return StrictFastMath.jdkRemainderPi(angle);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (angle <= 2.0 * NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE_PIO2) {
            double fn = (int)(angle * PI_INV + 0.5);
            if ((angle = angle - fn * PI_HI - fn * PI_LO) < -1.5707963267948966) {
                angle = angle + PI_HI + PI_LO;
            } else if (angle > 1.5707963267948966) {
                angle = angle - PI_HI - PI_LO;
            }
            return negateResult ? -angle : angle;
        }
        if (angle < Double.POSITIVE_INFINITY) {
            angle = StrictFastMath.heavyRemainderPi(angle);
            return negateResult ? -angle : angle;
        }
        return Double.NaN;
    }

    private static long remainderPiO2(double angle) {
        if (USE_JDK_MATH) {
            return StrictFastMath.jdkRemainderPiO2(angle, false);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (angle <= NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE_PIO2) {
            int n2 = (int)(angle * PIO2_INV + 0.5);
            double fn = n2;
            if ((angle = angle - fn * PIO2_HI - fn * PIO2_LO) < -0.7853981633974483) {
                angle = angle + PIO2_HI + PIO2_LO;
                --n2;
            } else if (angle > 0.7853981633974483) {
                angle = angle - PIO2_HI - PIO2_LO;
                ++n2;
            }
            if (negateResult) {
                angle = -angle;
            }
            return StrictFastMath.encodeRemainderAndQuadrant(angle, n2 & 3);
        }
        if (angle < Double.POSITIVE_INFINITY) {
            return StrictFastMath.heavyRemainderPiO2(angle, negateResult);
        }
        return StrictFastMath.encodeRemainderAndQuadrant(Double.NaN, 0);
    }

    private static double remainderTwoPiFast(double angle) {
        double fn;
        if (USE_JDK_MATH) {
            return StrictFastMath.jdkRemainderTwoPi(angle);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (!(angle <= TWO_POW_26 * (Math.PI * 2))) {
            if (angle <= TWO_POW_52 * (Math.PI * 2)) {
                fn = (int)(angle * (TWOPI_INV / TWO_POW_26) + 0.5);
                if ((angle = angle - fn * (TWOPI_HI * TWO_POW_26) - fn * (TWOPI_LO * TWO_POW_26)) < 0.0) {
                    angle = -angle;
                    negateResult = !negateResult;
                }
            } else {
                if (angle < Double.POSITIVE_INFINITY) {
                    return 0.0;
                }
                return Double.NaN;
            }
        }
        if ((angle = angle - (fn = (double)((int)(angle * TWOPI_INV + 0.5))) * TWOPI_HI - fn * TWOPI_LO) < -Math.PI) {
            angle = angle + TWOPI_HI + TWOPI_LO;
        } else if (angle > Math.PI) {
            angle = angle - TWOPI_HI - TWOPI_LO;
        }
        return negateResult ? -angle : angle;
    }

    private static double remainderPiFast(double angle) {
        double fn;
        if (USE_JDK_MATH) {
            return StrictFastMath.jdkRemainderPi(angle);
        }
        boolean negateResult = false;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        }
        if (!(angle <= TWO_POW_26 * Math.PI)) {
            if (angle <= TWO_POW_52 * Math.PI) {
                fn = (int)(angle * (PI_INV / TWO_POW_26) + 0.5);
                if ((angle = angle - fn * (PI_HI * TWO_POW_26) - fn * (PI_LO * TWO_POW_26)) < 0.0) {
                    angle = -angle;
                    negateResult = !negateResult;
                }
            } else {
                if (angle < Double.POSITIVE_INFINITY) {
                    return 0.0;
                }
                return Double.NaN;
            }
        }
        if ((angle = angle - (fn = (double)((int)(angle * PI_INV + 0.5))) * PI_HI - fn * PI_LO) < -1.5707963267948966) {
            angle = angle + PI_HI + PI_LO;
        } else if (angle > 1.5707963267948966) {
            angle = angle - PI_HI - PI_LO;
        }
        return negateResult ? -angle : angle;
    }
}

