/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.learner;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.jafama.FastMath;

public class ObjFunction
implements Serializable {
    private static final Map<String, ObjFunction> FUNCTIONS = new HashMap<String, ObjFunction>();

    public static ObjFunction fromName(String name2) {
        ObjFunction result2 = FUNCTIONS.get(name2);
        if (result2 == null) {
            throw new IllegalArgumentException(name2 + " is not supported objective function.");
        }
        return result2;
    }

    public static void register(String name2, ObjFunction objFunction) {
        FUNCTIONS.put(name2, objFunction);
    }

    public static void useFastMathExp(boolean useJafama) {
        if (useJafama) {
            ObjFunction.register("binary:logistic", new RegLossObjLogistic_Jafama());
            ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb_Jafama());
        } else {
            ObjFunction.register("binary:logistic", new RegLossObjLogistic());
            ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb());
        }
    }

    public float[] predTransform(float[] preds) {
        return preds;
    }

    public float predTransform(float pred) {
        return pred;
    }

    public float probToMargin(float prob) {
        return prob;
    }

    static {
        ObjFunction.register("rank:pairwise", new ObjFunction());
        ObjFunction.register("binary:logistic", new RegLossObjLogistic());
        ObjFunction.register("binary:logitraw", new ObjFunction());
        ObjFunction.register("multi:softmax", new SoftmaxMultiClassObjClassify());
        ObjFunction.register("multi:softprob", new SoftmaxMultiClassObjProb());
        ObjFunction.register("reg:linear", new ObjFunction());
        ObjFunction.register("reg:squarederror", new ObjFunction());
        ObjFunction.register("reg:gamma", new RegObjFunction());
        ObjFunction.register("reg:tweedie", new RegObjFunction());
        ObjFunction.register("count:poisson", new RegObjFunction());
    }

    static class SoftmaxMultiClassObjProb_Jafama
    extends SoftmaxMultiClassObjProb {
        SoftmaxMultiClassObjProb_Jafama() {
        }

        @Override
        float exp(float x) {
            return (float)FastMath.exp(x);
        }
    }

    static class SoftmaxMultiClassObjProb
    extends ObjFunction {
        SoftmaxMultiClassObjProb() {
        }

        @Override
        public float[] predTransform(float[] preds) {
            int i2;
            float max = preds[0];
            for (int i3 = 1; i3 < preds.length; ++i3) {
                max = Math.max(preds[i3], max);
            }
            double sum = 0.0;
            for (i2 = 0; i2 < preds.length; ++i2) {
                preds[i2] = this.exp(preds[i2] - max);
                sum += (double)preds[i2];
            }
            i2 = 0;
            while (i2 < preds.length) {
                int n2 = i2++;
                preds[n2] = preds[n2] / (float)sum;
            }
            return preds;
        }

        @Override
        public float predTransform(float pred) {
            throw new UnsupportedOperationException();
        }

        float exp(float x) {
            return (float)Math.exp(x);
        }
    }

    static class SoftmaxMultiClassObjClassify
    extends ObjFunction {
        SoftmaxMultiClassObjClassify() {
        }

        @Override
        public float[] predTransform(float[] preds) {
            int maxIndex = 0;
            float max = preds[0];
            for (int i2 = 1; i2 < preds.length; ++i2) {
                if (!(max < preds[i2])) continue;
                maxIndex = i2;
                max = preds[i2];
            }
            return new float[]{maxIndex};
        }

        @Override
        public float predTransform(float pred) {
            throw new UnsupportedOperationException();
        }
    }

    static class RegLossObjLogistic_Jafama
    extends RegLossObjLogistic {
        RegLossObjLogistic_Jafama() {
        }

        @Override
        float sigmoid(float x) {
            return (float)(1.0 / (1.0 + FastMath.exp(-x)));
        }
    }

    static class RegLossObjLogistic
    extends ObjFunction {
        RegLossObjLogistic() {
        }

        @Override
        public float[] predTransform(float[] preds) {
            for (int i2 = 0; i2 < preds.length; ++i2) {
                preds[i2] = this.sigmoid(preds[i2]);
            }
            return preds;
        }

        @Override
        public float predTransform(float pred) {
            return this.sigmoid(pred);
        }

        float sigmoid(float x) {
            return 1.0f / (1.0f + (float)Math.exp(-x));
        }

        @Override
        public float probToMargin(float prob) {
            return (float)(-Math.log(1.0f / prob - 1.0f));
        }
    }

    static class RegObjFunction
    extends ObjFunction {
        RegObjFunction() {
        }

        @Override
        public float[] predTransform(float[] preds) {
            if (preds.length != 1) {
                throw new IllegalStateException("Regression problem is supposed to have just a single predicted value, got " + preds.length + " instead.");
            }
            preds[0] = (float)Math.exp(preds[0]);
            return preds;
        }

        @Override
        public float predTransform(float pred) {
            return (float)Math.exp(pred);
        }

        @Override
        public float probToMargin(float prob) {
            return (float)Math.log(prob);
        }
    }
}

