/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.tree;

import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.tree.RegTreeNode;
import biz.k11i.xgboost.tree.RegTreeNodeStat;
import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public class RegTreeImpl
implements RegTree {
    private Param param;
    private Node[] nodes;
    private RegTreeNodeStat[] stats;

    public void loadModel(ModelReader reader) throws IOException {
        int i2;
        this.param = new Param(reader);
        this.nodes = new Node[this.param.num_nodes];
        for (i2 = 0; i2 < this.param.num_nodes; ++i2) {
            this.nodes[i2] = new Node(reader);
        }
        this.stats = new RegTreeNodeStat[this.param.num_nodes];
        for (i2 = 0; i2 < this.param.num_nodes; ++i2) {
            this.stats[i2] = new RegTreeNodeStat(reader);
        }
    }

    @Override
    public int getLeafIndex(FVec feat) {
        int id = 0;
        while (true) {
            Node n2 = this.nodes[id];
            if (n2._isLeaf) break;
            id = n2.next(feat);
        }
        return id;
    }

    @Override
    public void getLeafPath(FVec feat, StringBuilder sb) {
        int id = 0;
        while (true) {
            Node n2 = this.nodes[id];
            if (n2._isLeaf) break;
            id = n2.next(feat);
            sb.append(id == n2.cleft_ ? "L" : "R");
        }
    }

    @Override
    public float getLeafValue(FVec feat, int root_id) {
        Node n2 = this.nodes[root_id];
        while (!n2._isLeaf) {
            n2 = this.nodes[n2.next(feat)];
        }
        return n2.leaf_value;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    @Override
    public RegTreeNodeStat[] getStats() {
        return this.stats;
    }

    public static class Node
    extends RegTreeNode
    implements Serializable {
        final int parent_;
        final int cleft_;
        final int cright_;
        final int sindex_;
        final float leaf_value;
        final float split_cond;
        private final int _defaultNext;
        private final int _splitIndex;
        final boolean _isLeaf;

        Node(ModelReader reader) throws IOException {
            this.parent_ = reader.readInt();
            this.cleft_ = reader.readInt();
            this.cright_ = reader.readInt();
            this.sindex_ = reader.readInt();
            if (this.isLeaf()) {
                this.leaf_value = reader.readFloat();
                this.split_cond = Float.NaN;
            } else {
                this.split_cond = reader.readFloat();
                this.leaf_value = Float.NaN;
            }
            this._defaultNext = this.cdefault();
            this._splitIndex = this.getSplitIndex();
            this._isLeaf = this.isLeaf();
        }

        @Override
        public boolean isLeaf() {
            return this.cleft_ == -1;
        }

        @Override
        public int getSplitIndex() {
            return (int)((long)this.sindex_ & Integer.MAX_VALUE);
        }

        public int cdefault() {
            return this.default_left() ? this.cleft_ : this.cright_;
        }

        @Override
        public boolean default_left() {
            return this.sindex_ >>> 31 != 0;
        }

        @Override
        public int next(FVec feat) {
            float value2 = feat.fvalue(this._splitIndex);
            if (value2 != value2) {
                return this._defaultNext;
            }
            return value2 < this.split_cond ? this.cleft_ : this.cright_;
        }

        @Override
        public int getParentIndex() {
            return this.parent_;
        }

        @Override
        public int getLeftChildIndex() {
            return this.cleft_;
        }

        @Override
        public int getRightChildIndex() {
            return this.cright_;
        }

        @Override
        public float getSplitCondition() {
            return this.split_cond;
        }

        @Override
        public float getLeafValue() {
            return this.leaf_value;
        }
    }

    static class Param
    implements Serializable {
        final int num_roots;
        final int num_nodes;
        final int num_deleted;
        final int max_depth;
        final int num_feature;
        final int size_leaf_vector;
        final int[] reserved;

        Param(ModelReader reader) throws IOException {
            this.num_roots = reader.readInt();
            this.num_nodes = reader.readInt();
            this.num_deleted = reader.readInt();
            this.max_depth = reader.readInt();
            this.num_feature = reader.readInt();
            this.size_leaf_vector = reader.readInt();
            this.reserved = reader.readIntArray(31);
        }
    }
}

