/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.factories;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.factories.SerializerFactory;
import com.esotericsoftware.kryo.util.Util;

public class ReflectionSerializerFactory
implements SerializerFactory {
    private final Class<? extends Serializer> serializerClass;

    public ReflectionSerializerFactory(Class<? extends Serializer> serializerClass) {
        this.serializerClass = serializerClass;
    }

    @Override
    public Serializer makeSerializer(Kryo kryo, Class<?> type2) {
        return ReflectionSerializerFactory.makeSerializer(kryo, this.serializerClass, type2);
    }

    public static Serializer makeSerializer(Kryo kryo, Class<? extends Serializer> serializerClass, Class<?> type2) {
        try {
            try {
                return serializerClass.getConstructor(Kryo.class, Class.class).newInstance(kryo, type2);
            }
            catch (NoSuchMethodException ex1) {
                try {
                    return serializerClass.getConstructor(Kryo.class).newInstance(kryo);
                }
                catch (NoSuchMethodException ex2) {
                    try {
                        return serializerClass.getConstructor(Class.class).newInstance(type2);
                    }
                    catch (NoSuchMethodException ex3) {
                        return serializerClass.newInstance();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to create serializer \"" + serializerClass.getName() + "\" for class: " + Util.className(type2), ex);
        }
    }
}

