/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.InputChunked;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.OutputChunked;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.minlog.Log;

public class CompatibleFieldSerializer<T>
extends FieldSerializer<T> {
    private static final int THRESHOLD_BINARY_SEARCH = 32;

    public CompatibleFieldSerializer(Kryo kryo, Class type2) {
        super(kryo, type2);
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields2 = this.getFields();
        ObjectMap context = kryo.getGraphContext();
        if (!context.containsKey(this)) {
            context.put(this, null);
            if (Log.TRACE) {
                Log.trace("kryo", "Write " + fields2.length + " field names.");
            }
            output.writeVarInt(fields2.length, true);
            int n2 = fields2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                output.writeString(this.getCachedFieldName(fields2[i2]));
            }
        }
        OutputChunked outputChunked = new OutputChunked(output, 1024);
        int n3 = fields2.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            fields2[i3].write(outputChunked, object);
            outputChunked.endChunks();
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type2) {
        T object = this.create(kryo, input, type2);
        kryo.reference(object);
        ObjectMap context = kryo.getGraphContext();
        FieldSerializer.CachedField[] fields2 = (FieldSerializer.CachedField[])context.get(this);
        if (fields2 == null) {
            int length = input.readVarInt(true);
            if (Log.TRACE) {
                Log.trace("kryo", "Read " + length + " field names.");
            }
            String[] names = new String[length];
            for (int i2 = 0; i2 < length; ++i2) {
                names[i2] = input.readString();
            }
            fields2 = new FieldSerializer.CachedField[length];
            FieldSerializer.CachedField[] allFields = this.getFields();
            if (length < 32) {
                block1: for (int i3 = 0; i3 < length; ++i3) {
                    String schemaName = names[i3];
                    int nn = allFields.length;
                    for (int ii = 0; ii < nn; ++ii) {
                        if (!this.getCachedFieldName(allFields[ii]).equals(schemaName)) continue;
                        fields2[i3] = allFields[ii];
                        continue block1;
                    }
                    if (!Log.TRACE) continue;
                    Log.trace("kryo", "Ignore obsolete field: " + schemaName);
                }
            } else {
                int maxFieldLength = allFields.length;
                block3: for (int i4 = 0; i4 < length; ++i4) {
                    String schemaName = names[i4];
                    int low = 0;
                    int high = maxFieldLength - 1;
                    while (low <= high) {
                        int mid = low + high >>> 1;
                        String midVal = this.getCachedFieldName(allFields[mid]);
                        int compare2 = schemaName.compareTo(midVal);
                        if (compare2 < 0) {
                            high = mid - 1;
                            continue;
                        }
                        if (compare2 > 0) {
                            low = mid + 1;
                            continue;
                        }
                        fields2[i4] = allFields[mid];
                        continue block3;
                    }
                    if (!Log.TRACE) continue;
                    Log.trace("kryo", "Ignore obsolete field: " + schemaName);
                }
            }
            context.put(this, fields2);
        }
        InputChunked inputChunked = new InputChunked(input, 1024);
        boolean hasGenerics = this.getGenerics() != null;
        for (FieldSerializer.CachedField cachedField : fields2) {
            if (cachedField != null && hasGenerics) {
                cachedField = this.getField(this.getCachedFieldName(cachedField));
            }
            if (cachedField == null) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Skip obsolete field.");
                }
                inputChunked.nextChunks();
                continue;
            }
            cachedField.read(inputChunked, object);
            inputChunked.nextChunks();
        }
        return object;
    }
}

