/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.InputChunked;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.OutputChunked;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.TaggedFieldSerializerConfig;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;

public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] tags;
    private int writeFieldCount;
    private boolean[] deprecated;
    private boolean[] annexed;
    private static final Comparator<FieldSerializer.CachedField> TAGGED_VALUE_COMPARATOR = new Comparator<FieldSerializer.CachedField>(){

        @Override
        public int compare(FieldSerializer.CachedField o1, FieldSerializer.CachedField o2) {
            return o1.getField().getAnnotation(Tag.class).value() - o2.getField().getAnnotation(Tag.class).value();
        }
    };

    public TaggedFieldSerializer(Kryo kryo, Class type2) {
        super(kryo, type2, null, kryo.getTaggedFieldSerializerConfig().clone());
    }

    public void setSkipUnknownTags(boolean skipUnknownTags) {
        ((TaggedFieldSerializerConfig)this.config).setSkipUnknownTags(skipUnknownTags);
        this.rebuildCachedFields();
    }

    public boolean isSkipUnknownTags() {
        return ((TaggedFieldSerializerConfig)this.config).isSkipUnknownTags();
    }

    @Override
    protected void initializeCachedFields() {
        Field field2;
        int i2;
        FieldSerializer.CachedField[] fields2 = this.getFields();
        int n2 = fields2.length;
        for (i2 = 0; i2 < n2; ++i2) {
            field2 = fields2[i2].getField();
            if (field2.getAnnotation(Tag.class) != null) continue;
            if (Log.TRACE) {
                Log.trace("kryo", "Ignoring field without tag: " + fields2[i2]);
            }
            super.removeField(fields2[i2]);
        }
        fields2 = this.getFields();
        this.tags = new int[fields2.length];
        this.deprecated = new boolean[fields2.length];
        this.annexed = new boolean[fields2.length];
        this.writeFieldCount = fields2.length;
        Arrays.sort(fields2, TAGGED_VALUE_COMPARATOR);
        n2 = fields2.length;
        for (i2 = 0; i2 < n2; ++i2) {
            field2 = fields2[i2].getField();
            this.tags[i2] = field2.getAnnotation(Tag.class).value();
            if (i2 > 0 && this.tags[i2] == this.tags[i2 - 1]) {
                throw new KryoException(String.format("The fields [%s] and [%s] both have a Tag value of %d.", field2, fields2[i2 - 1].getField(), this.tags[i2]));
            }
            if (field2.getAnnotation(Deprecated.class) != null) {
                this.deprecated[i2] = true;
                --this.writeFieldCount;
            }
            if (!field2.getAnnotation(Tag.class).annexed()) continue;
            this.annexed[i2] = true;
        }
        this.removedFields.clear();
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field2) {
        super.removeField(field2);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields2 = this.getFields();
        output.writeVarInt(this.writeFieldCount, true);
        OutputChunked outputChunked = null;
        int n2 = fields2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.deprecated[i2]) continue;
            output.writeVarInt(this.tags[i2], true);
            if (this.annexed[i2]) {
                if (outputChunked == null) {
                    outputChunked = new OutputChunked(output, 1024);
                }
                fields2[i2].write(outputChunked, object);
                outputChunked.endChunks();
                continue;
            }
            fields2[i2].write(output, object);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type2) {
        T object = this.create(kryo, input, type2);
        kryo.reference(object);
        int fieldCount = input.readVarInt(true);
        int[] tags = this.tags;
        InputChunked inputChunked = null;
        FieldSerializer.CachedField[] fields2 = this.getFields();
        int n2 = fieldCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            int tag = input.readVarInt(true);
            FieldSerializer.CachedField cachedField = null;
            boolean isAnnexed = false;
            int nn = tags.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (tags[ii] != tag) continue;
                cachedField = fields2[ii];
                isAnnexed = this.annexed[ii];
                break;
            }
            if (cachedField == null) {
                if (this.isSkipUnknownTags()) {
                    if (inputChunked == null) {
                        inputChunked = new InputChunked(input, 1024);
                    }
                    inputChunked.nextChunks();
                    if (!Log.TRACE) continue;
                    Log.trace(String.format("Unknown field tag: %d (%s) encountered. Assuming a future annexed tag with chunked encoding and skipping.", tag, this.getType().getName()));
                    continue;
                }
                throw new KryoException("Unknown field tag: " + tag + " (" + this.getType().getName() + ")");
            }
            if (isAnnexed) {
                if (inputChunked == null) {
                    inputChunked = new InputChunked(input, 1024);
                }
                cachedField.read(inputChunked, object);
                inputChunked.nextChunks();
                continue;
            }
            cachedField.read(input, object);
        }
        return object;
    }

    @Deprecated
    public void setIgnoreUnknownTags(boolean ignoreUnknownTags) {
    }

    @Deprecated
    public boolean isIgnoreUnkownTags() {
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();

        public boolean annexed() default false;
    }
}

