/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public class VersionFieldSerializer<T>
extends FieldSerializer<T> {
    private int typeVersion = 0;
    private int[] fieldVersion;
    private boolean compatible = true;

    public VersionFieldSerializer(Kryo kryo, Class type2) {
        super(kryo, type2);
        this.initializeCachedFields();
    }

    public VersionFieldSerializer(Kryo kryo, Class type2, boolean compatible) {
        this(kryo, type2);
        this.compatible = compatible;
    }

    @Override
    protected void initializeCachedFields() {
        FieldSerializer.CachedField[] fields2 = this.getFields();
        this.fieldVersion = new int[fields2.length];
        int n2 = fields2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field2 = fields2[i2].getField();
            Since since = field2.getAnnotation(Since.class);
            if (since != null) {
                this.fieldVersion[i2] = since.value();
                this.typeVersion = Math.max(this.fieldVersion[i2], this.typeVersion);
                continue;
            }
            this.fieldVersion[i2] = 0;
        }
        this.removedFields.clear();
        if (Log.DEBUG) {
            Log.debug("Version for type " + this.getType().getName() + " is " + this.typeVersion);
        }
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field2) {
        super.removeField(field2);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields2 = this.getFields();
        output.writeVarInt(this.typeVersion, true);
        int n2 = fields2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            fields2[i2].write(output, object);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type2) {
        T object = this.create(kryo, input, type2);
        kryo.reference(object);
        int version2 = input.readVarInt(true);
        if (!this.compatible && version2 != this.typeVersion) {
            throw new KryoException("Version not compatible: " + version2 + " <-> " + this.typeVersion);
        }
        FieldSerializer.CachedField[] fields2 = this.getFields();
        int n2 = fields2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.fieldVersion[i2] > version2) {
                if (!Log.DEBUG) continue;
                Log.debug("Skip field " + fields2[i2].getField().getName());
                continue;
            }
            fields2[i2].read(input, object);
        }
        return object;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Since {
        public int value() default 0;
    }
}

