/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.util.ObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IdentityMap<K, V> {
    private static final int PRIME2 = -1105259343;
    private static final int PRIME3 = -1262997959;
    private static final int PRIME4 = -825114047;
    public int size;
    K[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private boolean isBigTable;
    private Entries entries;
    private Values values;
    private Keys keys;

    public IdentityMap() {
        this(32, 0.8f);
    }

    public IdentityMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public IdentityMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + initialCapacity);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(initialCapacity);
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.isBigTable = this.capacity >>> 16 != 0;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public V put(K key2, V value2) {
        int i2;
        if (key2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] keyTable = this.keyTable;
        int mask = this.mask;
        boolean isBigTable = this.isBigTable;
        int hashCode2 = System.identityHashCode(key2);
        int index1 = hashCode2 & mask;
        K key1 = keyTable[index1];
        if (key1 == key2) {
            V oldValue = this.valueTable[index1];
            this.valueTable[index1] = value2;
            return oldValue;
        }
        int index2 = this.hash2(hashCode2);
        K key22 = keyTable[index2];
        if (key22 == key2) {
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = value2;
            return oldValue;
        }
        int index3 = this.hash3(hashCode2);
        K key3 = keyTable[index3];
        if (key3 == key2) {
            V oldValue = this.valueTable[index3];
            this.valueTable[index3] = value2;
            return oldValue;
        }
        int index4 = -1;
        K key4 = null;
        if (isBigTable && (key4 = (K)keyTable[index4 = this.hash4(hashCode2)]) == key2) {
            V oldValue = this.valueTable[index4];
            this.valueTable[index4] = value2;
            return oldValue;
        }
        int n2 = i2 + this.stashSize;
        for (i2 = this.capacity; i2 < n2; ++i2) {
            if (keyTable[i2] != key2) continue;
            V oldValue = this.valueTable[i2];
            this.valueTable[i2] = value2;
            return oldValue;
        }
        if (key1 == null) {
            keyTable[index1] = key2;
            this.valueTable[index1] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (key22 == null) {
            keyTable[index2] = key2;
            this.valueTable[index2] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (key3 == null) {
            keyTable[index3] = key2;
            this.valueTable[index3] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (isBigTable && key4 == null) {
            keyTable[index4] = key2;
            this.valueTable[index4] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(key2, value2, index1, key1, index2, key22, index3, key3, index4, key4);
        return null;
    }

    private void putResize(K key2, V value2) {
        int hashCode2 = System.identityHashCode(key2);
        int index1 = hashCode2 & this.mask;
        K key1 = this.keyTable[index1];
        if (key1 == null) {
            this.keyTable[index1] = key2;
            this.valueTable[index1] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index2 = this.hash2(hashCode2);
        K key22 = this.keyTable[index2];
        if (key22 == null) {
            this.keyTable[index2] = key2;
            this.valueTable[index2] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index3 = this.hash3(hashCode2);
        K key3 = this.keyTable[index3];
        if (key3 == null) {
            this.keyTable[index3] = key2;
            this.valueTable[index3] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index4 = -1;
        K key4 = null;
        if (this.isBigTable && (key4 = (K)this.keyTable[index4 = this.hash4(hashCode2)]) == null) {
            this.keyTable[index4] = key2;
            this.valueTable[index4] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(key2, value2, index1, key1, index2, key22, index3, key3, index4, key4);
    }

    private void push(K insertKey, V insertValue, int index1, K key1, int index2, K key2, int index3, K key3, int index4, K key4) {
        V evictedValue;
        K evictedKey;
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int mask = this.mask;
        boolean isBigTable = this.isBigTable;
        int i2 = 0;
        int pushIterations = this.pushIterations;
        int n2 = isBigTable ? 4 : 3;
        while (true) {
            switch (ObjectMap.random.nextInt(n2)) {
                case 0: {
                    evictedKey = key1;
                    evictedValue = valueTable[index1];
                    keyTable[index1] = insertKey;
                    valueTable[index1] = insertValue;
                    break;
                }
                case 1: {
                    evictedKey = key2;
                    evictedValue = valueTable[index2];
                    keyTable[index2] = insertKey;
                    valueTable[index2] = insertValue;
                    break;
                }
                case 2: {
                    evictedKey = key3;
                    evictedValue = valueTable[index3];
                    keyTable[index3] = insertKey;
                    valueTable[index3] = insertValue;
                    break;
                }
                default: {
                    evictedKey = key4;
                    evictedValue = valueTable[index4];
                    keyTable[index4] = insertKey;
                    valueTable[index4] = insertValue;
                }
            }
            int hashCode2 = System.identityHashCode(evictedKey);
            index1 = hashCode2 & mask;
            key1 = keyTable[index1];
            if (key1 == null) {
                keyTable[index1] = evictedKey;
                valueTable[index1] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            index2 = this.hash2(hashCode2);
            key2 = keyTable[index2];
            if (key2 == null) {
                keyTable[index2] = evictedKey;
                valueTable[index2] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            index3 = this.hash3(hashCode2);
            key3 = keyTable[index3];
            if (key3 == null) {
                keyTable[index3] = evictedKey;
                valueTable[index3] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (isBigTable && (key4 = keyTable[index4 = this.hash4(hashCode2)]) == null) {
                keyTable[index4] = evictedKey;
                valueTable[index4] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++i2 == pushIterations) break;
            insertKey = evictedKey;
            insertValue = evictedValue;
        }
        this.putStash(evictedKey, evictedValue);
    }

    private void putStash(K key2, V value2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(key2, value2);
            return;
        }
        int index2 = this.capacity + this.stashSize;
        this.keyTable[index2] = key2;
        this.valueTable[index2] = value2;
        ++this.stashSize;
        ++this.size;
    }

    public V get(K key2) {
        int hashCode2 = System.identityHashCode(key2);
        int index2 = hashCode2 & this.mask;
        if (key2 != this.keyTable[index2] && key2 != this.keyTable[index2 = this.hash2(hashCode2)] && key2 != this.keyTable[index2 = this.hash3(hashCode2)]) {
            if (this.isBigTable) {
                index2 = this.hash4(hashCode2);
                if (key2 != this.keyTable[index2]) {
                    return this.getStash(key2, null);
                }
            } else {
                return this.getStash(key2, null);
            }
        }
        return this.valueTable[index2];
    }

    public V get(K key2, V defaultValue2) {
        int hashCode2 = System.identityHashCode(key2);
        int index2 = hashCode2 & this.mask;
        if (key2 != this.keyTable[index2] && key2 != this.keyTable[index2 = this.hash2(hashCode2)] && key2 != this.keyTable[index2 = this.hash3(hashCode2)]) {
            if (this.isBigTable) {
                index2 = this.hash4(hashCode2);
                if (key2 != this.keyTable[index2]) {
                    return this.getStash(key2, defaultValue2);
                }
            } else {
                return this.getStash(key2, defaultValue2);
            }
        }
        return this.valueTable[index2];
    }

    private V getStash(K key2, V defaultValue2) {
        int i2;
        K[] keyTable = this.keyTable;
        int n2 = i2 + this.stashSize;
        for (i2 = this.capacity; i2 < n2; ++i2) {
            if (keyTable[i2] != key2) continue;
            return this.valueTable[i2];
        }
        return defaultValue2;
    }

    public V remove(K key2) {
        int hashCode2 = System.identityHashCode(key2);
        int index2 = hashCode2 & this.mask;
        if (this.keyTable[index2] == key2) {
            this.keyTable[index2] = null;
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = null;
            --this.size;
            return oldValue;
        }
        index2 = this.hash2(hashCode2);
        if (this.keyTable[index2] == key2) {
            this.keyTable[index2] = null;
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = null;
            --this.size;
            return oldValue;
        }
        index2 = this.hash3(hashCode2);
        if (this.keyTable[index2] == key2) {
            this.keyTable[index2] = null;
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = null;
            --this.size;
            return oldValue;
        }
        if (this.isBigTable && this.keyTable[index2 = this.hash4(hashCode2)] == key2) {
            this.keyTable[index2] = null;
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = null;
            --this.size;
            return oldValue;
        }
        return this.removeStash(key2);
    }

    V removeStash(K key2) {
        int i2;
        K[] keyTable = this.keyTable;
        int n2 = i2 + this.stashSize;
        for (i2 = this.capacity; i2 < n2; ++i2) {
            if (keyTable[i2] != key2) continue;
            V oldValue = this.valueTable[i2];
            this.removeStashIndex(i2);
            --this.size;
            return oldValue;
        }
        return null;
    }

    void removeStashIndex(int index2) {
        --this.stashSize;
        int lastIndex = this.capacity + this.stashSize;
        if (index2 < lastIndex) {
            this.keyTable[index2] = this.keyTable[lastIndex];
            this.valueTable[index2] = this.valueTable[lastIndex];
            this.valueTable[lastIndex] = null;
        } else {
            this.valueTable[index2] = null;
        }
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        if (this.size > maximumCapacity) {
            maximumCapacity = this.size;
        }
        if (this.capacity <= maximumCapacity) {
            return;
        }
        maximumCapacity = ObjectMap.nextPowerOfTwo(maximumCapacity);
        this.resize(maximumCapacity);
    }

    public void clear(int maximumCapacity) {
        if (this.capacity <= maximumCapacity) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(maximumCapacity);
    }

    public void clear() {
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i2 = this.capacity + this.stashSize;
        while (i2-- > 0) {
            keyTable[i2] = null;
            valueTable[i2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsValue(Object value2, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value2 == null) {
            K[] keyTable = this.keyTable;
            int i2 = this.capacity + this.stashSize;
            while (i2-- > 0) {
                if (keyTable[i2] == null || valueTable[i2] != null) continue;
                return true;
            }
        } else if (identity) {
            int i3 = this.capacity + this.stashSize;
            while (i3-- > 0) {
                if (valueTable[i3] != value2) continue;
                return true;
            }
        } else {
            int i4 = this.capacity + this.stashSize;
            while (i4-- > 0) {
                if (!value2.equals(valueTable[i4])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(K key2) {
        int hashCode2 = System.identityHashCode(key2);
        int index2 = hashCode2 & this.mask;
        if (key2 != this.keyTable[index2] && key2 != this.keyTable[index2 = this.hash2(hashCode2)] && key2 != this.keyTable[index2 = this.hash3(hashCode2)]) {
            if (this.isBigTable) {
                index2 = this.hash4(hashCode2);
                if (key2 != this.keyTable[index2]) {
                    return this.containsKeyStash(key2);
                }
            } else {
                return this.containsKeyStash(key2);
            }
        }
        return true;
    }

    private boolean containsKeyStash(K key2) {
        int i2;
        K[] keyTable = this.keyTable;
        int n2 = i2 + this.stashSize;
        for (i2 = this.capacity; i2 < n2; ++i2) {
            if (keyTable[i2] != key2) continue;
            return true;
        }
        return false;
    }

    public K findKey(Object value2, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value2 == null) {
            K[] keyTable = this.keyTable;
            int i2 = this.capacity + this.stashSize;
            while (i2-- > 0) {
                if (keyTable[i2] == null || valueTable[i2] != null) continue;
                return keyTable[i2];
            }
        } else if (identity) {
            int i3 = this.capacity + this.stashSize;
            while (i3-- > 0) {
                if (valueTable[i3] != value2) continue;
                return this.keyTable[i3];
            }
        } else {
            int i4 = this.capacity + this.stashSize;
            while (i4-- > 0) {
                if (!value2.equals(valueTable[i4])) continue;
                return this.keyTable[i4];
            }
        }
        return null;
    }

    public void ensureCapacity(int additionalCapacity) {
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded >= this.threshold) {
            this.resize(ObjectMap.nextPowerOfTwo((int)((float)sizeNeeded / this.loadFactor)));
        }
    }

    private void resize(int newSize) {
        int oldEndIndex = this.capacity + this.stashSize;
        this.capacity = newSize;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(newSize);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(newSize)) * 2);
        this.pushIterations = Math.max(Math.min(newSize, 8), (int)Math.sqrt(newSize) / 8);
        this.isBigTable = this.capacity >>> 16 != 0;
        K[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new Object[newSize + this.stashCapacity];
        this.valueTable = new Object[newSize + this.stashCapacity];
        int oldSize = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (oldSize > 0) {
            for (int i2 = 0; i2 < oldEndIndex; ++i2) {
                K key2 = oldKeyTable[i2];
                if (key2 == null) continue;
                this.putResize(key2, oldValueTable[i2]);
            }
        }
    }

    private int hash2(int h) {
        return ((h *= -1105259343) ^ h >>> this.hashShift) & this.mask;
    }

    private int hash3(int h) {
        return ((h *= -1262997959) ^ h >>> this.hashShift) & this.mask;
    }

    private int hash4(int h) {
        return ((h *= -825114047) ^ h >>> this.hashShift) & this.mask;
    }

    public String toString() {
        K key2;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i2 = keyTable.length;
        while (i2-- > 0) {
            key2 = keyTable[i2];
            if (key2 == null) continue;
            buffer.append(key2);
            buffer.append('=');
            buffer.append(valueTable[i2]);
            break;
        }
        while (i2-- > 0) {
            key2 = keyTable[i2];
            if (key2 == null) continue;
            buffer.append(", ");
            buffer.append(key2);
            buffer.append('=');
            buffer.append(valueTable[i2]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public Entries<K, V> entries() {
        if (this.entries == null) {
            this.entries = new Entries(this);
        } else {
            this.entries.reset();
        }
        return this.entries;
    }

    public Values<V> values() {
        if (this.values == null) {
            this.values = new Values(this);
        } else {
            this.values.reset();
        }
        return this.values;
    }

    public Keys<K> keys() {
        if (this.keys == null) {
            this.keys = new Keys(this);
        } else {
            this.keys.reset();
        }
        return this.keys;
    }

    public static class Keys<K>
    extends MapIterator<K, Object>
    implements Iterable<K>,
    Iterator<K> {
        public Keys(IdentityMap<K, ?> map) {
            super(map);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public K next() {
            Object key2 = this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key2;
        }

        @Override
        public Iterator<K> iterator() {
            return this;
        }

        public ArrayList<K> toArray() {
            ArrayList<K> array = new ArrayList<K>(this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    public static class Values<V>
    extends MapIterator<Object, V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(IdentityMap<?, V> map) {
            super(map);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public V next() {
            Object value2 = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return value2;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        public ArrayList<V> toArray() {
            ArrayList<V> array = new ArrayList<V>(this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public void toArray(ArrayList<V> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
        }
    }

    public static class Entries<K, V>
    extends MapIterator<K, V>
    implements Iterable<Entry<K, V>>,
    Iterator<Entry<K, V>> {
        private Entry<K, V> entry = new Entry();

        public Entries(IdentityMap<K, V> map) {
            super(map);
        }

        @Override
        public Entry<K, V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            K[] keyTable = this.map.keyTable;
            this.entry.key = keyTable[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<K, V>> iterator() {
            return this;
        }
    }

    private static class MapIterator<K, V> {
        public boolean hasNext;
        final IdentityMap<K, V> map;
        int nextIndex;
        int currentIndex;

        public MapIterator(IdentityMap<K, V> map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            this.hasNext = false;
            K[] keyTable = this.map.keyTable;
            int n2 = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n2) {
                if (keyTable[this.nextIndex] == null) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.currentIndex >= this.map.capacity) {
                this.map.removeStashIndex(this.currentIndex);
                this.nextIndex = this.currentIndex - 1;
                this.findNextIndex();
            } else {
                this.map.keyTable[this.currentIndex] = null;
                this.map.valueTable[this.currentIndex] = null;
            }
            this.currentIndex = -1;
            --this.map.size;
        }
    }

    public static class Entry<K, V> {
        public K key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

