/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.core.clustering;

import ml.combust.mleap.core.annotation.SparkCode;
import ml.combust.mleap.core.clustering.ClusteringTreeNode$;
import ml.combust.mleap.core.linalg.LinalgUtils$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.mleap.VectorWithNorm;
import org.apache.spark.ml.linalg.mleap.VectorWithNorm$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@SparkCode(uri="https://github.com/apache/spark/blob/v2.0.0/mllib/src/main/scala/org/apache/spark/mllib/clustering/BisectingKMeansModel.scala")
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u00016\u0011!c\u00117vgR,'/\u001b8h)J,WMT8eK*\u00111\u0001B\u0001\u000bG2,8\u000f^3sS:<'BA\u0003\u0007\u0003\u0011\u0019wN]3\u000b\u0005\u001dA\u0011!B7mK\u0006\u0004(BA\u0005\u000b\u0003\u001d\u0019w.\u001c2vgRT\u0011aC\u0001\u0003[2\u001c\u0001a\u0005\u0003\u0001\u001dQ9\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003\u001faI!!\u0007\t\u0003\u000fA\u0013x\u000eZ;di\"A1\u0004\u0001BK\u0002\u0013\u0005A$A\u0003j]\u0012,\u00070F\u0001\u001e!\tya$\u0003\u0002 !\t\u0019\u0011J\u001c;\t\u0011\u0005\u0002!\u0011#Q\u0001\nu\ta!\u001b8eKb\u0004\u0003\u0002C\u0012\u0001\u0005+\u0007I\u0011\u0001\u0013\u0002\u001d\r,g\u000e^3s/&$\bNT8s[V\tQ\u0005\u0005\u0002'c5\tqE\u0003\u0002\bQ)\u0011\u0011FK\u0001\u0007Y&t\u0017\r\\4\u000b\u0005-Y#B\u0001\u0017.\u0003\u0015\u0019\b/\u0019:l\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005I:#A\u0004,fGR|'oV5uQ:{'/\u001c\u0005\ti\u0001\u0011\t\u0012)A\u0005K\u0005y1-\u001a8uKJ<\u0016\u000e\u001e5O_Jl\u0007\u0005\u0003\u00057\u0001\tU\r\u0011\"\u00018\u0003!\u0019\u0007.\u001b7ee\u0016tW#\u0001\u001d\u0011\u0007=I4(\u0003\u0002;!\t)\u0011I\u001d:bsB\u0011A\bA\u0007\u0002\u0005!Aa\b\u0001B\tB\u0003%\u0001(A\u0005dQ&dGM]3oA!)\u0001\t\u0001C\u0001\u0003\u00061A(\u001b8jiz\"Ba\u000f\"D\t\")1d\u0010a\u0001;!)1e\u0010a\u0001K!)ag\u0010a\u0001q!9a\t\u0001b\u0001\n\u00039\u0015AB5t\u0019\u0016\fg-F\u0001I!\ty\u0011*\u0003\u0002K!\t9!i\\8mK\u0006t\u0007B\u0002'\u0001A\u0003%\u0001*A\u0004jg2+\u0017M\u001a\u0011\t\u000b9\u0003A\u0011\u0001\u000f\u0002\u00179,Xn\u00115jY\u0012\u0014XM\u001c\u0005\u0006!\u0002!\t!U\u0001\u0007G\u0016tG/\u001a:\u0016\u0003I\u0003\"a\u0015+\u000e\u0003!J!!\u0016\u0015\u0003\rY+7\r^8s\u0011\u00159\u0006\u0001\"\u0001Y\u0003\u001d\u0001(/\u001a3jGR$\"!H-\t\u000bi3\u0006\u0019\u0001*\u0002\u000bA|\u0017N\u001c;\t\u000b]\u0003A\u0011\u0002/\u0015\u0005u\u001b\u0007\u0003B\b_;\u0001L!a\u0018\t\u0003\rQ+\b\u000f\\33!\ty\u0011-\u0003\u0002c!\t1Ai\\;cY\u0016DQ\u0001Z.A\u0002\u0015\nQ\u0002]8j]R<\u0016\u000e\u001e5O_Jl\u0007\"B,\u0001\t\u00131GcA/hQ\")A-\u001aa\u0001K!)\u0011.\u001aa\u0001A\u0006!1m\\:uQ\t)7\u000e\u0005\u0002m_6\tQN\u0003\u0002o!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Al'a\u0002;bS2\u0014Xm\u0019\u0005\u0006e\u0002!\taN\u0001\nY\u0016\fgMT8eKNDq\u0001\u001e\u0001\u0002\u0002\u0013\u0005Q/\u0001\u0003d_BLH\u0003B\u001ewobDqaG:\u0011\u0002\u0003\u0007Q\u0004C\u0004$gB\u0005\t\u0019A\u0013\t\u000fY\u001a\b\u0013!a\u0001q!9!\u0010AI\u0001\n\u0003Y\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0002y*\u0012Q$`\u0016\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002[\u0006IQO\\2iK\u000e\\W\rZ\u0005\u0005\u0003\u000f\t\tAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0003\u0001#\u0003%\t!!\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0002\u0016\u0003KuD\u0011\"a\u0005\u0001#\u0003%\t!!\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0003\u0016\u0003quD\u0011\"a\u0007\u0001\u0003\u0003%\t%!\b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\t1\fgn\u001a\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u0012\u0005\u0019\u0019FO]5oO\"A\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005A$\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u00026\u0001\t\t\u0011\"\u0001\u00028\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001d\u0003\u007f\u00012aDA\u001e\u0013\r\ti\u0004\u0005\u0002\u0004\u0003:L\b\"CA!\u0003g\t\t\u00111\u0001\u001e\u0003\rAH%\r\u0005\n\u0003\u000b\u0002\u0011\u0011!C!\u0003\u000f\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0013\u0002b!a\u0013\u0002R\u0005eRBAA'\u0015\r\ty\u0005E\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA*\u0003\u001b\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u0011\u0006m\u0003BCA!\u0003+\n\t\u00111\u0001\u0002:!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0013\u0011M\u0001\tQ\u0006\u001c\bnQ8eKR\tQ\u0004C\u0005\u0002f\u0001\t\t\u0011\"\u0011\u0002h\u0005AAo\\*ue&tw\r\u0006\u0002\u0002 !I\u00111\u000e\u0001\u0002\u0002\u0013\u0005\u0013QN\u0001\u0007KF,\u0018\r\\:\u0015\u0007!\u000by\u0007\u0003\u0006\u0002B\u0005%\u0014\u0011!a\u0001\u0003sAs\u0001AA:\u0003{\ny\b\u0005\u0003\u0002v\u0005eTBAA<\u0015\tqG!\u0003\u0003\u0002|\u0005]$!C*qCJ\\7i\u001c3f\u0003\r)(/[\u0011\u0003\u0003\u0003\u000bQ\u0010\u001b;uaNTtfL4ji\",(ML2p[>\n\u0007/Y2iK>\u001a\b/\u0019:l_\tdwNY\u0018we9\u0002d\u0006M\u0018nY2L'mL:sG>j\u0017-\u001b80g\u000e\fG.Y\u0018pe\u001e|\u0013\r]1dQ\u0016|3\u000f]1sW>jG\u000e\\5c_\rdWo\u001d;fe&twm\f\"jg\u0016\u001cG/\u001b8h\u00176+\u0017M\\:N_\u0012,GNL:dC2\fw!CAC\u0005\u0005\u0005\t\u0012AAD\u0003I\u0019E.^:uKJLgn\u001a+sK\u0016tu\u000eZ3\u0011\u0007q\nII\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAF'\u0015\tI)!$\u0015!!\ty)!&\u001eKaZTBAAI\u0015\r\t\u0019\nE\u0001\beVtG/[7f\u0013\u0011\t9*!%\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004A\u0003\u0013#\t!a'\u0015\u0005\u0005\u001d\u0005BCA3\u0003\u0013\u000b\t\u0011\"\u0012\u0002h!Q\u0011\u0011UAE\u0003\u0003%\t)a)\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fm\n)+a*\u0002*\"11$a(A\u0002uAaaIAP\u0001\u0004)\u0003B\u0002\u001c\u0002 \u0002\u0007\u0001\b\u0003\u0006\u0002.\u0006%\u0015\u0011!CA\u0003_\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00022\u0006u\u0006#B\b\u00024\u0006]\u0016bAA[!\t1q\n\u001d;j_:\u0004baDA];\u0015B\u0014bAA^!\t1A+\u001e9mKNB\u0011\"a0\u0002,\u0006\u0005\t\u0019A\u001e\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002D\u0006%\u0015\u0011!C\u0005\u0003\u000b\f1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0019\t\u0005\u0003C\tI-\u0003\u0003\u0002L\u0006\r\"AB(cU\u0016\u001cG\u000f")
public class ClusteringTreeNode
implements Serializable,
Product {
    private final int index;
    private final VectorWithNorm centerWithNorm;
    private final ClusteringTreeNode[] children;
    private final boolean isLeaf;

    public static Option<Tuple3<Object, VectorWithNorm, ClusteringTreeNode[]>> unapply(ClusteringTreeNode clusteringTreeNode) {
        return ClusteringTreeNode$.MODULE$.unapply(clusteringTreeNode);
    }

    public static ClusteringTreeNode apply(int n2, VectorWithNorm vectorWithNorm, ClusteringTreeNode[] clusteringTreeNodeArray) {
        return ClusteringTreeNode$.MODULE$.apply(n2, vectorWithNorm, clusteringTreeNodeArray);
    }

    public static Function1<Tuple3<Object, VectorWithNorm, ClusteringTreeNode[]>, ClusteringTreeNode> tupled() {
        return ClusteringTreeNode$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<VectorWithNorm, Function1<ClusteringTreeNode[], ClusteringTreeNode>>> curried() {
        return ClusteringTreeNode$.MODULE$.curried();
    }

    public int index() {
        return this.index;
    }

    public VectorWithNorm centerWithNorm() {
        return this.centerWithNorm;
    }

    public ClusteringTreeNode[] children() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public int numChildren() {
        return this.children().length;
    }

    public Vector center() {
        return this.centerWithNorm().vector();
    }

    /*
     * WARNING - void declaration
     */
    public int predict(Vector point) {
        Tuple2<Object, Object> tuple2 = this.predict(VectorWithNorm$.MODULE$.apply(point));
        if (tuple2 != null) {
            void var2_5;
            int index2;
            int n2;
            int index3 = n2 = (index2 = tuple2._1$mcI$sp());
            return (int)var2_5;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm) {
        return this.predict(pointWithNorm, LinalgUtils$.MODULE$.fastSquaredDistance(this.centerWithNorm(), pointWithNorm));
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm, double cost) {
        Tuple2 tuple2;
        while (true) {
            double minCost;
            Tuple2 tuple22;
            if (this_.isLeaf()) {
                return new Tuple2.mcID.sp(this_.index(), cost);
            }
            tuple2 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this_.children()).map((Function1)new Serializable(this_, pointWithNorm){
                public static final long serialVersionUID = 0L;
                private final VectorWithNorm pointWithNorm$1;

                public final Tuple2<ClusteringTreeNode, Object> apply(ClusteringTreeNode child) {
                    return new Tuple2((Object)child, (Object)BoxesRunTime.boxToDouble((double)LinalgUtils$.MODULE$.fastSquaredDistance(child.centerWithNorm(), this.pointWithNorm$1)));
                }
                {
                    this.pointWithNorm$1 = pointWithNorm$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).minBy((Function1)new Serializable(this_){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<ClusteringTreeNode, Object> x$2) {
                    return x$2._2$mcD$sp();
                }
            }, (Ordering)Ordering.Double$.MODULE$);
            if (tuple2 == null) break;
            ClusteringTreeNode selectedChild = (ClusteringTreeNode)tuple2._1();
            double minCost2 = tuple2._2$mcD$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)selectedChild, (Object)BoxesRunTime.boxToDouble((double)minCost2));
            ClusteringTreeNode selectedChild2 = (ClusteringTreeNode)tuple23._1();
            cost = minCost = tuple23._2$mcD$sp();
            ClusteringTreeNode this_ = selectedChild2;
        }
        throw new MatchError((Object)tuple2);
    }

    public ClusteringTreeNode[] leafNodes() {
        return this.isLeaf() ? (ClusteringTreeNode[])((Object[])new ClusteringTreeNode[]{this}) : (ClusteringTreeNode[])Predef$.MODULE$.refArrayOps((Object[])this.children()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<ClusteringTreeNode> apply(ClusteringTreeNode x$4) {
                return Predef$.MODULE$.refArrayOps((Object[])x$4.leafNodes());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClusteringTreeNode.class)));
    }

    public ClusteringTreeNode copy(int index2, VectorWithNorm centerWithNorm, ClusteringTreeNode[] children) {
        return new ClusteringTreeNode(index2, centerWithNorm, children);
    }

    public int copy$default$1() {
        return this.index();
    }

    public VectorWithNorm copy$default$2() {
        return this.centerWithNorm();
    }

    public ClusteringTreeNode[] copy$default$3() {
        return this.children();
    }

    public String productPrefix() {
        return "ClusteringTreeNode";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n2 = x$1;
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.children();
                break;
            }
            case 1: {
                object = this.centerWithNorm();
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.index());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ClusteringTreeNode;
    }

    public int hashCode() {
        int n2 = -889275714;
        n2 = Statics.mix((int)n2, (int)this.index());
        n2 = Statics.mix((int)n2, (int)Statics.anyHash((Object)this.centerWithNorm()));
        n2 = Statics.mix((int)n2, (int)Statics.anyHash((Object)this.children()));
        return Statics.finalizeHash((int)n2, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ClusteringTreeNode)) return false;
        boolean bl = true;
        if (!bl) return false;
        ClusteringTreeNode clusteringTreeNode = (ClusteringTreeNode)x$1;
        if (this.index() != clusteringTreeNode.index()) return false;
        VectorWithNorm vectorWithNorm = this.centerWithNorm();
        VectorWithNorm vectorWithNorm2 = clusteringTreeNode.centerWithNorm();
        if (vectorWithNorm == null) {
            if (vectorWithNorm2 != null) {
                return false;
            }
        } else if (!((Object)vectorWithNorm).equals(vectorWithNorm2)) return false;
        if (this.children() != clusteringTreeNode.children()) return false;
        if (!clusteringTreeNode.canEqual(this)) return false;
        return true;
    }

    public ClusteringTreeNode(int index2, VectorWithNorm centerWithNorm, ClusteringTreeNode[] children) {
        this.index = index2;
        this.centerWithNorm = centerWithNorm;
        this.children = children;
        Product.class.$init$((Product)this);
        this.isLeaf = Predef$.MODULE$.refArrayOps((Object[])children).isEmpty();
        Predef$.MODULE$.require(this.isLeaf() && index2 >= 0 || !this.isLeaf() && index2 < 0);
    }
}

