/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.core.clustering;

import ml.combust.mleap.core.annotation.SparkCode;
import ml.combust.mleap.core.clustering.GaussianMixtureModel;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.mleap.Utils$;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GaussianMixtureModel$
implements Serializable {
    public static final GaussianMixtureModel$ MODULE$;

    static {
        new GaussianMixtureModel$();
    }

    @SparkCode(uri="https://github.com/apache/spark/blob/branch-2.0/mllib/src/main/scala/org/apache/spark/ml/clustering/GaussianMixture.scala")
    public double[] computeProbabilities(DenseVector features, MultivariateGaussian[] dists, double[] weights) {
        double[] p = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(weights).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])dists), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(features){
            public static final long serialVersionUID = 0L;
            private final DenseVector features$1;

            public final double apply(Tuple2<Object, MultivariateGaussian> x0$1) {
                Tuple2<Object, MultivariateGaussian> tuple2 = x0$1;
                if (tuple2 != null) {
                    double weight = tuple2._1$mcD$sp();
                    MultivariateGaussian dist = (MultivariateGaussian)tuple2._2();
                    double d2 = Utils$.MODULE$.EPSILON() + weight * dist.pdf((Vector)this.features$1);
                    return d2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.features$1 = features$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double pSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(p).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        int i2 = 0;
        while (i2 < weights.length) {
            int n2 = i2++;
            p[n2] = p[n2] / pSum;
        }
        return p;
    }

    public GaussianMixtureModel apply(MultivariateGaussian[] gaussians, double[] weights) {
        return new GaussianMixtureModel(gaussians, weights);
    }

    public Option<Tuple2<MultivariateGaussian[], double[]>> unapply(GaussianMixtureModel x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.gaussians(), (Object)x$0.weights()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GaussianMixtureModel$() {
        MODULE$ = this;
    }
}

