/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.com.typesafe.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigException;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigNode;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigNodeValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ConfigNodeComment;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ConfigNodePath;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ConfigNodeSingleToken;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Token;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Tokens;

final class ConfigNodeField
extends AbstractConfigNode {
    private final ArrayList<AbstractConfigNode> children;

    public ConfigNodeField(Collection<AbstractConfigNode> children) {
        this.children = new ArrayList<AbstractConfigNode>(children);
    }

    @Override
    protected Collection<Token> tokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (AbstractConfigNode child : this.children) {
            tokens.addAll(child.tokens());
        }
        return tokens;
    }

    public ConfigNodeField replaceValue(AbstractConfigNodeValue newValue) {
        ArrayList<AbstractConfigNode> childrenCopy = new ArrayList<AbstractConfigNode>(this.children);
        for (int i2 = 0; i2 < childrenCopy.size(); ++i2) {
            if (!(childrenCopy.get(i2) instanceof AbstractConfigNodeValue)) continue;
            childrenCopy.set(i2, newValue);
            return new ConfigNodeField(childrenCopy);
        }
        throw new ConfigException.BugOrBroken("Field node doesn't have a value");
    }

    public AbstractConfigNodeValue value() {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (!(this.children.get(i2) instanceof AbstractConfigNodeValue)) continue;
            return (AbstractConfigNodeValue)this.children.get(i2);
        }
        throw new ConfigException.BugOrBroken("Field node doesn't have a value");
    }

    public ConfigNodePath path() {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (!(this.children.get(i2) instanceof ConfigNodePath)) continue;
            return (ConfigNodePath)this.children.get(i2);
        }
        throw new ConfigException.BugOrBroken("Field node doesn't have a path");
    }

    protected Token separator() {
        for (AbstractConfigNode child : this.children) {
            Token t2;
            if (!(child instanceof ConfigNodeSingleToken) || (t2 = ((ConfigNodeSingleToken)child).token()) != Tokens.PLUS_EQUALS && t2 != Tokens.COLON && t2 != Tokens.EQUALS) continue;
            return t2;
        }
        return null;
    }

    protected List<String> comments() {
        ArrayList<String> comments = new ArrayList<String>();
        for (AbstractConfigNode child : this.children) {
            if (!(child instanceof ConfigNodeComment)) continue;
            comments.add(((ConfigNodeComment)child).commentText());
        }
        return comments;
    }
}

