/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.com.typesafe.config.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigException;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigNodeValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ConfigReference;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ConfigString;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Path;
import ml.combust.mleap.shaded.com.typesafe.config.impl.PathParser;
import ml.combust.mleap.shaded.com.typesafe.config.impl.SubstitutionExpression;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Token;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Tokens;

final class ConfigNodeSimpleValue
extends AbstractConfigNodeValue {
    final Token token;

    ConfigNodeSimpleValue(Token value2) {
        this.token = value2;
    }

    @Override
    protected Collection<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    protected Token token() {
        return this.token;
    }

    protected AbstractConfigValue value() {
        if (Tokens.isValue(this.token)) {
            return Tokens.getValue(this.token);
        }
        if (Tokens.isUnquotedText(this.token)) {
            return new ConfigString.Unquoted(this.token.origin(), Tokens.getUnquotedText(this.token));
        }
        if (Tokens.isSubstitution(this.token)) {
            List<Token> expression = Tokens.getSubstitutionPathExpression(this.token);
            Path path2 = PathParser.parsePathExpression(expression.iterator(), this.token.origin());
            boolean optional2 = Tokens.getSubstitutionOptional(this.token);
            return new ConfigReference(this.token.origin(), new SubstitutionExpression(path2, optional2));
        }
        throw new ConfigException.BugOrBroken("ConfigNodeSimpleValue did not contain a valid value token");
    }
}

