/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft;

import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckFloatFFT {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65530, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static int[] sizes2D2 = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static int[] sizes3D2 = new int[]{2, 4, 8, 16, 32, 64, 128};
    private static double eps = Math.pow(2.0, -23.0);

    private AccuracyCheckFloatFFT() {
    }

    public static void checkAccuracyComplexFFT_1D() {
        System.out.println("Checking accuracy of 1D complex FFT...");
        int i2 = 0;
        while (i2 < sizes1D.length) {
            FloatFFT_1D fft = new FloatFFT_1D(sizes1D[i2]);
            double err = 0.0;
            float[] a = new float[2 * sizes1D[i2]];
            IOUtils.fillMatrix_1D(2 * sizes1D[i2], a);
            float[] b2 = new float[2 * sizes1D[i2]];
            IOUtils.fillMatrix_1D(2 * sizes1D[i2], b2);
            fft.complexForward(a);
            fft.complexInverse(a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyComplexFFT_2D() {
        Object b2;
        Object a;
        double err;
        FloatFFT_2D fft2;
        System.out.println("Checking accuracy of 2D complex FFT (float[] input)...");
        int i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new float[2 * sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], a);
            b2 = new float[2 * sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], b2);
            fft2.complexForward((float[])a);
            fft2.complexInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D complex FFT (float[][] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new float[sizes2D[i2]][2 * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], (float[][])a);
            b2 = new float[sizes2D[i2]][2 * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], 2 * sizes2D[i2], (float[][])b2);
            fft2.complexForward((float[][])a);
            fft2.complexInverse((float[][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][])a, (float[][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyComplexFFT_3D() {
        Object b2;
        Object a;
        double err;
        FloatFFT_3D fft3;
        System.out.println("Checking accuracy of 3D complex FFT (float[] input)...");
        int i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new float[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], a);
            b2 = new float[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], b2);
            fft3.complexForward((float[])a);
            fft3.complexInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D complex FFT (float[][][] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new float[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], (float[][][])a);
            b2 = new float[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], 2 * sizes3D[i2], (float[][][])b2);
            fft3.complexForward((float[][][])a);
            fft3.complexInverse((float[][][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][][])a, (float[][][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyRealFFT_1D() {
        int j;
        float[] b2;
        float[] a;
        double err;
        FloatFFT_1D fft;
        System.out.println("Checking accuracy of 1D real FFT...");
        int i2 = 0;
        while (i2 < sizes1D.length) {
            fft = new FloatFFT_1D(sizes1D[i2]);
            err = 0.0;
            a = new float[sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], a);
            b2 = new float[sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], b2);
            fft.realForward(a);
            fft.realInverse(a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of on 1D real forward full FFT...");
        i2 = 0;
        while (i2 < sizes1D.length) {
            fft = new FloatFFT_1D(sizes1D[i2]);
            err = 0.0;
            a = new float[2 * sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], a);
            b2 = new float[2 * sizes1D[i2]];
            j = 0;
            while (j < sizes1D[i2]) {
                b2[2 * j] = a[j];
                ++j;
            }
            fft.realForwardFull(a);
            fft.complexInverse(a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 1D real inverse full FFT...");
        i2 = 0;
        while (i2 < sizes1D.length) {
            fft = new FloatFFT_1D(sizes1D[i2]);
            err = 0.0;
            a = new float[2 * sizes1D[i2]];
            IOUtils.fillMatrix_1D(sizes1D[i2], a);
            b2 = new float[2 * sizes1D[i2]];
            j = 0;
            while (j < sizes1D[i2]) {
                b2[2 * j] = a[j];
                ++j;
            }
            fft.realInverseFull(a, true);
            fft.complexForward(a);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyRealFFT_2D() {
        int c;
        int r;
        Object b2;
        Object a;
        double err;
        FloatFFT_2D fft2;
        System.out.println("Checking accuracy of 2D real FFT (float[] input)...");
        int i2 = 0;
        while (i2 < sizes2D2.length) {
            fft2 = new FloatFFT_2D(sizes2D2[i2], sizes2D2[i2]);
            err = 0.0;
            a = new float[sizes2D2[i2] * sizes2D2[i2]];
            IOUtils.fillMatrix_2D(sizes2D2[i2], sizes2D2[i2], a);
            b2 = new float[sizes2D2[i2] * sizes2D2[i2]];
            IOUtils.fillMatrix_2D(sizes2D2[i2], sizes2D2[i2], b2);
            fft2.realForward((float[])a);
            fft2.realInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D2[i2] + " x " + sizes2D2[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D2[i2] + " x " + sizes2D2[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real FFT (float[][] input)...");
        i2 = 0;
        while (i2 < sizes2D2.length) {
            fft2 = new FloatFFT_2D(sizes2D2[i2], sizes2D2[i2]);
            err = 0.0;
            a = new float[sizes2D2[i2]][sizes2D2[i2]];
            IOUtils.fillMatrix_2D(sizes2D2[i2], sizes2D2[i2], (float[][])a);
            b2 = new float[sizes2D2[i2]][sizes2D2[i2]];
            IOUtils.fillMatrix_2D(sizes2D2[i2], sizes2D2[i2], (float[][])b2);
            fft2.realForward((float[][])a);
            fft2.realInverse((float[][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][])a, (float[][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D2[i2] + " x " + sizes2D2[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D2[i2] + " x " + sizes2D2[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (float[] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new float[2 * sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], a);
            b2 = new float[2 * sizes2D[i2] * sizes2D[i2]];
            r = 0;
            while (r < sizes2D[i2]) {
                c = 0;
                while (c < sizes2D[i2]) {
                    b2[r * 2 * AccuracyCheckFloatFFT.sizes2D[i2] + 2 * c] = a[r * sizes2D[i2] + c];
                    ++c;
                }
                ++r;
            }
            fft2.realForwardFull((float[])a);
            fft2.complexInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (float[][] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new float[sizes2D[i2]][2 * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], (float[][])a);
            b2 = new float[sizes2D[i2]][2 * sizes2D[i2]];
            r = 0;
            while (r < sizes2D[i2]) {
                c = 0;
                while (c < sizes2D[i2]) {
                    b2[r][2 * c] = a[r][c];
                    ++c;
                }
                ++r;
            }
            fft2.realForwardFull((float[][])a);
            fft2.complexInverse((float[][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][])a, (float[][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (float[] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new float[2 * sizes2D[i2] * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], a);
            b2 = new float[2 * sizes2D[i2] * sizes2D[i2]];
            r = 0;
            while (r < sizes2D[i2]) {
                c = 0;
                while (c < sizes2D[i2]) {
                    b2[r * 2 * AccuracyCheckFloatFFT.sizes2D[i2] + 2 * c] = a[r * sizes2D[i2] + c];
                    ++c;
                }
                ++r;
            }
            fft2.realInverseFull((float[])a, true);
            fft2.complexForward((float[])a);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (float[][] input)...");
        i2 = 0;
        while (i2 < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i2], sizes2D[i2]);
            err = 0.0;
            a = new float[sizes2D[i2]][2 * sizes2D[i2]];
            IOUtils.fillMatrix_2D(sizes2D[i2], sizes2D[i2], (float[][])a);
            b2 = new float[sizes2D[i2]][2 * sizes2D[i2]];
            r = 0;
            while (r < sizes2D[i2]) {
                c = 0;
                while (c < sizes2D[i2]) {
                    b2[r][2 * c] = a[r][c];
                    ++c;
                }
                ++r;
            }
            fft2.realInverseFull((float[][])a, true);
            fft2.complexForward((float[][])a);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][])a, (float[][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i2] + " x " + sizes2D[i2] + ";\terror = " + err);
            }
            a = null;
            b2 = null;
            fft2 = null;
            System.gc();
            ++i2;
        }
    }

    public static void checkAccuracyRealFFT_3D() {
        int c;
        int r;
        int s2;
        Object b2;
        Object a;
        double err;
        FloatFFT_3D fft3;
        System.out.println("Checking accuracy of 3D real FFT (float[] input)...");
        int i2 = 0;
        while (i2 < sizes3D2.length) {
            fft3 = new FloatFFT_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2]);
            err = 0.0;
            a = new float[sizes3D2[i2] * sizes3D2[i2] * sizes3D2[i2]];
            IOUtils.fillMatrix_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2], a);
            b2 = new float[sizes3D2[i2] * sizes3D2[i2] * sizes3D2[i2]];
            IOUtils.fillMatrix_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2], b2);
            fft3.realForward((float[])b2);
            fft3.realInverse((float[])b2, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D2[i2] + " x " + sizes3D2[i2] + " x " + sizes3D2[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D2[i2] + " x " + sizes3D2[i2] + " x " + sizes3D2[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real FFT (float[][][] input)...");
        i2 = 0;
        while (i2 < sizes3D2.length) {
            fft3 = new FloatFFT_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2]);
            err = 0.0;
            a = new float[sizes3D2[i2]][sizes3D2[i2]][sizes3D2[i2]];
            IOUtils.fillMatrix_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2], (float[][][])a);
            b2 = new float[sizes3D2[i2]][sizes3D2[i2]][sizes3D2[i2]];
            IOUtils.fillMatrix_3D(sizes3D2[i2], sizes3D2[i2], sizes3D2[i2], (float[][][])b2);
            fft3.realForward((float[][][])b2);
            fft3.realInverse((float[][][])b2, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][][])a, (float[][][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D2[i2] + " x " + sizes3D2[i2] + " x " + sizes3D2[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D2[i2] + " x " + sizes3D2[i2] + " x " + sizes3D2[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (float[] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new float[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], a);
            b2 = new float[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            s2 = 0;
            while (s2 < sizes3D[i2]) {
                r = 0;
                while (r < sizes3D[i2]) {
                    c = 0;
                    while (c < sizes3D[i2]) {
                        b2[s2 * 2 * AccuracyCheckFloatFFT.sizes3D[i2] * AccuracyCheckFloatFFT.sizes3D[i2] + r * 2 * AccuracyCheckFloatFFT.sizes3D[i2] + 2 * c] = a[s2 * sizes3D[i2] * sizes3D[i2] + r * sizes3D[i2] + c];
                        ++c;
                    }
                    ++r;
                }
                ++s2;
            }
            fft3.realForwardFull((float[])a);
            fft3.complexInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (float[][][] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new float[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], (float[][][])a);
            b2 = new float[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            s2 = 0;
            while (s2 < sizes3D[i2]) {
                r = 0;
                while (r < sizes3D[i2]) {
                    c = 0;
                    while (c < sizes3D[i2]) {
                        b2[s2][r][2 * c] = a[s2][r][c];
                        ++c;
                    }
                    ++r;
                }
                ++s2;
            }
            fft3.realForwardFull((float[][][])a);
            fft3.complexInverse((float[][][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][][])a, (float[][][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (float[] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new float[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], a);
            b2 = new float[2 * sizes3D[i2] * sizes3D[i2] * sizes3D[i2]];
            s2 = 0;
            while (s2 < sizes3D[i2]) {
                r = 0;
                while (r < sizes3D[i2]) {
                    c = 0;
                    while (c < sizes3D[i2]) {
                        b2[s2 * 2 * AccuracyCheckFloatFFT.sizes3D[i2] * AccuracyCheckFloatFFT.sizes3D[i2] + r * 2 * AccuracyCheckFloatFFT.sizes3D[i2] + 2 * c] = a[s2 * sizes3D[i2] * sizes3D[i2] + r * sizes3D[i2] + c];
                        ++c;
                    }
                    ++r;
                }
                ++s2;
            }
            fft3.realInverseFull((float[])a, true);
            fft3.complexForward((float[])a);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (float[][][] input)...");
        i2 = 0;
        while (i2 < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2]);
            err = 0.0;
            a = new float[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            IOUtils.fillMatrix_3D(sizes3D[i2], sizes3D[i2], sizes3D[i2], (float[][][])a);
            b2 = new float[sizes3D[i2]][sizes3D[i2]][2 * sizes3D[i2]];
            s2 = 0;
            while (s2 < sizes3D[i2]) {
                r = 0;
                while (r < sizes3D[i2]) {
                    c = 0;
                    while (c < sizes3D[i2]) {
                        b2[s2][r][2 * c] = a[s2][r][c];
                        ++c;
                    }
                    ++r;
                }
                ++s2;
            }
            fft3.realInverseFull((float[][][])a, true);
            fft3.complexForward((float[][][])a);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][][])a, (float[][][])b2);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i2] + " x " + sizes3D[i2] + " x " + sizes3D[i2] + ";\t\terror = " + err);
            }
            a = null;
            b2 = null;
            fft3 = null;
            System.gc();
            ++i2;
        }
    }

    private static double computeRMSE(float[] a, float[] b2) {
        if (a.length != b2.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int i2 = 0;
        while (i2 < a.length) {
            double tmp = a[i2] - b2[i2];
            rms += tmp * tmp;
            ++i2;
        }
        return Math.sqrt(rms / (double)a.length);
    }

    private static double computeRMSE(float[][] a, float[][] b2) {
        if (a.length != b2.length || a[0].length != b2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int r = 0;
        while (r < a.length) {
            int c = 0;
            while (c < a[0].length) {
                double tmp = a[r][c] - b2[r][c];
                rms += tmp * tmp;
                ++c;
            }
            ++r;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length));
    }

    private static double computeRMSE(float[][][] a, float[][][] b2) {
        if (a.length != b2.length || a[0].length != b2[0].length || a[0][0].length != b2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int s2 = 0;
        while (s2 < a.length) {
            int r = 0;
            while (r < a[0].length) {
                int c = 0;
                while (c < a[0][0].length) {
                    double tmp = a[s2][r][c] - b2[s2][r][c];
                    rms += tmp * tmp;
                    ++c;
                }
                ++r;
            }
            ++s2;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length * a[0][0].length));
    }

    public static void main(String[] args) {
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_1D();
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_1D();
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_2D();
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_2D();
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_3D();
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_3D();
        System.exit(0);
    }
}

