/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.org.apache.commons.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ml.combust.mleap.shaded.org.apache.commons.io.IOCase;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.AgeFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.AndFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.DelegateFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.DirectoryFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.FalseFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.FileFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.IOFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.MagicNumberFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.NameFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.NotFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.OrFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.PrefixFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.SizeFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.SuffixFileFilter;
import ml.combust.mleap.shaded.org.apache.commons.io.filefilter.TrueFileFilter;

public class FileFilterUtils {
    private static final IOFileFilter cvsFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter("CVS")));
    private static final IOFileFilter svnFilter = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter(".svn")));

    public static File[] filter(IOFileFilter filter2, File ... files) {
        if (filter2 == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (files == null) {
            return new File[0];
        }
        ArrayList<File> acceptedFiles = new ArrayList<File>();
        for (File file2 : files) {
            if (file2 == null) {
                throw new IllegalArgumentException("file array contains null");
            }
            if (!filter2.accept(file2)) continue;
            acceptedFiles.add(file2);
        }
        return acceptedFiles.toArray(new File[acceptedFiles.size()]);
    }

    public static File[] filter(IOFileFilter filter2, Iterable<File> files) {
        List<File> acceptedFiles = FileFilterUtils.filterList(filter2, files);
        return acceptedFiles.toArray(new File[acceptedFiles.size()]);
    }

    public static List<File> filterList(IOFileFilter filter2, Iterable<File> files) {
        return FileFilterUtils.filter(filter2, files, new ArrayList());
    }

    public static List<File> filterList(IOFileFilter filter2, File ... files) {
        File[] acceptedFiles = FileFilterUtils.filter(filter2, files);
        return Arrays.asList(acceptedFiles);
    }

    public static Set<File> filterSet(IOFileFilter filter2, File ... files) {
        File[] acceptedFiles = FileFilterUtils.filter(filter2, files);
        return new HashSet<File>(Arrays.asList(acceptedFiles));
    }

    public static Set<File> filterSet(IOFileFilter filter2, Iterable<File> files) {
        return FileFilterUtils.filter(filter2, files, new HashSet());
    }

    private static <T extends Collection<File>> T filter(IOFileFilter filter2, Iterable<File> files, T acceptedFiles) {
        if (filter2 == null) {
            throw new IllegalArgumentException("file filter is null");
        }
        if (files != null) {
            for (File file2 : files) {
                if (file2 == null) {
                    throw new IllegalArgumentException("file collection contains null");
                }
                if (!filter2.accept(file2)) continue;
                acceptedFiles.add((File)file2);
            }
        }
        return acceptedFiles;
    }

    public static IOFileFilter prefixFileFilter(String prefix) {
        return new PrefixFileFilter(prefix);
    }

    public static IOFileFilter prefixFileFilter(String prefix, IOCase caseSensitivity) {
        return new PrefixFileFilter(prefix, caseSensitivity);
    }

    public static IOFileFilter suffixFileFilter(String suffix2) {
        return new SuffixFileFilter(suffix2);
    }

    public static IOFileFilter suffixFileFilter(String suffix2, IOCase caseSensitivity) {
        return new SuffixFileFilter(suffix2, caseSensitivity);
    }

    public static IOFileFilter nameFileFilter(String name2) {
        return new NameFileFilter(name2);
    }

    public static IOFileFilter nameFileFilter(String name2, IOCase caseSensitivity) {
        return new NameFileFilter(name2, caseSensitivity);
    }

    public static IOFileFilter directoryFileFilter() {
        return DirectoryFileFilter.DIRECTORY;
    }

    public static IOFileFilter fileFileFilter() {
        return FileFileFilter.FILE;
    }

    @Deprecated
    public static IOFileFilter andFileFilter(IOFileFilter filter1, IOFileFilter filter2) {
        return new AndFileFilter(filter1, filter2);
    }

    @Deprecated
    public static IOFileFilter orFileFilter(IOFileFilter filter1, IOFileFilter filter2) {
        return new OrFileFilter(filter1, filter2);
    }

    public static IOFileFilter and(IOFileFilter ... filters) {
        return new AndFileFilter(FileFilterUtils.toList(filters));
    }

    public static IOFileFilter or(IOFileFilter ... filters) {
        return new OrFileFilter(FileFilterUtils.toList(filters));
    }

    public static List<IOFileFilter> toList(IOFileFilter ... filters) {
        if (filters == null) {
            throw new IllegalArgumentException("The filters must not be null");
        }
        ArrayList<IOFileFilter> list2 = new ArrayList<IOFileFilter>(filters.length);
        for (int i2 = 0; i2 < filters.length; ++i2) {
            if (filters[i2] == null) {
                throw new IllegalArgumentException("The filter[" + i2 + "] is null");
            }
            list2.add(filters[i2]);
        }
        return list2;
    }

    public static IOFileFilter notFileFilter(IOFileFilter filter2) {
        return new NotFileFilter(filter2);
    }

    public static IOFileFilter trueFileFilter() {
        return TrueFileFilter.TRUE;
    }

    public static IOFileFilter falseFileFilter() {
        return FalseFileFilter.FALSE;
    }

    public static IOFileFilter asFileFilter(FileFilter filter2) {
        return new DelegateFileFilter(filter2);
    }

    public static IOFileFilter asFileFilter(FilenameFilter filter2) {
        return new DelegateFileFilter(filter2);
    }

    public static IOFileFilter ageFileFilter(long cutoff) {
        return new AgeFileFilter(cutoff);
    }

    public static IOFileFilter ageFileFilter(long cutoff, boolean acceptOlder) {
        return new AgeFileFilter(cutoff, acceptOlder);
    }

    public static IOFileFilter ageFileFilter(Date cutoffDate) {
        return new AgeFileFilter(cutoffDate);
    }

    public static IOFileFilter ageFileFilter(Date cutoffDate, boolean acceptOlder) {
        return new AgeFileFilter(cutoffDate, acceptOlder);
    }

    public static IOFileFilter ageFileFilter(File cutoffReference) {
        return new AgeFileFilter(cutoffReference);
    }

    public static IOFileFilter ageFileFilter(File cutoffReference, boolean acceptOlder) {
        return new AgeFileFilter(cutoffReference, acceptOlder);
    }

    public static IOFileFilter sizeFileFilter(long threshold2) {
        return new SizeFileFilter(threshold2);
    }

    public static IOFileFilter sizeFileFilter(long threshold2, boolean acceptLarger) {
        return new SizeFileFilter(threshold2, acceptLarger);
    }

    public static IOFileFilter sizeRangeFileFilter(long minSizeInclusive, long maxSizeInclusive) {
        SizeFileFilter minimumFilter = new SizeFileFilter(minSizeInclusive, true);
        SizeFileFilter maximumFilter = new SizeFileFilter(maxSizeInclusive + 1L, false);
        return new AndFileFilter(minimumFilter, maximumFilter);
    }

    public static IOFileFilter magicNumberFileFilter(String magicNumber) {
        return new MagicNumberFileFilter(magicNumber);
    }

    public static IOFileFilter magicNumberFileFilter(String magicNumber, long offset) {
        return new MagicNumberFileFilter(magicNumber, offset);
    }

    public static IOFileFilter magicNumberFileFilter(byte[] magicNumber) {
        return new MagicNumberFileFilter(magicNumber);
    }

    public static IOFileFilter magicNumberFileFilter(byte[] magicNumber, long offset) {
        return new MagicNumberFileFilter(magicNumber, offset);
    }

    public static IOFileFilter makeCVSAware(IOFileFilter filter2) {
        if (filter2 == null) {
            return cvsFilter;
        }
        return FileFilterUtils.and(filter2, cvsFilter);
    }

    public static IOFileFilter makeSVNAware(IOFileFilter filter2) {
        if (filter2 == null) {
            return svnFilter;
        }
        return FileFilterUtils.and(filter2, svnFilter);
    }

    public static IOFileFilter makeDirectoryOnly(IOFileFilter filter2) {
        if (filter2 == null) {
            return DirectoryFileFilter.DIRECTORY;
        }
        return new AndFileFilter(DirectoryFileFilter.DIRECTORY, filter2);
    }

    public static IOFileFilter makeFileOnly(IOFileFilter filter2) {
        if (filter2 == null) {
            return FileFileFilter.FILE;
        }
        return new AndFileFilter(FileFileFilter.FILE, filter2);
    }
}

