/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.executor.repository;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import ml.combust.mleap.executor.error.BundleException;
import ml.combust.mleap.executor.repository.FileRepositoryConfig;
import ml.combust.mleap.executor.repository.FileRepositoryConfig$;
import ml.combust.mleap.executor.repository.Repository;
import scala.Function0;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q4A\u0001D\u0007\u00011!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\r]\u0002\u0001\u0015!\u0003.\u0011\u001dA\u0004A1A\u0005\u0004eBaa\u0010\u0001!\u0002\u0013Q\u0004\"B\u0014\u0001\t\u0003\u0001\u0005\"B!\u0001\t\u0003\u0012\u0005\"\u0002,\u0001\t\u0003:\u0006\"\u0002/\u0001\t\u0003j\u0006\"B1\u0001\t\u0003\u0012'A\u0004$jY\u0016\u0014V\r]8tSR|'/\u001f\u0006\u0003\u001d=\t!B]3q_NLGo\u001c:z\u0015\t\u0001\u0012#\u0001\u0005fq\u0016\u001cW\u000f^8s\u0015\t\u00112#A\u0003nY\u0016\f\u0007O\u0003\u0002\u0015+\u000591m\\7ckN$(\"\u0001\f\u0002\u00055d7\u0001A\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!C5\tQ\"\u0003\u0002#\u001b\tQ!+\u001a9pg&$xN]=\u0002\r\r|gNZ5h!\t\u0001S%\u0003\u0002'\u001b\t!b)\u001b7f%\u0016\u0004xn]5u_JL8i\u001c8gS\u001e\fa\u0001P5oSRtDCA\u0015+!\t\u0001\u0003\u0001C\u0003$\u0005\u0001\u0007A%\u0001\u0006uQJ,\u0017\r\u001a)p_2,\u0012!\f\t\u0003]Uj\u0011a\f\u0006\u0003aE\n!bY8oGV\u0014(/\u001a8u\u0015\t\u00114'\u0001\u0003vi&d'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003m=\u0012q\"\u0012=fGV$xN]*feZL7-Z\u0001\fi\"\u0014X-\u00193Q_>d\u0007%\u0001\u0004eSN\\WiY\u000b\u0002uA\u00111(P\u0007\u0002y)\u0011\u0001gG\u0005\u0003}q\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u000f\u0011L7o[#dAQ\t\u0011&\u0001\be_^tGn\\1e\u0005VtG\r\\3\u0015\u0005\rs\u0005cA\u001eE\r&\u0011Q\t\u0010\u0002\u0007\rV$XO]3\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00024jY\u0016T!aS\u001a\u0002\u00079Lw.\u0003\u0002N\u0011\n!\u0001+\u0019;i\u0011\u0015y\u0005\u00021\u0001Q\u0003\r)(/\u001b\t\u0003#Rk\u0011A\u0015\u0006\u0003'N\n1A\\3u\u0013\t)&KA\u0002V%&\u000b\u0011bY1o\u0011\u0006tG\r\\3\u0015\u0005a[\u0006C\u0001\u000eZ\u0013\tQ6DA\u0004C_>dW-\u00198\t\u000b=K\u0001\u0019\u0001)\u0002\u0011MDW\u000f\u001e3po:$\u0012A\u0018\t\u00035}K!\u0001Y\u000e\u0003\tUs\u0017\u000e^\u0001\u0011C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:$2AX2i\u0011\u0015!7\u00021\u0001f\u0003\u001d!\u0018.\\3pkR\u0004\"A\u00074\n\u0005\u001d\\\"\u0001\u0002'p]\u001eDQ![\u0006A\u0002)\fA!\u001e8jiB\u00111.\u001f\b\u0003YZt!!\u001c;\u000f\u00059\u001chBA8s\u001b\u0005\u0001(BA9\u0018\u0003\u0019a$o\\8u}%\tA$\u0003\u000217%\u0011Q\u000fP\u0001\tIV\u0014\u0018\r^5p]&\u0011q\u000f_\u0001\ba\u0006\u001c7.Y4f\u0015\t)H(\u0003\u0002{w\nAA+[7f+:LGO\u0003\u0002xq\u0002")
public class FileRepository
implements Repository {
    private final FileRepositoryConfig config;
    private final ExecutorService threadPool;
    private final ExecutionContext diskEc;

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    public ExecutionContext diskEc() {
        return this.diskEc;
    }

    @Override
    public Future<Path> downloadBundle(URI uri) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void v0;
            if (uri.getPath().isEmpty()) {
                throw new BundleException("file path cannot be empty");
            }
            Path local = new File(uri.getPath()).toPath();
            if (!Files.exists(local, new LinkOption[0])) {
                throw new BundleException(new StringBuilder(20).append("file does not exist ").append(local).toString());
            }
            if ($this.config.move()) {
                void var3_3;
                Path tmpFile = Files.createTempFile("mleap", ".bundle.zip", new FileAttribute[0]);
                Files.copy(local, tmpFile, StandardCopyOption.REPLACE_EXISTING);
                tmpFile.toFile().deleteOnExit();
                v0 = var3_3;
            } else {
                void var2_2;
                v0 = var2_2;
            }
            return v0;
        }, this.diskEc());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHandle(URI uri) {
        String string = uri.getScheme();
        String string2 = "file";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = uri.getScheme();
        String string4 = "jar:file";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public void shutdown() {
        this.threadPool().shutdown();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.threadPool().awaitTermination(timeout, unit);
    }

    public FileRepository(FileRepositoryConfig config) {
        this.config = config;
        this.threadPool = Executors.newFixedThreadPool(config.threads());
        this.diskEc = ExecutionContext$.MODULE$.fromExecutor((Executor)this.threadPool());
    }

    public FileRepository() {
        this(new FileRepositoryConfig(FileRepositoryConfig$.MODULE$.defaults()));
    }
}

