/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.executor.repository;

import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import ml.combust.mleap.executor.repository.HttpRepositoryConfig;
import ml.combust.mleap.executor.repository.Repository;
import scala.Function0;
import scala.Serializable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i4Aa\u0003\u0007\u0001/!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u0004+\u0001\t\u0007I\u0011B\u0016\t\rY\u0002\u0001\u0015!\u0003-\u0011\u001d9\u0004A1A\u0005\u0004aBaA\u0010\u0001!\u0002\u0013I\u0004\"B \u0001\t\u0003\u0002\u0005\"\u0002+\u0001\t\u0003*\u0006\"\u0002.\u0001\t\u0003Z\u0006\"B0\u0001\t\u0003\u0002'A\u0004%uiB\u0014V\r]8tSR|'/\u001f\u0006\u0003\u001b9\t!B]3q_NLGo\u001c:z\u0015\ty\u0001#\u0001\u0005fq\u0016\u001cW\u000f^8s\u0015\t\t\"#A\u0003nY\u0016\f\u0007O\u0003\u0002\u0014)\u000591m\\7ckN$(\"A\u000b\u0002\u00055d7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 A5\tA\"\u0003\u0002\"\u0019\tQ!+\u001a9pg&$xN]=\u0002\r\r|gNZ5h!\tyB%\u0003\u0002&\u0019\t!\u0002\n\u001e;q%\u0016\u0004xn]5u_JL8i\u001c8gS\u001e\fa\u0001P5oSRtDC\u0001\u0015*!\ty\u0002\u0001C\u0003#\u0005\u0001\u00071%\u0001\u0006uQJ,\u0017\r\u001a)p_2,\u0012\u0001\f\t\u0003[Qj\u0011A\f\u0006\u0003_A\n!bY8oGV\u0014(/\u001a8u\u0015\t\t$'\u0001\u0003vi&d'\"A\u001a\u0002\t)\fg/Y\u0005\u0003k9\u0012q\"\u0012=fGV$xN]*feZL7-Z\u0001\fi\"\u0014X-\u00193Q_>d\u0007%\u0001\u0004eSN\\WiY\u000b\u0002sA\u0011!\bP\u0007\u0002w)\u0011qFG\u0005\u0003{m\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u000f\u0011L7o[#dA\u0005qAm\\<oY>\fGMQ;oI2,GCA!M!\rQ$\tR\u0005\u0003\u0007n\u0012aAR;ukJ,\u0007CA#K\u001b\u00051%BA$I\u0003\u00111\u0017\u000e\\3\u000b\u0005%\u0013\u0014a\u00018j_&\u00111J\u0012\u0002\u0005!\u0006$\b\u000eC\u0003N\u000f\u0001\u0007a*A\u0002ve&\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u001a\u0002\u00079,G/\u0003\u0002T!\n\u0019QKU%\u0002\u0013\r\fg\u000eS1oI2,GC\u0001,Z!\tIr+\u0003\u0002Y5\t9!i\\8mK\u0006t\u0007\"B'\t\u0001\u0004q\u0015\u0001C:ikR$wn\u001e8\u0015\u0003q\u0003\"!G/\n\u0005yS\"\u0001B+oSR\f\u0001#Y<bSR$VM]7j]\u0006$\u0018n\u001c8\u0015\u0007q\u000bg\rC\u0003c\u0015\u0001\u00071-A\u0004uS6,w.\u001e;\u0011\u0005e!\u0017BA3\u001b\u0005\u0011auN\\4\t\u000b\u001dT\u0001\u0019\u00015\u0002\tUt\u0017\u000e\u001e\t\u0003S^t!A\u001b;\u000f\u0005-\u0014hB\u00017r\u001d\ti\u0007/D\u0001o\u0015\tyg#\u0001\u0004=e>|GOP\u0005\u00027%\u0011qFG\u0005\u0003gn\n\u0001\u0002Z;sCRLwN\\\u0005\u0003kZ\fq\u0001]1dW\u0006<WM\u0003\u0002tw%\u0011\u00010\u001f\u0002\t)&lW-\u00168ji*\u0011QO\u001e")
public class HttpRepository
implements Repository {
    private final ExecutorService threadPool;
    private final ExecutionContext diskEc;

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    public ExecutionContext diskEc() {
        return this.diskEc;
    }

    @Override
    public Future<Path> downloadBundle(URI uri) {
        return Future$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            Path tmpFile = Files.createTempFile("mleap", ".bundle.zip", new FileAttribute[0]);
            Files.copy(uri.toURL().openStream(), tmpFile, new CopyOption[0]);
            return tmpFile;
        }, this.diskEc());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHandle(URI uri) {
        String string = uri.getScheme();
        String string2 = "http";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = uri.getScheme();
        String string4 = "https";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public void shutdown() {
        this.threadPool().shutdown();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.threadPool().awaitTermination(timeout, unit);
    }

    public HttpRepository(HttpRepositoryConfig config) {
        this.threadPool = Executors.newFixedThreadPool(config.threads());
        this.diskEc = ExecutionContext$.MODULE$.fromExecutor((Executor)this.threadPool());
    }
}

