/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.grpc.server;

import akka.Done$;
import akka.actor.ActorSystem;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import ml.combust.mleap.executor.MleapExecutor;
import ml.combust.mleap.executor.MleapExecutor$;
import ml.combust.mleap.grpc.server.ErrorInterceptor;
import ml.combust.mleap.grpc.server.GrpcServer;
import ml.combust.mleap.grpc.server.GrpcServerConfig;
import ml.combust.mleap.pb.MleapGrpc;
import ml.combust.mleap.pb.MleapGrpc$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001I3AAC\u0006\u0001-!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005(\u0001\t\u0005\t\u0015a\u0003)\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u001d9\u0004A1A\u0005\naBaa\u0010\u0001!\u0002\u0013I\u0004b\u0002!\u0001\u0001\u0004%I!\u0011\u0005\b\u0011\u0002\u0001\r\u0011\"\u0003J\u0011\u0019y\u0005\u0001)Q\u0005\u0005\")\u0001\u000b\u0001C\u0001#\nI!+\u001e8TKJ4XM\u001d\u0006\u0003\u00195\taa]3sm\u0016\u0014(B\u0001\b\u0010\u0003\u00119'\u000f]2\u000b\u0005A\t\u0012!B7mK\u0006\u0004(B\u0001\n\u0014\u0003\u001d\u0019w.\u001c2vgRT\u0011\u0001F\u0001\u0003[2\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\faaY8oM&<\u0007CA\u0010&\u001b\u0005\u0001#BA\u000f\"\u0015\t\u00113%\u0001\u0005usB,7/\u00194f\u0015\u0005!\u0013aA2p[&\u0011a\u0005\t\u0002\u0007\u0007>tg-[4\u0002\rML8\u000f^3n!\tIc&D\u0001+\u0015\tYC&A\u0003bGR|'OC\u0001.\u0003\u0011\t7n[1\n\u0005=R#aC!di>\u00148+_:uK6\fa\u0001P5oSRtDC\u0001\u001a7)\t\u0019T\u0007\u0005\u00025\u00015\t1\u0002C\u0003(\u0007\u0001\u000f\u0001\u0006C\u0003\u001e\u0007\u0001\u0007a$\u0001\u0004m_\u001e<WM]\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A(I\u0001\rg\u000e\fG.\u00197pO\u001eLgnZ\u0005\u0003}m\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\fG>|'\u000fZ5oCR|'/F\u0001C!\rA2)R\u0005\u0003\tf\u0011aa\u00149uS>t\u0007CA\u0015G\u0013\t9%FA\nD_>\u0014H-\u001b8bi\u0016$7\u000b[;uI><h.A\bd_>\u0014H-\u001b8bi>\u0014x\fJ3r)\tQU\n\u0005\u0002\u0019\u0017&\u0011A*\u0007\u0002\u0005+:LG\u000fC\u0004O\u000f\u0005\u0005\t\u0019\u0001\"\u0002\u0007a$\u0013'\u0001\u0007d_>\u0014H-\u001b8bi>\u0014\b%A\u0002sk:$\u0012A\u0013")
public class RunServer {
    private final Config config;
    private final ActorSystem system;
    private final Logger logger;
    private Option<CoordinatedShutdown> coordinator;

    private Logger logger() {
        return this.logger;
    }

    private Option<CoordinatedShutdown> coordinator() {
        return this.coordinator;
    }

    private void coordinator_$eq(Option<CoordinatedShutdown> x$1) {
        this.coordinator = x$1;
    }

    public void run() {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Starting MLeap gRPC Server");
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            CoordinatedShutdown coordinator = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply($this.system);
            this.coordinator_$eq((Option<CoordinatedShutdown>)new Some((Object)coordinator));
            GrpcServerConfig grpcServerConfig = new GrpcServerConfig($this.config.getConfig("default"));
            MleapExecutor mleapExecutor = (MleapExecutor)MleapExecutor$.MODULE$.apply($this.system);
            int port = $this.config.getInt("port");
            None$ threads = $this.config.hasPath("threads") ? new Some((Object)BoxesRunTime.boxToInteger((int)$this.config.getInt("threads"))) : None$.MODULE$;
            int threadCount = BoxesRunTime.unboxToInt((Object)threads.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Math.min(Math.max(Runtime.getRuntime().availableProcessors() * 4, 32), 64)));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Creating thread pool for server with size {}", new Object[]{BoxesRunTime.boxToInteger((int)threadCount)});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            ExecutorService grpcThreadPool = Executors.newFixedThreadPool(threadCount);
            ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)grpcThreadPool);
            coordinator.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone(), "threadPoolShutdownNow", () -> RunServer.$anonfun$run$3(this, grpcThreadPool, (ExecutionContext)ec));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Creating executor service");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            GrpcServer grpcService = new GrpcServer(mleapExecutor, grpcServerConfig, $this.system);
            ServerBuilder builder = ServerBuilder.forPort((int)port);
            builder.intercept((ServerInterceptor)new ErrorInterceptor());
            builder.addService(MleapGrpc$.MODULE$.bindService((MleapGrpc.Mleap)grpcService, (ExecutionContext)ec));
            Server grpcServer = builder.build();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Starting server on port {}", new Object[]{BoxesRunTime.boxToInteger((int)port)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            grpcServer.start();
            coordinator.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind(), "grpcServiceShutdown", (Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Shutting down gRPC");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                grpcServer.shutdown();
                grpcServer.awaitTermination(10L, TimeUnit.SECONDS);
                return Done$.MODULE$;
            }, (ExecutionContext)ExecutionContext$.MODULE$.global()));
            coordinator.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceStop(), "grpcServiceShutdownNow", (Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Object object;
                if (!grpcServer.isShutdown()) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Shutting down gRPC NOW!");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    grpcServer.shutdownNow();
                    object = BoxesRunTime.boxToBoolean((boolean)grpcServer.awaitTermination(5L, TimeUnit.SECONDS));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return Done$.MODULE$;
            }, (ExecutionContext)ExecutionContext$.MODULE$.global()));
        });
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error encountered starting server", err);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.coordinator().foreach((Function1 & Serializable & scala.Serializable)c -> c.run((CoordinatedShutdown.Reason)CoordinatedShutdown.UnknownReason$.MODULE$));
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ Future $anonfun$run$3(RunServer $this, ExecutorService grpcThreadPool$1, ExecutionContext ec$1) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Shutting down gRPC thread pool");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            grpcThreadPool$1.shutdown();
            grpcThreadPool$1.awaitTermination(5L, TimeUnit.SECONDS);
            return Done$.MODULE$;
        }, ec$1);
    }

    public RunServer(Config config, ActorSystem system) {
        this.config = config;
        this.system = system;
        this.logger = Logger$.MODULE$.apply(RunServer.class);
        this.coordinator = None$.MODULE$;
    }
}

