/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.repository.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3URI;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import ml.combust.mleap.executor.repository.Repository;
import ml.combust.mleap.repository.s3.S3RepositoryConfig;
import scala.Function0;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0007\u000f\u0001eA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006Y\u0001!\t!\f\u0005\ba\u0001\u0011\r\u0011\"\u00032\u0011\u0019i\u0004\u0001)A\u0005e!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0004L\u0001\t\u0007I1\u0001'\t\rI\u0003\u0001\u0015!\u0003N\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u0015\u0019\b\u0001\"\u0011u\u00051\u00196GU3q_NLGo\u001c:z\u0015\ty\u0001#\u0001\u0002tg)\u0011\u0011CE\u0001\u000be\u0016\u0004xn]5u_JL(BA\n\u0015\u0003\u0015iG.Z1q\u0015\t)b#A\u0004d_6\u0014Wo\u001d;\u000b\u0003]\t!!\u001c7\u0004\u0001M\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\tS%D\u0001#\u0015\t\t2E\u0003\u0002%%\u0005AQ\r_3dkR|'/\u0003\u0002'E\tQ!+\u001a9pg&$xN]=\u0002\r\r|gNZ5h!\tI#&D\u0001\u000f\u0013\tYcB\u0001\nTgI+\u0007o\\:ji>\u0014\u0018pQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002/_A\u0011\u0011\u0006\u0001\u0005\u0006O\t\u0001\r\u0001K\u0001\u0007G2LWM\u001c;\u0016\u0003I\u0002\"aM\u001e\u000e\u0003QR!aD\u001b\u000b\u0005Y:\u0014\u0001C:feZL7-Z:\u000b\u0005aJ\u0014!C1nCj|g.Y<t\u0015\u0005Q\u0014aA2p[&\u0011A\b\u000e\u0002\t\u00036\f'p\u001c8Tg\u000591\r\\5f]R\u0004\u0013A\u0003;ie\u0016\fG\rU8pYV\t\u0001\t\u0005\u0002B\u00116\t!I\u0003\u0002D\t\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u00153\u0015\u0001B;uS2T\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\u0005\nyQ\t_3dkR|'oU3sm&\u001cW-A\u0006uQJ,\u0017\r\u001a)p_2\u0004\u0013A\u00023jg.,5-F\u0001N!\tq\u0005+D\u0001P\u0015\t\u0019E$\u0003\u0002R\u001f\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\bI&\u001c8.R2!\u00039!wn\u001e8m_\u0006$')\u001e8eY\u0016$\"!\u00161\u0011\u000793\u0006,\u0003\u0002X\u001f\n1a)\u001e;ve\u0016\u0004\"!\u00170\u000e\u0003iS!a\u0017/\u0002\t\u0019LG.\u001a\u0006\u0003;\u001a\u000b1A\\5p\u0013\ty&L\u0001\u0003QCRD\u0007\"B1\n\u0001\u0004\u0011\u0017aA;sSB\u00111MZ\u0007\u0002I*\u0011QMR\u0001\u0004]\u0016$\u0018BA4e\u0005\r)&+S\u0001\nG\u0006t\u0007*\u00198eY\u0016$\"A[7\u0011\u0005mY\u0017B\u00017\u001d\u0005\u001d\u0011un\u001c7fC:DQ!\u0019\u0006A\u0002\t\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002aB\u00111$]\u0005\u0003er\u0011A!\u00168ji\u0006\u0001\u0012m^1jiR+'/\\5oCRLwN\u001c\u000b\u0004aVT\b\"\u0002<\r\u0001\u00049\u0018a\u0002;j[\u0016|W\u000f\u001e\t\u00037aL!!\u001f\u000f\u0003\t1{gn\u001a\u0005\u0006w2\u0001\r\u0001`\u0001\u0005k:LG\u000fE\u0002~\u0003/q1A`A\t\u001d\ry\u0018Q\u0002\b\u0005\u0003\u0003\tYA\u0004\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9\u0001G\u0001\u0007yI|w\u000e\u001e \n\u0003uI!a\u0011\u000f\n\u0007\u0005=q*\u0001\u0005ekJ\fG/[8o\u0013\u0011\t\u0019\"!\u0006\u0002\u000fA\f7m[1hK*\u0019\u0011qB(\n\t\u0005e\u00111\u0004\u0002\t)&lW-\u00168ji*!\u00111CA\u000b\u0001")
public class S3Repository
implements Repository {
    private final AmazonS3 client = AmazonS3ClientBuilder.defaultClient();
    private final ExecutorService threadPool;
    private final ExecutionContext diskEc;

    private AmazonS3 client() {
        return this.client;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    public ExecutionContext diskEc() {
        return this.diskEc;
    }

    public Future<Path> downloadBundle(URI uri) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            AmazonS3URI s3Uri = new AmazonS3URI(uri);
            String bucket = s3Uri.getBucket();
            String key = s3Uri.getKey();
            Path tmpFile = Files.createTempFile("mleap", ".bundle.zip", new FileAttribute[0]);
            Files.copy((InputStream)this.client().getObject(bucket, key).getObjectContent(), tmpFile, new CopyOption[0]);
            return tmpFile;
        }, this.diskEc());
    }

    public boolean canHandle(URI uri) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new AmazonS3URI(uri)).isSuccess();
    }

    public void shutdown() {
        this.threadPool().shutdown();
    }

    public void awaitTermination(long timeout, TimeUnit unit) {
        this.threadPool().awaitTermination(timeout, unit);
    }

    public S3Repository(S3RepositoryConfig config) {
        this.threadPool = Executors.newFixedThreadPool(config.threads());
        this.diskEc = ExecutionContext$.MODULE$.fromExecutor((Executor)this.threadPool());
    }
}

