/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.bundle.ops.classification;

import ml.combust.bundle.BundleContext;
import ml.combust.bundle.dsl.Bundle;
import ml.combust.bundle.dsl.HasAttributes;
import ml.combust.bundle.dsl.Model;
import ml.combust.bundle.dsl.Value;
import ml.combust.bundle.dsl.Value$;
import ml.combust.bundle.op.OpModel;
import ml.combust.mleap.bundle.ops.MleapOp;
import ml.combust.mleap.core.classification.AbstractLogisticRegressionModel;
import ml.combust.mleap.core.classification.BinaryLogisticRegressionModel;
import ml.combust.mleap.core.classification.LogisticRegressionModel;
import ml.combust.mleap.core.classification.ProbabilisticLogisticsRegressionModel;
import ml.combust.mleap.runtime.MleapContext;
import ml.combust.mleap.runtime.transformer.classification.LogisticRegression;
import ml.combust.mleap.tensor.DenseTensor;
import ml.combust.mleap.tensor.Tensor;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001\u001f\t!Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u001fBT!a\u0001\u0003\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011QAB\u0001\u0004_B\u001c(BA\u0004\t\u0003\u0019\u0011WO\u001c3mK*\u0011\u0011BC\u0001\u0006[2,\u0017\r\u001d\u0006\u0003\u00171\tqaY8nEV\u001cHOC\u0001\u000e\u0003\tiGn\u0001\u0001\u0014\u0005\u0001\u0001\u0002\u0003B\t\u0013)ui\u0011\u0001B\u0005\u0003'\u0011\u0011q!\u00147fCB|\u0005\u000f\u0005\u0002\u001675\taC\u0003\u0002\u0004/)\u0011\u0001$G\u0001\fiJ\fgn\u001d4pe6,'O\u0003\u0002\u001b\u0011\u00059!/\u001e8uS6,\u0017B\u0001\u000f\u0017\u0005IaunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8\u0011\u0005y\u0011S\"A\u0010\u000b\u0005\r\u0001#BA\u0011\t\u0003\u0011\u0019wN]3\n\u0005\rz\"a\u0006'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\t!\u0001C\u0004+\u0001\t\u0007IQB\u0016\u0002K1{u)S*U\u0013\u000e{&+R$S\u000bN\u001b\u0016j\u0014(`\t\u00163\u0015)\u0016'U?RC%+R*I\u001f2#U#\u0001\u0017\u0010\u00035\u0002\u0003b\u0010q\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0005\u0007_\u0001\u0001\u000bQ\u0002\u0017\u0002M1{u)S*U\u0013\u000e{&+R$S\u000bN\u001b\u0016j\u0014(`\t\u00163\u0015)\u0016'U?RC%+R*I\u001f2#\u0005\u0005C\u00042\u0001\t\u0007I\u0011\t\u001a\u0002\u000b5{G-\u001a7\u0016\u0003M\u0002B\u0001\u000e\u001d;;5\tQG\u0003\u00027o\u0005\u0011q\u000e\u001d\u0006\u0003\u000f)I!!O\u001b\u0003\u000f=\u0003Xj\u001c3fYB\u00111\bP\u0007\u00023%\u0011Q(\u0007\u0002\r\u001b2,\u0017\r]\"p]R,\u0007\u0010\u001e\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u001a\u0002\r5{G-\u001a7!\u0011\u0015\t\u0005\u0001\"\u0011C\u0003\u0015iw\u000eZ3m)\ti2\tC\u0003E\u0001\u0002\u0007A#\u0001\u0003o_\u0012,\u0007")
public class LogisticRegressionOp
extends MleapOp<LogisticRegression, LogisticRegressionModel> {
    private final double LOGISTIC_REGRESSION_DEFAULT_THRESHOLD;
    private final OpModel<MleapContext, LogisticRegressionModel> Model = new OpModel<MleapContext, LogisticRegressionModel>(this){
        private final Class<LogisticRegressionModel> klazz;

        public String modelOpName(Object obj, BundleContext context) {
            return OpModel.class.modelOpName((OpModel)this, (Object)obj, (BundleContext)context);
        }

        public Class<LogisticRegressionModel> klazz() {
            return this.klazz;
        }

        public String opName() {
            return Bundle.BuiltinOps$.classification$.MODULE$.logistic_regression();
        }

        public Model store(Model model, LogisticRegressionModel obj, BundleContext<MleapContext> context) {
            Model model2;
            Model m = (Model)model.withValue("num_classes", Value$.MODULE$.long((long)obj.numClasses()));
            if (obj.isMultinomial()) {
                ProbabilisticLogisticsRegressionModel mm = obj.multinomialModel();
                Matrix cm = mm.coefficientMatrix();
                model2 = (Model)((HasAttributes)((HasAttributes)m.withValue("coefficient_matrix", Value$.MODULE$.tensor((Tensor)new DenseTensor((Object)cm.toArray(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{cm.numRows(), cm.numCols()})), ClassTag$.MODULE$.Double())))).withValue("intercept_vector", Value$.MODULE$.vector((Object)mm.interceptVector().toArray(), ClassTag$.MODULE$.Double()))).withValue("thresholds", mm.thresholds().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(double[] x$1) {
                        return Predef$.MODULE$.doubleArrayOps(x$1).toSeq();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Value apply(Seq<Object> value) {
                        return Value$.MODULE$.doubleList(value);
                    }
                }));
            } else {
                model2 = (Model)((HasAttributes)((HasAttributes)m.withValue("coefficients", Value$.MODULE$.vector((Object)obj.binaryModel().coefficients().toArray(), ClassTag$.MODULE$.Double()))).withValue("intercept", Value$.MODULE$.double(obj.binaryModel().intercept()))).withValue("threshold", Value$.MODULE$.double(obj.binaryModel().threshold()));
            }
            return model2;
        }

        public LogisticRegressionModel load(Model model, BundleContext<MleapContext> context) {
            BinaryLogisticRegressionModel binaryLogisticRegressionModel;
            long numClasses = model.value("num_classes").getLong();
            if (numClasses > 2L) {
                Tensor tensor = model.value("coefficient_matrix").getTensor();
                Matrix cm = Matrices$.MODULE$.dense(BoxesRunTime.unboxToInt((Object)tensor.dimensions().head()), BoxesRunTime.unboxToInt((Object)tensor.dimensions().apply(1)), (double[])tensor.toArray());
                binaryLogisticRegressionModel = new ProbabilisticLogisticsRegressionModel(cm, Vectors$.MODULE$.dense((double[])model.value("intercept_vector").getTensor().toArray()), model.getValue("thresholds").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply(Value x$2) {
                        return (double[])x$2.getDoubleList().toArray(ClassTag$.MODULE$.Double());
                    }
                }));
            } else {
                double threshold = BoxesRunTime.unboxToDouble((Object)model.getValue("threshold").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Value value) {
                        return value.getDouble();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 0.5;
                    }
                }));
                binaryLogisticRegressionModel = new BinaryLogisticRegressionModel(Vectors$.MODULE$.dense((double[])model.value("coefficients").getTensor().toArray()), model.value("intercept").getDouble(), threshold);
            }
            BinaryLogisticRegressionModel lm = binaryLogisticRegressionModel;
            return new LogisticRegressionModel((AbstractLogisticRegressionModel)lm);
        }
        {
            OpModel.class.$init$((OpModel)this);
            this.klazz = LogisticRegressionModel.class;
        }
    };

    private final double LOGISTIC_REGRESSION_DEFAULT_THRESHOLD() {
        return 0.5;
    }

    public OpModel<MleapContext, LogisticRegressionModel> Model() {
        return this.Model;
    }

    public LogisticRegressionModel model(LogisticRegression node) {
        return node.model();
    }

    public LogisticRegressionOp() {
        super(ClassTag$.MODULE$.apply(LogisticRegression.class));
    }
}

