/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.bundle;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import ml.combust.bundle.BundleRegistry;
import ml.combust.bundle.BundleRegistry$;
import ml.combust.mleap.ClassLoaderUtil$;
import org.apache.spark.ml.bundle.SparkBundleContext;
import org.apache.spark.package$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;

public final class SparkBundleContext$
implements Serializable {
    public static final SparkBundleContext$ MODULE$;
    private final String DEFAULT_REGISTRY_KEY;
    private final String sparkVersion;
    private final String versionedRegistryKey;
    private SparkBundleContext defaultContext;
    private volatile boolean bitmap$0;

    static {
        new SparkBundleContext$();
    }

    private SparkBundleContext defaultContext$lzycompute() {
        SparkBundleContext$ sparkBundleContext$ = this;
        synchronized (sparkBundleContext$) {
            if (!this.bitmap$0) {
                this.defaultContext = this.apply((Option<Dataset<Row>>)None$.MODULE$, (Option<ClassLoader>)new Some((Object)SparkBundleContext.class.getClassLoader()));
                this.bitmap$0 = true;
            }
            return this.defaultContext;
        }
    }

    public String DEFAULT_REGISTRY_KEY() {
        return this.DEFAULT_REGISTRY_KEY;
    }

    private String sparkVersion() {
        return this.sparkVersion;
    }

    private String versionedRegistryKey() {
        return this.versionedRegistryKey;
    }

    public SparkBundleContext defaultContext() {
        return this.bitmap$0 ? this.defaultContext : this.defaultContext$lzycompute();
    }

    public SparkBundleContext apply(Option<Dataset<Row>> dataset) {
        return this.apply(dataset, (Option<ClassLoader>)None$.MODULE$);
    }

    public SparkBundleContext apply(Option<Dataset<Row>> dataset, Option<ClassLoader> clOption) {
        ClassLoader cl = (ClassLoader)clOption.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ClassLoader apply() {
                return ClassLoaderUtil$.MODULE$.findClassLoader(SparkBundleContext.class.getCanonicalName());
            }
        });
        Config config = ConfigFactory.load((ClassLoader)cl);
        String registryKey = config.hasPath(this.DEFAULT_REGISTRY_KEY()) ? this.DEFAULT_REGISTRY_KEY() : this.versionedRegistryKey();
        return new SparkBundleContext(dataset, BundleRegistry$.MODULE$.apply(registryKey, (Option)new Some((Object)cl)));
    }

    public Option<Dataset<Row>> apply$default$1() {
        return None$.MODULE$;
    }

    public SparkBundleContext apply(Option<Dataset<Row>> dataset, BundleRegistry bundleRegistry) {
        return new SparkBundleContext(dataset, bundleRegistry);
    }

    public Option<Tuple2<Option<Dataset<Row>>, BundleRegistry>> unapply(SparkBundleContext x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.dataset(), (Object)x$0.bundleRegistry()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkBundleContext$() {
        block6: {
            String string;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            MODULE$ = this;
                            this.DEFAULT_REGISTRY_KEY = "ml.combust.mleap.spark.registry.default";
                            this.sparkVersion = package$.MODULE$.SPARK_VERSION();
                            if (!this.sparkVersion().startsWith("2.0")) break block2;
                            string = "ml.combust.mleap.spark.registry.v20";
                            break block3;
                        }
                        if (!this.sparkVersion().startsWith("2.1")) break block4;
                        string = "ml.combust.mleap.spark.registry.v21";
                        break block3;
                    }
                    if (!this.sparkVersion().startsWith("2.2")) break block5;
                    string = "ml.combust.mleap.spark.registry.v22";
                    break block3;
                }
                if (!this.sparkVersion().startsWith("2.3")) break block6;
                string = "ml.combust.mleap.spark.registry.v23";
            }
            this.versionedRegistryKey = string;
            return;
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported Spark version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sparkVersion()})));
    }
}

