/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.mleap;

import java.math.BigDecimal;
import ml.combust.mleap.core.types.BasicType;
import ml.combust.mleap.core.types.Casting$;
import ml.combust.mleap.core.types.DataShape;
import ml.combust.mleap.core.types.ListShape;
import ml.combust.mleap.core.types.ListType;
import ml.combust.mleap.core.types.ListType$;
import ml.combust.mleap.core.types.ScalarShape;
import ml.combust.mleap.core.types.ScalarType;
import ml.combust.mleap.core.types.ScalarType$;
import ml.combust.mleap.core.types.TensorShape;
import ml.combust.mleap.core.types.TensorType;
import ml.combust.mleap.core.types.TensorType$;
import ml.combust.mleap.core.util.VectorConverters$;
import ml.combust.mleap.tensor.DenseTensor;
import ml.combust.mleap.tensor.Tensor;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.MatrixUDT;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.mleap.TypeConverters;
import org.apache.spark.sql.mleap.TypeConverters$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public abstract class TypeConverters$class {
    private static int getVectorSize(TypeConverters $this, Dataset dataset, StructField field) {
        Try sizeInMeta = Try$.MODULE$.apply((Function0)new Serializable($this, field){
            public static final long serialVersionUID = 0L;
            private final StructField field$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return (int)this.field$1.metadata().getMetadata("ml_attr").getLong("num_attrs");
            }
            {
                this.field$1 = field$1;
            }
        });
        return sizeInMeta.isSuccess() ? BoxesRunTime.unboxToInt((Object)sizeInMeta.get()) : ((Vector)((Row)dataset.select(field.name(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getAs(0)).size();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Function1 sparkToMleapValue(TypeConverters $this, DataType dataType) {
        void var3_8;
        DataType dataType2 = dataType;
        if (dataType2 instanceof DecimalType) {
            Serializable serializable = new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final double apply(Object v) {
                    return ((BigDecimal)v).doubleValue();
                }
            };
            return var3_8;
        }
        if (dataType2 instanceof VectorUDT) {
            Serializable serializable = new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Tensor<Object> apply(Object v) {
                    return VectorConverters$.MODULE$.sparkVectorToMleapTensor((Vector)v);
                }
            };
            return var3_8;
        }
        if (dataType2 instanceof MatrixUDT) {
            Serializable serializable = new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Tensor<Object> apply(Object v) {
                    return VectorConverters$.MODULE$.sparkMatrixToMleapTensor((Matrix)v);
                }
            };
            return var3_8;
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType dataType3 = arrayType.elementType();
            VectorUDT vectorUDT = new VectorUDT();
            if (!(dataType3 != null ? !dataType3.equals(vectorUDT) : vectorUDT != null)) {
                Serializable serializable = new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final DenseTensor<Object> apply(Object v) {
                        WrappedArray t = (WrappedArray)v;
                        int s = ((Vector)t.head()).size();
                        double[] values = (double[])((WrappedArray)t.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ArrayOps<Object> apply(Vector x$1) {
                                return Predef$.MODULE$.doubleArrayOps(x$1.toArray());
                            }
                        }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.Double());
                        return new DenseTensor((Object)values, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{t.size(), s})), ClassTag$.MODULE$.Double());
                    }
                };
                return var3_8;
            }
        }
        Serializable serializable = new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object v) {
                return v;
            }
        };
        return var3_8;
    }

    public static Tuple2 sparkToMleapConverter(TypeConverters $this, Dataset dataset, StructField field) {
        return new Tuple2((Object)$this.sparkFieldToMleapField((Dataset<Row>)dataset, field), $this.sparkToMleapValue(field.dataType()));
    }

    public static ml.combust.mleap.core.types.StructField sparkFieldToMleapField(TypeConverters $this, Dataset dataset, StructField field) {
        DataType dataType;
        block23: {
            ScalarType scalarType;
            block3: {
                DataType elementType;
                ArrayType arrayType;
                boolean bl;
                block22: {
                    block21: {
                        block20: {
                            ArrayType arrayType2;
                            DataType dataType2;
                            DataType dataType3;
                            block19: {
                                DataType dataType4;
                                block18: {
                                    DataType dataType5;
                                    block17: {
                                        DataType dataType6;
                                        block16: {
                                            DataType dataType7;
                                            block15: {
                                                DataType dataType8;
                                                block14: {
                                                    DataType dataType9;
                                                    block13: {
                                                        DataType dataType10;
                                                        block12: {
                                                            block11: {
                                                                block10: {
                                                                    block9: {
                                                                        block8: {
                                                                            block7: {
                                                                                block6: {
                                                                                    block5: {
                                                                                        block4: {
                                                                                            block2: {
                                                                                                bl = false;
                                                                                                arrayType = null;
                                                                                                dataType = field.dataType();
                                                                                                if (!BooleanType$.MODULE$.equals(dataType)) break block2;
                                                                                                scalarType = ScalarType$.MODULE$.Boolean();
                                                                                                break block3;
                                                                                            }
                                                                                            if (!ByteType$.MODULE$.equals(dataType)) break block4;
                                                                                            scalarType = ScalarType$.MODULE$.Byte();
                                                                                            break block3;
                                                                                        }
                                                                                        if (!ShortType$.MODULE$.equals(dataType)) break block5;
                                                                                        scalarType = ScalarType$.MODULE$.Short();
                                                                                        break block3;
                                                                                    }
                                                                                    if (!IntegerType$.MODULE$.equals(dataType)) break block6;
                                                                                    scalarType = ScalarType$.MODULE$.Int();
                                                                                    break block3;
                                                                                }
                                                                                if (!LongType$.MODULE$.equals(dataType)) break block7;
                                                                                scalarType = ScalarType$.MODULE$.Long();
                                                                                break block3;
                                                                            }
                                                                            if (!FloatType$.MODULE$.equals(dataType)) break block8;
                                                                            scalarType = ScalarType$.MODULE$.Float();
                                                                            break block3;
                                                                        }
                                                                        if (!DoubleType$.MODULE$.equals(dataType)) break block9;
                                                                        scalarType = ScalarType$.MODULE$.Double();
                                                                        break block3;
                                                                    }
                                                                    if (!(dataType instanceof DecimalType)) break block10;
                                                                    scalarType = ScalarType$.MODULE$.Double();
                                                                    break block3;
                                                                }
                                                                if (!StringType$.MODULE$.equals(dataType)) break block11;
                                                                scalarType = ScalarType$.MODULE$.String().setNullable(field.nullable());
                                                                break block3;
                                                            }
                                                            if (!(dataType instanceof ArrayType)) break block12;
                                                            bl = true;
                                                            arrayType = (ArrayType)dataType;
                                                            DataType dataType11 = arrayType.elementType();
                                                            if (!ByteType$.MODULE$.equals(dataType11)) break block12;
                                                            scalarType = ListType$.MODULE$.Byte();
                                                            break block3;
                                                        }
                                                        if (!bl || !BooleanType$.MODULE$.equals(dataType10 = arrayType.elementType())) break block13;
                                                        scalarType = ListType$.MODULE$.Boolean();
                                                        break block3;
                                                    }
                                                    if (!bl || !ShortType$.MODULE$.equals(dataType9 = arrayType.elementType())) break block14;
                                                    scalarType = ListType$.MODULE$.Short();
                                                    break block3;
                                                }
                                                if (!bl || !IntegerType$.MODULE$.equals(dataType8 = arrayType.elementType())) break block15;
                                                scalarType = ListType$.MODULE$.Int();
                                                break block3;
                                            }
                                            if (!bl || !LongType$.MODULE$.equals(dataType7 = arrayType.elementType())) break block16;
                                            scalarType = ListType$.MODULE$.Long();
                                            break block3;
                                        }
                                        if (!bl || !FloatType$.MODULE$.equals(dataType6 = arrayType.elementType())) break block17;
                                        scalarType = ListType$.MODULE$.Float();
                                        break block3;
                                    }
                                    if (!bl || !DoubleType$.MODULE$.equals(dataType5 = arrayType.elementType())) break block18;
                                    scalarType = ListType$.MODULE$.Double();
                                    break block3;
                                }
                                if (!bl || !StringType$.MODULE$.equals(dataType4 = arrayType.elementType())) break block19;
                                scalarType = ListType$.MODULE$.String();
                                break block3;
                            }
                            if (!bl || !((dataType3 = arrayType.elementType()) instanceof ArrayType) || !ByteType$.MODULE$.equals(dataType2 = (arrayType2 = (ArrayType)dataType3).elementType())) break block20;
                            scalarType = ListType$.MODULE$.ByteString();
                            break block3;
                        }
                        if (!(dataType instanceof VectorUDT)) break block21;
                        int size = TypeConverters$class.getVectorSize($this, dataset, field);
                        scalarType = TensorType$.MODULE$.Double((Seq)Predef$.MODULE$.wrapIntArray(new int[]{size}));
                        break block3;
                    }
                    if (!(dataType instanceof MatrixUDT)) break block22;
                    Matrix m = (Matrix)((Row)dataset.select(field.name(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getAs(0);
                    scalarType = TensorType$.MODULE$.Double((Seq)Predef$.MODULE$.wrapIntArray(new int[]{m.numRows(), m.numCols()}));
                    break block3;
                }
                if (!bl) break block23;
                DataType dataType12 = elementType = arrayType.elementType();
                VectorUDT vectorUDT = new VectorUDT();
                if (dataType12 != null ? !dataType12.equals(vectorUDT) : vectorUDT != null) break block23;
                WrappedArray a = (WrappedArray)((Row)dataset.select(field.name(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getAs(0);
                scalarType = TensorType$.MODULE$.Double((Seq)Predef$.MODULE$.wrapIntArray(new int[]{a.length(), ((Vector)a.head()).size()}));
            }
            ScalarType dt = scalarType;
            return new ml.combust.mleap.core.types.StructField(field.name(), dt.setNullable(field.nullable()));
        }
        throw new MatchError((Object)dataType);
    }

    public static ml.combust.mleap.core.types.StructType sparkSchemaToMleapSchema(TypeConverters $this, Dataset dataset) {
        ml.combust.mleap.core.types.StructField[] fields = (ml.combust.mleap.core.types.StructField[])Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fields()).map((Function1)new Serializable($this, dataset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeConverters $outer;
            private final Dataset dataset$1;

            public final ml.combust.mleap.core.types.StructField apply(StructField f) {
                return this.$outer.sparkFieldToMleapField((Dataset<Row>)this.dataset$1, f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataset$1 = dataset$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ml.combust.mleap.core.types.StructField.class)));
        return (ml.combust.mleap.core.types.StructType)ml.combust.mleap.core.types.StructType$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])fields)).get();
    }

    public static DataType mleapBasicTypeToSparkType(TypeConverters $this, BasicType base) {
        BasicType basicType;
        block11: {
            BooleanType$ booleanType$;
            block3: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                basicType = base;
                                                if (!BasicType.Boolean$.MODULE$.equals(basicType)) break block2;
                                                booleanType$ = BooleanType$.MODULE$;
                                                break block3;
                                            }
                                            if (!BasicType.Byte$.MODULE$.equals(basicType)) break block4;
                                            booleanType$ = ByteType$.MODULE$;
                                            break block3;
                                        }
                                        if (!BasicType.Short$.MODULE$.equals(basicType)) break block5;
                                        booleanType$ = ShortType$.MODULE$;
                                        break block3;
                                    }
                                    if (!BasicType.Int$.MODULE$.equals(basicType)) break block6;
                                    booleanType$ = IntegerType$.MODULE$;
                                    break block3;
                                }
                                if (!BasicType.Long$.MODULE$.equals(basicType)) break block7;
                                booleanType$ = LongType$.MODULE$;
                                break block3;
                            }
                            if (!BasicType.Float$.MODULE$.equals(basicType)) break block8;
                            booleanType$ = FloatType$.MODULE$;
                            break block3;
                        }
                        if (!BasicType.Double$.MODULE$.equals(basicType)) break block9;
                        booleanType$ = DoubleType$.MODULE$;
                        break block3;
                    }
                    if (!BasicType.String$.MODULE$.equals(basicType)) break block10;
                    booleanType$ = StringType$.MODULE$;
                    break block3;
                }
                if (!BasicType.ByteString$.MODULE$.equals(basicType)) break block11;
                booleanType$ = new ArrayType((DataType)ByteType$.MODULE$, false);
            }
            return booleanType$;
        }
        throw new MatchError((Object)basicType);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Function1 mleapToSparkValue(TypeConverters $this, ml.combust.mleap.core.types.DataType dataType) {
        void var4_10;
        ml.combust.mleap.core.types.DataType dataType2 = dataType;
        if (dataType2 instanceof TensorType) {
            Object object;
            TensorType tensorType = (TensorType)dataType2;
            if (tensorType.dimensions().isEmpty()) {
                object = new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Object v) {
                        return ((Tensor)v).apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
                    }
                };
            } else if (Option$.MODULE$.option2Iterable(tensorType.dimensions()).size() == 1) {
                BasicType basicType = tensorType.base();
                BasicType.Double$ double$ = BasicType.Double$.MODULE$;
                if (!(basicType != null ? !basicType.equals(double$) : double$ != null)) {
                    object = new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final Vector apply(Object v) {
                            return VectorConverters$.MODULE$.mleapTensorToSparkVector((Tensor)v);
                        }
                    };
                } else {
                    Function1 c = (Function1)Casting$.MODULE$.basicCast().apply((Object)new Tuple2((Object)tensorType.base(), (Object)BasicType.Double$.MODULE$));
                    object = new Serializable($this, c){
                        public static final long serialVersionUID = 0L;
                        private final Function1 c$1;

                        public final Vector apply(Object v) {
                            return VectorConverters$.MODULE$.mleapTensorToSparkVector(((Tensor)v).mapValues(this.c$1, ClassTag$.MODULE$.Double()));
                        }
                        {
                            this.c$1 = c$1;
                        }
                    };
                }
            } else {
                if (Option$.MODULE$.option2Iterable(tensorType.dimensions()).size() != 2) throw new IllegalArgumentException("cannot convert tensor for non-scalar, vector or matrix tensor");
                BasicType basicType = tensorType.base();
                BasicType.Double$ double$ = BasicType.Double$.MODULE$;
                if (!(basicType != null ? !basicType.equals(double$) : double$ != null)) {
                    object = new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final Matrix apply(Object v) {
                            return VectorConverters$.MODULE$.mleapTensorToSparkMatrix((Tensor)v);
                        }
                    };
                } else {
                    Function1 c = (Function1)Casting$.MODULE$.basicCast().apply((Object)new Tuple2((Object)tensorType.base(), (Object)BasicType.Double$.MODULE$));
                    object = new Serializable($this, c){
                        public static final long serialVersionUID = 0L;
                        private final Function1 c$2;

                        public final Matrix apply(Object v) {
                            return VectorConverters$.MODULE$.mleapTensorToSparkMatrix(((Tensor)v).mapValues(this.c$2, ClassTag$.MODULE$.Double()));
                        }
                        {
                            this.c$2 = c$2;
                        }
                    };
                }
            }
            Serializable serializable = object;
            return var4_10;
        } else {
            Serializable serializable = new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object v) {
                    return v;
                }
            };
        }
        return var4_10;
    }

    public static Tuple2 mleapToSparkConverter(TypeConverters $this, ml.combust.mleap.core.types.StructField field) {
        ml.combust.mleap.core.types.DataType dataType;
        block5: {
            DataType dataType2;
            block3: {
                block4: {
                    block2: {
                        dataType = field.dataType();
                        if (!(dataType instanceof ScalarType)) break block2;
                        ScalarType scalarType = (ScalarType)dataType;
                        BasicType base = scalarType.base();
                        dataType2 = $this.mleapBasicTypeToSparkType(base);
                        break block3;
                    }
                    if (!(dataType instanceof ListType)) break block4;
                    ListType listType = (ListType)dataType;
                    BasicType base = listType.base();
                    dataType2 = new ArrayType($this.mleapBasicTypeToSparkType(base), false);
                    break block3;
                }
                if (!(dataType instanceof TensorType)) break block5;
                TensorType tensorType = (TensorType)dataType;
                dataType2 = $this.mleapTensorToSpark(tensorType);
            }
            DataType dt = dataType2;
            return new Tuple2((Object)new StructField(field.name(), dt, field.dataType().isNullable(), StructField$.MODULE$.apply$default$4()), $this.mleapToSparkValue(field.dataType()));
        }
        throw new MatchError((Object)dataType);
    }

    public static StructField mleapFieldToSparkField(TypeConverters $this, ml.combust.mleap.core.types.StructField field) {
        ml.combust.mleap.core.types.DataType dataType;
        block5: {
            DataType dataType2;
            block3: {
                block4: {
                    block2: {
                        dataType = field.dataType();
                        if (!(dataType instanceof ScalarType)) break block2;
                        ScalarType scalarType = (ScalarType)dataType;
                        BasicType base = scalarType.base();
                        dataType2 = $this.mleapBasicTypeToSparkType(base);
                        break block3;
                    }
                    if (!(dataType instanceof ListType)) break block4;
                    ListType listType = (ListType)dataType;
                    BasicType base = listType.base();
                    dataType2 = new ArrayType($this.mleapBasicTypeToSparkType(base), false);
                    break block3;
                }
                if (!(dataType instanceof TensorType)) break block5;
                TensorType tensorType = (TensorType)dataType;
                dataType2 = $this.mleapTensorToSpark(tensorType);
            }
            DataType dt = dataType2;
            return new StructField(field.name(), dt, field.dataType().isNullable(), StructField$.MODULE$.apply$default$4());
        }
        throw new MatchError((Object)dataType);
    }

    public static StructType mleapSchemaToSparkSchema(TypeConverters $this, ml.combust.mleap.core.types.StructType schema) {
        Seq fields = (Seq)schema.fields().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeConverters $outer;

            public final StructField apply(ml.combust.mleap.core.types.StructField field) {
                return this.$outer.mleapFieldToSparkField(field);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply(fields);
    }

    public static DataType mleapTensorToSpark(TypeConverters $this, TensorType tt) {
        block5: {
            DataType dataType;
            block3: {
                block4: {
                    block2: {
                        Predef$.MODULE$.assert(TypeConverters$.MODULE$.VECTOR_BASIC_TYPES().contains((Object)tt.base()), (Function0)new Serializable($this, tt){
                            public static final long serialVersionUID = 0L;
                            private final TensorType tt$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot convert tensor with base ", " to vector"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tt$1.base()}));
                            }
                            {
                                this.tt$1 = tt$1;
                            }
                        });
                        Predef$.MODULE$.assert(tt.dimensions().isDefined(), (Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "cannot convert tensor with undefined dimensions";
                            }
                        });
                        if (!tt.dimensions().isEmpty()) break block2;
                        dataType = $this.mleapBasicTypeToSparkType(tt.base());
                        break block3;
                    }
                    if (Option$.MODULE$.option2Iterable(tt.dimensions()).size() != 1) break block4;
                    dataType = new VectorUDT();
                    break block3;
                }
                if (Option$.MODULE$.option2Iterable(tt.dimensions()).size() != 2) break block5;
                dataType = new MatrixUDT();
            }
            return dataType;
        }
        throw new IllegalArgumentException("cannot convert tensor for non-scalar, vector or matrix tensor");
    }

    public static DataShape sparkToMleapDataShape(TypeConverters $this, StructField field, Dataset dataset) {
        block7: {
            ScalarShape scalarShape;
            block3: {
                DataType dataType;
                block6: {
                    block5: {
                        ArrayType arrayType;
                        boolean bl;
                        block4: {
                            block2: {
                                dataType = field.dataType();
                                boolean bl2 = BooleanType$.MODULE$.equals(dataType) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType)))))));
                                if (!bl2) break block2;
                                scalarShape = new ScalarShape(field.nullable());
                                break block3;
                            }
                            if (!(dataType instanceof DecimalType)) break block4;
                            scalarShape = new ScalarShape(field.nullable());
                            break block3;
                        }
                        if (!(dataType instanceof ArrayType) || (bl = (arrayType = (ArrayType)dataType).containsNull())) break block5;
                        scalarShape = new ListShape(field.nullable());
                        break block3;
                    }
                    if (!(dataType instanceof VectorUDT)) break block6;
                    int size = TypeConverters$class.getVectorSize($this, dataset, field);
                    scalarShape = new TensorShape((Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{size}))), field.nullable());
                    break block3;
                }
                if (!(dataType instanceof MatrixUDT)) break block7;
                Matrix m = (Matrix)((Row)dataset.select(field.name(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).getAs(0);
                scalarShape = new TensorShape((Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{m.numRows(), m.numCols()}))), field.nullable());
            }
            return scalarShape;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid struct field for shape: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field})));
    }

    public static void $init$(TypeConverters $this) {
    }
}

