/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.feature;

import ml.combust.mleap.core.annotation.SparkCode;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.mleap.feature.OneHotEncoderBase;
import org.apache.spark.ml.mleap.feature.OneHotEncoderModel$;
import org.apache.spark.ml.mleap.param.HasDropLast$class;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@SparkCode(uri="https://github.com/apache/spark/blob/v2.0.0/mllib/src/main/scala/org/apache/spark/ml/feature/OneHotEncoder.scala")
@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001=\u0011!c\u00148f\u0011>$XI\\2pI\u0016\u0014Xj\u001c3fY*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!A\u0003nY\u0016\f\u0007O\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0019\u0011C\u0005\u000b\u000e\u0003\u0019I!a\u0005\u0004\u0003\u000b5{G-\u001a7\u0011\u0005U\u0001Q\"\u0001\u0002\u0011\u0005U9\u0012B\u0001\r\u0003\u0005Eye.\u001a%pi\u0016s7m\u001c3fe\n\u000b7/\u001a\u0005\t5\u0001\u0011)\u0019!C!7\u0005\u0019Q/\u001b3\u0016\u0003q\u0001\"!H\u0012\u000f\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0002\rA\u0013X\rZ3g\u0013\t!SE\u0001\u0004TiJLgn\u001a\u0006\u0003E}A\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0005k&$\u0007\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0001+\u0003\u0011\u0019\u0018N_3\u0016\u0003-\u0002\"A\b\u0017\n\u00055z\"aA%oi\"Aq\u0006\u0001B\u0001B\u0003%1&A\u0003tSj,\u0007\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0004)M\"\u0004\"\u0002\u000e1\u0001\u0004a\u0002\"B\u00151\u0001\u0004Y\u0003\"B\u0019\u0001\t\u00031DC\u0001\u000b8\u0011\u0015IS\u00071\u0001,\u0011\u0015I\u0004\u0001\"\u0001;\u0003-\u0019X\r\u001e#s_Bd\u0015m\u001d;\u0015\u0005mbT\"\u0001\u0001\t\u000buB\u0004\u0019\u0001 \u0002\u000bY\fG.^3\u0011\u0005yy\u0014B\u0001! \u0005\u001d\u0011un\u001c7fC:DQA\u0011\u0001\u0005\u0002\r\u000b1b]3u\u0013:\u0004X\u000f^\"pYR\u00111\b\u0012\u0005\u0006{\u0005\u0003\r\u0001\b\u0005\u0006\r\u0002!\taR\u0001\rg\u0016$x*\u001e;qkR\u001cu\u000e\u001c\u000b\u0003w!CQ!P#A\u0002qAQA\u0013\u0001\u0005B-\u000bAaY8qsR\u0011A\u0003\u0014\u0005\u0006\u001b&\u0003\rAT\u0001\u0006Kb$(/\u0019\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u001a\tQ\u0001]1sC6L!a\u0015)\u0003\u0011A\u000b'/Y7NCBDQ!\u0016\u0001\u0005BY\u000b\u0011\u0002\u001e:b]N4wN]7\u0015\u0005][\u0007C\u0001-i\u001d\tIVM\u0004\u0002[G:\u00111L\u0019\b\u00039\u0006t!!\u00181\u000e\u0003yS!a\u0018\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002e\u0011\u0005\u00191/\u001d7\n\u0005\u0019<\u0017a\u00029bG.\fw-\u001a\u0006\u0003I\"I!!\u001b6\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00014h\u0011\u0015aG\u000b1\u0001n\u0003\u001d!\u0017\r^1tKR\u0004$A\u001c;\u0011\u0007=\u0004(/D\u0001h\u0013\t\txMA\u0004ECR\f7/\u001a;\u0011\u0005M$H\u0002\u0001\u0003\nk.\f\t\u0011!A\u0003\u0002Y\u00141a\u0018\u00132#\t9(\u0010\u0005\u0002\u001fq&\u0011\u0011p\b\u0002\b\u001d>$\b.\u001b8h!\tq20\u0003\u0002}?\t\u0019\u0011I\\=\t\u000by\u0004A\u0011I@\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!!\u0001\u0002\u000eA!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b\u001d\fQ\u0001^=qKNLA!a\u0003\u0002\u0006\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005=Q\u00101\u0001\u0002\u0002\u000511o\u00195f[\u0006D3!`A\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u0011q\u0003\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0015\b\u0001\u0005\u0005\u0012qGA\u001d!\u0011\t\u0019#a\r\u000e\u0005\u0005\u0015\"\u0002BA\r\u0003OQA!!\u000b\u0002,\u0005!1m\u001c:f\u0015\r)\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0004d_6\u0014Wo\u001d;\u000b\u0003\u001dIA!!\u000e\u0002&\tI1\u000b]1sW\u000e{G-Z\u0001\u0004kJL\u0017EAA\u001e\u0003ADG\u000f\u001e9tu=zs-\u001b;ik\nt3m\\70CB\f7\r[30gB\f'o[\u0018cY>\u0014wF\u001e\u001a/a9\u0002t&\u001c7mS\n|3O]20[\u0006LgnL:dC2\fwf\u001c:h_\u0005\u0004\u0018m\u00195f_M\u0004\u0018M]60[2|c-Z1ukJ,wf\u00148f\u0011>$XI\\2pI\u0016\u0014hf]2bY\u0006\u0004")
public class OneHotEncoderModel
extends Model<OneHotEncoderModel>
implements OneHotEncoderBase {
    private final String uid;
    private final int size;
    private final BooleanParam dropLast;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public final BooleanParam dropLast() {
        return this.dropLast;
    }

    @Override
    public final void org$apache$spark$ml$mleap$param$HasDropLast$_setter_$dropLast_$eq(BooleanParam x$1) {
        this.dropLast = x$1;
    }

    @Override
    public final boolean getDropLast() {
        return HasDropLast$class.getDropLast(this);
    }

    public final Param<String> outputCol() {
        return this.outputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    public final String getOutputCol() {
        return HasOutputCol.class.getOutputCol((HasOutputCol)this);
    }

    public final Param<String> inputCol() {
        return this.inputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    public final String getInputCol() {
        return HasInputCol.class.getInputCol((HasInputCol)this);
    }

    public String uid() {
        return this.uid;
    }

    public int size() {
        return this.size;
    }

    public OneHotEncoderModel setDropLast(boolean value) {
        return (OneHotEncoderModel)this.set((Param)this.dropLast(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public OneHotEncoderModel setInputCol(String value) {
        return (OneHotEncoderModel)this.set(this.inputCol(), value);
    }

    public OneHotEncoderModel setOutputCol(String value) {
        return (OneHotEncoderModel)this.set(this.outputCol(), value);
    }

    public OneHotEncoderModel copy(ParamMap extra) {
        return (OneHotEncoderModel)this.defaultCopy(extra);
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        int indexMax = this.size();
        String inputColName = (String)this.$(this.inputCol());
        String outputColName = (String)this.$(this.outputCol());
        boolean shouldDropLast = BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.dropLast()));
        double[] oneValue = new double[]{1.0};
        double[] emptyValues = (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double());
        int[] emptyIndices = (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OneHotEncoderModel.class.getClassLoader());
        public final class Org_apache_spark_ml_mleap_feature_OneHotEncoderModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_mleap_feature_OneHotEncoderModel$$typecreator1$1(OneHotEncoderModel $outer) {
            }
        }
        UserDefinedFunction encode = functions$.MODULE$.udf((Function1)new Serializable(this, indexMax, oneValue, emptyValues, emptyIndices){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneHotEncoderModel $outer;
            private final int indexMax$1;
            private final double[] oneValue$1;
            private final double[] emptyValues$1;
            private final int[] emptyIndices$1;

            public final Vector apply(double label) {
                return label < (double)this.indexMax$1 ? Vectors$.MODULE$.sparse(this.$outer.size(), new int[]{(int)label}, this.oneValue$1) : Vectors$.MODULE$.sparse(this.$outer.size(), this.emptyIndices$1, this.emptyValues$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.indexMax$1 = indexMax$1;
                this.oneValue$1 = oneValue$1;
                this.emptyValues$1 = emptyValues$1;
                this.emptyIndices$1 = emptyIndices$1;
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_mleap_feature_OneHotEncoderModel$$typecreator1$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        AttributeGroup outputAttrGroup = AttributeGroup$.MODULE$.fromStructField(this.transformSchema(dataset.schema()).apply(outputColName));
        if (outputAttrGroup.size() < 0) {
            String[] outputAttrNames = (String[])Array$.MODULE$.tabulate(this.size(), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$1) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class));
            String[] filtered = shouldDropLast ? (String[])Predef$.MODULE$.refArrayOps((Object[])outputAttrNames).dropRight(1) : outputAttrNames;
            Attribute[] outputAttrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filtered).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            outputAttrGroup = new AttributeGroup(outputColName, outputAttrs);
        }
        Metadata metadata = outputAttrGroup.toMetadata();
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.col("*"), encode.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.col(inputColName).cast((DataType)DoubleType$.MODULE$)})).as(outputColName, metadata)}));
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        AttributeGroup attributeGroup;
        None$ none$;
        Attribute inputAttr;
        String inputColName = (String)this.$(this.inputCol());
        String outputColName = (String)this.$(this.outputCol());
        Predef$.MODULE$.require(schema.apply(inputColName).dataType() instanceof NumericType, (Function0)new Serializable(this, schema, inputColName){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;
            private final String inputColName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input column must be of type NumericType but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema$1.apply(this.inputColName$1).dataType()}));
            }
            {
                this.schema$1 = schema$1;
                this.inputColName$1 = inputColName$1;
            }
        });
        StructField[] inputFields = schema.fields();
        Predef$.MODULE$.require(!Predef$.MODULE$.refArrayOps((Object[])inputFields).exists((Function1)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final boolean apply(StructField x$2) {
                String string = x$2.name();
                String string2 = this.outputColName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        }), (Function0)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputColName$1}));
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        });
        Attribute attribute = inputAttr = Attribute$.MODULE$.fromStructField(schema.apply(inputColName));
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.values().isDefined() ? nominalAttribute.values() : (nominalAttribute.numValues().isDefined() ? nominalAttribute.numValues().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply(int n) {
                    return (String[])Array$.MODULE$.tabulate(n, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(int x$3) {
                            return ((Object)BoxesRunTime.boxToInteger((int)x$3)).toString();
                        }
                    }, ClassTag$.MODULE$.apply(String.class));
                }
            }) : None$.MODULE$);
        } else if (attribute instanceof BinaryAttribute) {
            BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
            none$ = binaryAttribute.values().isDefined() ? binaryAttribute.values() : new Some(Array$.MODULE$.tabulate(2, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$4) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$4)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class)));
        } else {
            if (attribute instanceof NumericAttribute) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " cannot be numeric."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputColName})));
            }
            none$ = None$.MODULE$;
        }
        None$ outputAttrNames = none$;
        Option filteredOutputAttrNames = outputAttrNames.map((Function1)new Serializable(this, inputColName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneHotEncoderModel $outer;
            public final String inputColName$1;

            public final String[] apply(String[] names) {
                String[] stringArray;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.$((Param)this.$outer.dropLast()))) {
                    Predef$.MODULE$.require(names.length > 1, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$8 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " should have at least two distinct values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$1}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])names).dropRight(1);
                } else {
                    stringArray = names;
                }
                return stringArray;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.inputColName$1 = inputColName$1;
            }
        });
        if (filteredOutputAttrNames.isDefined()) {
            Attribute[] attrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filteredOutputAttrNames.get()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            attributeGroup = new AttributeGroup((String)this.$(this.outputCol()), attrs);
        } else {
            attributeGroup = new AttributeGroup((String)this.$(this.outputCol()));
        }
        AttributeGroup outputAttrGroup = attributeGroup;
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])inputFields).$colon$plus((Object)outputAttrGroup.toStructField(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(outputFields);
    }

    public OneHotEncoderModel(String uid, int size) {
        this.uid = uid;
        this.size = size;
        HasInputCol.class.$init$((HasInputCol)this);
        HasOutputCol.class.$init$((HasOutputCol)this);
        HasDropLast$class.$init$(this);
        this.setDefault((Param)this.dropLast(), BoxesRunTime.boxToBoolean((boolean)true));
    }

    public OneHotEncoderModel(int size) {
        this(Identifiable$.MODULE$.randomUID("oneHotEncoderModel"), size);
    }
}

