/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.classification;

import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.mleap.classification.SVMBase;
import org.apache.spark.ml.mleap.classification.SVMBase$class;
import org.apache.spark.ml.mleap.classification.SVMModel;
import org.apache.spark.ml.mleap.classification.SVMWithSGD;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001=\u00111a\u0015,N\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mK\u0006\u0004(BA\u0004\t\u0003\tiGN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t!!\u0015\t2#F\u000e\u001e\u001b\u0005\u0011\"BA\u0002\u0007\u0013\t!\"CA\fQe>\u0014\u0017MY5mSN$\u0018nY\"mCN\u001c\u0018NZ5feB\u0011a#G\u0007\u0002/)\u0011\u0001DB\u0001\u0007Y&t\u0017\r\\4\n\u0005i9\"A\u0002,fGR|'\u000f\u0005\u0002\u001d\u00015\t!\u0001\u0005\u0002\u001d=%\u0011qD\u0001\u0002\t'ZkUj\u001c3fYB\u0011A$I\u0005\u0003E\t\u0011qa\u0015,N\u0005\u0006\u001cX\r\u0003\u0005%\u0001\t\u0015\r\u0011\"\u0011&\u0003\r)\u0018\u000eZ\u000b\u0002MA\u0011q%\f\b\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&K\u0001\u0007!J,G-\u001a4\n\u00059z#AB*ue&twM\u0003\u0002-S!A\u0011\u0007\u0001B\u0001B\u0003%a%\u0001\u0003vS\u0012\u0004\u0003\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\b\u0006\u0002\u001ck!)AE\ra\u0001M!)1\u0007\u0001C\u0001oQ\t1\u0004C\u0003:\u0001\u0011\u0005!(\u0001\ttKRtU/\\%uKJ\fG/[8ogR\u00111\bP\u0007\u0002\u0001!)Q\b\u000fa\u0001}\u0005)a/\u00197vKB\u0011\u0001fP\u0005\u0003\u0001&\u00121!\u00138u\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0003-\u0019X\r^*uKB\u001c\u0016N_3\u0015\u0005m\"\u0005\"B\u001fB\u0001\u0004)\u0005C\u0001\u0015G\u0013\t9\u0015F\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0013\u0002!\tAS\u0001\fg\u0016$(+Z4QCJ\fW\u000e\u0006\u0002<\u0017\")Q\b\u0013a\u0001\u000b\")Q\n\u0001C\u0001\u001d\u0006!2/\u001a;NS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:$\"aO(\t\u000bub\u0005\u0019A#\t\u000bE\u0003A\u0011\u0001*\u0002\u001fM,GOR5u\u0013:$XM]2faR$\"aO*\t\u000bu\u0002\u0006\u0019\u0001+\u0011\u0005!*\u0016B\u0001,*\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0017\u0001\u0005\u0002e\u000bAb]3u)\"\u0014Xm\u001d5pY\u0012$\"a\u000f.\t\u000bu:\u0006\u0019A#\t\u000bq\u0003A\u0011A/\u0002\u001d\rdW-\u0019:UQJ,7\u000f[8mIR\t1\bC\u0003`\u0001\u0011\u0005\u0003-\u0001\u0003d_BLHCA\u000eb\u0011\u0015\u0011g\f1\u0001d\u0003\u0015)\u0007\u0010\u001e:b!\t!w-D\u0001f\u0015\t1g!A\u0003qCJ\fW.\u0003\u0002iK\nA\u0001+\u0019:b[6\u000b\u0007\u000fC\u0003k\u0001\u0011E3.A\u0003ue\u0006Lg\u000e\u0006\u0002\u001eY\")Q.\u001ba\u0001]\u00069A-\u0019;bg\u0016$\bGA8x!\r\u00018/^\u0007\u0002c*\u0011!\u000fC\u0001\u0004gFd\u0017B\u0001;r\u0005\u001d!\u0015\r^1tKR\u0004\"A^<\r\u0001\u0011I\u0001\u0010\\A\u0001\u0002\u0003\u0015\t!\u001f\u0002\u0004?\u0012\n\u0014C\u0001>~!\tA30\u0003\u0002}S\t9aj\u001c;iS:<\u0007C\u0001\u0015\u007f\u0013\ty\u0018FA\u0002B]f\u0004")
public class SVM
extends ProbabilisticClassifier<Vector, SVM, SVMModel>
implements SVMBase {
    private final String uid;
    private final DoubleParam stepSize;
    private final IntParam numIterations;
    private final DoubleParam regParam;
    private final DoubleParam miniBatchFraction;
    private final BooleanParam fitIntercept;
    private final DoubleParam threshold;

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final IntParam numIterations() {
        return this.numIterations;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$numIterations_$eq(IntParam x$1) {
        this.numIterations = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final double getStepSize() {
        return SVMBase$class.getStepSize(this);
    }

    @Override
    public final int getNumIterations() {
        return SVMBase$class.getNumIterations(this);
    }

    @Override
    public final double getRegParam() {
        return SVMBase$class.getRegParam(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return SVMBase$class.getMiniBatchFraction(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return SVMBase$class.getFitIntercept(this);
    }

    @Override
    public final double getThreshold() {
        return SVMBase$class.getThreshold(this);
    }

    public String uid() {
        return this.uid;
    }

    public SVM setNumIterations(int value) {
        return (SVM)this.set((Param)this.numIterations(), BoxesRunTime.boxToInteger((int)value));
    }

    public SVM setStepSize(double value) {
        return (SVM)this.set((Param)this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM setRegParam(double value) {
        return (SVM)this.set((Param)this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM setMiniBatchFraction(double value) {
        return (SVM)this.set((Param)this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM setFitIntercept(boolean value) {
        return (SVM)this.set((Param)this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public SVM setThreshold(double value) {
        return (SVM)this.set((Param)this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM clearThreshold() {
        return (SVM)this.clear((Param)this.threshold());
    }

    public SVM copy(ParamMap extra) {
        return (SVM)this.defaultCopy(extra);
    }

    public SVMModel train(Dataset<?> dataset) {
        Option option;
        block4: {
            org.apache.spark.mllib.classification.SVMModel mllibModel;
            block3: {
                org.apache.spark.mllib.classification.SVMModel sVMModel;
                block2: {
                    RDD labeledPoints = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col((String)this.$(this.labelCol())), functions$.MODULE$.col((String)this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final LabeledPoint apply(Row x0$1) {
                            Row row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                Object label = ((SeqLike)some.get()).apply(0);
                                Object features = ((SeqLike)some.get()).apply(1);
                                if (label instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)label);
                                    if (features instanceof Vector) {
                                        Vector vector = (Vector)features;
                                        LabeledPoint labeledPoint = new LabeledPoint(d, Vectors$.MODULE$.dense(vector.toArray()));
                                        return labeledPoint;
                                    }
                                }
                            }
                            throw new MatchError((Object)row);
                        }
                    }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                    mllibModel = (org.apache.spark.mllib.classification.SVMModel)new SVMWithSGD(this.getStepSize(), this.getNumIterations(), this.getRegParam(), this.getMiniBatchFraction()).setIntercept(this.getFitIntercept()).run(labeledPoints);
                    option = this.get((Param)this.threshold());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    double t = BoxesRunTime.unboxToDouble((Object)some.x());
                    sVMModel = mllibModel.setThreshold(t);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                sVMModel = mllibModel.clearThreshold();
            }
            return new SVMModel(mllibModel);
        }
        throw new MatchError((Object)option);
    }

    public SVM(String uid) {
        this.uid = uid;
        SVMBase$class.$init$(this);
        this.setDefault((Param)this.stepSize(), BoxesRunTime.boxToDouble((double)1.0));
        this.setDefault((Param)this.regParam(), BoxesRunTime.boxToDouble((double)0.01));
        this.setDefault((Param)this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)1.0));
        this.setDefault((Param)this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)true));
    }

    public SVM() {
        this(Identifiable$.MODULE$.randomUID("svm"));
    }
}

