/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.bundle.extension.ops.classification;

import ml.combust.bundle.BundleContext;
import ml.combust.bundle.dsl.Bundle;
import ml.combust.bundle.dsl.HasAttributes;
import ml.combust.bundle.dsl.Model;
import ml.combust.bundle.dsl.NodeShape;
import ml.combust.bundle.dsl.Value;
import ml.combust.bundle.dsl.Value$;
import ml.combust.bundle.op.OpModel;
import org.apache.spark.ml.bundle.ParamSpec;
import org.apache.spark.ml.bundle.ParamSpec$;
import org.apache.spark.ml.bundle.SimpleParamSpec;
import org.apache.spark.ml.bundle.SimpleSparkOp;
import org.apache.spark.ml.bundle.SparkBundleContext;
import org.apache.spark.ml.mleap.classification.SVMModel;
import org.apache.spark.ml.param.Param;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001'\t12+\u001e9q_J$h+Z2u_Jl\u0015m\u00195j]\u0016|\u0005O\u0003\u0002\u0004\t\u0005q1\r\\1tg&4\u0017nY1uS>t'BA\u0003\u0007\u0003\ry\u0007o\u001d\u0006\u0003\u000f!\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\u0005%Q\u0011A\u00022v]\u0012dWM\u0003\u0002\f\u0019\u0005\u0011Q\u000e\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\r)b\u0003G\u0007\u0002\u0011%\u0011q\u0003\u0003\u0002\u000e'&l\u0007\u000f\\3Ta\u0006\u00148n\u00149\u0011\u0005eiR\"\u0001\u000e\u000b\u0005\rY\"B\u0001\u000f\u000b\u0003\u0015iG.Z1q\u0013\tq\"D\u0001\u0005T-6ku\u000eZ3m\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!\u0001C\u0004&\u0001\t\u0007I\u0011\t\u0014\u0002\u000b5{G-\u001a7\u0016\u0003\u001d\u0002B\u0001K\u0018215\t\u0011F\u0003\u0002+W\u0005\u0011q\u000e\u001d\u0006\u0003\u00131R!!\f\u0018\u0002\u000f\r|WNY;ti*\t1\"\u0003\u00021S\t9q\n]'pI\u0016d\u0007CA\u000b3\u0013\t\u0019\u0004B\u0001\nTa\u0006\u00148NQ;oI2,7i\u001c8uKb$\bBB\u001b\u0001A\u0003%q%\u0001\u0004N_\u0012,G\u000e\t\u0005\u0006o\u0001!\t\u0005O\u0001\ngB\f'o\u001b'pC\u0012$B\u0001G\u001dF\u001b\")!H\u000ea\u0001w\u0005\u0019Q/\u001b3\u0011\u0005q\u0012eBA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s\u0014A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!\u0011 \t\u000b\u00193\u0004\u0019A$\u0002\u000bMD\u0017\r]3\u0011\u0005![U\"A%\u000b\u0005)[\u0013a\u00013tY&\u0011A*\u0013\u0002\n\u001d>$Wm\u00155ba\u0016DQA\u0014\u001cA\u0002a\tQ!\\8eK2DQ\u0001\u0015\u0001\u0005BE\u000b1b\u001d9be.Le\u000e];ugR\u0011!+\u0019\t\u0004'nsfB\u0001+Z\u001d\t)\u0006,D\u0001W\u0015\t9&#\u0001\u0004=e>|GOP\u0005\u0002\u007f%\u0011!LP\u0001\ba\u0006\u001c7.Y4f\u0013\taVLA\u0002TKFT!A\u0017 \u0011\u0005Uy\u0016B\u00011\t\u0005%\u0001\u0016M]1n'B,7\rC\u0003c\u001f\u0002\u0007\u0001$A\u0002pE*DQ\u0001\u001a\u0001\u0005B\u0015\fAb\u001d9be.|U\u000f\u001e9viN$\"A\u001a6\u0011\u0007M[v\r\u0005\u0002\u0016Q&\u0011\u0011\u000e\u0003\u0002\u0010'&l\u0007\u000f\\3QCJ\fWn\u00159fG\")!m\u0019a\u00011\u0001")
public class SupportVectorMachineOp
extends SimpleSparkOp<SVMModel> {
    private final OpModel<SparkBundleContext, SVMModel> Model = new OpModel<SparkBundleContext, SVMModel>(this){
        private final Class<SVMModel> klazz;

        public String modelOpName(Object obj, BundleContext context) {
            return OpModel.class.modelOpName((OpModel)this, (Object)obj, (BundleContext)context);
        }

        public Class<SVMModel> klazz() {
            return this.klazz;
        }

        public String opName() {
            return Bundle.BuiltinOps$.classification$.MODULE$.support_vector_machine();
        }

        public Model store(Model model, SVMModel obj, BundleContext<SparkBundleContext> context) {
            None$ thresholds = obj.isSet((Param)obj.thresholds()) ? new Some((Object)obj.getThresholds()) : None$.MODULE$;
            return (Model)((HasAttributes)((HasAttributes)((HasAttributes)model.withValue("coefficients", Value$.MODULE$.vector((Object)obj.model().weights().toArray(), ClassTag$.MODULE$.Double()))).withValue("intercept", Value$.MODULE$.double(obj.model().intercept()))).withValue("num_classes", Value$.MODULE$.long(2L))).withValue("thresholds", thresholds.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Object> apply(double[] x$1) {
                    return Predef$.MODULE$.doubleArrayOps(x$1).toSeq();
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Value apply(Seq<Object> value) {
                    return Value$.MODULE$.doubleList(value);
                }
            }));
        }

        public SVMModel load(Model model, BundleContext<SparkBundleContext> context) {
            if (model.value("num_classes").getLong() != 2L) {
                throw new IllegalArgumentException("only binary logistic regression supported in Spark");
            }
            Vector weights = Vectors$.MODULE$.dense((double[])model.value("coefficients").getTensor().toArray());
            org.apache.spark.mllib.classification.SVMModel svm = new org.apache.spark.mllib.classification.SVMModel(weights, model.value("intercept").getDouble());
            SVMModel svmModel = new SVMModel("", svm);
            return (SVMModel)model.getValue("thresholds").map((Function1)new Serializable(this, svmModel){
                public static final long serialVersionUID = 0L;
                private final SVMModel svmModel$1;

                public final SVMModel apply(Value t) {
                    return (SVMModel)this.svmModel$1.setThresholds((double[])t.getDoubleList().toArray(ClassTag$.MODULE$.Double()));
                }
                {
                    this.svmModel$1 = svmModel$1;
                }
            }).getOrElse((Function0)new Serializable(this, svmModel){
                public static final long serialVersionUID = 0L;
                private final SVMModel svmModel$1;

                public final SVMModel apply() {
                    return this.svmModel$1;
                }
                {
                    this.svmModel$1 = svmModel$1;
                }
            });
        }
        {
            OpModel.class.$init$((OpModel)this);
            this.klazz = SVMModel.class;
        }
    };

    public OpModel<SparkBundleContext, SVMModel> Model() {
        return this.Model;
    }

    public SVMModel sparkLoad(String uid, NodeShape shape, SVMModel model) {
        SVMModel m = new SVMModel(uid, model.model());
        Object object = model.isDefined((Param)model.thresholds()) ? m.setThresholds(model.getThresholds()) : BoxedUnit.UNIT;
        return m;
    }

    public Seq<ParamSpec> sparkInputs(SVMModel obj) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleParamSpec[]{ParamSpec$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)obj.featuresCol()))}));
    }

    public Seq<SimpleParamSpec> sparkOutputs(SVMModel obj) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleParamSpec[]{ParamSpec$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"raw_prediction"), (Object)obj.rawPredictionCol())), ParamSpec$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"probability"), (Object)obj.probabilityCol())), ParamSpec$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prediction"), (Object)obj.predictionCol()))}));
    }

    public SupportVectorMachineOp() {
        super(ClassTag$.MODULE$.apply(SVMModel.class));
    }
}

