/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.feature;

import java.io.IOException;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.mleap.feature.Imputer$;
import org.apache.spark.ml.mleap.feature.ImputerModel;
import org.apache.spark.ml.mleap.feature.ImputerParams;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001\u0002\f\u0018\u0001\u0011B\u0001B\u000e\u0001\u0003\u0006\u0004%\te\u000e\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005q!)a\t\u0001C\u0001\u000f\")a\t\u0001C\u0001'\")Q\u000b\u0001C\u0001-\")1\f\u0001C\u00019\"9q\f\u0001b\u0001\n\u0003\u0001\u0007B\u00025\u0001A\u0003%\u0011\rC\u0003k\u0001\u0011\u00051\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0003w\u0001\u0011\u0005q\u000fC\u0003z\u0001\u0011\u0005#\u0010C\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u001d9\u0011\u0011J\f\t\u0002\u0005-cA\u0002\f\u0018\u0011\u0003\ti\u0005\u0003\u0004G!\u0011\u0005\u0011\u0011\r\u0005\u000b\u0003G\u0002\"\u0019!C\u00017\u0005\u0015\u0004\u0002CAC!\u0001\u0006I!a\u001a\t\u000f\u0005\u001d\u0005\u0003\"\u0011\u0002\n\"I\u0011\u0011\u0013\t\u0002\u0002\u0013%\u00111\u0013\u0002\b\u00136\u0004X\u000f^3s\u0015\tA\u0012$A\u0004gK\u0006$XO]3\u000b\u0005iY\u0012!B7mK\u0006\u0004(B\u0001\u000f\u001e\u0003\tiGN\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0013.aA\u0019aeJ\u0015\u000e\u0003mI!\u0001K\u000e\u0003\u0013\u0015\u001bH/[7bi>\u0014\bC\u0001\u0016,\u001b\u00059\u0012B\u0001\u0017\u0018\u00051IU\u000e];uKJlu\u000eZ3m!\tQc&\u0003\u00020/\ti\u0011*\u001c9vi\u0016\u0014\b+\u0019:b[N\u0004\"!\r\u001b\u000e\u0003IR!aM\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003kI\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW-A\u0002vS\u0012,\u0012\u0001\u000f\t\u0003s\ts!A\u000f!\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\u001a\u0013A\u0002\u001fs_>$hHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\te(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!?\u0003\u0011)\u0018\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\tA\u0015\n\u0005\u0002+\u0001!)ag\u0001a\u0001q!\u001a1aS)\u0011\u00051{U\"A'\u000b\u00059k\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001+\u0014\u0002\u0006'&t7-Z\u0011\u0002%\u0006)!GL\u0019/aQ\t\u0001\nK\u0002\u0005\u0017F\u000b1b]3u\u0013:\u0004X\u000f^\"pYR\u0011q\u000bW\u0007\u0002\u0001!)\u0011,\u0002a\u0001q\u0005)a/\u00197vK\"\u001aQaS)\u0002\u0019M,GoT;uaV$8i\u001c7\u0015\u0005]k\u0006\"B-\u0007\u0001\u0004A\u0004f\u0001\u0004L#\u0006Y\u0011.\u001c9vi\u00164\u0016\r\\;f+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013\u001c\u0003\u0015\u0001\u0018M]1n\u0013\t17MA\u0006E_V\u0014G.\u001a)be\u0006l\u0007fA\u0004L#\u0006a\u0011.\u001c9vi\u00164\u0016\r\\;fA!\u001a\u0001bS)\u0002\u0017M,Go\u0015;sCR,w-\u001f\u000b\u0003/2DQ!W\u0005A\u0002aB3!C&R\u0003=\u0019X\r^'jgNLgn\u001a,bYV,GCA,q\u0011\u0015I&\u00021\u0001r!\t\u00118/D\u0001?\u0013\t!hH\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u0015-\u000b\u0016AD4fi&k\u0007/\u001e;f-\u0006dW/Z\u000b\u0002c\"\u001a1bS)\u0002\u0007\u0019LG\u000f\u0006\u0002*w\")A\u0010\u0004a\u0001{\u00069A-\u0019;bg\u0016$\bg\u0001@\u0002\u000eA)q0!\u0002\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007i\u0012aA:rY&!\u0011qAA\u0001\u0005\u001d!\u0015\r^1tKR\u0004B!a\u0003\u0002\u000e1\u0001AaCA\bw\u0006\u0005\t\u0011!B\u0001\u0003#\u00111a\u0018\u00132#\u0011\t\u0019\"!\u0007\u0011\u0007I\f)\"C\u0002\u0002\u0018y\u0012qAT8uQ&tw\rE\u0002s\u00037I1!!\b?\u0005\r\te._\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u00111EA\u0018!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003\u0003\tQ\u0001^=qKNLA!!\f\u0002(\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005ER\u00021\u0001\u0002$\u000511o\u00195f[\u0006\fAaY8qsR\u0019\u0001*a\u000e\t\u000f\u0005eb\u00021\u0001\u0002<\u0005)Q\r\u001f;sCB\u0019!-!\u0010\n\u0007\u0005}2M\u0001\u0005QCJ\fW.T1qQ\r\u0001\u00111\t\t\u0004\u0019\u0006\u0015\u0013bAA$\u001b\naQ\t\u001f9fe&lWM\u001c;bY\u00069\u0011*\u001c9vi\u0016\u0014\bC\u0001\u0016\u0011'\u001d\u0001\u0012qJA+\u00037\u00022A]A)\u0013\r\t\u0019F\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\tE\n9\u0006S\u0005\u0004\u00033\u0012$!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0004e\u0006u\u0013bAA0}\ta1+\u001a:jC2L'0\u00192mKR\u0011\u00111J\u0001\u0017gV\u0004\bo\u001c:uK\u0012\u001cFO]1uK\u001eLh*Y7fgV\u0011\u0011q\r\t\u0007\u0003S\n\u0019(a\u001e\u000e\u0005\u0005-$\u0002BA7\u0003_\n\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005Ed(\u0001\u0006d_2dWm\u0019;j_:LA!!\u001e\u0002l\t\u00191+\u001a;\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005!A.\u00198h\u0015\t\t\t)\u0001\u0003kCZ\f\u0017bA\"\u0002|\u000592/\u001e9q_J$X\rZ*ue\u0006$XmZ=OC6,7\u000fI\u0001\u0005Y>\fG\rF\u0002I\u0003\u0017Ca!!$\u0015\u0001\u0004A\u0014\u0001\u00029bi\"D3\u0001F&R\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\u0005\u0003BA=\u0003/KA!!'\u0002|\t1qJ\u00196fGRD3\u0001E&RQ\ry1*\u0015")
public class Imputer
extends Estimator<ImputerModel>
implements ImputerParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam imputeValue;
    private final Param<String> strategy;
    private final DoubleParam missingValue;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public static Imputer load(String string) {
        return Imputer$.MODULE$.load(string);
    }

    public static MLReader<Imputer> read() {
        return Imputer$.MODULE$.read();
    }

    public MLWriter write() {
        return DefaultParamsWritable.write$((DefaultParamsWritable)this);
    }

    public void save(String path) throws IOException {
        MLWritable.save$((MLWritable)this, (String)path);
    }

    @Override
    public String getStrategy() {
        return ImputerParams.getStrategy$(this);
    }

    @Override
    public double getMissingValue() {
        return ImputerParams.getMissingValue$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return ImputerParams.validateAndTransformSchema$(this, schema);
    }

    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$((HasOutputCol)this);
    }

    public final String getInputCol() {
        return HasInputCol.getInputCol$((HasInputCol)this);
    }

    @Override
    public Param<String> strategy() {
        return this.strategy;
    }

    @Override
    public DoubleParam missingValue() {
        return this.missingValue;
    }

    @Override
    public void org$apache$spark$ml$mleap$feature$ImputerParams$_setter_$strategy_$eq(Param<String> x$1) {
        this.strategy = x$1;
    }

    @Override
    public void org$apache$spark$ml$mleap$feature$ImputerParams$_setter_$missingValue_$eq(DoubleParam x$1) {
        this.missingValue = x$1;
    }

    public final Param<String> outputCol() {
        return this.outputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    public final Param<String> inputCol() {
        return this.inputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    public String uid() {
        return this.uid;
    }

    public Imputer setInputCol(String value) {
        return (Imputer)this.set(this.inputCol(), value);
    }

    public Imputer setOutputCol(String value) {
        return (Imputer)this.set(this.outputCol(), value);
    }

    public DoubleParam imputeValue() {
        return this.imputeValue;
    }

    public Imputer setStrategy(String value) {
        return (Imputer)this.set(this.strategy(), value);
    }

    public Imputer setMissingValue(double value) {
        return (Imputer)this.set((Param)this.missingValue(), BoxesRunTime.boxToDouble((double)value));
    }

    public double getImputeValue() {
        return BoxesRunTime.unboxToDouble((Object)this.$((Param)this.imputeValue()));
    }

    public ImputerModel fit(Dataset<?> dataset) {
        double d;
        this.transformSchema(dataset.schema(), true);
        Column inputColumn = functions$.MODULE$.col((String)this.$(this.inputCol()));
        Dataset filtered = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{inputColumn.cast((DataType)DoubleType$.MODULE$)})).filter(inputColumn.isNotNull().$amp$amp((Object)inputColumn.$eq$bang$eq(this.$((Param)this.missingValue())))).filter(inputColumn.isNaN().unary_$bang());
        if (filtered.count() == 0L) {
            throw new SparkException(new StringBuilder(30).append("surrogate cannot be computed. ").append(new StringBuilder(51).append("All the values in ").append(this.$(this.inputCol())).append(" are Null, Nan or missingValue (").append(this.missingValue()).append(")").toString()).toString());
        }
        String string = (String)this.$(this.strategy());
        if ("mean".equals(string)) {
            d = ((Row)filtered.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.avg((String)this.$(this.inputCol()))})).first()).getDouble(0);
        } else if ("median".equals(string)) {
            d = filtered.stat().approxQuantile((String)this.$(this.inputCol()), new double[]{0.5}, 0.001)[0];
        } else {
            throw new MatchError((Object)string);
        }
        double surrogate = d;
        return (ImputerModel)this.copyValues((Params)new ImputerModel(this.uid(), surrogate).setParent(this), this.copyValues$default$2());
    }

    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public Imputer copy(ParamMap extra) {
        return (Imputer)this.defaultCopy(extra);
    }

    public Imputer(String uid) {
        this.uid = uid;
        HasInputCol.$init$((HasInputCol)this);
        HasOutputCol.$init$((HasOutputCol)this);
        ImputerParams.$init$(this);
        MLWritable.$init$((MLWritable)this);
        DefaultParamsWritable.$init$((DefaultParamsWritable)this);
        this.imputeValue = new DoubleParam((Identifiable)this, "imputeValue", "Value which will be used to impute missing values.");
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.strategy().$minus$greater((Object)"mean"), this.missingValue().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public Imputer() {
        this(Identifiable$.MODULE$.randomUID("imputer"));
    }
}

