/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.classification;

import java.io.Serializable;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.mleap.classification.SVMBase;
import org.apache.spark.ml.mleap.classification.SVMModel;
import org.apache.spark.ml.mleap.classification.SVMWithSGD;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\b\u0010\u0001qA\u0001\u0002\r\u0001\u0003\u0006\u0004%\t%\r\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005e!)\u0001\t\u0001C\u0001\u0003\")\u0001\t\u0001C\u0001\u0007\")A\t\u0001C\u0001\u000b\")Q\n\u0001C\u0001\u001d\")1\u000b\u0001C\u0001)\")a\u000b\u0001C\u0001/\")\u0011\f\u0001C\u00015\")q\f\u0001C\u0001A\")!\r\u0001C\u0001G\")A\r\u0001C!K\")a\u000e\u0001C)_\n\u00191KV'\u000b\u0005A\t\u0012AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003%M\tQ!\u001c7fCBT!\u0001F\u000b\u0002\u00055d'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!H\u0017\u0011\u000by\u0001#\u0005\u000b\u0016\u000e\u0003}Q!\u0001E\n\n\u0005\u0005z\"a\u0006)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\t\u0019c%D\u0001%\u0015\t)3#\u0001\u0004mS:\fGnZ\u0005\u0003O\u0011\u0012aAV3di>\u0014\bCA\u0015\u0001\u001b\u0005y\u0001CA\u0015,\u0013\tasB\u0001\u0005T-6ku\u000eZ3m!\tIc&\u0003\u00020\u001f\t91KV'CCN,\u0017aA;jIV\t!\u0007\u0005\u00024y9\u0011AG\u000f\t\u0003kaj\u0011A\u000e\u0006\u0003om\ta\u0001\u0010:p_Rt$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB\u0014A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!a\u000f\u001d\u0002\tULG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005!\u0012\u0005\"\u0002\u0019\u0004\u0001\u0004\u0011D#\u0001\u0015\u0002!M,GOT;n\u0013R,'/\u0019;j_:\u001cHC\u0001$H\u001b\u0005\u0001\u0001\"\u0002%\u0006\u0001\u0004I\u0015!\u0002<bYV,\u0007C\u0001&L\u001b\u0005A\u0014B\u0001'9\u0005\rIe\u000e^\u0001\fg\u0016$8\u000b^3q'&TX\r\u0006\u0002G\u001f\")\u0001J\u0002a\u0001!B\u0011!*U\u0005\u0003%b\u0012a\u0001R8vE2,\u0017aC:fiJ+w\rU1sC6$\"AR+\t\u000b!;\u0001\u0019\u0001)\u0002)M,G/T5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8o)\t1\u0005\fC\u0003I\u0011\u0001\u0007\u0001+A\btKR4\u0015\u000e^%oi\u0016\u00148-\u001a9u)\t15\fC\u0003I\u0013\u0001\u0007A\f\u0005\u0002K;&\u0011a\f\u000f\u0002\b\u0005>|G.Z1o\u00031\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7e)\t1\u0015\rC\u0003I\u0015\u0001\u0007\u0001+\u0001\bdY\u0016\f'\u000f\u00165sKNDw\u000e\u001c3\u0015\u0003\u0019\u000bAaY8qsR\u0011\u0001F\u001a\u0005\u0006O2\u0001\r\u0001[\u0001\u0006Kb$(/\u0019\t\u0003S2l\u0011A\u001b\u0006\u0003WN\tQ\u0001]1sC6L!!\u001c6\u0003\u0011A\u000b'/Y7NCB\fQ\u0001\u001e:bS:$\"A\u000b9\t\u000bEl\u0001\u0019\u0001:\u0002\u000f\u0011\fG/Y:fiB\u00121o\u001f\t\u0004i^LX\"A;\u000b\u0005Y,\u0012aA:rY&\u0011\u00010\u001e\u0002\b\t\u0006$\u0018m]3u!\tQ8\u0010\u0004\u0001\u0005\u0013q\u0004\u0018\u0011!A\u0001\u0006\u0003i(aA0%cE\u0019a0a\u0001\u0011\u0005){\u0018bAA\u0001q\t9aj\u001c;iS:<\u0007c\u0001&\u0002\u0006%\u0019\u0011q\u0001\u001d\u0003\u0007\u0005s\u0017\u0010")
public class SVM
extends ProbabilisticClassifier<Vector, SVM, SVMModel>
implements SVMBase {
    private final String uid;
    private final DoubleParam stepSize;
    private final IntParam numIterations;
    private final DoubleParam regParam;
    private final DoubleParam miniBatchFraction;
    private final BooleanParam fitIntercept;
    private final DoubleParam threshold;

    @Override
    public final double getStepSize() {
        return SVMBase.getStepSize$(this);
    }

    @Override
    public final int getNumIterations() {
        return SVMBase.getNumIterations$(this);
    }

    @Override
    public final double getRegParam() {
        return SVMBase.getRegParam$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return SVMBase.getMiniBatchFraction$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return SVMBase.getFitIntercept$(this);
    }

    @Override
    public final double getThreshold() {
        return SVMBase.getThreshold$(this);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final IntParam numIterations() {
        return this.numIterations;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$numIterations_$eq(IntParam x$1) {
        this.numIterations = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final void org$apache$spark$ml$mleap$classification$SVMBase$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    public String uid() {
        return this.uid;
    }

    public SVM setNumIterations(int value) {
        return (SVM)this.set((Param)this.numIterations(), BoxesRunTime.boxToInteger((int)value));
    }

    public SVM setStepSize(double value) {
        return (SVM)this.set((Param)this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM setRegParam(double value) {
        return (SVM)this.set((Param)this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM setMiniBatchFraction(double value) {
        return (SVM)this.set((Param)this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM setFitIntercept(boolean value) {
        return (SVM)this.set((Param)this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public SVM setThreshold(double value) {
        return (SVM)this.set((Param)this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public SVM clearThreshold() {
        return (SVM)this.clear((Param)this.threshold());
    }

    public SVM copy(ParamMap extra) {
        return (SVM)this.defaultCopy(extra);
    }

    public SVMModel train(Dataset<?> dataset) {
        org.apache.spark.mllib.classification.SVMModel sVMModel;
        RDD labeledPoints = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col((String)this.$(this.labelCol())), functions$.MODULE$.col((String)this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Object features;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    features = ((SeqLike)some.get()).apply(1);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)features;
            LabeledPoint labeledPoint = new LabeledPoint(d, Vectors$.MODULE$.dense(vector.toArray()));
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        org.apache.spark.mllib.classification.SVMModel mllibModel = (org.apache.spark.mllib.classification.SVMModel)new SVMWithSGD(this.getStepSize(), this.getNumIterations(), this.getRegParam(), this.getMiniBatchFraction()).setIntercept(this.getFitIntercept()).run(labeledPoints);
        Option option = this.get((Param)this.threshold());
        if (option instanceof Some) {
            Some some = (Some)option;
            double t = BoxesRunTime.unboxToDouble((Object)some.value());
            sVMModel = mllibModel.setThreshold(t);
        } else if (None$.MODULE$.equals(option)) {
            sVMModel = mllibModel.clearThreshold();
        } else {
            throw new MatchError((Object)option);
        }
        return new SVMModel(mllibModel);
    }

    public SVM(String uid) {
        this.uid = uid;
        SVMBase.$init$(this);
        this.setDefault((Param)this.stepSize(), BoxesRunTime.boxToDouble((double)1.0));
        this.setDefault((Param)this.regParam(), BoxesRunTime.boxToDouble((double)0.01));
        this.setDefault((Param)this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)1.0));
        this.setDefault((Param)this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)true));
    }

    public SVM() {
        this(Identifiable$.MODULE$.randomUID("svm"));
    }
}

