/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.bundle;

import java.io.File;
import ml.combust.bundle.dsl.AttributeList;
import ml.combust.bundle.dsl.Bundle;
import ml.combust.bundle.dsl.Bundle$;
import ml.combust.bundle.serializer.BundleSerializer;
import ml.combust.bundle.serializer.HasBundleRegistry;
import ml.combust.bundle.serializer.SerializationFormat;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.Transformer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class SparkBundle$ {
    public static final SparkBundle$ MODULE$;

    static {
        new SparkBundle$();
    }

    public PipelineModel readTransformerGraph(File path, HasBundleRegistry hr) {
        Bundle bundle = new BundleSerializer(path, hr).read();
        return new PipelineModel(bundle.name(), (Transformer[])((TraversableOnce)bundle.nodes().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Transformer apply(Object x$1) {
                return (Transformer)x$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Transformer.class)));
    }

    public Tuple2<Bundle, Transformer> readTransformer(File path, HasBundleRegistry hr) {
        Bundle bundle = new BundleSerializer(path, hr).read();
        PipelineModel transformer = bundle.nodes().length() == 1 ? (Transformer)bundle.nodes().head() : new PipelineModel(bundle.name(), (Transformer[])((TraversableOnce)bundle.nodes().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Transformer apply(Object x$2) {
                return (Transformer)x$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Transformer.class)));
        return new Tuple2((Object)bundle, (Object)transformer);
    }

    public void writeTransformerGraph(PipelineModel graph, File path, Option<AttributeList> list, SerializationFormat format, HasBundleRegistry hr) {
        Bundle bundle = Bundle$.MODULE$.createBundle(graph.uid(), format, (Seq)Predef$.MODULE$.wrapRefArray((Object[])graph.stages()), list);
        new BundleSerializer(path, hr).write(bundle);
    }

    public void writeTransformer(Transformer transformer, File path, Option<AttributeList> list, SerializationFormat format, HasBundleRegistry hr) {
        Transformer transformer2 = transformer;
        if (transformer2 instanceof PipelineModel) {
            PipelineModel pipelineModel = (PipelineModel)transformer2;
            this.writeTransformerGraph(pipelineModel, path, list, format, hr);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Bundle bundle = Bundle$.MODULE$.createBundle(transformer.uid(), format, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Transformer[]{transformer})), list);
            new BundleSerializer(path, hr).write(bundle);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<AttributeList> writeTransformerGraph$default$3() {
        return None$.MODULE$;
    }

    public SerializationFormat writeTransformerGraph$default$4() {
        return SerializationFormat.Mixed$.MODULE$;
    }

    public Option<AttributeList> writeTransformer$default$3() {
        return None$.MODULE$;
    }

    public SerializationFormat writeTransformer$default$4() {
        return SerializationFormat.Mixed$.MODULE$;
    }

    private SparkBundle$() {
        MODULE$ = this;
    }
}

