/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.mleap.feature;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.mleap.feature.OneHotEncoderBase;
import org.apache.spark.ml.mleap.feature.OneHotEncoderModel$;
import org.apache.spark.ml.mleap.param.HasDropLast$class;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001=\u0011!c\u00148f\u0011>$XI\\2pI\u0016\u0014Xj\u001c3fY*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!A\u0003nY\u0016\f\u0007O\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0019\u0011C\u0005\u000b\u000e\u0003\u0019I!a\u0005\u0004\u0003\u000b5{G-\u001a7\u0011\u0005U\u0001Q\"\u0001\u0002\u0011\u0005U9\u0012B\u0001\r\u0003\u0005Eye.\u001a%pi\u0016s7m\u001c3fe\n\u000b7/\u001a\u0005\t5\u0001\u0011)\u0019!C!7\u0005\u0019Q/\u001b3\u0016\u0003q\u0001\"!H\u0012\u000f\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0002\rA\u0013X\rZ3g\u0013\t!SE\u0001\u0004TiJLgn\u001a\u0006\u0003E}A\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0005k&$\u0007\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0001+\u0003\u0011\u0019\u0018N_3\u0016\u0003-\u0002\"A\b\u0017\n\u00055z\"aA%oi\"Aq\u0006\u0001B\u0001B\u0003%1&A\u0003tSj,\u0007\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0004)M\"\u0004\"\u0002\u000e1\u0001\u0004a\u0002\"B\u00151\u0001\u0004Y\u0003\"B\u0019\u0001\t\u00031DC\u0001\u000b8\u0011\u0015IS\u00071\u0001,\u0011\u0015I\u0004\u0001\"\u0001;\u0003-\u0019X\r^%oaV$8i\u001c7\u0015\u0005mbT\"\u0001\u0001\t\u000buB\u0004\u0019\u0001\u000f\u0002\u000bY\fG.^3\t\u000b}\u0002A\u0011\u0001!\u0002\u0019M,GoT;uaV$8i\u001c7\u0015\u0005m\n\u0005\"B\u001f?\u0001\u0004a\u0002\"B\"\u0001\t\u0003\"\u0015\u0001B2paf$\"\u0001F#\t\u000b\u0019\u0013\u0005\u0019A$\u0002\u000b\u0015DHO]1\u0011\u0005![U\"A%\u000b\u0005)3\u0011!\u00029be\u0006l\u0017B\u0001'J\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\"\u0002(\u0001\t\u0003z\u0015!\u0003;sC:\u001chm\u001c:n)\t\u0001F\r\u0005\u0002RC:\u0011!K\u0018\b\u0003'rs!\u0001V.\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003;\"\t1a]9m\u0013\ty\u0006-A\u0004qC\u000e\\\u0017mZ3\u000b\u0005uC\u0011B\u00012d\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002`A\")Q-\u0014a\u0001M\u00069A-\u0019;bg\u0016$\bGA4n!\rA\u0017n[\u0007\u0002A&\u0011!\u000e\u0019\u0002\b\t\u0006$\u0018m]3u!\taW\u000e\u0004\u0001\u0005\u00139$\u0017\u0011!A\u0001\u0006\u0003y'aA0%cE\u0011\u0001o\u001d\t\u0003=EL!A]\u0010\u0003\u000f9{G\u000f[5oOB\u0011a\u0004^\u0005\u0003k~\u00111!\u00118z\u0011\u00159\b\u0001\"\u0011y\u0003=!(/\u00198tM>\u0014XnU2iK6\fGCA=\u0000!\tQX0D\u0001|\u0015\ta\b-A\u0003usB,7/\u0003\u0002\u007fw\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\r\u0005\u0005a\u000f1\u0001z\u0003\u0019\u00198\r[3nC\"\u001aa/!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003\t\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\tIA\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public class OneHotEncoderModel
extends Model<OneHotEncoderModel>
implements OneHotEncoderBase {
    private final String uid;
    private final int size;
    private final BooleanParam dropLast;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public final BooleanParam dropLast() {
        return this.dropLast;
    }

    @Override
    public final void org$apache$spark$ml$mleap$param$HasDropLast$_setter_$dropLast_$eq(BooleanParam x$1) {
        this.dropLast = x$1;
    }

    @Override
    public final boolean getDropLast() {
        return HasDropLast$class.getDropLast(this);
    }

    public final Param<String> outputCol() {
        return this.outputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    public final String getOutputCol() {
        return HasOutputCol.class.getOutputCol((HasOutputCol)this);
    }

    public final Param<String> inputCol() {
        return this.inputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    public final String getInputCol() {
        return HasInputCol.class.getInputCol((HasInputCol)this);
    }

    public String uid() {
        return this.uid;
    }

    public int size() {
        return this.size;
    }

    public OneHotEncoderModel setInputCol(String value) {
        return (OneHotEncoderModel)this.set(this.inputCol(), value);
    }

    public OneHotEncoderModel setOutputCol(String value) {
        return (OneHotEncoderModel)this.set(this.outputCol(), value);
    }

    public OneHotEncoderModel copy(ParamMap extra) {
        return (OneHotEncoderModel)this.defaultCopy(extra);
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        String inputColName = (String)this.$(this.inputCol());
        String outputColName = (String)this.$(this.outputCol());
        boolean shouldDropLast = BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.dropLast()));
        double[] oneValue = new double[]{1.0};
        double[] emptyValues = (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double());
        int[] emptyIndices = (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OneHotEncoderModel.class.getClassLoader());
        public final class Org_apache_spark_ml_mleap_feature_OneHotEncoderModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_mleap_feature_OneHotEncoderModel$$typecreator1$1(OneHotEncoderModel $outer) {
            }
        }
        UserDefinedFunction encode = functions$.MODULE$.udf((Function1)new Serializable(this, oneValue, emptyValues, emptyIndices){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneHotEncoderModel $outer;
            private final double[] oneValue$1;
            private final double[] emptyValues$1;
            private final int[] emptyIndices$1;

            public final Vector apply(double label) {
                return label < (double)this.$outer.size() ? Vectors$.MODULE$.sparse(this.$outer.size(), new int[]{(int)label}, this.oneValue$1) : Vectors$.MODULE$.sparse(this.$outer.size(), this.emptyIndices$1, this.emptyValues$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.oneValue$1 = oneValue$1;
                this.emptyValues$1 = emptyValues$1;
                this.emptyIndices$1 = emptyIndices$1;
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_mleap_feature_OneHotEncoderModel$$typecreator1$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        AttributeGroup outputAttrGroup = AttributeGroup$.MODULE$.fromStructField(this.transformSchema(dataset.schema()).apply(outputColName));
        if (outputAttrGroup.size() < 0) {
            String[] outputAttrNames = (String[])Array$.MODULE$.tabulate(this.size(), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$1) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class));
            String[] filtered = shouldDropLast ? (String[])Predef$.MODULE$.refArrayOps((Object[])outputAttrNames).dropRight(1) : outputAttrNames;
            Attribute[] outputAttrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filtered).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            outputAttrGroup = new AttributeGroup(outputColName, outputAttrs);
        }
        Metadata metadata = outputAttrGroup.toMetadata();
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.col("*"), encode.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.col(inputColName).cast((DataType)DoubleType$.MODULE$)})).as(outputColName, metadata)}));
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        AttributeGroup attributeGroup;
        None$ none$;
        Attribute inputAttr;
        String inputColName = (String)this.$(this.inputCol());
        String outputColName = (String)this.$(this.outputCol());
        Predef$.MODULE$.require(schema.apply(inputColName).dataType() instanceof NumericType, (Function0)new Serializable(this, schema, inputColName){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;
            private final String inputColName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input column must be of type NumericType but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema$1.apply(this.inputColName$1).dataType()}));
            }
            {
                this.schema$1 = schema$1;
                this.inputColName$1 = inputColName$1;
            }
        });
        StructField[] inputFields = schema.fields();
        Predef$.MODULE$.require(!Predef$.MODULE$.refArrayOps((Object[])inputFields).exists((Function1)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final boolean apply(StructField x$2) {
                String string = x$2.name();
                String string2 = this.outputColName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        }), (Function0)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputColName$1}));
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        });
        Attribute attribute = inputAttr = Attribute$.MODULE$.fromStructField(schema.apply(inputColName));
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.values().isDefined() ? nominalAttribute.values() : (nominalAttribute.numValues().isDefined() ? nominalAttribute.numValues().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply(int n) {
                    return (String[])Array$.MODULE$.tabulate(n, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(int x$3) {
                            return ((Object)BoxesRunTime.boxToInteger((int)x$3)).toString();
                        }
                    }, ClassTag$.MODULE$.apply(String.class));
                }
            }) : None$.MODULE$);
        } else if (attribute instanceof BinaryAttribute) {
            BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
            none$ = binaryAttribute.values().isDefined() ? binaryAttribute.values() : new Some(Array$.MODULE$.tabulate(2, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$4) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$4)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class)));
        } else {
            if (attribute instanceof NumericAttribute) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " cannot be numeric."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputColName})));
            }
            none$ = None$.MODULE$;
        }
        None$ outputAttrNames = none$;
        Option filteredOutputAttrNames = outputAttrNames.map((Function1)new Serializable(this, inputColName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneHotEncoderModel $outer;
            public final String inputColName$1;

            public final String[] apply(String[] names) {
                String[] stringArray;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.$((Param)this.$outer.dropLast()))) {
                    Predef$.MODULE$.require(names.length > 1, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$8 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " should have at least two distinct values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$1}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])names).dropRight(1);
                } else {
                    stringArray = names;
                }
                return stringArray;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.inputColName$1 = inputColName$1;
            }
        });
        if (filteredOutputAttrNames.isDefined()) {
            Attribute[] attrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filteredOutputAttrNames.get()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            attributeGroup = new AttributeGroup((String)this.$(this.outputCol()), attrs);
        } else {
            attributeGroup = new AttributeGroup((String)this.$(this.outputCol()));
        }
        AttributeGroup outputAttrGroup = attributeGroup;
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])inputFields).$colon$plus((Object)outputAttrGroup.toStructField(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(outputFields);
    }

    public OneHotEncoderModel(String uid, int size) {
        this.uid = uid;
        this.size = size;
        HasInputCol.class.$init$((HasInputCol)this);
        HasOutputCol.class.$init$((HasOutputCol)this);
        HasDropLast$class.$init$(this);
    }

    public OneHotEncoderModel(int size) {
        this(Identifiable$.MODULE$.randomUID("oneHotEncoderModel"), size);
    }
}

