/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.bundle.ops.classification;

import ml.combust.bundle.dsl.Attribute;
import ml.combust.bundle.dsl.Bundle;
import ml.combust.bundle.dsl.ReadableModel;
import ml.combust.bundle.dsl.ReadableNode;
import ml.combust.bundle.dsl.Shape;
import ml.combust.bundle.dsl.Shape$;
import ml.combust.bundle.dsl.Value;
import ml.combust.bundle.dsl.Value$;
import ml.combust.bundle.dsl.WritableModel;
import ml.combust.bundle.op.OpModel;
import ml.combust.bundle.op.OpNode;
import ml.combust.bundle.serializer.BundleContext;
import org.apache.spark.ml.mleap.classification.SVMModel;
import org.apache.spark.ml.param.Param;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;

public final class SupportVectorMachineOp$
implements OpNode<SVMModel, SVMModel> {
    public static final SupportVectorMachineOp$ MODULE$;
    private final OpModel<SVMModel> Model;

    static {
        new SupportVectorMachineOp$();
    }

    public OpModel<SVMModel> Model() {
        return this.Model;
    }

    public String name(SVMModel node) {
        return node.uid();
    }

    public SVMModel model(SVMModel node) {
        return node;
    }

    public SVMModel load(BundleContext context, ReadableNode node, SVMModel model) {
        return (SVMModel)new SVMModel(node.name(), model.model()).copy(model.extractParamMap()).setFeaturesCol(node.shape().input("features").name()).setPredictionCol(node.shape().output("prediction").name());
    }

    public Shape shape(SVMModel node) {
        return new Shape(Shape$.MODULE$.apply$default$1()).withInput(node.getFeaturesCol(), "features").withOutput(node.getPredictionCol(), "prediction");
    }

    private SupportVectorMachineOp$() {
        MODULE$ = this;
        this.Model = new OpModel<SVMModel>(){

            public String opName() {
                return Bundle.BuiltinOps$.classification$.MODULE$.support_vector_machine();
            }

            public WritableModel store(BundleContext context, WritableModel model, SVMModel obj) {
                WritableModel m = model.withAttr(new Attribute("coefficients", Value$.MODULE$.doubleVector((Seq)Predef$.MODULE$.wrapDoubleArray(obj.model().weights().toArray())))).withAttr(new Attribute("intercept", Value$.MODULE$.double(obj.model().intercept()))).withAttr(new Attribute("num_classes", Value$.MODULE$.long(2L)));
                return (WritableModel)obj.get((Param)obj.threshold()).map((Function1)new Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final WritableModel m$1;

                    public final WritableModel apply(double t) {
                        return this.m$1.withAttr(new Attribute("threshold", Value$.MODULE$.double(t)));
                    }
                    {
                        this.m$1 = m$1;
                    }
                }).getOrElse((Function0)new Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final WritableModel m$1;

                    public final WritableModel apply() {
                        return this.m$1;
                    }
                    {
                        this.m$1 = m$1;
                    }
                });
            }

            public SVMModel load(BundleContext context, ReadableModel model) {
                if (model.value("num_classes").getLong() != 2L) {
                    throw new Error("Only binary logistic regression supported in Spark");
                }
                org.apache.spark.mllib.classification.SVMModel svm = new org.apache.spark.mllib.classification.SVMModel(Vectors$.MODULE$.dense((double[])model.value("coefficients").getDoubleVector().toArray(ClassTag$.MODULE$.Double())), model.value("intercept").getDouble());
                SVMModel svmModel = new SVMModel("", svm);
                return (SVMModel)model.getValue("threshold").map((Function1)new Serializable(this, svmModel){
                    public static final long serialVersionUID = 0L;
                    private final SVMModel svmModel$1;

                    public final SVMModel apply(Value t) {
                        return this.svmModel$1.setThreshold(t.getDouble());
                    }
                    {
                        this.svmModel$1 = svmModel$1;
                    }
                }).getOrElse((Function0)new Serializable(this, svmModel){
                    public static final long serialVersionUID = 0L;
                    private final SVMModel svmModel$1;

                    public final SVMModel apply() {
                        return this.svmModel$1;
                    }
                    {
                        this.svmModel$1 = svmModel$1;
                    }
                });
            }
        };
    }
}

